/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.milesandmore;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.html.DomNode;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "iframe:privacy-iframe";
    static String COOKIE_ACCEPT_PATH = "//div[contains(@id,'privacy')]//button[contains(@class,'accept')]";
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[@class='ajax_loading' and @stlye='']";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[7];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//*[contains(@class,'error') and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
        WebUtils.xpathSearchString[1] = "//*[@id='wrong-credentials-notification']";
        WebUtils.xpathSearchString[2] = "//div[@id='wartungsSeite']";
        WebUtils.xpathSearchString[3] = "//h3[contains(.,'Fehler beim Laden Ihrer Daten')]";
        WebUtils.xpathSearchString[4] = "//div[@id='generic-credentials-notification' and not(contains(@style,'display: none'))]";
        WebUtils.xpathSearchString[5] = "//h3[contains(.,'Passwort vergessen')]";
        WebUtils.xpathSearchString[6] = "//h1[contains(.,'Geplante Wartungsarbeiten')]//parent::div";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String logIdent = "[WebSync:Miles&&More] ".replace("&&", "&");
        String longName = "Miles && More Kreditkarte";
        String errorMessage = null;
        if (responsePageAsString.contains("PIN \u00e4ndern")) {
            errorMessage = "Es ist notwendig dass Sie Ihre Zugangs-PIN \u00e4ndern. \n\nBitte melden Sie sich im Online-Baning an und folgen dort den Anweisungen.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + errorMessage, "institutlogo-milesandmore.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (seleniumWebDriver.getCurrentUrl().contains("RequestPin.xhtml")) {
            errorMessage = "Sie haben Ihr/e PIN/Passwort vergessen und k\u00f6nnen sich nicht mehr im Banking anmelden? Geben Sie hier Ihren Anmeldenamen an und beantworten die Verifizierungsfragen.\n\nUnter der Website\nhttps://www.dkb.de/Welcome/content/RequestPin.xhtml\nk\u00f6nnen Sie ein neues Passwort anfordern.\n\nDurch das Absenden des Auftrags wird Ihr Zugang zum Banking sofort gesperrt und ein Start-Passwort zur einmaligen Anmeldung generiert.";
            DialogError.invoke((Object)DialogError, "Hinweis-Frage der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\nPasswort vergessen\n\n" + errorMessage, "institutlogo-milesandmore.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("Online-Sperre aufheben") || responsePageAsString.contains("PIN-Sperre aufheben")) {
            errorMessage = "Ihr Zugang zum Online-Banking ist gesperrt. \n\nF\u00fcr die Freischaltung melden Sie sich im Online-Banking an und folgen dort den Anweisungen.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + errorMessage, "institutlogo-milesandmore.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("id=\"wartungsSeite\"") && responsePageAsString.contains("Geplante Wartungsarbeiten")) {
            errorMessage = "Geplante Wartungsarbeiten\n\nManchmal muss man auch in der digitalen Welt manuell Hand anlegen.\n\nDie Webseite steht aufgrund von Wartungsarbeiten aktuell nicht zur Verf\u00fcgung. Wir bitten um Ihr Verst\u00e4ndnis.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + errorMessage, "institutlogo-milesandmore.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-milesandmore.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static String checkResponse(String responseContentAsString, Page responsePage, String siteArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String getLogMethod = "[checkResponse] ";
        boolean isSelfException = false;
        try {
            String errorResponse = null;
            String errorMessage = null;
            if (responseContentAsString.contains("PIN \u00e4ndern")) {
                errorMessage = "Es ist notwendig dass Sie Ihre Zugangs-PIN \u00e4ndern. \n\nBitte melden Sie sich im Online-Baning an und folgen dort den Anweisungen.";
                DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + errorMessage, "institutlogo-milesandmore.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responsePage.getUrl().toString().equals("https://www.dkb.de/Welcome/content/RequestPin.xhtml")) {
                errorMessage = "Sie haben Ihr/e PIN/Passwort vergessen und k\u00f6nnen sich nicht mehr im Banking anmelden? Geben Sie hier Ihren Anmeldenamen an und beantworten die Verifizierungsfragen.\n\nUnter der Website\nhttps://www.dkb.de/Welcome/content/RequestPin.xhtml\nk\u00f6nnen Sie ein neues Passwort anfordern.\n\nDurch das Absenden des Auftrags wird Ihr Zugang zum Banking sofort gesperrt und ein Start-Passwort zur einmaligen Anmeldung generiert.";
                DialogError.invoke((Object)DialogError, "Hinweis-Frage der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\nPasswort vergessen\n\n" + errorMessage, "institutlogo-milesandmore.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("Online-Sperre aufheben") || responseContentAsString.contains("PIN-Sperre aufheben")) {
                errorMessage = "Ihr Zugang zum Online-Banking ist gesperrt. \n\nF\u00fcr die Freischaltung melden Sie sich im Online-Banking an und folgen dort den Anweisungen.";
                DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + errorMessage, "institutlogo-milesandmore.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("id=\"wartungsSeite\"") && responseContentAsString.contains("Geplante Wartungsarbeiten")) {
                errorMessage = "Geplante Wartungsarbeiten\n\nManchmal muss man auch in der digitalen Welt manuell Hand anlegen.\n\nDie Webseite steht aufgrund von Wartungsarbeiten aktuell nicht zur Verf\u00fcgung. Wir bitten um Ihr Verst\u00e4ndnis.";
                DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + errorMessage, "institutlogo-milesandmore.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("errorMessage") || responseContentAsString.contains("remarkBox\">") || responseContentAsString.contains("class=\"msg")) {
                errorResponse = ((DomNode)responsePage).asXml();
                String windowErrorMessage = WebUtils.formErrorMessage(errorResponse, externalLogger, externalProgressMonitor);
                errorMessage = windowErrorMessage.replaceAll("\\n\\n\\n", " -- ");
                errorMessage = errorMessage.replaceAll("\\n\\n", ": ");
                errorMessage = errorMessage.replaceAll("\\n", " ");
                String[] messageArray = errorMessage.split(" -- ");
                errorMessage = messageArray[0];
                if (responseContentAsString.contains("class=\"msginst") && !responseContentAsString.contains("errorMessage")) {
                    DialogError.invoke((Object)DialogError, "Wichtige Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + windowErrorMessage, "institutlogo-milesandmore.png");
                    if (messageArray.length > 1) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Wichtige Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                        MonitorLog.invoke((Object)MonitorLog, "Wichtige Meldung der Bank: " + messageArray[1]);
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                        MonitorLog.invoke((Object)MonitorLog, "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    } else {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Wichtige Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                        MonitorLog.invoke((Object)MonitorLog, "Wichtige Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    }
                    return null;
                }
                if (responseContentAsString.contains("class=\"msgwarning") && !responseContentAsString.contains("errorMessage")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Warnungs-Nachricht der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    MonitorLog.invoke((Object)MonitorLog, "Warnungs-Nachricht der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    if (messageArray.length > 1) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                        MonitorLog.invoke((Object)MonitorLog, "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                    }
                    return null;
                }
                if (responseContentAsString.contains("remarkBox\">") && !responseContentAsString.contains("errorMessage")) {
                    if (siteArt.equals("DataPage") && errorMessage.equals("F\u00fcr den angegebenen Zeitraum sind keine Ums\u00e4tze vorhanden.")) {
                        return null;
                    }
                    if (siteArt.equals("DataPageAfterSearch")) {
                        return null;
                    }
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Info-, oder Warnungs-Nachricht der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    MonitorLog.invoke((Object)MonitorLog, "Info-, oder Warnungs-Nachricht der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    if (messageArray.length > 1) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                        MonitorLog.invoke((Object)MonitorLog, "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                    }
                    return null;
                }
                if (responseContentAsString.contains("class=\"msginfo") || responseContentAsString.contains("class=\"msgcont") && !responseContentAsString.contains("errorMessage")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Informations-Nachricht der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    MonitorLog.invoke((Object)MonitorLog, "Informations-Nachricht der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + errorMessage);
                    if (messageArray.length > 1) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                        MonitorLog.invoke((Object)MonitorLog, "weitere Meldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ": " + messageArray[1]);
                    }
                    return null;
                }
                DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n" + windowErrorMessage, "institutlogo-milesandmore.png");
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("wurden automatisch vom System abgemeldet")) {
                isSelfException = true;
                throw new Exception("Die Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an");
            }
            if (responseContentAsString.contains("Aus technischen Gr\u00fcnden") && responseContentAsString.contains("leider nicht zur Verf\u00fcgung") || responseContentAsString.contains("us technischen Gr&uuml;nden") && responseContentAsString.contains("leider nicht zur Verf&uuml;gung") || responseContentAsString.contains("Achtung! Wichtiger Hinweis") && responseContentAsString.contains("mit Hochdruck daran") || responseContentAsString.contains("Wichtiger Hinweis") && responseContentAsString.contains("Banking zurzeit leider nicht zur")) {
                DialogError.invoke((Object)DialogError, "Fehlermeldung der " + "Miles && More Kreditkarte".replace("&&", "&") + ":\n\n\n+++ Wichtiger Hinweis +++\n\nAus technischen Gr\u00fcnden steht das Internet-Banking\nzurzeit leider nicht zur Verf\u00fcgung.\nWir arbeiten mit Hochdruck daran, dass Sie sich in K\u00fcrze wieder einloggen k\u00f6nnen.\n\nWir bitten diese tempor\u00e4ren Einschr\u00e4nkungen zu entschuldigen\nund danken f\u00fcr Ihr Verst\u00e4ndnis.Ihre DKB", "institutlogo-milesandmore.png");
                isSelfException = true;
                throw new Exception("Aus technischen Gr\u00fcnden steht das Internet-Banking zurzeit leider nicht zur Verf\u00fcgung. Wir arbeiten mit Hochdruck daran, dass Sie sich in K\u00fcrze wieder einloggen k\u00f6nnen");
            }
            if (responseContentAsString.contains("Bitte melden Sie sich erneut mit Ihrer Kontonummer und Ihrer PIN an")) {
                throw new Exception("Die Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an");
            }
            if (responseContentAsString.contains("Beim Online-Banking ist ein Fehler aufgetreten") && responseContentAsString.contains("Ihre Session") && responseContentAsString.contains("beendet")) {
                isSelfException = true;
                throw new Exception("Beim Online-Banking ist ein Fehler aufgetreten. Ihre Session wurde m\u00f6glicherweise aus Sicherheitsgr\u00fcnden beendet");
            }
            if (!siteArt.equals("Login")) {
                if (responseContentAsString.contains("class=\"anmeldung\"") || responseContentAsString.contains("id=\"login\"")) {
                    isSelfException = true;
                    throw new Exception("Die Loginseite wird wieder angezeigt. Informieren Sie bitte den Entwickler im Forum");
                }
            } else {
                return null;
            }
            return errorMessage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            String ErrorText;
            if (contentStringToParse.contains("errorMessage") || contentStringToParse.contains("remarkBox\">")) {
                int ErrorIDXstart = contentStringToParse.indexOf("errorMessage");
                if (ErrorIDXstart == -1) {
                    ErrorIDXstart = contentStringToParse.indexOf("remarkBox\">");
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorIDXstart: " + ErrorIDXstart);
                int ErrorTextIDXStart = contentStringToParse.indexOf("</span>", ErrorIDXstart) + 7;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorTextIDXStart: " + ErrorTextIDXStart);
                int ErrorTextIDXend = contentStringToParse.indexOf("</li>", ErrorTextIDXStart);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorTextIDXend: " + ErrorTextIDXend);
                ErrorText = contentStringToParse.substring(ErrorTextIDXStart, ErrorTextIDXend);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            } else if (contentStringToParse.contains("class=\"msg")) {
                int ErrorIDXstart = contentStringToParse.indexOf("class=\"msg");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorIDXstart: " + ErrorIDXstart);
                int ErrorTextIDXStart = contentStringToParse.indexOf(">", ErrorIDXstart) + 1;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorTextIDXStart: " + ErrorTextIDXStart);
                int ErrorTextIDXend = contentStringToParse.indexOf("</div>", ErrorTextIDXStart);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorTextIDXend: " + ErrorTextIDXend);
                ErrorText = contentStringToParse.substring(ErrorTextIDXStart, ErrorTextIDXend);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Suche eine weitere (versteckte) Nachricht ...");
                int ErrorIDXstart2 = contentStringToParse.lastIndexOf("class=\"msg");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorIDXstart2: " + ErrorIDXstart2);
                if (ErrorIDXstart2 > ErrorIDXstart) {
                    ErrorTextIDXStart = contentStringToParse.indexOf(">", ErrorIDXstart2) + 1;
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorTextIDXStart: " + ErrorTextIDXStart);
                    ErrorTextIDXend = contentStringToParse.indexOf("</div>", ErrorTextIDXStart);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorTextIDXend: " + ErrorTextIDXend);
                    String ErrorText2 = contentStringToParse.substring(ErrorTextIDXStart, ErrorTextIDXend);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorText2 (unformatiert): " + ErrorText2);
                    ErrorText = ErrorText + "\n\n\n" + ErrorText2;
                } else {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "... anscheinend keine weitere vorhanden");
                }
            } else {
                throw new Exception("Fehlernachrichten konnten nun doch nicht gefunden werden?! Somit kein auslesen m\u00f6glich");
            }
            String formErrorText = ErrorText.replaceAll("</strong><br/>", "\n\n");
            formErrorText = formErrorText.replaceAll("</strong><br />", "\n\n");
            formErrorText = formErrorText.replaceAll("</span></h3>", "\n\n");
            formErrorText = formErrorText.replaceAll("<br/>", "\n");
            formErrorText = formErrorText.replaceAll("<br />", "\n");
            formErrorText = formErrorText.replaceAll("</li><li>", "\n");
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

