/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.milesandmore;

import de.derrichter.finance.websync.institute.milesandmore.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String maskedCreditcardNumber, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            double amount;
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kreditkartennummer enthalten ist ...");
            String formatedMaskNumber = "**** " + maskedCreditcardNumber.substring(maskedCreditcardNumber.length() - 4);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "checkCardNr (formated): " + formatedMaskNumber);
            try {
                wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//*[contains(.,'" + formatedMaskNumber + "')]"))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "OK - Kreditkartennummer auf der Startseite vorhanden");
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Kreditkartennummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] " + getLogMethod + "Check ob der Karten-Tab gewechselt werden muss...");
            String cardSelectorPath = "//span[contains(.,'" + formatedMaskNumber + "')]//ancestor::a[contains(@id,'credit-card')]";
            String tabID = "";
            boolean tabIsActive = true;
            try {
                tabID = seleniumWebDriver.findElement(By.xpath((String)cardSelectorPath)).getAttribute("id");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] " + getLogMethod + "asked tabID: " + tabID);
                String tabName = seleniumWebDriver.findElement(By.xpath((String)cardSelectorPath)).getAttribute("aria-label");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] " + getLogMethod + "asked tabName: " + tabName);
                String tabClass = "";
                try {
                    tabClass = seleniumWebDriver.findElement(By.xpath((String)cardSelectorPath)).getAttribute("aria-current");
                }
                catch (Exception error) {
                    tabIsActive = false;
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] " + getLogMethod + "current tabClass: " + tabClass);
                if (tabClass == null || !tabClass.contains("page")) {
                    tabIsActive = false;
                }
            }
            catch (NoSuchElementException | TimeoutException noTab) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] " + getLogMethod + "keine Tab-ID gefunden, ist wohl Single-Container: " + noTab.getMessage());
            }
            try {
                if (!StringCharUtils.isNullOrEmptyOrNothing(tabID) && !tabIsActive) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] " + getLogMethod + "Angefragter Tab nicht aktiv, es wird gewechselt...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "tabButton", cardSelectorPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
            }
            catch (Exception tabChange) {
                isSelfException = true;
                throw new Exception("Tab-Wechsel fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)tabChange));
            }
            Thread.sleep(2500L);
            String downloadButtonPath = "//button[contains(@id,'transactions-export')]";
            wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadButtonPath)));
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] " + getLogMethod + "read amount ...");
                String amountTextPath = "//div[contains(@id,'card-balance') or contains(@class,'creditStyle')]";
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountTextPath)));
                String amountText = seleniumWebDriver.findElement(By.xpath((String)amountTextPath)).getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] " + getLogMethod + "amountText: " + amountText);
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] " + getLogMethod + "amountText html: " + seleniumWebDriver.findElement(By.xpath((String)amountTextPath)).getAttribute("outerHTML"));
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("Auslesen des Kontostands fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            double availableAmount = Double.NaN;
            try {
                String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"//div[@id='card-limit']")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "availableAmountText: " + availableAmountText);
                availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage());
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Miles && More Kreditkarte\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + maskedCreditcardNumber + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + availableAmount + "\n\n";
            boolean haveNewTrans = false;
            try {
                if (seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'r den angegebenen Zeitraum sind keine Ums')]")) != null) {
                    transData = transData + "Datum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                }
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] xpath ///*[contains(.,'r den angegebenen Zeitraum sind keine Ums')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
            }
            File downloadedFile = null;
            String doctext = "";
            String filetype = "";
            boolean localTest = false;
            if (localTest) {
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                downloadedFile = new File(docFixTempFilePath);
            }
            if (haveNewTrans) {
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadMenu", downloadButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvExport", "//li[contains(.,'CSV') or contains(.,'Excel')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    filetype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                    if (filetype.toLowerCase().equals("txt") || filetype.toLowerCase().equals("htm") || filetype.toLowerCase().equals("html") || filetype.toLowerCase().equals("asp") || filetype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                String fileResponse = "";
                String fileencoding = "windows-1252";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    doctext = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    doctext = fileResponse;
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + filetype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                if (!localTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
                transData = doctext;
            }
            String[] dataResponseArray = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = StringCharUtils.data2matrixArray(StringCharUtils.replaceDoubleQuotesInDoubleQuotes(transData, ";"), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                if (matrixArrayData[i].length < 5 || !matrixArrayData[i][6].equals("Gebucht") || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0]) || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) continue;
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + "matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                Date currentCSVdate = new SimpleDateFormat("dd.MM.yyyy").parse(matrixArrayData[i][0].substring(0, 10));
                Date fromDate = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Miles&&More] " + getLogMethod + "CurrentCSVdate: " + currentCSVdate + " | " + currentCSVdate.getTime());
                if (currentCSVdate.getTime() < fromDate.getTime()) {
                    LogDebug.invoke((Object)LogDebug, "toDate=" + fromDateSimple + ";currentCSVdate=" + matrixArrayData[i][0].substring(0, 10) + " --- CurrentCSVdate '" + String.valueOf(currentCSVdate.getTime()) + "' soll nun kleiner oder gleich sein als toDate: '" + String.valueOf(fromDate.getTime()));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Miles&&More] CSV-Zeile (" + matrixArrayData[i][0] + ";" + matrixArrayData[i][1] + ";" + matrixArrayData[i][2] + ") ist \u00e4lter als der Abrufzeitraum ... daher kein weiteres Auslesen mehr");
                    break;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][2], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayData[i][5].contains("zinsen")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zinsen vor Steuern");
                    } else if (!String.valueOf(betrag).contains("-") && matrixArrayData[i][5].equals("unknown")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else if (!matrixArrayData[i][5].equals("unknown")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][4].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][7])) {
                        String kommentar = "Urspr\u00fcnglicher Betrag: " + matrixArrayData[i][7];
                        if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][8])) {
                            kommentar = kommentar + "\nUmrechnungskurs: " + matrixArrayData[i][8];
                        }
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentar);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Miles&&More] ".replace("&&", "&") + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "needTransPurpFusion", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Miles&&More".replace("&&", "&"), maskedCreditcardNumber, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

