/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.leaseplanbank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "//div[@id='onetrust-banner-sdk' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
    static String COOKIE_ACCEPT_PATH = COOKIE_DETECT_PATH + "//button[contains(@id,'accept')]";
    static String LOADER_CATCHSTRING = "button__busy";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[@class='animsition-loading' or @class='loader__wrapper' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]/parent::div[not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
    static String LOADER_TEXT = "button__busy";
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//label[contains(@class,'error-message') and text()!='' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
        WebUtils.xpathSearchString[1] = "//div[contains(@class,'servicebanner') and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:LeasePlanBank] ";
        String longName = "LeasePlan Bank";
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        if (responsePageAsString.contains("Ihr Passwort ist abgelaufen") && !responsePageAsString.contains("Ihr Passwort ist abgelaufen?")) {
            String formErrorText = StringCharUtils.formMessageText(logIdent, seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Ihr Passwort abgelaufen')]")).getText(), externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "errorText: " + formErrorText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der LeasePlan Bank:\n\n\n" + formErrorText.replace("nachfolgend", "manuell im Online-Banking"), "institutlogo-leaseplanbank.png");
            throw new Exception("Ihr Passwort ist abgelaufen");
        }
        if (responsePageAsString.contains("Entschuldigung") || responsePageAsString.contains("Wartungsarbeiten an unserem System")) {
            String formErrorText = StringCharUtils.formMessageText(logIdent, seleniumWebDriver.findElement(By.xpath((String)"//div[@class='content-top']")).getText(), externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "errorText: " + formErrorText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der LeasePlan Bank:\n\n\n" + formErrorText, "institutlogo-leaseplanbank.png");
            throw new Exception("Webseite ist im Moment nicht verf\u00fcgbar, vermutlich aufgrund von Wartungsarbeiten. Meldung der Bank wurde angezeigt");
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-leaseplanbank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static WebDriver checkForMTAN(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalDialogInterface, Class<?> externalProgressMonitor) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        String tanArt = "mobileTAN";
        String detectTANformPath = "//*[contains(.,'Einmaliger Code')]";
        String secTextPath = "//div[contains(@class,'intro')]";
        String tanInputPath = "//input[@id='VerificationCode']";
        String submitTanPath = "//button[@type='submit' and contains(.,'Weiter')]";
        boolean retryInput = false;
        LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
            try {
                do {
                    wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)secTextPath)));
                    String secText = seleniumWebDriver.findElement(By.xpath((String)secTextPath)).getText().trim();
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-leaseplanbank.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:LeasePlanBank] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    Thread.sleep(1000L);
                    WebElement selectElement = seleniumWebDriver.findElement(By.xpath((String)submitTanPath));
                    JavascriptExecutor jsExecutor = (JavascriptExecutor)seleniumWebDriver;
                    jsExecutor.executeScript("window.scrollTo(document.body.scrollHeight,1920)", new Object[0]);
                    jsExecutor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{selectElement});
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    try {
                        wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        retryInput = true;
                    }
                    catch (TimeoutException noSecondSec) {
                        retryInput = false;
                    }
                } while (retryInput);
            }
            catch (Exception secError) {
                if (isSelfException) {
                    throw new Exception(secError.getMessage());
                }
                throw new Exception("Sicherheitsverfahren '" + tanArt + "' fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)secError));
            }
        }
        catch (TimeoutException noSecondSec) {
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
        }
        return seleniumWebDriver;
    }
}

