/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.leaseplanbank;

import de.derrichter.finance.websync.institute.leaseplanbank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(20L));
        boolean isSelfException = false;
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        try {
            try {
                String detectPath = "//div[@id='confirm-personal-details-form' or (@class='modal-form' and contains(.,'tigen Sie erneut Ihre Identit'))]";
                String messagePath = detectPath + "//h2";
                String closePath = "//*[contains(@data-test-id,'close')]";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String formWarnText = "";
                    List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                    for (WebElement headline : allHeadlines) {
                        String headlinetext = headline.getText();
                        formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:LeasePlanBank] ", headlinetext, externalLogger) + " ";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "warnText: " + formWarnText);
                    DialogWarn.invoke((Object)DialogWarn, "Meldung der LeasePlan Bank:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://sparen.leaseplanbank.de/login/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-leaseplanbank.png");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasAbortButton = false;
                        isSelfException = true;
                        throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                    }
                    hasAbortButton = true;
                    LogWarn.invoke((Object)LogWarn, "[WebSync:LeasePlanBank] Meldung(en) der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//a[contains(@href,'/tagesgeld')]")));
            }
            catch (Exception afterloginerror) {
                try {
                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[contains(.,'Ertr\u00e4gnisaufstellung herunterladen')]")));
                    DialogWarn.invoke((Object)DialogWarn, "Meldung der LeasePlan Bank:\n\n\n\n\nBitte melden Sie sich am Online-Banking unter\nhttps://sparen.leaseplanbank.de/login/login\nan und laden die Ertr\u00e4gnisaufstellung herunter.", "institutlogo-leaseplanbank.png");
                    throw new Exception("Bitte melden Sie sich am Online-Banking an und laden die Ertr\u00e4gnisaufstellung herunter.");
                }
                catch (Exception noDownload) {
                    throw new Exception("Kein Tagesgeldkonten-Block gefunden (scheinbar keine Konten vorhanden): " + afterloginerror.getMessage());
                }
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Check ob in der Konto\u00fcbersicht der Willkommen-Seite die Kontonummer enthalten ist ...");
            LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "Kontonummer-Check: IBANsub: " + kontonummer);
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//p[contains(.,'" + kontonummer + "')]"))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (Exception waiterror) {
                isSelfException = true;
                throw new Exception("Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte online pr\u00fcfen");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] " + getLogMethod + "Kontoansicht aufrufen ... (GET " + "https://sparen.leaseplanbank.de/tagesgeld/" + ")");
            try {
                seleniumWebDriver.get("https://sparen.leaseplanbank.de/tagesgeld/");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "page after click: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//table[@id='single-transactions']//tbody[@aria-live='polite']")));
            String saldoPath = "(//tr//td[contains(.,'" + kontonummer + "')]//following-sibling::td[contains(.,'\u20ac')])";
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)saldoPath)));
                seleniumWebDriver.findElement(By.xpath((String)saldoPath));
            }
            catch (Exception waiterror) {
                isSelfException = true;
                throw new Exception("Auf der Seite konnte kein 'Saldo' zum angegebenen Konto gefunden werden. Falsche oder andere Seite");
            }
            WebElement amountCollum = seleniumWebDriver.findElement(By.xpath((String)saldoPath));
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "getAmount: amountCollum: " + amountCollum);
            String amountText = amountCollum.getText();
            LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "AmountText: " + amountText);
            if (StringCharUtils.shrinkString(amountText).equals("-")) {
                amountText = "0,00";
            }
            Double amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "Amount: " + String.valueOf(amount));
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            Thread.sleep(1000L);
            Calendar dateNow = Calendar.getInstance();
            JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
            Select timeAreaSelect = new Select(seleniumWebDriver.findElement(By.id((String)"period-selector")));
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "timeAreaSelect: " + timeAreaSelect);
            if (dateNow.get(7) == 6 || dateNow.get(7) == 7 || dateNow.get(7) == 1) {
                long currentDate = new Date().getTime();
                long getDate = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple).getTime();
                if (getDate < currentDate - 14515200000L) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] Wegen Wochende wurde der Abrufzeitraum auf 'Alle' gesetzt, um ausstehende Transaktionen im aktuellen Saldo zu beachten");
                    MonitorLog.invoke((Object)MonitorLog, "Wegen Wochende Abrufzeitraum auf 'Alle' gesetzt um ausstehende Transaktionen im aktuellen Saldo zu beachten");
                    timeAreaSelect.selectByValue("all");
                } else if (getDate < currentDate - 7257600000L) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] Wegen Wochende wurde der Abrufzeitraum auf 6 Monate gesetzt, um ausstehende Transaktionen im aktuellen Saldo zu beachten");
                    MonitorLog.invoke((Object)MonitorLog, "Wegen Wochende Abrufzeitraum auf 6 Monate gesetzt um ausstehende Transaktionen im aktuellen Saldo zu beachten");
                    timeAreaSelect.selectByValue("sixmonths");
                } else {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] Wegen Wochende wurde der Abrufzeitraum auf 3 Monate gesetzt, um ausstehende Transaktionen im aktuellen Saldo zu beachten");
                    MonitorLog.invoke((Object)MonitorLog, "Wegen Wochende Abrufzeitraum auf 3 Monate gesetzt um ausstehende Transaktionen im aktuellen Saldo zu beachten");
                    timeAreaSelect.selectByValue("threemonths");
                }
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            timeAreaSelect.selectByValue("period");
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            WebElement fromDateInput = seleniumWebDriver.findElement(By.id((String)"start-date-period"));
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "fromDateInput: " + fromDateInput);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "fromDate: " + fromDateSimple);
            jse.executeScript("document.getElementById('start-date-period').setAttribute('value', '" + fromDateSimple.replace(".", "-") + "');", new Object[0]);
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "fromDateInput (after set): " + fromDateInput);
            WebElement toDateInput = seleniumWebDriver.findElement(By.id((String)"end-date-period"));
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "toDateInput: " + toDateInput);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "toDate: " + toDateSimple);
            jse.executeScript("document.getElementById('end-date-period').setAttribute('value', '" + toDateSimple.replace(".", "-") + "');", new Object[0]);
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "toDateInput (after set): " + toDateInput);
            WebElement showButton = seleniumWebDriver.findElement(By.xpath((String)"//button[@data-show='period']"));
            jse.executeScript("arguments[0].removeAttribute('disabled')", new Object[]{showButton});
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Click showButton: " + showButton);
            showButton.click();
            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            Thread.sleep(1000L);
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der LeasePlan Bank\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
            boolean haveNewTrans = false;
            try {
                if (seleniumWebDriver.findElement(By.xpath((String)"//div[contains(text(),'keine aktuell gebuchten Transaktionen vorhanden')]")) != null) {
                    transData = transData + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                }
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] xpath //div[contains(text(),'keine aktuell gebuchten Transaktionen vorhanden')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            File downloadedFile = null;
            String pdftext = null;
            boolean localTest = false;
            if (localTest) {
                haveNewTrans = false;
                String pdfFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.pdf";
                downloadedFile = new File(pdfFixTempFilePath);
            }
            if (haveNewTrans && !localTest) {
                WebElement downloadButton = seleniumWebDriver.findElement(By.xpath((String)"(//button[contains(.,'Download')])[last()]"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Click downloadButton: " + downloadButton);
                downloadButton.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(500L);
                downloadButton = seleniumWebDriver.findElement(By.xpath((String)"(//a[@data-id='pdf'])[last()]"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Click downloadButton: " + downloadButton);
                downloadButton.click();
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Warte auf die Fertigstellung des PDF-Kontoauszugs ...");
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//li[@data-module='TransactionsOverview']/child::div[@style='display: none;']/child::div[@class='loader__wrapper']")));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
            }
            if (haveNewTrans || localTest) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                MemoryUsageSetting memUsageSetting = MemoryUsageSetting.setupTempFileOnly();
                PDDocument pdf = Loader.loadPDF((File)downloadedFile);
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "[PDDocument.load FILE]: " + pdf);
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "Erzeuge einen Kontoauszug aus PDF ...");
                try {
                    PDFTextStripper stripper = new PDFTextStripper();
                    stripper.setWordSeparator(";");
                    stripper.setSortByPosition(true);
                    pdftext = stripper.getText(pdf);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der PDF hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "getDataExport: soeben abgeholte und umgewandelte PDF-Rechnung (pdftext): \n" + pdftext);
                pdf.close();
                if (!localTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "pdfResponse: \n\n====================== BEGIN DATA ======================\n" + pdftext + "\n======================= END DATA =======================\n");
            String[] dataResponse = new String[]{pdftext, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(pdftext.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn2;
                    String[] checkColumn = matrixArrayData[i][0].trim().split("-");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    if (matrixArrayData[i][1].length() == 10 && (checkColumn2 = matrixArrayData[i][1].trim().split("-")).length == 3 || matrixArrayData[i].length < 3) continue;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + e.toString());
                    continue;
                }
                int setPos = 0;
                if (matrixArrayData[i].length == 3) {
                    setPos = 2;
                }
                if (matrixArrayData[i].length == 4) {
                    setPos = 1;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].trim().substring(0, 10).split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][0].trim().substring(0, 10).split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(StringCharUtils.shrinkString(matrixArrayData[i][4 - setPos]), externalLogger));
                    if (matrixArrayData[i].length > 3 && matrixArrayData[i][3 - setPos].equals("ab") && !matrixArrayData[i][4 - setPos].contains("-")) {
                        betrag *= -1.0;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayData[i][2 - setPos].contains("Zinsen") || matrixArrayData[i][2 - setPos].equals("Zins") || matrixArrayData[i].length == 3) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zinszahlung");
                    } else if (matrixArrayData[i][3 - setPos].equals("ab") || matrixArrayData[i][3 - setPos].equals("dazu")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("\u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (matrixArrayData[i].length == 5 && !StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][2 - setPos])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][2 - setPos].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String transKonto = "";
                    String transBLZ = "";
                    String transIBAN = "";
                    String transBic = "";
                    String transName = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1]) && matrixArrayData[i].length == 5 || matrixArrayData[i].length == 4 && !matrixArrayData[i][1].contains("Zinsen")) {
                        transIBAN = matrixArrayData[i][1].replaceAll("\\s+", "");
                        if (transIBAN.startsWith("DE")) {
                            transBLZ = transIBAN.substring(4, 12);
                            transKonto = transIBAN.substring(12);
                            if (!transKonto.equals(kontonummer)) {
                                transName = "";
                                transBic = "";
                            } else {
                                transIBAN = "";
                                transBLZ = "";
                                transKonto = "";
                            }
                        } else if (transIBAN.length() == 10) {
                            transIBAN = "";
                            transBLZ = "";
                            transKonto = transIBAN;
                        } else {
                            transBLZ = "";
                            transKonto = "";
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transIBAN);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transBic);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transKonto);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("LeasePlanBank", kontonummer, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

