/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.leaseplanbank;

import de.derrichter.finance.websync.institute.leaseplanbank.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    private static String logIdent = "[[WebSync:LeasePlanBank] ] ";

    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] " + getLogMethod + "LeasePlanBank-Login aufrufen ... (GET " + "https://sparen.leaseplanbank.de/login/login" + ")");
            try {
                seleniumWebDriver.get("https://sparen.leaseplanbank.de/login/login");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)WebUtils.COOKIE_DETECT_PATH)));
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:LeasePlanBank] ", "LeasePlan Bank", "institutlogo-leaseplanbank.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"account-name")));
                WebElement inputUser = seleniumWebDriver.findElement(By.id((String)"account-name"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "inputUser: " + inputUser);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.id((String)"password"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "inputPasswd: " + inputPasswd);
                WebElement submitContinue = seleniumWebDriver.findElement(By.xpath((String)"//button[@type='submit' and contains(.,'Weiter')]"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "submitContinue: " + submitContinue);
                inputUser.click();
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                inputPasswd.click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[@type='submit' and contains(.,'Weiter')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            seleniumWebDriver = WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalDialogInterface, externalProgressMonitor);
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "after login: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            if (pageAfterLoginResponse.contains("data-module=\"loginForm\"")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:LeasePlanBank] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        try {
            String logoutXpath = "(//a[@data-module='LogOut'])[1]";
            LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] " + getLogMethod + "Abmelden aufrufen durch klicken ... ");
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundener Logout-Button: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)logoutXpath))));
                WebElement logoutButton = seleniumWebDriver.findElement(By.xpath((String)logoutXpath));
                logoutButton.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1000L);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Logout-Button nicht gefunden! xPathExpression \"" + logoutXpath + "\" ergab kein Ergebnis");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:LeasePlanBank] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//h1[contains(.,'Anmelden')]";
            try {
                LogDebug.invoke((Object)LogDebug, logIdent + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:LeasePlanBank] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:LeasePlanBank] " + getLogMethod + "Logout bei der '" + "LeasePlan Bank" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:LeasePlanBank] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

