/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.lbb;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "//div[contains(@class,'cookie-banner') and not(ancestor::div[contains(@style,'display:none')]) and not(ancestor::div[@hidden]) and not(ancestor::div[contains(@style,'display: none')])]";
    static String COOKIE_ACCEPT_PATH = "//div[contains(@class,'cookie-banner') and not(ancestor::div[contains(@style,'display:none')]) and not(ancestor::div[@hidden]) and not(ancestor::div[contains(@style,'display: none')])]//button[contains(@class,'button primary')]";
    static String LOADER_CATCHSTRING = "spinner";
    static String LOADER_EXCLUSIONS = "DummyLoaderExclution";
    static String LOADER_PATH = "//span[@class='spinner']";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[4];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//mat-error";
        WebUtils.xpathSearchString[1] = "//ngb-alert";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "die von Ihnen eingegebenen Suchkriterien konnte keine Transaktion gefunden werden";
        WebUtils.xpathSearchStringExclusion[1] = "Bitte versuchen Sie die Seite neu zu laden.";
        WebUtils.xpathSearchStringExclusion[2] = "keine Aktionen veranlassen";
        WebUtils.xpathSearchStringExclusion[3] = "Um eine Ersatzkarte zu bestellen";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        if (responsePageAsString.contains("Wir arbeiten f\u00fcr Sie") && responsePageAsString.contains("Zurzeit steht Ihnen das Online-Banking leider nicht zur Verf")) {
            String formWarnText = StringCharUtils.formMessageText(WebUtils.getLogIdent(bankArt), seleniumWebDriver.findElement(By.xpath((String)"//div[@id='maintenance-message']")).getText(), externalLogger);
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "errorText: " + formWarnText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der " + WebUtils.getLongName(bankArt) + ":\n\n\n" + formWarnText, WebUtils.getLogoPath(bankArt));
            throw new Exception("Webseite ist im Moment nicht verf\u00fcgbar, vermutlich aufgrund von Wartungsarbeiten. Meldung der Bank wurde angezeigt");
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static String getShortName(String bankArt) throws Exception {
        String shortName;
        block5: {
            shortName = null;
            try {
                if (bankArt.equals("Amazon")) {
                    shortName = "Amazon-VISA";
                    break block5;
                }
                if (bankArt.equals("LBB")) {
                    shortName = "LBB-VISA";
                    break block5;
                }
                if (bankArt.equals("ADAC")) {
                    shortName = "ADAC-VISA";
                    break block5;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'shortName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return shortName;
    }

    public static String getLongName(String bankArt) throws Exception {
        String longName;
        block5: {
            longName = null;
            try {
                if (bankArt.equals("Amazon")) {
                    longName = "Landesbank Berlin (Amazon-VISA)";
                    break block5;
                }
                if (bankArt.equals("LBB")) {
                    longName = "Landesbank Berlin (VISA)";
                    break block5;
                }
                if (bankArt.equals("ADAC")) {
                    longName = "Landesbank Berlin (ADAC-VISA)";
                    break block5;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'longName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return longName;
    }

    public static String getLogIdent(String bankArt) throws Exception {
        String logIdent;
        block5: {
            logIdent = null;
            try {
                if (bankArt.equals("Amazon")) {
                    logIdent = "[WebSync:Amazon-VISA] ";
                    break block5;
                }
                if (bankArt.equals("LBB")) {
                    logIdent = "[WebSync:LBB-VISA] ";
                    break block5;
                }
                if (bankArt.equals("ADAC")) {
                    logIdent = "[WebSync:ADAC-VISA] ";
                    break block5;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logIdent' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logIdent;
    }

    public static String getLogoPath(String bankArt) throws Exception {
        String logoPath;
        block5: {
            logoPath = null;
            try {
                if (bankArt.equals("Amazon")) {
                    logoPath = "institutlogo-amazonvisa.png";
                    break block5;
                }
                if (bankArt.equals("LBB")) {
                    logoPath = "institutlogo-lbbvisa.png";
                    break block5;
                }
                if (bankArt.equals("ADAC")) {
                    logoPath = "institutlogo-adacvisa.png";
                    break block5;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logoPath' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logoPath;
    }

    public static String getMainURL(String bankArt) throws Exception {
        String logoPath;
        block5: {
            logoPath = null;
            try {
                if (bankArt.equals("Amazon")) {
                    logoPath = "https://amazon.lbb.de";
                    break block5;
                }
                if (bankArt.equals("LBB")) {
                    logoPath = "https://kkb.lbb.de";
                    break block5;
                }
                if (bankArt.equals("ADAC")) {
                    logoPath = "https://adac.lbb.de";
                    break block5;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'loginURL' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logoPath;
    }
}

