/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.lbb;

import de.derrichter.finance.websync.institute.lbb.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String bankArt, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait30 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        String getLogMethod = "[getTransData] ";
        boolean localTest = false;
        boolean localPDFTest = false;
        try {
            String transactionData;
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            double unbookedAmount = Double.NaN;
            int unbookedTransCount = 0;
            int previewTransCount = 0;
            Date fromDate = null;
            String newestBillDate = null;
            String doctext = "";
            boolean haveNewTrans = false;
            if (!localTest) {
                try {
                    String detectPath = "//*[@id='mailboxtermsconditions-submitButton' or @id='welcome-process-form' or @id='datenabgleich' or contains(@class,'modal-dialog')]";
                    String messagePath = detectPath + "//h1";
                    String closePath = "//*[contains(@data-test-id,'close')]";
                    boolean hasAbortButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + "Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String formWarnText = "";
                        List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                        for (WebElement headline : allHeadlines) {
                            String headlinetext = headline.getText();
                            formWarnText = formWarnText + StringCharUtils.formMessageText(WebUtils.getLogIdent(bankArt), headlinetext, externalLogger) + " ";
                        }
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "warnText: " + formWarnText);
                        DialogWarn.invoke((Object)DialogWarn, "Meldung der " + WebUtils.getLongName(bankArt) + ":\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + WebUtils.getMainURL(bankArt) + "\nan und best\u00e4tigen Sie diese Meldung(en).", WebUtils.getLogoPath(bankArt));
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasAbortButton = false;
                            isSelfException = true;
                            throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                        }
                        hasAbortButton = true;
                        LogWarn.invoke((Object)LogWarn, WebUtils.getLogIdent(bankArt) + "Meldung(en) der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    } while (hasAbortButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + "Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                double amountLimit = Double.NaN;
                amount = Double.NaN;
                availableAmount = Double.NaN;
                unbookedAmount = 0.0;
                unbookedTransCount = 0;
                previewTransCount = 0;
                try {
                    String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"((//div[contains(.,'Verf\u00fcgbar') and contains(@class,'wheel')])[2]//following::div[contains(.,'\u20ac')])[1]")).getText();
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "availableAmountText: " + availableAmountText);
                    availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
                    try {
                        String amountText = seleniumWebDriver.findElement(By.xpath((String)"((//div[contains(.,'Verbraucht') and contains(@class,'wheel')])[3]//following::div[contains(.,'\u20ac')])[1]")).getText();
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "amountText: " + amountText);
                        amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Amount: " + String.valueOf(amount *= -1.0));
                    }
                    catch (NoSuchElementException noAmount) {
                        String amountLimitText = seleniumWebDriver.findElement(By.xpath((String)"//span[contains(.,'monatliches Limit')]")).getText();
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "amountLimitText: " + amountLimitText);
                        amountLimit = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountLimitText, externalLogger));
                        amount = StringCharUtils.mathRound(availableAmount - amountLimit, 2);
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Amount is (amountLimit - availableAmount) * -1: " + String.valueOf(amount));
                    }
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Verbrauchten oder Verf\u00fcgbaren Betrag' fehlgeschlagen: " + error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "transactionsLink", "(//a[@href='/transactions'])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String accdetailResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(accdetailResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterButton", "//button[contains(.,'Letzte')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                SimpleDateFormat gerDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                fromDate = gerDateFormat.parse(fromDateSimple);
                long fromDateMillis = fromDate.toInstant().toEpochMilli();
                if (System.currentTimeMillis() - fromDateMillis > 31363200000L) {
                    fromDateSimple = gerDateFormat.format(System.currentTimeMillis() - 31363200000L);
                }
                try {
                    String fromInputPath = "(//input[contains(@class,'mat-datepicker')])[1]";
                    String toInputPath = "(//input[contains(@class,'mat-datepicker')])[2]";
                    String filterButtonPath = "//button[contains(.,' \u00dcbernehmen ')]";
                    seleniumWebDriver = SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), fromDateSimple, toDateSimple, fromInputPath, toInputPath, filterButtonPath, false, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception searchError) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)searchError));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
                transactionData = "";
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
                newestBillDate = null;
                doctext = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der " + WebUtils.getLogIdent(bankArt) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
                haveNewTrans = false;
                try {
                    if (seleniumWebDriver.findElement(By.xpath((String)"//div[contains(.,'keine Ums\u00e4tze ')]")) != null) {
                        doctext = doctext + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                    }
                }
                catch (Exception waiterror) {
                    haveNewTrans = true;
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "xpath //div[contains(.,'Keine Ums\u00e4tze ')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
                }
            }
            String transDataPDFs = "";
            File downloadedFile = null;
            String filetype = "";
            if (localTest) {
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                downloadedFile = new File(docFixTempFilePath);
            }
            boolean downloadedFileIsFalse = false;
            int downloadCount = 1;
            if (haveNewTrans || localTest) {
                do {
                    if (!localTest) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvExport", "//a[contains(.,'CSV')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nAuf dieser Seite befindliche Links zur Analyse:" + SeleniumUtils.getFormatedListOfAllWebElements(seleniumWebDriver, "//a", externalLogger));
                        }
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    filetype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                    if (filetype.toLowerCase().equals("txt") || filetype.toLowerCase().equals("htm") || filetype.toLowerCase().equals("html") || filetype.toLowerCase().equals("asp") || filetype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                String fileResponse = "";
                String fileencoding = "UTF-8";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    doctext = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    doctext = fileResponse;
                }
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + filetype + "-Auszug (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                if (!localTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
            }
            transactionData = doctext;
            if (!localPDFTest) {
                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + WebUtils.getShortName(bankArt) + "-Rechnungen aufrufen ... (GET " + WebUtils.getMainURL(bankArt) + "/postbox/overview)");
                MonitorLog.invoke((Object)MonitorLog, "Es werden alle notwendigen PDF-Abrechnungen abgerufen ... bitte warten ...");
                try {
                    seleniumWebDriver.get(WebUtils.getMainURL(bankArt) + "/postbox/overview");
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String billFilterPath = "(//button[contains(@class,'filter-button') and contains(.,'Rechnungen')])[2]";
                wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)billFilterPath)));
                Thread.sleep(500L);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "billsFilterButton", billFilterPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageDownlodsResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageDownlodsResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            transDataPDFs = "Gesammelte Rechnung(en) f\u00fcr ein Konto der " + WebUtils.getLongName(bankArt) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + availableAmount + "\n\n";
            String nextBillToReadAsText = "";
            String billDateText = null;
            String billDateTextBefore = null;
            try {
                boolean haveNextSite = false;
                block66: do {
                    int billRound;
                    List billLinks;
                    ArrayList<String> sortedBillLinksDates;
                    String billLinksPath;
                    boolean haveNextPDFs;
                    block173: {
                        haveNextPDFs = false;
                        billLinksPath = "//div[contains(@class,'kkb-postbox-list-item__subject')]";
                        sortedBillLinksDates = null;
                        billLinks = null;
                        billRound = 0;
                        if (!localPDFTest) {
                            try {
                                if (seleniumWebDriver.findElement(By.xpath((String)"//div[contains(.,'Es sind keine ')]")) != null) {
                                    transDataPDFs = transDataPDFs + "Kaufdatum;Umsatz/Ort;Buchungsdatum;W\u00e4hrung;Betrag;Kurs;Betrag in Euro\nIm Abrufzeitraum sind keine PDF-Abrechnungen vorhanden";
                                }
                                break block173;
                            }
                            catch (Exception waiterror) {
                                haveNextPDFs = true;
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "xpath //div[contains(.,'Es sind keine ')] NICHT gefunden; Es sollten PDF-Abrechnungen vorhanden sein...");
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "Lese alle Rechnungs-Links um Anzahl zu erhalten ...");
                                billLinks = seleniumWebDriver.findElements(By.xpath((String)billLinksPath));
                                SeleniumUtils.showFormatedListOfAllWebElementsInLog(seleniumWebDriver, billLinksPath, externalLogger);
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "Formatiere und sortiere die Rechnungs-Links um sicher saubere Reihenfolge zu bearbeiten...");
                                sortedBillLinksDates = SeleniumUtils.getSortedDatesAsStringOfAllWebElements(seleniumWebDriver, billLinksPath, "(\\d{1,2})\\.(\\d{1,2})\\.(\\d{4})", true, externalLogger);
                                if (newestBillDate == null) {
                                    newestBillDate = sortedBillLinksDates.get(0);
                                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "newestBillDate: " + newestBillDate);
                                }
                                break block173;
                            }
                        }
                        haveNextPDFs = true;
                    }
                    while (haveNextPDFs) {
                        File downloadedBill = null;
                        String billtext = null;
                        String fileType = "";
                        WebElement nextBillLinkFromSortedDates = null;
                        if (!localPDFTest) {
                            billLinks = seleniumWebDriver.findElements(By.xpath((String)billLinksPath));
                            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "BillLinks in this Round #" + String.valueOf(billRound) + " are: " + String.valueOf(billLinks.size()));
                        }
                        if (localPDFTest) {
                            String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.pdf";
                            downloadedBill = new File(docFixTempFilePath);
                        } else {
                            billDateText = (String)sortedBillLinksDates.get(billRound);
                            billDateTextBefore = billRound > 0 ? (String)sortedBillLinksDates.get(billRound - 1) : billDateText;
                            for (int i = 0; i < billLinks.size(); ++i) {
                                if (!((WebElement)billLinks.get(i)).getText().contains(billDateText)) continue;
                                nextBillToReadAsText = ((WebElement)billLinks.get(i)).getText();
                                nextBillLinkFromSortedDates = (WebElement)billLinks.get(i);
                                break;
                            }
                            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Datum der Rechnung (Kreditkartenabrechnung) aus Listeneintrag die nun verarbeitet wird: " + billDateText + " [" + nextBillToReadAsText + "]");
                            Date billDate = new SimpleDateFormat("dd.MM.yyyy").parse(billDateText);
                            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "billDate: " + billDate + " | " + billDate.getTime());
                            Date billDateBefore = new SimpleDateFormat("dd.MM.yyyy").parse(billDateTextBefore);
                            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "billDateBefore: " + billDateBefore + " | " + billDateBefore.getTime());
                            if (billDate.getTime() < fromDate.getTime() && !localPDFTest) {
                                LogDebug.invoke((Object)LogDebug, "BillDateText=" + billDateText + ";fromDateSimple=" + fromDateSimple + " --- Billdate '" + String.valueOf(billDate.getTime()) + "' soll nun kleiner sein als fromDate: '" + String.valueOf(fromDate.getTime()));
                                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + "Rechnung (" + ((WebElement)billLinks.get(billRound)).getText() + ") liegt au\u00dferhalb des Abrufdatum ... daher kein weiterer Abruf mehr");
                                haveNextPDFs = false;
                                haveNextSite = false;
                                continue block66;
                            }
                        }
                        downloadedFileIsFalse = false;
                        downloadCount = 1;
                        do {
                            if (!localPDFTest) {
                                String billViewLinkPath = "//*[contains(@class,'download__container')]";
                                try {
                                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] current original windowhandle are: " + seleniumWebDriver.getWindowHandle());
                                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] current original pagetitle: " + seleniumWebDriver.getTitle());
                                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] current original url: " + seleniumWebDriver.getCurrentUrl());
                                    JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                                    jse.executeScript("window.scrollTo(document.body.scrollHeight,0)", new Object[0]);
                                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                    nextBillLinkFromSortedDates.click();
                                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                    Thread.sleep(500L);
                                    jse.executeScript("window.scrollTo(document.body.scrollHeight,0)", new Object[0]);
                                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                    try {
                                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "billViewLink", billViewLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception error) {
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                    }
                                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                    Thread.sleep(1000L);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                ArrayList windowHandles = new ArrayList(seleniumWebDriver.getWindowHandles());
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] all current windowhandles: " + windowHandles);
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] *** switch the windowhandle to second tab ***");
                                seleniumWebDriver.switchTo().window((String)windowHandles.get(windowHandles.size() - 1));
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] title of second Page/Tab (after switch): " + seleniumWebDriver.getTitle());
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[headless download-fix in js-tab] url of second Page/Tab (after switch): " + seleniumWebDriver.getCurrentUrl());
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Warte auf die Fertigstellung des Downloads einer PDF-Rechnung ...");
                                do {
                                    Thread.sleep(500L);
                                    int waiter = 0;
                                    do {
                                        if ((downloadedBill = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                        Thread.sleep(1000L);
                                        ++waiter;
                                    } while (downloadedBill == null && waiter < 30);
                                    if (downloadedBill != null && downloadedBill.exists()) continue;
                                    if (downloadCount < 4) {
                                        try {
                                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "billViewLink", billViewLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                        }
                                        catch (Exception error) {
                                            isSelfException = true;
                                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                        }
                                        ++downloadCount;
                                        Thread.sleep(500L);
                                        waiter = 0;
                                        downloadedBill = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"));
                                        continue;
                                    }
                                    isSelfException = true;
                                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                                } while (downloadedBill.getAbsolutePath().endsWith(".crdownload"));
                            }
                            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "downloaded file: " + downloadedBill.getAbsolutePath());
                            fileType = downloadedBill.getName().substring(downloadedBill.getAbsolutePath().lastIndexOf("\\.") + 1).toUpperCase();
                            if (fileType.toLowerCase().equals("txt") || fileType.toLowerCase().equals("htm") || fileType.toLowerCase().equals("html") || fileType.toLowerCase().equals("asp") || fileType.toLowerCase().equals("js")) {
                                LogWarn.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "wrong downloaded file: " + downloadedBill.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                                ++downloadCount;
                                downloadedFileIsFalse = true;
                            } else {
                                downloadedFileIsFalse = false;
                            }
                            if (downloadCount < 4) continue;
                            isSelfException = true;
                            throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                        } while (downloadedFileIsFalse);
                        MemoryUsageSetting memUsageSetting = MemoryUsageSetting.setupTempFileOnly();
                        PDDocument pdf = Loader.loadPDF((File)downloadedBill);
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[PDDocument.load FILE]: " + pdf);
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Erzeuge einen Kontoauszug aus PDF ...");
                        try {
                            PDFTextStripper stripper = new PDFTextStripper();
                            stripper.setWordSeparator(";");
                            stripper.setSortByPosition(true);
                            billtext = stripper.getText(pdf);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Beim Lesen der PDF hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "getDataExport: soeben abgeholte und umgewandelte PDF-Rechnung (pdftext): \n" + billtext);
                        pdf.close();
                        String header = "Kaufdatum;Umsatz/Ort;Buchungs";
                        int idxStart = billtext.indexOf(header);
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "billtext - idxStart: " + idxStart);
                        int idxEnd = billtext.indexOf("Neuer Kontostand;", idxStart);
                        idxEnd = billtext.indexOf("\n", idxEnd);
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "billtext - idxEnd: " + idxEnd);
                        billtext = StringCharUtils.unescapeHtml4(billtext.substring(idxStart, idxEnd));
                        while (billtext.lastIndexOf(header) > 10) {
                            int startCutIDX = -1;
                            startCutIDX = billtext.contains("Pr\u00fcfen Sie Ihre Kartenabrechnung unverz") ? billtext.lastIndexOf("\n", billtext.indexOf("Pr\u00fcfen Sie Ihre Kartenabrechnung unverz")) : billtext.lastIndexOf("\n", billtext.indexOf("Kontoverbindung bei Einzahlungen"));
                            int endCutIDX = -1;
                            endCutIDX = billtext.contains("datum;rung;EUR") ? billtext.indexOf("\n", billtext.indexOf("datum;rung;EUR", startCutIDX)) : billtext.indexOf("\n", billtext.indexOf(header, startCutIDX));
                            billtext = billtext.substring(0, startCutIDX) + billtext.substring(endCutIDX);
                        }
                        if (!localPDFTest) {
                            FileUtils.copyFileToDirectory((File)downloadedBill, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "deleting downloaded pdf-bill file ...");
                            FileSysUtils.forceDeleteTarget(downloadedBill);
                        }
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + billtext + "\n======================= END DATA =======================\n");
                        transDataPDFs = transDataPDFs + "\n\n" + billtext.replace("\"", "");
                        if (localPDFTest) continue block66;
                        if (billRound >= billLinks.size() - 1 || localPDFTest) {
                            haveNextPDFs = false;
                            String pagingNavPath = "//*[contains(@class,'paging__position')]";
                            try {
                                if (seleniumWebDriver.findElement(By.xpath((String)pagingNavPath)) != null) {
                                    String pagePosition = seleniumWebDriver.findElement(By.xpath((String)pagingNavPath)).getText();
                                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "currentPagePosition: " + pagePosition);
                                    int currentPage = Integer.valueOf(pagePosition.split(" von ")[0]);
                                    int lastPage = Integer.valueOf(pagePosition.split(" von ")[1]);
                                    if (currentPage < lastPage) {
                                        haveNextSite = true;
                                        try {
                                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "nextPageButton", "//*[@data-mat-icon-name='navigate-next']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                            continue;
                                        }
                                        catch (Exception error) {
                                            isSelfException = true;
                                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                        }
                                    }
                                    haveNextSite = false;
                                    continue;
                                }
                                haveNextSite = false;
                            }
                            catch (NoSuchElementException finderror) {
                                haveNextSite = false;
                                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "xpath " + pagingNavPath + " NICHT gefunden; Es sollten keine weiteren Seiten vorhanden sein");
                            }
                            continue;
                        }
                        ++billRound;
                    }
                } while (haveNextSite);
            }
            catch (IOException ioerror) {
                LogWarn.invoke((Object)LogWarn, WebUtils.getLogIdent(bankArt) + getLogMethod + nextBillToReadAsText + " konnte nicht gelesen werden! Bitte im Onlinebanking den Zugriff pr\u00fcfen (IOException: Error: End-of-File)! Der PDF-Abruf wird daher hier beendet!");
                MonitorLog.invoke((Object)MonitorLog, "Fehler-Warnung!: " + nextBillToReadAsText + " konnte nicht gelesen werden! Bitte im Onlinebanking den Zugriff pr\u00fcfen (IOException: Error: End-of-File)! Der PDF-Abruf wird daher hier beendet!");
            }
            String dataResponse = "";
            if (localPDFTest) {
                transactionData = "";
                dataResponse = transDataPDFs;
            } else {
                dataResponse = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der " + WebUtils.getLongName(bankArt) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nKontostand:;" + amount + "\n\nBuchungsdatum;Valutadatum;Transaktions-ID;Kategorie;Kartennummer;Kurz-Nr.;Verwendungszweck;Betrag;Fremdbetrag;Fremdw\u00e4hrung;Wechselkurs;Bonuspunkte;Extrapunkte\n" + transactionData + "\n\n\n" + transDataPDFs;
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 65);
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "dataResponse: \n\n====================== BEGIN DATA ======================\n" + dataResponse + "\n======================= END DATA =======================\n");
            if (dataResponse.contains("<html") || dataResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataFile = new String[]{dataResponse, Double.toString(amount)};
            String[][] matrixArrayDataCSV = null;
            String[][] matrixArrayDataPDF = null;
            matrixArrayDataCSV = StringCharUtils.data2matrixArray(transactionData, '\"', ';', externalLogger);
            matrixArrayDataPDF = StringCharUtils.data2matrixArray(transDataPDFs, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayDataCSV.length; ++i) {
                if (matrixArrayDataCSV[i] == null) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "matrixArrayDataCSV: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayDataCSV[i][1].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataCSV: OK - diese hat die Grund-Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + e.toString());
                    continue;
                }
                if ((matrixArrayDataCSV[i][8] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][8]) || matrixArrayDataCSV[i][8].equals("0") || matrixArrayDataCSV[i][8].equals("0,00")) && matrixArrayDataCSV[i][3].contains("AMAZON PUNKTE")) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataCSV: Umsatz ohne Valuta-Datum, gilt als 'Vorgemerkt' und sind AMAZON-PUNKTE, Umsatzzeile wird daher nun ausgelassen ...");
                    continue;
                }
                if (matrixArrayDataCSV[i][8] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][8]) || matrixArrayDataCSV[i][8].equals("0") || matrixArrayDataCSV[i][8].equals("0,00")) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataCSV: Null-Umsatz, gilt als 'vorgemerkt', Umsatzzeile wird daher nun ausgelassen ...");
                    ++previewTransCount;
                    continue;
                }
                if (matrixArrayDataCSV[i][2] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][2]) && matrixArrayDataCSV[i][3].contains("AMAZON PUNKTE")) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataCSV: Umsatz ohne Valuta-Datum, gilt als 'Vorgemerkt' und sind AMAZON-PUNKTE, Umsatzzeile wird daher nun ausgelassen ...");
                    continue;
                }
                if (matrixArrayDataCSV[i][2] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][2])) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataCSV: Umsatz ohne Valuta-Datum, gilt als 'Vorgemerkt', Umsatzzeile wird daher nun ausgelassen ...");
                    ++previewTransCount;
                    if (matrixArrayDataCSV[i][8].equals("0,00") || matrixArrayDataCSV[i][8] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][8])) continue;
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "und Buchung im Status 'Vorgemerkt', Der Saldo wird aber auf Ungebucht gerechnet ...");
                    double unbookedEuroAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCSV[i][8], externalLogger));
                    unbookedAmount += unbookedEuroAmount;
                    ++unbookedTransCount;
                    --previewTransCount;
                    continue;
                }
                Date lastBillDate = new SimpleDateFormat("dd.MM.yyyy").parse(newestBillDate);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "lastBillDate: " + lastBillDate + " | " + lastBillDate.getTime());
                if (StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][2])) {
                    matrixArrayDataCSV[i][2] = matrixArrayDataCSV[i][1];
                }
                Date currentCSVdate = new SimpleDateFormat("dd.MM.yyyy").parse(matrixArrayDataCSV[i][2].substring(0, 10));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "CurrentCSVdate: " + currentCSVdate + " | " + currentCSVdate.getTime());
                if (currentCSVdate.getTime() <= lastBillDate.getTime() && !localPDFTest) {
                    LogDebug.invoke((Object)LogDebug, "NewestBillDate=" + newestBillDate + ";currentCSVdate=" + matrixArrayDataCSV[i][2].substring(0, 10) + " --- CurrentCSVdate '" + String.valueOf(currentCSVdate.getTime()) + "' soll nun kleiner oder gleich sein als NewestBillDate: '" + String.valueOf(lastBillDate.getTime()));
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + "CSV-Zeile (" + matrixArrayDataCSV[i][0] + ";" + matrixArrayDataCSV[i][1] + ";" + matrixArrayDataCSV[i][2] + ") ist in PDF-Rechnung enthalten ... daher kein weiteres Auslesen mehr");
                    break;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayDataCSV[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayDataCSV[i][2].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    if (StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][8])) {
                        isSelfException = true;
                        throw new Exception("Der Betrag konnte nich ausgelesen da das Felde leer sind");
                    }
                    double Betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCSV[i][8], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag *= -1.0);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][4]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayDataCSV[i][3]));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    String kommentarText = "";
                    String foreignAmount = StringCharUtils.shrinkString(matrixArrayDataCSV[i][5]);
                    String foreignCurrencyName = StringCharUtils.shrinkString(matrixArrayDataCSV[i][6]);
                    String foreignExchange = StringCharUtils.shrinkString(matrixArrayDataCSV[i][7]);
                    String shortCardNumber = StringCharUtils.shrinkString(matrixArrayDataCSV[i][0]);
                    String bonusPoints = StringCharUtils.shrinkString(matrixArrayDataCSV[i][9]).trim();
                    String additionalBonusPoints = StringCharUtils.shrinkString(matrixArrayDataCSV[i][10]).trim();
                    if (!(StringCharUtils.isNullOrEmptyOrNothing(foreignAmount) || foreignAmount.contains("\u20ac") || foreignAmount.equals("0"))) {
                        kommentarText = "Originalbetrag: " + foreignAmount;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(foreignCurrencyName)) {
                            kommentarText = kommentarText + " " + foreignCurrencyName;
                        }
                        if (!StringCharUtils.isNullOrEmptyOrNothing(foreignExchange)) {
                            kommentarText = kommentarText + "\nWechselkurs: " + foreignExchange;
                        }
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(shortCardNumber)) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + "Kartennummer (maskiert): " + shortCardNumber;
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(bonusPoints) && !bonusPoints.equals("0")) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + "Bonuspunkte: " + bonusPoints;
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(additionalBonusPoints) && !additionalBonusPoints.equals("0")) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText) && !StringCharUtils.isNullOrEmptyOrNothing(bonusPoints)) {
                            kommentarText = kommentarText + "\n";
                        } else if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + "Extra-Bonuspunkte: " + additionalBonusPoints;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentarText);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(new String()));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            String currentCard = "";
            for (int i = 0; i < matrixArrayDataPDF.length; ++i) {
                String[] copyClone;
                String[] checkColumn;
                if (matrixArrayDataPDF[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataPDF[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "matrixArrayDataPDF: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                if (matrixArrayDataPDF[i].length == 3 || matrixArrayDataPDF[i].length == 4 && !matrixArrayDataPDF[i][0].contains(".") && matrixArrayDataPDF[i][0].length() != 10) {
                    try {
                        checkColumn = matrixArrayDataPDF[i][1].split("\\.");
                        float testnumber = Float.parseFloat(checkColumn[0]);
                        testnumber = Float.parseFloat(checkColumn[1]);
                        testnumber = Float.parseFloat(checkColumn[2]);
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataPDF: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + e.toString());
                        continue;
                    }
                    currentCard = "";
                    copyClone = (String[])matrixArrayDataPDF[i].clone();
                    matrixArrayDataPDF[i] = new String[copyClone.length + 1];
                    matrixArrayDataPDF[i][0] = copyClone[1];
                    for (int dataset = 0; dataset < copyClone.length; ++dataset) {
                        matrixArrayDataPDF[i][dataset + 1] = copyClone[dataset];
                    }
                } else if (matrixArrayDataPDF[i][0].contains("AUSLANDSEINSATZENTGELT")) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + ">>> alten Auslandeinsatzengelt-Umsatz erkannt, hier die drie vorherigen Zeilen+diese selbst:\n" + Arrays.toString(matrixArrayDataPDF[i - 3]) + "\n" + Arrays.toString(matrixArrayDataPDF[i - 2]) + "\n" + Arrays.toString(matrixArrayDataPDF[i - 1]) + "\n" + Arrays.toString(matrixArrayDataPDF[i]));
                    copyClone = (String[])matrixArrayDataPDF[i].clone();
                    matrixArrayDataPDF[i] = new String[4];
                    if (matrixArrayDataPDF[i - 1][0].contains(".") && matrixArrayDataPDF[i - 1][0].length() == 10) {
                        matrixArrayDataPDF[i][0] = matrixArrayDataPDF[i - 1][0];
                        matrixArrayDataPDF[i][2] = matrixArrayDataPDF[i - 1][2];
                    } else if (matrixArrayDataPDF[i - 2][0].contains(".") && matrixArrayDataPDF[i - 2][0].length() == 10) {
                        matrixArrayDataPDF[i][0] = matrixArrayDataPDF[i - 2][0];
                        matrixArrayDataPDF[i][2] = matrixArrayDataPDF[i - 2][2];
                    } else if (matrixArrayDataPDF[i - 3][0].contains(".") && matrixArrayDataPDF[i - 3][0].length() == 10) {
                        matrixArrayDataPDF[i][0] = matrixArrayDataPDF[i - 3][0];
                        matrixArrayDataPDF[i][2] = matrixArrayDataPDF[i - 3][2];
                    } else {
                        String umsatz = copyClone[0] + ";" + copyClone[1];
                        if (copyClone.length > 2) {
                            umsatz = umsatz + copyClone[2];
                        }
                        isSelfException = true;
                        throw new Exception("Notwendiges Datum zu Auslandseinsatzentgelt konnte in den vorherigen Transaktionen nicht gefunden werden! (" + umsatz + ")");
                    }
                    matrixArrayDataPDF[i][1] = copyClone[0];
                    matrixArrayDataPDF[i][3] = copyClone.length > 2 ? copyClone[2] + copyClone[1] : copyClone[1];
                } else {
                    if (matrixArrayDataPDF[i][0].contains("Visa Karte") || matrixArrayDataPDF[i][0].contains("MasterCard")) {
                        currentCard = matrixArrayDataPDF[i][0];
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + ">>> aktuell auszulesende Karte: " + currentCard);
                        continue;
                    }
                    try {
                        checkColumn = matrixArrayDataPDF[i][0].split("\\.");
                        float testnumber = Float.parseFloat(checkColumn[0]);
                        testnumber = Float.parseFloat(checkColumn[1]);
                        testnumber = Float.parseFloat(checkColumn[2]);
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataPDF: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + e.toString());
                        continue;
                    }
                }
                try {
                    double betrag;
                    if (matrixArrayDataPDF[i].length != 7) {
                        copyClone = (String[])matrixArrayDataPDF[i].clone();
                        matrixArrayDataPDF[i] = new String[7];
                        matrixArrayDataPDF[i][0] = copyClone[0];
                        matrixArrayDataPDF[i][1] = copyClone[1];
                        matrixArrayDataPDF[i][2] = copyClone[2];
                        if (copyClone.length == 4) {
                            matrixArrayDataPDF[i][6] = copyClone[3];
                        } else if (copyClone.length == 5) {
                            matrixArrayDataPDF[i][6] = copyClone[4] + copyClone[3];
                        } else if (copyClone.length == 6) {
                            matrixArrayDataPDF[i][1] = copyClone[1] + copyClone[2];
                            matrixArrayDataPDF[i][2] = copyClone[3];
                            matrixArrayDataPDF[i][6] = copyClone[5] + copyClone[4];
                        } else if (copyClone.length > 7) {
                            matrixArrayDataPDF[i][3] = copyClone[3];
                            matrixArrayDataPDF[i][4] = copyClone[4];
                            matrixArrayDataPDF[i][5] = copyClone[5];
                            matrixArrayDataPDF[i][6] = copyClone[7] + copyClone[6];
                        }
                    }
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayDataPDF[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayDataPDF[i][2].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataPDF[i][6])) {
                        betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataPDF[i][6], externalLogger));
                        if (matrixArrayDataPDF[i].length == 5 && matrixArrayDataPDF[i][4].contains("-")) {
                            betrag *= -1.0;
                        }
                    } else {
                        isSelfException = true;
                        throw new Exception("Der Betrag konnte nich ausgelesen da das Felde leer sind");
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayDataPDF[i][1].contains("ZAHLUNG-LASTSCHRIFT")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("ZAHLUNG-LASTSCHRIFT");
                    } else if (String.valueOf(betrag).indexOf("-") == -1) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataPDF[i][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayDataPDF[i][1]));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    String kommentarText = "";
                    String foreignAmount = StringCharUtils.shrinkString(matrixArrayDataPDF[i][4]);
                    String foreignCurrencyName = StringCharUtils.shrinkString(matrixArrayDataPDF[i][3]);
                    String foreignExchange = StringCharUtils.shrinkString(matrixArrayDataPDF[i][5]);
                    if (!StringCharUtils.isNullOrEmptyOrNothing(foreignAmount) && !foreignAmount.equals("0")) {
                        if (foreignAmount.contains("-")) {
                            foreignAmount = "-" + foreignAmount.replace("-", "").trim();
                        } else if (foreignAmount.contains("+")) {
                            foreignAmount = "+" + foreignAmount.replace("+", "").trim();
                        }
                        kommentarText = "Originalbetrag: " + foreignAmount;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(foreignCurrencyName)) {
                            kommentarText = kommentarText + " " + foreignCurrencyName;
                        }
                        if (!StringCharUtils.isNullOrEmptyOrNothing(foreignExchange)) {
                            kommentarText = kommentarText + "\nWechselkurs: " + foreignExchange;
                        }
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(currentCard)) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + "Karte: " + currentCard;
                    }
                    if (matrixArrayDataPDF[i + 1][0].toLowerCase().contains("punkte")) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + matrixArrayDataPDF[i + 1][0];
                        if (matrixArrayDataPDF[i + 2][0].toLowerCase().contains("punkte")) {
                            kommentarText = kommentarText + "\n" + matrixArrayDataPDF[i + 2][0];
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentarText);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "Anzahl an vorgemerkter Transaktionen die nicht \u00fcbernommen wurden: " + previewTransCount);
            if (previewTransCount == 1) {
                MonitorLog.invoke((Object)MonitorLog, "Info: Es wurde 'eine' vorgemerkte Transaktion (noch) nicht in den Kontoauszug \u00fcbernommen");
            } else if (previewTransCount > 1) {
                MonitorLog.invoke((Object)MonitorLog, "Info: Es wurden '" + previewTransCount + "' vorgemerkte Transaktionen (noch) nicht in den Kontoauszug \u00fcbernommen");
            }
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "Anzahl an ungebuchten Transaktionen die nicht \u00fcbernommen wurden: " + unbookedTransCount);
            if (unbookedTransCount == 1) {
                MonitorLog.invoke((Object)MonitorLog, "Info: Es wurde 'eine' ungebuchte Transaktion (noch) nicht in den Kontoauszug \u00fcbernommen");
            } else if (unbookedTransCount > 1) {
                MonitorLog.invoke((Object)MonitorLog, "Info: Es wurden '" + unbookedTransCount + "' ungebuchte Transaktionen (noch) nicht in den Kontoauszug \u00fcbernommen");
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "needTransPurpFusion", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader(WebUtils.getShortName(bankArt), bankArt, amount, availableAmount, unbookedAmount, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

