/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.lbb;

import de.derrichter.finance.websync.institute.lbb.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        boolean localTest = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            if (!localTest) {
                LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + WebUtils.getShortName(bankArt) + "-Login aufrufen ... (GET " + WebUtils.getMainURL(bankArt) + "/security/login)");
                try {
                    seleniumWebDriver.get(WebUtils.getMainURL(bankArt) + "/security/login");
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)"username")));
                    WebElement inputUser = seleniumWebDriver.findElement(By.name((String)"username"));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "inputUser: " + inputUser);
                    WebElement inputPasswd = seleniumWebDriver.findElement(By.name((String)"password"));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "inputPasswd: " + inputPasswd);
                    inputUser.sendKeys(new CharSequence[]{responseLogin});
                    inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                    Thread.sleep(1000L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(.,'Login')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLogin2Response = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLogin2Response, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String tanArt = "mobileTAN";
                String detectTANformPath = "//div[@class='kkb-device-auth']";
                String secTextPath = "//div[@class='kkb-registration-tan']//p[1]";
                String tanInputPath = "//input[contains(@id,'input') and @maxlength='6']";
                String submitTanPath = "//button[contains(.,'freischalten')]";
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                try {
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "rememberDevice", "//input[@name='rememberDevice']//parent::label", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "startUnlockButton", "//button[@id='start-unlock-btn']//parent::label", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String secText = seleniumWebDriver.findElement(By.xpath((String)secTextPath)).getText().trim();
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, WebUtils.getLogoPath(bankArt));
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                }
                catch (NoSuchElementException | TimeoutException noSecondSec) {
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
                }
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(.,'Verf\u00fcgbar') and contains(@class,'wheel')]")));
                }
                catch (NoSuchElementException | TimeoutException noSecondSec) {
                    try {
                        WebElement checkLoginField = seleniumWebDriver.findElement(By.name((String)"username"));
                        isSelfException = true;
                        throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Bitte pr\u00fcfen Sie dies zuerst manuell Online, ansonsten informieren Sie bitte den Entwickler im Forum");
                    }
                    catch (NoSuchElementException | TimeoutException throwable) {
                        // empty catch block
                    }
                }
            }
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "Abmelden von der Onlinebanking-Website ...");
            try {
                Actions action = new Actions(seleniumWebDriver);
                WebElement we = seleniumWebDriver.findElement(By.xpath((String)"(//div[@class='user-menu']//div)"));
                action.moveToElement(we).moveToElement(seleniumWebDriver.findElement(By.xpath((String)"(//span[contains(text(),'Abmelden')]//parent::a)"))).click().build().perform();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPageXML = seleniumWebDriver.getPageSource();
            String successLogoutXpath = "//input[@name='username']";
            try {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "Logout bei der '" + WebUtils.getLongName(bankArt) + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

