/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.ingdiba;

import de.derrichter.finance.websync.institute.ingdiba.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPush {
    private static String secAuthMeth = "BankingApp";

    public static String getSecAuthMeth() {
        return secAuthMeth;
    }

    public static void setSecAuthMeth(String value) {
        secAuthMeth = value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void transfer(WebDriver seleniumWebDriver, String kontonummer, String gegenkontoName, String gegenkontoIBAN, String gegenkontoBIC, String betrag, String verwendungszweck, String termin, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        Method DialogAskBankingApp = externalDialogInterface.getMethod("askBankingAppforTransaction", String.class, String.class, String.class);
        String getLogMethod = "[sendTrans] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Originale Auftragsdaten wie vom Programm \u00fcbergeben (Auftragskonto, IBAN, BIC und Betrag sind aber schon getrimmt)");
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Auftragskonto (IBAN):             " + gegenkontoName);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Auftragskonto (IBAN):             " + kontonummer);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Gegenkonto (IBAN):                " + gegenkontoIBAN);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Gegenkonto (BIC):                 " + gegenkontoBIC);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Auftragsdaten (Betrag):           " + betrag);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Auftragsdaten (Verwendungszweck): " + verwendungszweck);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Auftragsdaten (Termin):           " + termin);
        kontonummer = kontonummer.replaceAll("\\s+", "").trim();
        gegenkontoIBAN = gegenkontoIBAN.replaceAll("\\s+", "").trim();
        gegenkontoBIC = gegenkontoBIC.replaceAll("\\s+", "").trim();
        betrag = betrag.replaceAll("[^\\d,]", "").trim();
        gegenkontoName = gegenkontoName.replace("\u00c4", "Ae").replace("\u00e4", "ae").replace("\u00d6", "Oe").replace("\u00f6", "oe").replace("\u00dc", "Ue").replace("\u00fc", "ue").replace("\u00df", "ss").trim();
        verwendungszweck = verwendungszweck.replace("\u00c4", "Ae").replace("\u00e4", "ae").replace("\u00d6", "Oe").replace("\u00f6", "oe").replace("\u00dc", "Ue").replace("\u00fc", "ue").replace("\u00df", "ss").trim();
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        try {
            block63: {
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:ING] ", "ING-DiBa AG", "institutlogo-ingdibasepa.png", WebUtils.COOKIE_DETECT_PATH2, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                String detectPath = "//section[contains(@class,'insight') and @aria-hidden='false']";
                String messagePath = detectPath + "//h1";
                String closePath = "//div[contains(@class,'close')]";
                SeleniumUtils.checkAndCloseInfoMessage(seleniumWebDriver, "[WebSync:ING] ", "ING-DiBa AG", "https://banking.ing.de/app/obligo", "institutlogo-ingdibasepa.png", detectPath, messagePath, closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
                LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Kontonummer (formated): " + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer));
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//span[contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer) + "')]"))));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
                }
                catch (NoSuchElementException | TimeoutException noCreditCard) {
                    isSelfException = true;
                    throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                MonitorLog.invoke((Object)MonitorLog, "SEPA-\u00dcberweisungsformular aufrufen, ausf\u00fcllen und Authentifizierung anfordern ...");
                LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "SEPA-\u00dcberweisungsformular aufrufen, ausf\u00fcllen und Authentifizierung anfordern ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "transferFormLink", "//ing-button[contains(.,'berweisung')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "Zu belastendes Konto ausw\u00e4hlen ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountSelectOption", "//a[contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer) + "')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String resNamePath = "//textarea[contains(@name,'zahlungsempfaenger')]";
                String resIbanPath = "//input[contains(@name,'iban')]";
                String resAmountPath = "//input[contains(@name,'betrag')]";
                String resPurposePath = "//textarea[contains(@name,'verwendungszweck')]";
                String continueButtonPath = "//button[contains(@name,'next')]";
                String accountSelectorPath = "//select[contains(@name,'empfaengerkonto')]";
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)resPurposePath)));
                try {
                    try {
                        String contactButtonPath = "//option[contains(.,'" + gegenkontoIBAN + "') or contains(.,'" + StringCharUtils.ibanAddSpaces(gegenkontoIBAN) + "')]";
                        LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "Pr\u00fcfe auf vorgegebenes Gegenkonto...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)contactButtonPath)));
                        MonitorLog.invoke((Object)MonitorLog, "INFO: F\u00fcr diese Gegenkonto-IBAN ist ein vorgegebenes Konto vorhanden. Da dieses genutzt wird, wird der angegebene Name nun nicht \u00fcbernommen!");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "F\u00fcr diese Gegenkonto-IBAN ist ein vorgegebenes Konto vorhanden. Da dieses genutzt wird, wird der angegebene Name nun nicht \u00fcbernommen!");
                        Select accountSelect = new Select(seleniumWebDriver.findElement(By.xpath((String)accountSelectorPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "accountSelect: " + accountSelect);
                        for (WebElement option : accountSelect.getOptions()) {
                            if (!option.getText().contains(gegenkontoIBAN) && !option.getText().contains(StringCharUtils.ibanAddSpaces(gegenkontoIBAN))) continue;
                            accountSelect.selectByIndex(Integer.parseInt(option.getAttribute("value")));
                        }
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    catch (NoSuchElementException | TimeoutException noContact) {
                        try {
                            Select accountSelect = new Select(seleniumWebDriver.findElement(By.xpath((String)accountSelectorPath)));
                            String optionsTexts = "";
                            Iterator option = accountSelect.getOptions().iterator();
                            while (true) {
                                if (!option.hasNext()) {
                                    isSelfException = true;
                                    throw new Exception("Dieses Konto unterst\u00fctzt das Gegenkonto als Empf\u00e4nger nicht.\nFest vorgegebene IBANs sind: " + optionsTexts);
                                }
                                WebElement option2 = (WebElement)option.next();
                                optionsTexts = optionsTexts + option2.getText().split("/")[0].replace(" ", "") + "; ";
                            }
                        }
                        catch (NoSuchElementException | TimeoutException accountSelect) {
                            WebElement resNameField = seleniumWebDriver.findElement(By.xpath((String)resNamePath));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "resNameField: " + resNameField);
                            resNameField.sendKeys(new CharSequence[]{gegenkontoName});
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                            WebElement resIbanField = seleniumWebDriver.findElement(By.xpath((String)resIbanPath));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "resIban: " + resIbanPath);
                            resIbanField.sendKeys(new CharSequence[]{gegenkontoIBAN});
                            String pageNewContact = seleniumWebDriver.getPageSource();
                            try {
                                WebUtils.checkSeleniumResponseHasError(pageNewContact, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception(error.getMessage());
                            }
                        }
                    }
                    WebElement resAmountField = seleniumWebDriver.findElement(By.xpath((String)resAmountPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "resAmount: " + resAmountField);
                    resAmountField.sendKeys(new CharSequence[]{betrag});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    WebElement resPurposeField = seleniumWebDriver.findElement(By.xpath((String)resPurposePath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "resPurposeField: " + resPurposePath);
                    resPurposeField.sendKeys(new CharSequence[]{verwendungszweck});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(500L);
                }
                catch (Exception error) {
                    if (isSelfException) {
                        throw new Exception(error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen der Auftrags-Werte (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 35);
                TakesScreenshot screenshotObject = null;
                String screenShotBASE64 = null;
                String tempScreenshotPath = null;
                String currentSourceToView = null;
                try {
                    try {
                        WebElement beginning = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'accountselector')]"));
                        JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                        jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{beginning});
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    catch (Exception error) {
                        LogError.invoke((Object)LogError, "[WebSync:ING] " + getLogMethod + "Scrollen zum Anfang des Formulars fehlgeschlagen: " + error.getMessage());
                    }
                    screenshotObject = (TakesScreenshot)seleniumWebDriver;
                    File screenShotFile = (File)screenshotObject.getScreenshotAs(OutputType.FILE);
                    tempScreenshotPath = System.getProperty("java.io.tmpdir") + File.separator + "syncWebClient_ScreenCaptureTmp" + File.separator + "ingdiba" + String.valueOf(new Date().getTime()) + "-transfer.png";
                    FileUtils.moveFile((File)screenShotFile, (File)new File(tempScreenshotPath));
                    String screenShotRawBASE64 = (String)screenshotObject.getScreenshotAs(OutputType.BASE64);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "screenShotRawBASE64: " + screenShotRawBASE64);
                    screenShotBASE64 = "data:image/png;base64," + screenShotRawBASE64;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "screenShotBASE64: " + screenShotBASE64);
                    currentSourceToView = tempScreenshotPath;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Sichtkontrollseite konnte nicht erstellt werden; Errorseite vermutlich erstellt: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
                if (!WebPush.getSecAuthMeth().equals("BankingApp")) {
                    isSelfException = true;
                    throw new Exception("Verifizierungs-Verfahren nicht bekannt (Bitte dem Entwickler im Forum melden)");
                }
                try {
                    String userInfoText = "Mit einem Klick auf 'Ausf\u00fchren' wird der Auftrag abgesendet und somit die Authentifizierung per Banking-App angefragt.\nBitte best\u00e4tigen Sie die Daten.\n\nEmpf\u00e4nger: " + gegenkontoName + "\nEmpf\u00e4nger IBAN: " + gegenkontoIBAN + "\nAuftragsdatum: " + new SimpleDateFormat("dd.MM.yyyy").format(new Date().getTime()) + "\nBetrag: " + betrag + "" + System.getProperty("line.separator");
                    DialogAskBankingApp.invoke((Object)DialogAskBankingApp, userInfoText, currentSourceToView, "institutlogo-ingdibasepa.png");
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "Auftrag wird abgesendet und somit die Banking-APP-Freigabe angefordert ...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "continueButton", continueButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception clickError) {
                        throw new Exception(clickError.getMessage());
                    }
                    String pageBeforeTransSend = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageBeforeTransSend, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'Bitte w\u00e4hlen Sie Ihr Ger\u00e4t')]"));
                        LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "Mit dem vor-selektiertem Ger\u00e4t weiter machen...");
                        boolean hasPreSelected = false;
                        List devices = seleniumWebDriver.findElements(By.xpath((String)"//input[@type='radio']"));
                        for (int d = 1; d <= devices.size(); ++d) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + WebPush.getSecAuthMeth() + "Device #" + d + ": isEnabled: " + ((WebElement)devices.get(d - 1)).isEnabled() + " | isSelected: " + ((WebElement)devices.get(d - 1)).isSelected());
                            if (!((WebElement)devices.get(d - 1)).isSelected()) continue;
                            hasPreSelected = true;
                        }
                        if (!hasPreSelected) {
                            ((WebElement)seleniumWebDriver.findElements(By.xpath((String)"//input[@type='radio']")).get(0)).click();
                        }
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "sendButton", "//button[contains(@name,'next')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    catch (NoSuchElementException hasPreSelected) {
                        // empty catch block
                    }
                    try {
                        String detectTANformPath = "//*[contains(.,'den Auftrag freigeben')]";
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "Banking-App als abfragendes 2FA-Sicherheitsverfahren erkannt");
                        WebElement waiterCheck = null;
                        MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                        int rounds = 0;
                        Thread.sleep(3000L);
                        boolean waitAppAuth = true;
                        do {
                            try {
                                waiterCheck = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                            }
                            catch (NoSuchElementException | TimeoutException noBestSign) {
                                waitAppAuth = false;
                            }
                            if (waitAppAuth) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:ING] Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                                Thread.sleep(3000L);
                                ++rounds;
                            }
                            if (rounds < 79) continue;
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung auch nach 4 Minuten nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                        } while (waitAppAuth);
                    }
                    catch (Exception error) {
                        if (isSelfException) {
                            throw new Exception(error.getMessage());
                        }
                        isSelfException = true;
                        throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    pageResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    if (!currentSourceToView.contains("syncWebClient")) break block63;
                }
                catch (InvocationTargetException error) {
                    try {
                        if (isSelfException) {
                            throw new Exception(error.getMessage());
                        }
                        isSelfException = true;
                        if (ExceptionUtils.getRootCauseStackTrace((Throwable)error)[0].contains("OperationCanceledException")) {
                            throw new Exception("Anfrage der Banking-APP-Freigabe vom Benutzer abgebrochen (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:ING] " + getLogMethod + "DialogAskBankingApp fehlerhaft:" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("DialogAskBankingApp fehlerhaft: " + error.getMessage());
                        catch (Exception error2) {
                            if (isSelfException) {
                                throw new Exception(error2.getMessage());
                            }
                            isSelfException = true;
                            throw new Exception("Anfrage der Banking-APP-Freigabe vom Benutzer abgebrochen oder DialogAskBankingApp fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error2));
                        }
                    }
                    catch (Throwable throwable) {
                        if (!currentSourceToView.contains("syncWebClient")) throw throwable;
                        try {
                            FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                            throw throwable;
                        }
                        catch (Exception error3) {
                            LogError.invoke((Object)LogError, "[WebSync:ING] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error3.getMessage());
                        }
                        throw throwable;
                    }
                }
                try {
                    FileUtils.forceDelete((File)new File(currentSourceToView).getParentFile());
                }
                catch (Exception error) {
                    LogError.invoke((Object)LogError, "[WebSync:ING] " + getLogMethod + "L\u00f6schen der Sichtkontrolle fehlgeschlagen: " + error.getMessage());
                }
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 70);
            String successPinAuthPath = "//*[contains(.,'Ihr Auftrag wurde angenommen')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "Auftrag wohl erfolgreich, da xpath: " + successPinAuthPath + wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successPinAuthPath))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Erfolgreiche Ausf\u00fchrung des Auftrags konnte nicht best\u00e4tigt werden! Bitte online pr\u00fcfen. (Falls dennoch ausgef\u00fchrt: Wenn notwendig, Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)" + ExceptionUtils.getStackTrace((Throwable)notFounderr));
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 85);
            return;
        }
        catch (Exception error) {
            if (!isSelfException) throw new Exception("Exception beim Ausf\u00fchren des Auftrags: " + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception(error.getMessage());
        }
    }
}

