/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.ingdiba;

import de.derrichter.finance.websync.institute.ingdiba.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "fromDateSimple: " + fromDateSimple);
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "toDateSimple: " + toDateSimple);
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        Date dateFrom = sdf.parse(fromDateSimple);
        long dateFromMilli = dateFrom.getTime();
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "dateFromMilli: " + dateFromMilli);
        long dateToMilli = System.currentTimeMillis();
        LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "dateToMilli: " + String.valueOf(dateToMilli));
        try {
            double availableAmount;
            double amount;
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:ING] ", "ING-DiBa AG", "institutlogo-ingdibasepa.png", WebUtils.COOKIE_DETECT_PATH2, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            String detectPath = "//section[contains(@class,'insight') and @aria-hidden='false']";
            String messagePath = detectPath + "//div[contains(@class,'content')]";
            String closePath = "//button[contains(@class,'close')]";
            SeleniumUtils.checkAndCloseInfoMessage(seleniumWebDriver, "[WebSync:ING] ", "ING-DiBa AG", "https://banking.ing.de/app/obligo", "institutlogo-ingdibasepa.png", detectPath, messagePath, closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
            LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
            LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Kontonummer (formated): " + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer));
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//span[contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer) + "')]"))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "read amount ...");
                String amountPath = "//span[contains(@class,'details') and contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer) + "')]//following-sibling::span[contains(@class,'amount')]";
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountPath)));
                String amountText = seleniumWebDriver.findElement(By.xpath((String)amountPath)).getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "amountText: " + amountText);
                availableAmount = amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("Auslesen des Kontostands fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
            String csvResponse = "Dies ist ein reines Saldo-Konto als Saldo-Info zum SEPA-Transfer";
            String[] dataResponse = new String[]{csvResponse, String.valueOf(amount)};
            String[][] matrixArrayDataCSV = StringCharUtils.data2matrixArray(csvResponse, '\"', ',', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            int transDateCount = 1;
            for (int i = 0; i < matrixArrayDataCSV.length; ++i) {
                if (matrixArrayDataCSV[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "matrixArrayDataCSV: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayDataCSV[i][0].split("-");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] matrixArrayDataCSV: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayDataCSV[i][0].split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[0], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[2], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    Double Betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCSV[i][5], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][3]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][4]);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][3]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][2])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][2]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][1]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    String iban = matrixArrayDataCSV[i][2];
                    String gegenkontoNummer = "";
                    String GegenkontoBLZ = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(iban) && StringCharUtils.isIbanCountryStructure(iban) && iban.startsWith("DE")) {
                        gegenkontoNummer = iban.substring(12, 22);
                        GegenkontoBLZ = iban.substring(4, 12);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(iban)) {
                        gegenkontoNummer = iban;
                        if (!StringCharUtils.isIbanCountryStructure(iban)) {
                            iban = "";
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][6])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Betrag Fremdw\u00e4hrung: " + matrixArrayDataCSV[i][6] + " " + matrixArrayDataCSV[i][7] + "\nWechselkurs: " + matrixArrayDataCSV[i][8]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + StringCharUtils.shrinkString(((ArrayList)transactionDataList.get(arrayRowCount)).get(12).toString()));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    ++transDateCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("ING", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

