/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.ingdiba;

import de.derrichter.finance.websync.institute.ingdiba.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "ING" + "-Login aufrufen ... (GET " + "https://banking.ing.de/app/obligo" + ")");
            try {
                seleniumWebDriver.get("https://banking.ing.de/app/obligo");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:ING] ", "ING-DiBa AG", "institutlogo-ingdibasepa.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            try {
                String userPath = "//input[contains(@name,'alias')]";
                String passPath = "//input[contains(@name,'secret')]";
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userPath)));
                WebElement inputUser = seleniumWebDriver.findElement(By.xpath((String)userPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "inputUser: " + inputUser);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)passPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:ING] " + getLogMethod + "inputPasswd: " + inputPasswd);
                inputUser.click();
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                inputPasswd.click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(@name,'next')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                if (WebUtils.checkForBankingApp(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "ING" + "-2FA-Login mit Banking durchlaufen");
                } else if (WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "ING" + "-2FA-Login mit mTAN durchlaufen");
                } else {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "2FA-Verfahren nicht erkannt, daher wohl nicht notwendig, mache weiter..." + seleniumWebDriver.getPageSource());
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@name,'zugangskennung')]"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Bitte pr\u00fcfen Sie dies zuerst manuell Online, ansonsten informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:ING] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "Abmelden aufrufen...");
            try {
                WebElement shadowHost = seleniumWebDriver.findElement(By.cssSelector((String)"ing-header"));
                LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Navigation shadowHost:\n" + shadowHost.getAttribute("outerHTML"));
                SearchContext shadowRoot = shadowHost.getShadowRoot();
                WebElement shadowHost2 = shadowRoot.findElement(By.cssSelector((String)"ing-session-button"));
                LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Session shadowHost:\n" + shadowHost.getAttribute("outerHTML"));
                SearchContext shadowRoot2 = shadowHost2.getShadowRoot();
                WebElement shadowContent = shadowRoot2.findElement(By.cssSelector((String)"button[class='session-button__logout-button']"));
                shadowContent.click();
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[contains(.,'erfolgreich abgemeldet')]")));
                LogInfo.invoke((Object)LogInfo, "[WebSync:ING] " + getLogMethod + "Logout bei der '" + "ING-DiBa AG" + "' war erfolgreich");
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                LogTrace.invoke((Object)LogTrace, "[WebSync:ING] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:ING] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

