/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.ikanobank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlPage;

public class WebUtils {
    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> externalLogger, Class<?> ExternalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        boolean isSelfException = false;
        try {
            String errorMessage = null;
            if (responseContentAsString.contains("class=\"error\"") || responseContentAsString.contains("class=\"ui-messages-error-summary\"")) {
                if (responseContentAsString.contains("Die Suche ergab zu viele Treffer und wurde automatisch eingeschr")) {
                    return null;
                }
                errorMessage = WebUtils.formErrorMessage(responsePage, externalLogger, ExternalProgressMonitor);
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Ikano Bank AB (publ):\n\n\n" + errorMessage, "institutlogo-ikanobank.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("wurden automatisch vom System abgemeldet")) {
                isSelfException = true;
                throw new Exception("Die Online Banking Sitzung ist abgelaufen. Bitte melden Sie sich erneut an.");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(Page responsePage, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            String formErrorText = ((DomElement)((HtmlPage)responsePage).getFirstByXPath("//span[contains(@class,'messages-error-summary')]")).asNormalizedText();
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

