/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.ikanobank;

import de.derrichter.finance.websync.institute.ikanobank.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSpan;

public class WebPull {
    public static ArrayList getTransData(WebClient syncWebClient, String kundenummer, String kontonummer, String Unterkonto, String BLZ, String fromDateSimple, String toDateSimple, HtmlPage postLoginPage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        HtmlPage dataPage = null;
        try {
            int i;
            String responsePageXML = postLoginPage.asXml();
            String responsePageText = postLoginPage.asNormalizedText();
            if (!responsePageXML.contains("Kontostand") && !responsePageXML.contains("Account balance")) {
                throw new Exception("Auf der Seite konnte kein Kontostand gefunden werden. Falsche oder andere Seite");
            }
            String amountText = ((HtmlSpan)postLoginPage.getFirstByXPath("//span[@id='creditinfoMinRepayAmo']")).asNormalizedText();
            LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "amountText: " + amountText);
            double amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "Amount: " + amount);
            LogInfo.invoke((Object)LogInfo, "[WebSync:IkanoBank] " + getLogMethod + "Umsatzsuche aufrufen ... (GET " + "https://www.ikano-storeportal.de/plus-iss/iss/login.xhtml?prodCode=IB1DP&_ga=2.62082665.476520232.1520414199-2052144078.1481700067&&&&&&&&&&&&&&&&&&&&&&source=DE_Br_Brand&searchString=CjwKCAjwtuOlBhBREiwA7agf1iHrS4SgK9a_Rsb9PG2Osxx0CDX-PPKoLbm2Z9vTZKfJXgByU6rxLBoCRZIQAvD_BwE" + ")");
            try {
                dataPage = (HtmlPage)syncWebClient.getPage("https://www.ikano-storeportal.de/plus-iss/iss/auth/showTransactions/transactions.xhtml?dswid=531");
                syncWebClient.waitForBackgroundJavaScript(10000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "dataPage: " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String dataPageXML = dataPage.asXml();
            try {
                WebUtils.checkResponse(dataPageXML, (Page)dataPage, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (dataPage == null) {
                throw new Exception("Die Umsatz\u00fcbersicht konnte nicht aufgerufen werden!");
            }
            String transData = "";
            boolean firstRun = true;
            boolean searchForTransactions = true;
            while (searchForTransactions) {
                HtmlForm form;
                try {
                    form = dataPage.getFormByName("transactionsForm");
                    form.getInputByName("transactionsForm:startdate_input").setValue(fromDateSimple);
                    form.getInputByName("transactionsForm:enddate_input").setValue(toDateSimple);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    dataPage = (HtmlPage)form.getButtonByName("transactionsForm:refreshButton").click();
                    syncWebClient.waitForBackgroundJavaScript(10000L);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "dataPage (Suche): " + dataPage);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                dataPageXML = dataPage.asXml();
                try {
                    WebUtils.checkResponse(dataPageXML, (Page)dataPage, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                if (dataPage == null) {
                    throw new Exception("Die Suche-Folgeseite konnte nicht aufgerufen werden!");
                }
                if (dataPageXML.contains("transactionsCount\">0</span>") && firstRun) {
                    transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Ikano Bank AB (publ)\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "Anzahl der Transaktionen:;0\nKontostand:;" + amount + "\n\nBuchungsdatum;Valutadatum;Transaktion;Absender / Empf\u00e4nger;Verwendungszweck;Betrag\nIm gew\u00e4hltem Abrufzeitraum sind keine Transaktionen vorhanden";
                    searchForTransactions = false;
                    continue;
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "Transaktionsdaten aus der Homepage exportieren ...");
                int transCount = dataPage.getByXPath("//tr[@data-ri]").size();
                LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "transCount nach xPath: " + transCount);
                int dataCount = Integer.valueOf(((HtmlSpan)dataPage.getFirstByXPath("//span[contains(@id,'transactionsCount')]")).asNormalizedText());
                LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "dataCount Angabe auf Seite: " + dataCount);
                if (dataCount != transCount) {
                    LogWarn.invoke((Object)LogWarn, "[WebSync:IkanoBank] " + getLogMethod + "dataCount, also Angabe auf Seite ist nicht gleich xPath-Suche!");
                }
                try {
                    String lastBelegData = null;
                    if (dataPageXML.contains("Die Suche ergab zu viele Treffer und wurde automatisch eingeschr")) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:IkanoBank] Die Suche ergab zu viele Treffer und wurde automatisch eingeschr\u00e4h; lese letzes Belegdatum aus und rufe ab diesem weiter ab ...");
                        lastBelegData = (String)dataPage.getFirstByXPath("(//tr[@data-ri='" + (transCount - 1) + "']//td)[1]//span[2]");
                        String[] arraydatum = lastBelegData.substring(0, 10).split("\\.");
                        Date lastDate = SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10));
                        fromDateSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date(lastDate.getTime()));
                    } else {
                        searchForTransactions = false;
                        lastBelegData = null;
                    }
                    if (firstRun) {
                        transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Ikano Bank AB (publ)\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "Anzahl der Transaktionen:;" + dataCount + "\nKontostand:;" + amount + "\n\nBuchungsdatum;Valutadatum;Transaktion/Art;Absender-Empf\u00e4nger/Referenz;Verwendungszweck;Betrag\n";
                        firstRun = false;
                    }
                    for (i = 0; i < transCount; ++i) {
                        String senderData;
                        double MonitorPercent = 30.0 + 29.0 / (double)dataCount * (double)(i + 1);
                        MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                        String belegData = StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[1]//span[2]")).asNormalizedText());
                        LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "belegData: " + belegData);
                        if (belegData.equals(lastBelegData)) continue;
                        String valutaData = !BLZ.equals("51430300") && !kontonummer.equals("0011218055") && !kontonummer.equals("0011218205") ? StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[2]//span[2]")).asNormalizedText()) : belegData;
                        LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "valutaData: " + valutaData);
                        String artData = !BLZ.equals("51430300") && !kontonummer.equals("0011218055") && !kontonummer.equals("0011218205") ? StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[3]//span[2]")).asNormalizedText()) : StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[2]//span[2]")).asNormalizedText());
                        LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "artData: " + artData);
                        if (!(BLZ.equals("51430300") || kontonummer.equals("0011218055") || kontonummer.equals("0011218205"))) {
                            senderData = StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[4]//span[2]")).asNormalizedText());
                            LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "accData: " + senderData);
                        } else {
                            senderData = StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[3]//span[2]")).asNormalizedText());
                            LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "accData: " + senderData);
                        }
                        String zweckData = !BLZ.equals("51430300") && !kontonummer.equals("0011218055") && !kontonummer.equals("0011218205") ? StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[5]//span[2]")).asNormalizedText()) : StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[4]//span[2]")).asNormalizedText());
                        LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "zweckData: " + zweckData);
                        String saldoData = !BLZ.equals("51430300") && !kontonummer.equals("0011218055") && !kontonummer.equals("0011218205") ? StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[6]//span[2]")).asNormalizedText()) : StringCharUtils.shrinkString(((HtmlSpan)dataPage.getFirstByXPath("(//tr[@data-ri='" + i + "']//td)[5]//span[2]")).asNormalizedText());
                        LogDebug.invoke((Object)LogDebug, "[WebSync:IkanoBank] " + getLogMethod + "saldoData: " + saldoData);
                        transData = transData + belegData + ";" + valutaData + ";" + artData + ";" + senderData + ";" + zweckData + ";" + saldoData + "\n";
                        transData = StringEscapeUtils.unescapeHtml4((String)transData);
                    }
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Die Transaktionsdaten konnten nicht ohne Fehler ausgelesen werden (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (transData != null) continue;
                throw new Exception("Der Kontoauszug konnte nicht erstellt werden! (TransData=NULL)");
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            if (transData.contains("<html") || transData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] DataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][5], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2].replaceAll(kontonummer, ""));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][4].replaceAll(kundenummer, "").replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2].replaceAll(kontonummer, ""));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String GegenkontoName = "";
                    String GegenkontoNummer = "";
                    String GegenkontoBLZ = "";
                    String IBAN2 = "";
                    String BIC = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3]) && !matrixArrayData[i][3].equals(" - ")) {
                        String Gegenkonto = StringCharUtils.shrinkString(matrixArrayData[i][3]);
                        String[] GegenkontoArray = Gegenkonto.split(" - ");
                        if (GegenkontoArray.length > 0 && !GegenkontoArray[0].contains(" - ")) {
                            GegenkontoName = GegenkontoArray[0];
                        }
                        if (GegenkontoArray.length > 1) {
                            String[] GegenkontoArray2 = GegenkontoArray[1].split("/");
                            if (GegenkontoArray2.length > 0 && !GegenkontoArray2[0].contains("/")) {
                                GegenkontoNummer = GegenkontoArray2[0];
                            }
                            if (GegenkontoArray2.length > 1) {
                                GegenkontoBLZ = GegenkontoArray2[1];
                            }
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(IBAN2);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(BIC);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    if (matrixArrayData[i][4].indexOf(kundenummer) != -1) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(kundenummer);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:IkanoBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("IkanoBank", kontonummer, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

