/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.hanseaticbank;

import de.derrichter.finance.websync.institute.hanseaticbank.InstitutOptions;
import de.derrichter.finance.websync.institute.hanseaticbank.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            try {
                String detectPath = "//div[contains(@class,'modal-dialog-centered')]";
                String messagePath = detectPath + "//*[@class='modal-title']";
                String closePath = detectPath + "//button[contains(@class,'close')]";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String formWarnText = "";
                    List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                    for (WebElement headline : allHeadlines) {
                        String headlinetext = headline.getText();
                        formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:HanseaticBank] ", headlinetext, externalLogger) + " ";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "warnText: " + formWarnText);
                    if (!formWarnText.contains("Freigabeverfahren verwalten")) {
                        DialogWarn.invoke((Object)DialogWarn, "Meldung der Hanseatic Bank:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://meine.hanseaticbank.de/de/register/sign-in" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-hanseaticbank.png");
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasAbortButton = false;
                        isSelfException = true;
                        throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                    }
                    hasAbortButton = true;
                    LogWarn.invoke((Object)LogWarn, "[WebSync:HanseaticBank] Meldung(en) der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            String transData = "";
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            double unbookedAmount = 0.0;
            boolean localTest = false;
            if (!localTest) {
                WebElement lastDate;
                LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
                LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "Kontonummer (formated): " + kontonummer);
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//a[contains(.,'" + kontonummer + "')]"))));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
                }
                catch (NoSuchElementException | TimeoutException noCreditCard) {
                    isSelfException = true;
                    throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "Account-Seite aufrufen ...");
                try {
                    seleniumWebDriver.get(InstitutOptions.ACCOUNT_URL);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String dataPageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(dataPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "Karte aufrufen ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardTabButton", "//div[@data-test-id='button-tab']//div[contains(.,'" + kontonummer + "')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    String amountText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@data-test-id,'current-balance')]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "amountText: " + amountText);
                    amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
                }
                try {
                    String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@data-test-id,'available-amount')]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "availableAmountText: " + availableAmountText);
                    availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage());
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "Amount: " + amount);
                LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "availableAmount: " + availableAmount);
                String returnToAccountOverviewnPath = "//a[@data-test-id='link-account-overview']";
                WebElement returnToAccountOverview = seleniumWebDriver.findElement(By.xpath((String)returnToAccountOverviewnPath));
                JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{returnToAccountOverview});
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "returnToAccountOverview", returnToAccountOverviewnPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String moreButtonPath = "//button[@data-test-id='load-more-button']";
                boolean more = false;
                SimpleDateFormat gerDateFormat = new SimpleDateFormat("dd.MM.yyyy");
                Date fromDate = gerDateFormat.parse(fromDateSimple);
                long fromDateMillis = fromDate.toInstant().toEpochMilli();
                LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "Accountdetails-Seite aufrufen ...");
                try {
                    seleniumWebDriver.get(InstitutOptions.ACCOUNTS_DETAIL_URL);
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                dataPageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(dataPageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "Karte aufrufen ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardTabButton", "//div[@data-test-id='button-tab']//div[contains(.,'" + kontonummer + "')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                Thread.sleep(3500L);
                boolean loadingData = false;
                int scrollRound = 0;
                do {
                    try {
                        JavascriptExecutor js = (JavascriptExecutor)seleniumWebDriver;
                        if (scrollRound > 5) {
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "scroll up to restart the scroll-down action, because the time to load looks like the load is hang...");
                            js.executeScript("window.scrollTo(0, 0)", new Object[0]);
                            Thread.sleep(2000L);
                        }
                        String spinnerTransPath = "//*[@data-test-id='spinner-image' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
                        LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "scroll down to load more transactions ...");
                        Thread.sleep(3000L);
                        js.executeScript("window.scrollTo(0, document.body.scrollHeight)", new Object[0]);
                        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)spinnerTransPath)));
                        SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, spinnerTransPath);
                        loadingData = true;
                        ++scrollRound;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "loading... spinner-transactions-loading found");
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (NoSuchElementException | TimeoutException loadingDataDone) {
                        loadingData = false;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "no spinner-transactions-loading found, no spinner");
                    }
                } while (loadingData);
                WebDriverWait wait5 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(5L));
                String transDetailsPath = "//div[@data-test-id='transactions' or @data-test-id='reservations']//div[contains(@class,'tw-flex') and contains(@class,'tw-w-full')]";
                String lastDatePath = "(" + transDetailsPath + "//following-sibling::div[2])[last()]";
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                Date oldestTransDate = sdf.parse(fromDateSimple);
                long oldestTransDateMillis = oldestTransDate.toInstant().toEpochMilli();
                boolean haveNewTrans = false;
                String lastDateText = fromDateSimple;
                try {
                    wait5.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transDetailsPath)));
                    lastDate = seleniumWebDriver.findElement(By.xpath((String)lastDatePath));
                    lastDateText = lastDate.getText().trim().replaceAll("[^0-9.]+", "");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] aktuelle Transaktionen lastDateText: " + lastDateText);
                    haveNewTrans = true;
                }
                catch (Exception waiterror) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] xpath " + transDetailsPath + " NICHT gefunden; Es sollten keine aktuellen Transaktionen vorhanden sein ...");
                }
                oldestTransDate = sdf.parse(lastDateText);
                oldestTransDateMillis = oldestTransDate.toInstant().toEpochMilli();
                LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] aktuelle Transaktionen oldestTransDateMillis: " + oldestTransDateMillis);
                try {
                    if (seleniumWebDriver.findElement(By.xpath((String)moreButtonPath)) != null) {
                        more = true;
                    }
                }
                catch (Exception waiterror) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] xpath " + moreButtonPath + " NICHT gefunden; Es sollten keine weiteren Transaktionen zu den schon angezeigten vorhanden sein ...");
                }
                if (!haveNewTrans && more || oldestTransDateMillis > fromDateMillis && more) {
                    try {
                        ((JavascriptExecutor)seleniumWebDriver).executeScript("window.scrollTo(0, document.body.scrollHeight)", new Object[0]);
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "loadMoreButton", moreButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        if (WebUtils.checkForBankingApp(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "HanseaticBank" + "-2FA-Login mit Banking durchlaufen");
                        } else if (WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "HanseaticBank" + "-2FA-Login mit mTAN durchlaufen");
                        } else {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "2FA-Verfahren nicht erkannt, daher wohl nicht notwendig, mache weiter..." + seleniumWebDriver.getPageSource());
                        }
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    Thread.sleep(3500L);
                    scrollRound = 0;
                    loadingData = false;
                    do {
                        try {
                            JavascriptExecutor js = (JavascriptExecutor)seleniumWebDriver;
                            if (scrollRound > 5) {
                                LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "scroll up to restart the scroll-down action, because the time to load looks like the load is hang...");
                                js.executeScript("window.scrollTo(0, 0)", new Object[0]);
                                Thread.sleep(2000L);
                            }
                            String spinnerTransPath = "//*[@data-test-id='spinner-image' and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "scroll down to load more transactions ...");
                            Thread.sleep(3000L);
                            js.executeScript("window.scrollTo(0, document.body.scrollHeight)", new Object[0]);
                            WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
                            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)spinnerTransPath)));
                            SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, spinnerTransPath);
                            loadingData = true;
                            ++scrollRound;
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "loading... spinner-transactions-loading found");
                            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (NoSuchElementException | TimeoutException loadingDataDone) {
                            loadingData = false;
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "no spinner-transactions-loading found, no spinner");
                        }
                    } while (loadingData);
                }
                try {
                    wait5.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transDetailsPath)));
                    lastDate = seleniumWebDriver.findElement(By.xpath((String)lastDatePath));
                    lastDateText = lastDate.getText().trim();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] aktuelle Transaktionen lastDateText: " + lastDateText);
                    haveNewTrans = true;
                }
                catch (Exception waiterror) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] xpath " + transDetailsPath + " NICHT gefunden; Es sollten keine aktuellen Transaktionen vorhanden sein ...");
                }
                transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Hanseatic Bank\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
                try {
                    if (haveNewTrans) {
                        String betragPath = ".//div[@data-test-id='transaction-amount']";
                        String purpPath = ".//h6//following-sibling::div[2]";
                        String purpPath2 = ".//h6//following-sibling::div[1]";
                        String purpPathTransfer = transDetailsPath + "//div[@data-test-id='transaction-details']//div[3]";
                        String ibanPathTransfer = transDetailsPath + "//div[@data-test-id='transaction-details']//div[1]";
                        String bicPathTransfer = transDetailsPath + "//div[@data-test-id='transaction-details']//div[2]";
                        String namePathTransfer = transDetailsPath + "//div[@data-test-id='recipient-name']";
                        int transferCount = 1;
                        String bookingDatePath = ".//h6//following-sibling::div[3]";
                        String bookingDatePathOld = ".//h6//following-sibling::div[2]";
                        String bookingDatePathReservated = "./div[1]/div[2]";
                        String artPath = ".//h6|.//a";
                        LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] " + getLogMethod + "Gefundene Ums\u00e4tze: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transDetailsPath))));
                        List transactions = seleniumWebDriver.findElements(By.xpath((String)transDetailsPath));
                        LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "Anzahl der gefundenen Transaktionen auf der Seite: " + String.valueOf(transactions.size()));
                        for (WebElement transaction : transactions) {
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transaction raw data:\n" + transaction.getAttribute("innerHTML"));
                            String purpPathText = "";
                            String betragPathText = "";
                            String bookingDatePathText = "";
                            String artPathText = "";
                            String ibanPathText = "";
                            String bicPathText = "";
                            String namePathText = "";
                            artPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)artPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "artPathText: " + artPathText);
                            if (!StringCharUtils.isNullOrEmpty(transaction.getAttribute("is-reservation")) && transaction.getAttribute("is-reservation").equals("true") || artPathText.equals("\u00dcberweisung")) {
                                bookingDatePathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)bookingDatePathReservated)).getText().replaceAll("[^0-9.]+", ""));
                                LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "bookingDatePathText: " + bookingDatePathText);
                            } else {
                                if (!artPathText.equals("\u00dcberweisung")) {
                                    bookingDatePathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)bookingDatePath)).getText());
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "bookingDatePathText: " + bookingDatePathText);
                                }
                                if (StringCharUtils.isNullOrEmptyOrNothing(bookingDatePathText)) {
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "bookingDatePathText war leer, daher nun Alternative..." + bookingDatePathText);
                                    bookingDatePathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)bookingDatePathOld)).getText());
                                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "bookingDatePathText alternativ: " + bookingDatePathText);
                                }
                            }
                            if (artPathText.equals("\u00dcberweisung")) {
                                WebElement tranfserInfo = transaction.findElement(By.xpath((String)artPath));
                                jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{tranfserInfo});
                                jse.executeScript("window.scrollBy(0, -100);", new Object[0]);
                                tranfserInfo.click();
                                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                                Thread.sleep(500L);
                                wait5.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("(" + String.valueOf(purpPathTransfer) + ")[" + transferCount + "]"))));
                                purpPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)("(" + purpPathTransfer + ")[" + String.valueOf(transferCount) + "]"))).getText());
                                namePathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)("(" + namePathTransfer + ")[" + String.valueOf(transferCount) + "]"))).getText());
                                ibanPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)("(" + ibanPathTransfer + ")[" + String.valueOf(transferCount) + "]"))).getText());
                                bicPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)("(" + bicPathTransfer + ")[" + String.valueOf(transferCount) + "]"))).getText());
                                ++transferCount;
                            } else {
                                purpPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)purpPath)).getText());
                                if (StringCharUtils.isNullOrEmptyOrNothing(purpPathText)) {
                                    purpPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)purpPath2)).getText());
                                }
                            }
                            purpPathText = purpPathText.replace("&apos;", "'");
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "purpPathText: " + purpPathText);
                            betragPathText = StringCharUtils.shrinkString(transaction.findElement(By.xpath((String)betragPath)).getText());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "betragPathText: " + betragPathText);
                            Date transDate = sdf.parse(bookingDatePathText);
                            long transDateMillis = transDate.toInstant().toEpochMilli();
                            if (transDateMillis < fromDateMillis && more) {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:HanseaticBank] Umsatzdatum " + bookingDatePathText + " auserhalb des Abrufzeitraum, beende parsen");
                            }
                            transData = transData + bookingDatePathText + ";" + artPathText + ";" + purpPathText + ";" + betragPathText + ";" + ibanPathText + ";" + bicPathText + ";" + namePathText + ";\n";
                        }
                    }
                    transData = transData + "\n\nKeine neuen Transaktionen vorhanden";
                }
                catch (TimeoutException notFounderr) {
                    isSelfException = true;
                    throw new Exception("Transaktionen aus Seite auslesen fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)notFounderr));
                }
            } else {
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                File downloadedFile = new File(docFixTempFilePath);
                String fileResponse = "";
                String fileencoding = "UTF-8";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:HanseaticBank] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    transData = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    transData = fileResponse.replace("&apos;", "'");
                }
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transDatas (Statement): \n\n====================== BEGIN STATEMENT DATA ======================\n" + StringCharUtils.unescapeHtml4(transData) + "\n\n\n\n======================= END STATEMENT DATA =======================\n");
            String[] dataResponse = new String[]{StringCharUtils.unescapeHtml4(transData), Double.toString(amount)};
            String[][] matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][3], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][1]));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    String purp = matrixArrayData[i][2];
                    if (!StringCharUtils.isNullOrEmptyOrNothing(purp)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][4].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][5].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][6])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][6].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:HanseaticBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("HanseaticBank", kontonummer, amount, availableAmount, unbookedAmount, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

