/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.dkbvisa;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[(@class='ajax_loading' and @stlye='') or (@class='skeleton-handler')]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[6];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "(//span[@class='error']//.)[1]";
        WebUtils.xpathSearchString[1] = "//div[contains(@class,'errorMessage') and not(contains(@style,'display: none;'))]";
        WebUtils.xpathSearchString[2] = "//div[@id='wartungsSeite']";
        WebUtils.xpathSearchString[3] = "//div[contains(@class,'successBox remarkBox')]";
        WebUtils.xpathSearchString[4] = "//p[contains(.,' notwendigen Wartungsarbeiten steht von ')]";
        WebUtils.xpathSearchString[5] = "//div[contains(@class,'icon--error') and not(contains(@style,'dsplay: none')) and not(contains(@style,'dsplay:none'))]//following::div[contains(@class,'error') and not(contains(@style,'display: none')) and not(contains(@style,'dsplay:none'))]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String logIdent = "[WebSync:DKB-Visa] ";
        String longName = "Deutsche Kreditbank AG (VISA)";
        String errorMessage = null;
        if (responsePageAsString.contains("PIN \u00e4ndern")) {
            errorMessage = "Es ist notwendig dass Sie Ihre Zugangs-PIN \u00e4ndern. \n\nBitte melden Sie sich im Online-Baning an und folgen dort den Anweisungen.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Deutsche Kreditbank AG (VISA):\n\n\n" + errorMessage, "institutlogo-dkbvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (seleniumWebDriver.getCurrentUrl().contains("RequestPin.xhtml")) {
            errorMessage = "Sie haben Ihr/e PIN/Passwort vergessen und k\u00f6nnen sich nicht mehr im Banking anmelden? Geben Sie hier Ihren Anmeldenamen an und beantworten die Verifizierungsfragen.\n\nUnter der Website\nhttps://www.dkb.de/Welcome/content/RequestPin.xhtml\nk\u00f6nnen Sie ein neues Passwort anfordern.\n\nDurch das Absenden des Auftrags wird Ihr Zugang zum Banking sofort gesperrt und ein Start-Passwort zur einmaligen Anmeldung generiert.";
            DialogError.invoke((Object)DialogError, "Hinweis-Frage der Deutsche Kreditbank AG (VISA):\n\n\nPasswort vergessen\n\n" + errorMessage, "institutlogo-dkbvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("Online-Sperre aufheben") || responsePageAsString.contains("PIN-Sperre aufheben")) {
            errorMessage = "Ihr Zugang zum Online-Banking ist gesperrt. \n\nF\u00fcr die Freischaltung melden Sie sich im Online-Banking an und folgen dort den Anweisungen.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Deutsche Kreditbank AG (VISA):\n\n\n" + errorMessage, "institutlogo-dkbvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("id=\"wartungsSeite\"") && responsePageAsString.contains("Geplante Wartungsarbeiten")) {
            errorMessage = "Geplante Wartungsarbeiten\n\nManchmal muss man auch in der digitalen Welt manuell Hand anlegen.\n\nDie Webseite steht aufgrund von Wartungsarbeiten aktuell nicht zur Verf\u00fcgung. Wir bitten um Ihr Verst\u00e4ndnis.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Deutsche Kreditbank AG (VISA):\n\n\n" + errorMessage, "institutlogo-dkbvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-dkbvisa.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }
}

