/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.dkbvisa;

import de.derrichter.finance.websync.institute.dkbvisa.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String unterkonto, String lastTransDate, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "Konten\u00fcbersicht aufrufen ... (GET " + "https://banking.dkb.de/login" + ")");
        try {
            seleniumWebDriver.get("https://banking.dkb.de/login");
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "accountspage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        String pageLoginAccounts = seleniumWebDriver.getPageSource();
        try {
            WebUtils.checkSeleniumResponseHasError(pageLoginAccounts, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            isSelfException = true;
            throw new Exception("Fehler auf der Konto\u00fcbersicht-Seite: " + error.getMessage());
        }
        boolean isCorrectDKBcreditcardnumber = true;
        if (unterkonto.length() != 16) {
            isCorrectDKBcreditcardnumber = false;
        }
        if (isCorrectDKBcreditcardnumber && !unterkonto.substring(4, 12).equals("********")) {
            isCorrectDKBcreditcardnumber = false;
        }
        if (isCorrectDKBcreditcardnumber) {
            try {
                String checkNumber = unterkonto.substring(0, 4);
                float testnumber = Float.parseFloat(checkNumber);
                testnumber = Float.parseFloat(checkNumber);
                String checkNumber2 = unterkonto.substring(12, 16);
                float testnumber2 = Float.parseFloat(checkNumber2);
                testnumber2 = Float.parseFloat(checkNumber2);
            }
            catch (NumberFormatException e) {
                isCorrectDKBcreditcardnumber = false;
            }
        }
        if (!isCorrectDKBcreditcardnumber) {
            isSelfException = true;
            throw new Exception("Die \u00fcbergebene Kreditkartennummer ist nicht im erforderlichen Format angegeben: 1234********5678 (ersten 4 Stellen + 8 Sternchen + letzen 4 Stellen)");
        }
        try {
            String cardTransPath = "// a[contains(.,'" + unterkonto.substring(0, 4) + "') and contains(.,'" + unterkonto.substring(12, 16) + "')]";
            LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kreditkartennummer enthalten ist ...");
            LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "checkCardNr (formated): " + unterkonto);
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cardTransPath)));
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "OK - Kreditkartennummer auf der Startseite vorhanden");
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Kreditkartennummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            double cardLimitAmount = Double.NaN;
            double availableAmount = Double.NaN;
            String pageAfterLoginResponse = null;
            String kkInfoUrlPath = "//a[contains(@aria-label,'" + unterkonto.substring(0, 4) + "') and contains(@aria-label,'" + unterkonto.substring(12, 16) + "') and contains(@href,'details')]";
            LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "kkInfoUrlPath: " + kkInfoUrlPath);
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)kkInfoUrlPath)));
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "kkInfoUrlPath", kkInfoUrlPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                Thread.sleep(3000L);
                pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                try {
                    String limitAmountText = seleniumWebDriver.findElement(By.xpath((String)"//span[contains(.,'limit')]//following::span[contains(.,'\u20ac')]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "cardLimitAmountText: " + limitAmountText);
                    cardLimitAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(limitAmountText, externalLogger));
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Kartenlimit Betrag' fehlgeschlagen: " + error.getMessage());
                }
            }
            catch (NoSuchElementException | TimeoutException noDetailsLink) {
                LogWarn.invoke((Object)LogWarn, "[WebSync:DKB-Visa] " + getLogMethod + "Link von Kartendetails nicht gefunden. Auslesen von 'Kreditlimit' nicht m\u00f6glich, wird daher zur\u00fcckgesetzt! Karte vermutlich gesperrt, ansonsten bitte im Forum melden.");
                MonitorLog.invoke((Object)MonitorLog, "Info-Warnung: Link von Kartendetails nicht gefunden. Auslesen von 'Kreditlimit' nicht m\u00f6glich, wird daher zur\u00fcckgesetzt! Karte vermutlich gesperrt, ansonsten bitte im Forum melden.");
            }
            String cookieDetectPath = "iframe:privacy-iframe";
            String cookieAcceptPath = "//button[@class='btn refuse-all']";
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:DKB-Visa] ", "Deutsche Kreditbank AG (VISA)", "institutlogo-dkbvisa.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "Keditkarten\u00fcbersicht aufrufen ... (GET " + "https://banking.dkb.de/login" + ")");
            try {
                seleniumWebDriver.get("https://banking.dkb.de/login");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cardTransPath)));
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardTransactions", cardTransPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            File downloadedFile = null;
            String doctext = null;
            String filetype = "";
            boolean localTest = false;
            if (localTest) {
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                downloadedFile = new File(docFixTempFilePath);
            }
            boolean downloadedFileIsFalse = false;
            int downloadCount = 1;
            do {
                if (!localTest) {
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvExport", "//button[contains(.,'CSV')][last()]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nAuf dieser Seite befindliche buttons zur Analyse:" + SeleniumUtils.getFormatedListOfAllWebElements(seleniumWebDriver, "//button", externalLogger));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                    do {
                        Thread.sleep(500L);
                        int waiter = 0;
                        do {
                            if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                            Thread.sleep(1000L);
                            ++waiter;
                        } while (downloadedFile == null && waiter < 30);
                        if (downloadedFile != null && downloadedFile.exists()) continue;
                        isSelfException = true;
                        throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                    } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                filetype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                if (filetype.toLowerCase().equals("txt") || filetype.toLowerCase().equals("htm") || filetype.toLowerCase().equals("html") || filetype.toLowerCase().equals("asp") || filetype.toLowerCase().equals("js")) {
                    LogWarn.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                    ++downloadCount;
                    downloadedFileIsFalse = true;
                } else {
                    downloadedFileIsFalse = false;
                }
                if (downloadCount < 4) continue;
                isSelfException = true;
                throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
            } while (downloadedFileIsFalse);
            String fileResponse = "";
            String fileencoding = "UTF-8";
            fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
            LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
            if (!fileencoding.equals("UTF-8")) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                doctext = new String(filebytes, System.getProperty("file.encoding"));
            } else {
                doctext = fileResponse;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + filetype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
            if (!localTest) {
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            String[][] csvDataRow = StringCharUtils.data2matrixArray(doctext, '\"', ';', externalLogger);
            double amount = Double.NaN;
            boolean foundAmount = false;
            for (int i = 0; i < csvDataRow.length; ++i) {
                if (csvDataRow[i].length <= 0 || !csvDataRow[i][0].contains("Saldo vom ")) continue;
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Datum des Saldo des RAW-Kontoauszuges (csvDataRow): " + csvDataRow[i][0]);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Saldo des RAW-Kontoauszuges (csvDataRow): " + csvDataRow[i][1]);
                if (StringCharUtils.isNullOrEmptyOrNothing(csvDataRow[i][1])) {
                    isSelfException = true;
                    throw new Exception("Guthaben von der Deutsche Kreditbank AG (VISA) nicht angegeben! Fehlt im Kontoauszug");
                }
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(csvDataRow[i][1].replace("--", ""), externalLogger));
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Amount: " + amount);
                foundAmount = true;
                break;
            }
            if (!foundAmount) {
                isSelfException = true;
                throw new Exception("Guthaben von der Deutsche Kreditbank AG (VISA) nicht gefunden! (Bitte dem Entwickler im Forum melden)");
            }
            availableAmount = amount + cardLimitAmount;
            String[] dataResponseArray = new String[]{doctext, Double.toString(amount)};
            String[][] matrixArrayData = csvDataRow;
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                block61: {
                    if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                    try {
                        if (!(matrixArrayData[i][2].equals("Ja") || matrixArrayData[i][2].equals("Nein") || matrixArrayData[i][2].equals("Gebucht"))) {
                        }
                        break block61;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + e.toString());
                    }
                    continue;
                }
                if (StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0]) || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) continue;
                long lastTransDateTime = new SimpleDateFormat("yyyy-MM-dd").parse(lastTransDate).getTime();
                long buchungsDateTime = new SimpleDateFormat("dd.MM.yyyy").parse(matrixArrayData[i][0].substring(0, 6) + "20" + matrixArrayData[i][0].substring(6, 8)).getTime();
                if (buchungsDateTime < lastTransDateTime) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Buchungsdatum '" + matrixArrayData[i][0] + "' ist \u00e4lter als das letzte Umsatzdatum, daher keine weitere Verarbeitung");
                    break;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 8).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt("20" + arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 8).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt("20" + arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][5], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayData[i][3].contains("zinsen")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zinsen vor Steuern");
                    } else if (!String.valueOf(betrag).contains("-")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][3].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][6])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Urspr\u00fcnglicher Betrag: " + matrixArrayData[i][6]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("DKB-Visa", unterkonto, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

