/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.dkbvisa;

import de.derrichter.finance.websync.institute.dkbvisa.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        optionalOptions = "DEAKTIVIERT";
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        Method DialogAskImageTan = externalDialogInterface.getMethod("askImageTAN", String.class, InputStream.class, String.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "DKB-Visa" + "-Login aufrufen ... (GET " + "https://banking.dkb.de/login" + ")");
            try {
                seleniumWebDriver.get("https://banking.dkb.de/login");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            String cookieDetectPath = "iframe:privacy-iframe";
            String cookieAcceptPath = "//button[@class='btn refuse-all']";
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:DKB-Visa] ", "Deutsche Kreditbank AG (VISA)", "institutlogo-dkbvisa.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            try {
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "loginpage: Suche Login-Elemente...");
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[@id='username' or @name='username']")));
                WebElement inputUsername = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='username' or @name='username']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "inputUsername: " + inputUsername);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='password' or @name='password']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "inputPassword: " + inputPasswd);
                seleniumWebDriver.findElement(By.xpath((String)"//label[@for='username']")).click();
                inputUsername.sendKeys(new CharSequence[]{responseLogin});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                seleniumWebDriver.findElement(By.xpath((String)"//label[@for='password']")).click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(@class,'button--primary') and contains(@class,'large')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            boolean isChipTan = false;
            boolean isChipTanQR = false;
            boolean isAppTan = false;
            boolean isAppConfirm = false;
            boolean appAuthHasCancel = false;
            do {
                boolean haveFound;
                String appDetectPath;
                block97: {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Pr\u00fcfen auf Verfahren der Zwei-Faktor-Authentifizierung ...");
                    MonitorLog.invoke((Object)MonitorLog, "Erste Login-Phase abgeschlossen, pr\u00fcfe auf Verfahren der Zwei-Faktor-Authentifizierung ...");
                    isChipTan = false;
                    isChipTanQR = false;
                    isAppTan = false;
                    isAppConfirm = false;
                    appAuthHasCancel = false;
                    appDetectPath = "//*[contains(@class,'mfaApp') and contains(.,'Anmeldung mit deiner DKB-App')]";
                    haveFound = false;
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)appDetectPath));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Banking-App ist als Verfahren gesetzt ...");
                        boolean callAltTan = false;
                        if (optionalOptions.equals("true")) {
                            callAltTan = true;
                        }
                        if (callAltTan) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + ">>> Durch optionalen Paramenter 'Erzwingen' <<< von alternativer TAN-Eingabe mit Tan-Generator oder TAN2Go-App, je nach genutzem Login-Benutzer...");
                            MonitorLog.invoke((Object)MonitorLog, "Erzwingen von alternativer TAN-Eingabe mit Tan-Generator oder TAN2Go-App, je nach genutzem Login-Benutzer...");
                            LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "Erzwingen von alternativer TAN-Eingabe mit Tan-Generator oder TAN2Go-App, je nach genutzem Login-Benutzer...");
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "loginWithTan", "(//a[contains(@href,'javascript:loginWithTan')])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            try {
                                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[contains(.,'um den aktuellen Prozesszustand wiederherzustellen')]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Prozesszustand verloren?, daher nochmal ...");
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resetProzess", "(//a[contains(@href,'LoginWithTan') or contains(@href,'chooseTanAlias')])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    break block97;
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                            }
                            catch (NoSuchElementException | TimeoutException error) {}
                            break block97;
                        }
                        haveFound = true;
                        isAppConfirm = true;
                    }
                    catch (NoSuchElementException | TimeoutException noBankingApp) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Sicherheitsverfahren 'Banking-App' ohne TAN-Eingabe wird NICHT (direkt) angeboten, pr\u00fcfe auf Selektor und manuelle TAN-Eingabe ...");
                    }
                }
                if (!haveFound) {
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//form[contains(@class,'selectMfaMethod')]")));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Auswahl gefunden: Selektieren der Methode zur Zwei-Faktor-Authentifizierung...");
                        if (optionalOptions.equals("true")) {
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//input[@id='chip_tan_manual']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            haveFound = true;
                            isChipTan = true;
                        } else {
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//input[@id='seal_one']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            haveFound = true;
                            isAppConfirm = true;
                        }
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(@class,'button--primary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                        try {
                            WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    }
                    catch (NoSuchElementException | TimeoutException noChipTanManual) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Zwei-Faktor-Authentifizierung mit TAN wird nicht (mehr?) angezeigt");
                    }
                }
                if (!haveFound) {
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Sie nutzen')]//b[contains(.,'chipTAN manuell')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "chipTan manuell ist als Verfahren gesetzt ...");
                        haveFound = true;
                        isChipTan = true;
                    }
                    catch (NoSuchElementException | TimeoutException noChipTanManual) {
                        // empty catch block
                    }
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Sie nutzen')]//b[contains(.,'chipTAN QR')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "chipTan QR ist als Verfahren gesetzt ...");
                        MonitorLog.invoke((Object)MonitorLog, "chipTAN QR als Verfahren erkannt, starte Abfrage ...");
                        haveFound = true;
                        isChipTanQR = true;
                    }
                    catch (NoSuchElementException | TimeoutException noChipTanManual) {
                        // empty catch block
                    }
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Sie nutzen')]//b[contains(.,'chipTAN optisch')]"));
                        LogWarn.invoke((Object)LogWarn, "[WebSync:DKB-Visa] " + getLogMethod + "chipTan optisch (Flickercode) ist als Verfahren gesetzt, wird aber NICHT unterst\u00fctzt ...");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "Das 2FA-Sicherheitsverfahren wird daher nun automatisch auf 'chipTAN manuell' gewechselt ... ");
                        MonitorLog.invoke((Object)MonitorLog, "Info-Warnung: chipTan optisch (Flickercode) ist als Verfahren gesetzt, wird aber NICHT unterst\u00fctzt.");
                        MonitorLog.invoke((Object)MonitorLog, "Das 2FA-Sicherheitsverfahren wird daher nun automatisch auf 'chipTAN manuell' gewechselt ...");
                        try {
                            WebElement chipTanManualButton = seleniumWebDriver.findElement(By.xpath((String)"//a[text()='chipTAN manuell']"));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "chipTanManualButton: " + chipTanManualButton);
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "chipTanManualButton", "//a[text()='chipTAN manuell']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                            try {
                                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception(error.getMessage());
                            }
                            haveFound = true;
                            isChipTan = true;
                        }
                        catch (NoSuchElementException | TimeoutException noChipTan) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Sicherheitsverfahren 'chipTAN manuell' wird NICHT zur Auswahl angeboten!");
                        }
                    }
                    catch (NoSuchElementException | TimeoutException noChipTan) {
                        // empty catch block
                    }
                }
                if (!isAppConfirm) continue;
                try {
                    WebElement waiterCheck = null;
                    MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                    int rounds = 0;
                    Thread.sleep(3000L);
                    boolean waitBestSign = true;
                    do {
                        try {
                            waiterCheck = seleniumWebDriver.findElement(By.xpath((String)appDetectPath));
                        }
                        catch (NoSuchElementException | TimeoutException noBestSign) {
                            waitBestSign = false;
                        }
                        if (waitBestSign) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                            ++rounds;
                        } else {
                            try {
                                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//*[contains(.,'um den aktuellen Prozesszustand wiederherzustellen')]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Prozesszustand verloren?, daher nochmal ...");
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "resetProzess", "(//a[contains(@href,'LoginWithTan')])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//form[contains(@action,'InfoOpenLoginRequest')]")));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "TAN-Sicherheitsverfahren wird angefordert?, es wurde wohl Baning-App abgelehnt, daher nochmal ...");
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                seleniumWebDriver.findElement(By.xpath((String)"//form[contains(@action,'Vorschaltseite/single.xhtml')]"));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "altes Sicherheitsverfahren iTAN angezeigt?, es wurde wohl Baning-App abgelehnt, daher nochmal ...");
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                seleniumWebDriver.findElement(By.xpath((String)"//form[contains(@action,'chooseTanAlias')]"));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "TAN2go verlangt die Wahl des Endger\u00e4ts?, es wurde wohl Baning-App abgelehnt, daher nochmal ...");
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "jsBackButton", "//button[@tid='$pageflow-back']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                seleniumWebDriver.findElement(By.xpath((String)"//label[contains(.,'TAN aus Ihrer DKB-TAN2go-App')]"));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Sicherheitsverfahren TAN2go angezeigt?, es wurde wohl Baning-App abgelehnt, daher nochmal ...");
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Sie nutzen')]//b[contains(.,'chipTAN manuell')]"));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Sicherheitsverfahren 'chipTAN manuell'? angezeigt?, es wurde wohl Banking-App abgelehnt, daher nochmal ...");
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Sie nutzen')]//b[contains(.,'chipTAN optisch')]"));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Sicherheitsverfahren 'chipTAN optisch (Flickercode)'? angezeigt?, es wurde wohl Banking-App abgelehnt, daher nochmal ...");
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                            try {
                                seleniumWebDriver.findElement(By.xpath((String)"//p[contains(.,'Sie nutzen')]//b[contains(.,'chipTAN QR')]"));
                                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Sicherheitsverfahren 'chipTAN QR (QR-Code)'? angezeigt?, es wurde wohl Banking-App abgelehnt, daher nochmal ...");
                                appAuthHasCancel = true;
                            }
                            catch (NoSuchElementException | TimeoutException error) {
                                // empty catch block
                            }
                        }
                        if (rounds < 19) continue;
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung auch nach 60 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                    } while (waitBestSign);
                }
                catch (Exception error) {
                    if (isSelfException) {
                        throw new Exception(error.getMessage());
                    }
                    isSelfException = true;
                    throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            } while (appAuthHasCancel);
            String tanArt = "unkown-tan";
            String secText = "Bitte geben Sie Ihre Tan ein";
            InputStream streamImage = null;
            if (!isAppConfirm) {
                if (isAppTan) {
                    secText = seleniumWebDriver.findElement(By.xpath((String)"//label[contains(@id,'tan-label')]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "secText: \n" + secText);
                    tanArt = "TAN2go";
                } else if (isChipTan) {
                    secText = seleniumWebDriver.findElement(By.xpath((String)"//ol[contains(@class,'instructions')]")).getText();
                    tanArt = "chipTan";
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "secText: \n" + secText);
                } else if (isChipTanQR) {
                    String imageToScanPath = "//img[@alt='QR-Code']";
                    wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)imageToScanPath)));
                    String base64ImageData = seleniumWebDriver.findElement(By.xpath((String)imageToScanPath)).getAttribute("src").trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "base64ImageData: " + base64ImageData);
                    streamImage = StringCharUtils.base64ImagetoInputStream(base64ImageData, externalLogger);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "streamImage (InputStream): " + streamImage);
                    secText = seleniumWebDriver.findElement(By.xpath((String)"(//form[@id='next']//fieldset//div[@class='hide-for-small-down'])[last()]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "secText: \n" + secText);
                    tanArt = "chipTanQR";
                } else {
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)"//td[contains(.,'Summe in Euro')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Summe in Euro wird angezeigt, dieser Login-Vorgang wohl ohne Zwei-Faktor-Authentifizierung ...");
                        isAppConfirm = true;
                    }
                    catch (NoSuchElementException | TimeoutException noBankingApp) {
                        LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "... bei der Seite mit dem vermeintlich angebotenen Sicherheitsverfahren handelt es sich um diese im XML-Format: \n" + seleniumWebDriver.getPageSource());
                        isSelfException = true;
                        throw new Exception("Angebotenes Sicherheitsverfahren nicht erkannt oder bekannt. Bitte informieren Sie im Forum den Entwickler");
                    }
                }
            }
            if (!isAppConfirm) {
                String userTanInput = null;
                try {
                    userTanInput = isChipTanQR ? (String)DialogAskImageTan.invoke((Object)DialogAskImageTan, tanArt, streamImage, secText, "institutlogo-dkbvisa.png") : (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-dkbvisa.png");
                }
                catch (InvocationTargetException error) {
                    isSelfException = true;
                    if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                        throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                    }
                    LogError.invoke((Object)LogError, "[WebSync:DKB-Visa] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                    throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                }
                WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)"//div[@data-testid='sui-numeric-input__boxes-container']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "tanInput: " + tanInput);
                tanInput.click();
                tanInput.sendKeys(new CharSequence[]{userTanInput});
                Thread.sleep(500000L);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//button[contains(@class,'button--primary')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//*[@id='username' or @name='username']"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:DKB-Visa] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "Abmelden aufrufen (" + "https://banking.dkb.de/logout" + ")");
            try {
                seleniumWebDriver.get("https://banking.dkb.de/logout");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//*[contains(.,'erfolgreich abgemeldet')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:DKB-Visa] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:DKB-Visa] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:DKB-Visa] " + getLogMethod + "Logout bei der '" + "Deutsche Kreditbank AG (VISA)" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:DKB-Visa] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

