/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.dabbnpparibas;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.HTMLUnitUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlDivision;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[2];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[@class='fehlermeldung' and text()!='']";
        WebUtils.xpathSearchString[1] = "//p[@class='error' and text()!='']";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Bitte aktivieren Sie Cookies in Ihren Browser-Einstellungen";
        WebUtils.xpathSearchStringExclusion[1] = "ist eine TAN-Freigabe erforderlich";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:DAB] ";
        String longName = "DAB BNP Paribas S.A.";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-dabbnpparibas.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static void checkHTMLUnitResponseHasError(String pageResponse, Page currentPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:DAB] ";
        String longName = "DAB BNP Paribas S.A.";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            HTMLUnitUtils.checkHTMLUnitWebClientResponse(pageResponse, currentPage, logIdent, longName, "institutlogo-dabbnpparibas.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static HtmlPage checkTANRequest(WebClient syncWebClient, HtmlPage dataPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        block12: {
            Method LogDebug = externalLogger.getMethod("debug", String.class);
            String getLogMethod = "[checkTANRequest] ";
            String tanArt = "TAN-Request";
            String detectTANrequestPath = "//a[contains(.,'Zur TAN Freigabe')]";
            boolean isSelfException = false;
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                HtmlAnchor detectTANrequestButton = (HtmlAnchor)dataPage.getFirstByXPath(detectTANrequestPath);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "detectTANrequestButton: " + detectTANrequestButton);
                if (detectTANrequestButton != null) {
                    HtmlAnchor callTanOffer = null;
                    try {
                        callTanOffer = (HtmlAnchor)dataPage.getFirstByXPath("//a[contains(.,'Zur TAN Freigabe')]");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "callTanOffer: " + callTanOffer);
                    }
                    catch (Exception callTanOfferError) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "xPath callTanOffer ergab Fehler: " + callTanOfferError.getMessage());
                    }
                    if (callTanOffer != null) {
                        try {
                            dataPage = (HtmlPage)callTanOffer.click();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            Thread.sleep(1000L);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "DataPage (callTanOffer): " + dataPage);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        if (dataPage == null) {
                            throw new Exception("Die TanAnforderungsAufruf-Folgeseite konnte nicht aufgerufen werden!");
                        }
                        String dataPageXML = dataPage.asXml();
                        try {
                            WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                        }
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + tanArt + "TAN-Request gestartet ... untersuche Tan-Abfrage ...");
                    break block12;
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ...");
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        return dataPage;
    }

    public static HtmlPage checkForMTAN(WebClient syncWebClient, HtmlPage dataPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        block22: {
            Method LogError = externalLogger.getMethod("error", String.class);
            Method LogDebug = externalLogger.getMethod("debug", String.class);
            Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
            Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
            String getLogMethod = "[checkForMTAN] ";
            String tanArt = "mobileTAN";
            String detectTANformPath = "//a[contains(.,'mobileTAN anfordern') or id='strongLogin_confirm_gen_mtan']";
            String secTextPath = "//div[contains(@class,'h2') or @id='authDialog']//text()";
            String tanInputPath = "//input[@id='strongLogin_confirm_da_mtan']";
            String submitTanPath = "//a[@id='confirmStrongLogin_submitButton']";
            boolean isSelfException = false;
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                HtmlAnchor detectTANButton = (HtmlAnchor)dataPage.getFirstByXPath(detectTANformPath);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "detectTANButton: " + detectTANButton);
                if (detectTANButton != null) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                    HtmlAnchor callTanButton = (HtmlAnchor)dataPage.getFirstByXPath(detectTANformPath);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "callTanButton: " + callTanButton);
                    try {
                        dataPage = (HtmlPage)callTanButton.click();
                        syncWebClient.waitForBackgroundJavaScript(5000L);
                        Thread.sleep(1000L);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "DataPage (callTan): " + dataPage);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    if (dataPage == null) {
                        throw new Exception("Die TanAnforderungs-Folgeseite konnte nicht aufgerufen werden!");
                    }
                    String dataPageXML = dataPage.asXml();
                    try {
                        WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                    }
                    String secText = ((DomText)dataPage.getFirstByXPath("(" + secTextPath + ")[1]")).getTextContent().trim() + "\n" + ((DomText)dataPage.getFirstByXPath("(" + secTextPath + ")[31]")).getTextContent().trim();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "secText: " + secText);
                    boolean retryInput = false;
                    do {
                        String userTanInput = null;
                        try {
                            userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-dabbnpparibas.png");
                        }
                        catch (InvocationTargetException error) {
                            isSelfException = true;
                            if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                                throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                            }
                            LogError.invoke((Object)LogError, "[WebSync:DAB] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                            throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                        }
                        HtmlInput tanInput = (HtmlInput)dataPage.getFirstByXPath(tanInputPath);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "tanInput: " + tanInput);
                        tanInput.click();
                        tanInput.type(userTanInput);
                        HtmlAnchor submitTanButton = (HtmlAnchor)dataPage.getFirstByXPath(submitTanPath);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "submitTanButton: " + submitTanButton);
                        try {
                            dataPage = (HtmlPage)submitTanButton.click();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            Thread.sleep(1000L);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "DataPage (callTanOffer): " + dataPage);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        if (dataPage == null) {
                            throw new Exception("Die Suche-Folgeseite konnte nicht aufgerufen werden!");
                        }
                        dataPageXML = dataPage.asXml();
                        try {
                            DomElement checkWrongTAN = (DomElement)dataPage.getFirstByXPath("//div[contains(@class,'input-hint--error')]");
                            if (checkWrongTAN != null) {
                                DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der DAB BNP Paribas S.A.:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-dabbnpparibas.png");
                                retryInput = true;
                            } else {
                                retryInput = false;
                            }
                        }
                        catch (Exception noSecondSec) {
                            retryInput = false;
                        }
                        try {
                            WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                        }
                    } while (retryInput);
                    break block22;
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ...");
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        return dataPage;
    }

    public static HtmlPage checkForQRTAN(WebClient syncWebClient, HtmlPage dataPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        block17: {
            Method LogError = externalLogger.getMethod("error", String.class);
            Method LogDebug = externalLogger.getMethod("debug", String.class);
            Method LogTrace = externalLogger.getMethod("trace", String.class);
            Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
            Method DialogAskImageTan = externalDialogInterface.getMethod("askImageTAN", String.class, InputStream.class, String.class, String.class);
            String getLogMethod = "[checkForQRTAN] ";
            String tanArt = "SecurePlus";
            String detectTANformPath = "//div[@id='strongLogin_confirm_def_auth_securePlusCode']";
            String secTextPath = "//div[contains(@class,'h2') or @id='authDialog']//text()";
            String tanInputPath = "//input[@id='strongLogin_confirm_da_secureplus']";
            String submitTanPath = "//a[@id='confirmStrongLogin_submitButton']";
            String imageToScanPath = "//img[@id='strongLogin_confirm_def_auth_securePlusCodeImage']";
            boolean isSelfException = false;
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                HtmlDivision detectTANButton = (HtmlDivision)dataPage.getFirstByXPath(detectTANformPath);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "detectTANButton: " + detectTANButton);
                if (detectTANButton != null) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                    String secText = ((DomText)dataPage.getFirstByXPath("(" + secTextPath + ")[1]")).getTextContent().trim() + "\n" + ((DomText)dataPage.getFirstByXPath("(" + secTextPath + ")[16]")).getTextContent().trim();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "secText: " + secText);
                    boolean retryInput = false;
                    do {
                        String base64ImageData = ((DomElement)dataPage.getFirstByXPath(imageToScanPath)).getAttribute("src").trim();
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "base64ImageData: " + base64ImageData);
                        InputStream streamImage = StringCharUtils.base64ImagetoInputStream(base64ImageData, externalLogger);
                        LogTrace.invoke((Object)LogTrace, getLogMethod + "streamImage (InputStream): " + streamImage);
                        String userTanInput = null;
                        try {
                            userTanInput = (String)DialogAskImageTan.invoke((Object)DialogAskImageTan, tanArt, streamImage, secText, "institutlogo-dabbnpparibas.png");
                        }
                        catch (InvocationTargetException error) {
                            isSelfException = true;
                            if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                                throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                            }
                            LogError.invoke((Object)LogError, getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                            throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                        }
                        HtmlInput tanInput = (HtmlInput)dataPage.getFirstByXPath(tanInputPath);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "tanInput: " + tanInput);
                        tanInput.click();
                        tanInput.type(userTanInput);
                        HtmlAnchor submitTanButton = (HtmlAnchor)dataPage.getFirstByXPath(submitTanPath);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "submitTanButton: " + submitTanButton);
                        try {
                            dataPage = (HtmlPage)submitTanButton.click();
                            syncWebClient.waitForBackgroundJavaScript(5000L);
                            Thread.sleep(1000L);
                            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "DataPage (callTanOffer): " + dataPage);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        if (dataPage == null) {
                            throw new Exception("Die Suche-Folgeseite konnte nicht aufgerufen werden!");
                        }
                        String dataPageXML = dataPage.asXml();
                        try {
                            DomElement checkWrongTAN = (DomElement)dataPage.getFirstByXPath("//div[contains(@class,'input-hint--error')]");
                            if (checkWrongTAN != null) {
                                DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der DAB BNP Paribas S.A.:\n\n\nDie eingegebene " + tanArt + " ist falsch.", "institutlogo-dabbnpparibas.png");
                                retryInput = true;
                            } else {
                                retryInput = false;
                            }
                        }
                        catch (Exception noSecondSec) {
                            retryInput = false;
                        }
                        try {
                            WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                        }
                    } while (retryInput);
                    break block17;
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ...");
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        return dataPage;
    }

    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method DialogError = ExternalDialogInterface.getMethod("error", String.class, String.class);
        boolean isSelfException = false;
        try {
            String errorResponse = null;
            String errorMessage = null;
            if (responseContentAsString.contains("class=\"fehlermeldung\"") && (responseContentAsString.split("class=\"fehlermeldung\"").length - 1 == 1 && !responseContentAsString.contains("Bitte aktivieren Sie Cookies in Ihren Browser-Einstellungen!") || responseContentAsString.split("class=\"fehlermeldung\"").length - 1 > 1) || responseContentAsString.contains("class=\"error\"")) {
                errorResponse = ((HtmlPage)responsePage).asXml();
                errorMessage = WebUtils.formErrorMessage(errorResponse, ExternalLogger, ExternalProgressMonitor);
                DialogError.invoke((Object)DialogError, "Fehlermeldung der DAB BNP Paribas S.A.:\n\n\n" + errorMessage, "institutlogo-dabbnpparibas.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("wurden automatisch vom System abgemeldet")) {
                isSelfException = true;
                throw new Exception("Die Online Banking Sitzung ist abgelaufen. Bitte melden Sie sich erneut an.");
            }
            if (responseContentAsString.contains("Sie unsere IT-Systeme erweitern und optimieren")) {
                isSelfException = true;
                throw new Exception("Wegen Wartungsarbeiten ist unser Online-Banking gerade leider nicht erreichbar");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> externalLogger, Class<?> externalProgressMonitor) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int errorTextIDXStart = 0;
            int errorTextIDXend = 0;
            if (contentStringToParse.contains("class=\"error\"")) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
                errorTextIDXStart = contentStringToParse.indexOf("</span>", errorTextIDXStart) + 7;
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            } else if (contentStringToParse.contains("class=\"fehlermeldung\"")) {
                errorTextIDXStart = contentStringToParse.indexOf("class=\"fehlermeldung\"");
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
                errorTextIDXStart = contentStringToParse.indexOf("<p>", errorTextIDXStart) + 3;
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            }
            errorTextIDXend = contentStringToParse.indexOf("</p>", errorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "ErrorTextIDXend: " + errorTextIDXend);
            String ErrorText = contentStringToParse.substring(errorTextIDXStart, errorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            String formErrorText = ErrorText.replaceAll("<br/> ", "\n");
            formErrorText = ErrorText.replaceAll("<br/ > ", "\n");
            formErrorText = ErrorText.replaceAll("<br> ", "\n");
            formErrorText = ErrorText.replaceAll("\t", "");
            formErrorText = ErrorText.replaceAll("<BR>", "\n");
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

