/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.dabbnpparibas;

import de.derrichter.finance.websync.institute.dabbnpparibas.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Land.SEPALand;
import de.jost_net.OBanToo.SEPA.SEPAException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.w3c.dom.Node;

public class WebPull {
    public static ArrayList getTransData(WebClient syncWebClient, String Kontonummer, String Unterkonto, String fromDateSimple, String toDateSimple, HtmlPage postLoginPage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        try {
            Page csv;
            HtmlAnchor searchSubmit;
            HtmlPage dataPage;
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] Check ob in der Konto\u00fcbersicht der Willkommen-Seite die Kontonummer enthalten ist ...");
            try {
                String responsePageXML = postLoginPage.asXml();
                if (!responsePageXML.contains(Kontonummer)) {
                    throw new Exception("Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Abbruch: " + error.getMessage());
            }
            syncWebClient.getOptions().setJavaScriptEnabled(true);
            String transactions = "https://b2b.dab-bank.de/Tradingcenter/Konto/Kontouebersicht/index.xhtml";
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "GET " + transactions);
            try {
                dataPage = (HtmlPage)syncWebClient.getPage(transactions);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "dataPage (Seite): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (dataPage == null) {
                throw new Exception("Die Umsatz\u00fcbersicht konnte nicht aufgerufen werden!");
            }
            String dataPageXML = dataPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                String pathvalue = "//div[contains(.,'" + Kontonummer + "')]/parent::a";
                HtmlAnchor dropDownSelect = (HtmlAnchor)dataPage.getFirstByXPath(pathvalue);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "DropDownSelect: " + dropDownSelect);
                Page kontoselect = dropDownSelect.click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "kontoselect: " + kontoselect);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim setzen der Kontoauswahl in der Umsatz\u00fcbersicht (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String amountPageXML = dataPage.asXml();
            if (!amountPageXML.contains("Aktueller Saldo")) {
                throw new Exception("Auf der Seite konnte kein 'Aktueller Saldo' gefunden werden. Falsche oder andere Seite");
            }
            DomText amountText = (DomText)dataPage.getFirstByXPath("//div[@class='anz' and contains(.,'Aktueller Saldo')]/following-sibling::div[@class='wert']/text()");
            LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "AmountText: " + amountText);
            DomText realAmountText = (DomText)dataPage.getFirstByXPath("//div[@class='anz' and contains(.,'Verf\u00fcgbarer Betrag')]/following-sibling::div[@class='wert']/text()");
            LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "RealAmountText: " + realAmountText);
            double amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText.getTextContent(), externalLogger));
            double realAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(realAmountText.getTextContent(), externalLogger));
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "realAmount: " + realAmount);
            try {
                HtmlForm form = dataPage.getFormByName("dab");
                ((HtmlInput)dataPage.getFirstByXPath("(//input[@name='dab:timeRange:rangeTypeRadio'])[2]")).click();
                ((HtmlInput)dataPage.getFirstByXPath("(//input[@name='dab:timeRange:rangeTypeRadio'])[2]")).setChecked(true);
                searchSubmit = (HtmlAnchor)dataPage.getFirstByXPath("//a[contains(@id,'submitSearch')]");
                form.getInputByName("dab:timeRange:dateFrom").setValue(fromDateSimple);
                form.getInputByName("dab:timeRange:dateTo").setValue(toDateSimple);
                DomElement fakeSubmitSearch = dataPage.createElement("button");
                fakeSubmitSearch.setAttribute("onclick", "jsf.ajax.request('dab:timeRange:dateFrom',event,{render:'dab:transactionsPanel dab:timeRange:main',onevent:clb.global.lockUnlock('#' + 'dab:transactionsPanel'),'javax.faces.behavior.event':'valueChange'})");
                fakeSubmitSearch.setAttribute("name", "dab:accountOverview_buttonSearch");
                fakeSubmitSearch.setAttribute("class", "search");
                fakeSubmitSearch.setAttribute("type", "submit");
                form.appendChild((Node)fakeSubmitSearch);
                dataPage = (HtmlPage)fakeSubmitSearch.click();
                syncWebClient.waitForBackgroundJavaScript(5000L);
                Thread.sleep(1000L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Suchen-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                searchSubmit = (HtmlAnchor)dataPage.getFirstByXPath("//a[contains(@id,'submitSearch')]");
                dataPage = (HtmlPage)searchSubmit.click();
                syncWebClient.waitForBackgroundJavaScript(5000L);
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "DataPage (Suche): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (dataPage == null) {
                throw new Exception("Die Suche-Folgeseite konnte nicht aufgerufen werden!");
            }
            dataPageXML = dataPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                dataPage = WebUtils.checkTANRequest(syncWebClient, dataPage, externalLogger, externalDialogInterface);
                dataPage = WebUtils.checkForMTAN(syncWebClient, dataPage, externalLogger, externalDialogInterface);
                dataPage = WebUtils.checkForQRTAN(syncWebClient, dataPage, externalLogger, externalDialogInterface);
            }
            catch (Exception tanError) {
                isSelfException = true;
                throw new Exception(tanError.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "CSV laden: Click //a[@name='dab:accountOverview_buttonCsvExport'");
            try {
                HtmlAnchor csvDownload = (HtmlAnchor)dataPage.getFirstByXPath("//a[@name='dab:accountOverview_buttonCsvExport']");
                csv = csvDownload.click();
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (csv == null) {
                throw new Exception("Der Kontoauszug (CSV) konnte nicht aufgerufen werden!");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "csv: " + csv);
            String csvResponse = csv.getWebResponse().getContentAsString();
            try {
                WebUtils.checkHTMLUnitResponseHasError(csvResponse, csv, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            syncWebClient.getOptions().setJavaScriptEnabled(true);
            LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + csvResponse + "\n======================= END DATA =======================\n");
            if (csvResponse.contains("<html") || csvResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataResponse = new String[]{csvResponse, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(csvResponse.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][8], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][3]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][7])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][7].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][6])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][6]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][4]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    String ibanFieldToCheck = matrixArrayData[i][5].replaceAll("\\s+", "").trim();
                    String Gegenkontonummer = new String("");
                    String GegenkontoBLZ = new String("");
                    if (!StringCharUtils.isNullOrEmptyOrNothing(ibanFieldToCheck)) {
                        IBAN iban = null;
                        try {
                            iban = new IBAN(ibanFieldToCheck);
                        }
                        catch (SEPAException error) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:DAB] " + getLogMethod + "new IBAN error (set iban as useraccount-nr): " + error.getMessage());
                            Gegenkontonummer = ibanFieldToCheck;
                        }
                        if (iban != null) {
                            SEPALand land = iban.getLand();
                            if (land.getBankIdentifierLength() == null) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:DAB] length of bank identifier unknown for this country, set iban as useraccount-nr");
                                Gegenkontonummer = ibanFieldToCheck;
                            } else {
                                Gegenkontonummer = iban.getKonto();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "Kontonummer aus IBAN: " + Gegenkontonummer);
                                GegenkontoBLZ = iban.getBLZ();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "BLZ aus IBAN: " + GegenkontoBLZ);
                            }
                        }
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Gegenkontonummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(GegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("DAB", Kontonummer, amount, realAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

