/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.dabbnpparibas;

import de.derrichter.finance.websync.institute.dabbnpparibas.WebUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.w3c.dom.Node;

public class WebAuth {
    public static HtmlPage loginWithHTMLUnit(String responseLogin, String responsePassword, WebClient syncWebClient, String Unterkonto, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        HtmlPage pageLogin = null;
        HtmlAnchor submitLogin = null;
        HtmlPage postLoginPage = null;
        String pageLoginXML = null;
        String postLoginXML = null;
        try {
            HtmlForm formLogin;
            LogInfo.invoke((Object)LogInfo, "[WebSync:DAB] " + getLogMethod + "[WebLogin] DAB-Bank-Login aufrufen ... (GET " + "https://b2b.dab-bank.de/Tradingcenter/" + ")");
            try {
                pageLogin = (HtmlPage)syncWebClient.getPage("https://b2b.dab-bank.de/Tradingcenter/");
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "[WebLogin] pageLogin: " + pageLogin);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (pageLogin == null) {
                throw new Exception("Die Login-Seite konnte nicht aufgerufen werden!");
            }
            pageLoginXML = pageLogin.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(pageLoginXML, (Page)pageLogin, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                formLogin = pageLogin.getFormByName("b3login");
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "[WebLogin] formLogin: " + formLogin);
                formLogin.getInputByName("accessNumber").setValue(responseLogin);
                formLogin.getInputByName("identifier").setValue(responsePassword);
                submitLogin = (HtmlAnchor)formLogin.getFirstByXPath("//a[@id='login_bt']");
            }
            catch (Exception error) {
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:DAB] " + getLogMethod + "[WebLogin] Login-Form wird abgesendet ...");
            try {
                DomElement FakeSubmitCC = pageLogin.createElement("button");
                FakeSubmitCC.setAttribute("type", "submit");
                formLogin.appendChild((Node)FakeSubmitCC);
                postLoginPage = (HtmlPage)FakeSubmitCC.click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "[WebLogin] postLoginPage: " + postLoginPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (postLoginPage == null) {
                throw new Exception("Die Login-Folgeseite konnte nicht aufgerufen werden!");
            }
            postLoginXML = postLoginPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(postLoginXML, (Page)postLoginPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                postLoginPage = WebUtils.checkTANRequest(syncWebClient, postLoginPage, externalLogger, externalDialogInterface);
                postLoginPage = WebUtils.checkForMTAN(syncWebClient, postLoginPage, externalLogger, externalDialogInterface);
                postLoginPage = WebUtils.checkForQRTAN(syncWebClient, postLoginPage, externalLogger, externalDialogInterface);
            }
            catch (Exception tanError) {
                isSelfException = true;
                throw new Exception(tanError.getMessage());
            }
            if (postLoginXML.contains("Identifier \u00e4ndern") && postLoginXML.contains("Der neue Identifier muss")) {
                isSelfException = true;
                throw new Exception("Vergabe eines neuen Identifier notwendig. Loggen Sie sich im Online-Banking ein um dies zu erledigen");
            }
            if (postLoginXML.contains("action=\"b3SecurityLoginCheck.xhtml") && postLoginXML.contains("name=\"b3login\"") && postLoginXML.contains("id=\"b3loginform\"")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return postLoginPage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logout(WebClient syncWebClient, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            String logoutURL = null;
            logoutURL = "https://b2b.dab-bank.de/Tradingcenter/Depot/Depotuebersicht/securityLogoff.xhtml";
            HtmlPage postLogoutPage = null;
            String postLogoutPageXML = null;
            LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "GET: " + logoutURL);
            try {
                postLogoutPage = (HtmlPage)syncWebClient.getPage(logoutURL);
                LogDebug.invoke((Object)LogDebug, "[WebSync:DAB] " + getLogMethod + "PostLogoutPage: " + postLogoutPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            postLogoutPageXML = postLogoutPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(postLogoutPageXML, (Page)postLogoutPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!(postLogoutPageXML.contains("Sie haben sich erfolgreich abgemeldet") || postLogoutPageXML.contains("Abmeldung erfolgreich") || postLogoutPageXML.contains("Vielen Dank f\u00fcr Ihren Besuch"))) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:DAB] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:DAB] " + getLogMethod + "Logout bei der '" + "DAB BNP Paribas S.A." + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:DAB] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

