/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.crediteuropebank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String COOKIE_DETECT_PATH = "#usercentrics-root,div[data-testid='uc-default-banner']";
    static String COOKIE_ACCEPT_PATH = "button[data-testid='uc-save-button']";
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//*[contains(@class,'spin_animation') or contains(@src,'loading')]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[1];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//label[@id='error-content-label']";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "DummyExclusion";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:CreditEuropeBank] ";
        String longName = "Credit Europe Bank N.V.";
        try {
            try {
                String warnDialogText = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'well-warning')]")).getText();
                DialogWarn.invoke((Object)DialogWarn, "Meldung der Credit Europe Bank N.V.:\n(Diese muss manuell im Onlinebanking best\u00e4tigt werden)\n\n\n" + warnDialogText, "institutlogo-crediteuropebank.png");
                warnDialogText = StringCharUtils.shrinkString(warnDialogText.replace(" x ", ""));
                throw new Exception(warnDialogText);
            }
            catch (NoSuchElementException noBestSign) {
                WebUtils.setSerchStrings();
                WebUtils.setSerchExclusionStrings();
                SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-crediteuropebank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    static boolean checkForCapcha(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogCaptcha = externalDialogInterface.getMethod("askCaptcha", InputStream.class, String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkForCapcha] ";
        String tanArt = "Captcha-Code";
        String detectTANformPath = "//*[@id='captcha' or @name='captcha']";
        String secTextPath = "//label[contains(@class,'proto') and contains(@class,'genericLabel')]";
        String captchaPath = "//img[contains(@src,'data:image/jpeg')]";
        String tanInputPath = "//*[@id='captcha' or @name='captcha']";
        String submiCaptchaPath = "//*[@id='captcha-approve-button']";
        String checkWrongCaptchaPath = "//*[contains(.,'Der eingegebene Code ist leider nicht korrekt')]";
        String confirmWrongCaptchaPath = "//*[@id='modal-forward-button']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                WebElement tanForm = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "tanForm: " + tanForm);
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")"))).getText().trim().replace(" Bitte geben Sie den Code innerhalb des angezeigten Zeitlimits ein.", "");
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "secText: " + secText);
                boolean retryInput = false;
                do {
                    String userCaptchaInput;
                    try {
                        String captchaImageObject = seleniumWebDriver.findElement(By.xpath((String)captchaPath)).getAttribute("src");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "CaptchaImageObject: " + captchaImageObject);
                        String base64Image = captchaImageObject.split(",")[1];
                        byte[] imageBytes = DatatypeConverter.parseBase64Binary((String)base64Image);
                        ByteArrayInputStream captchaImageResponse = new ByteArrayInputStream(imageBytes);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "CaptchaImageResponse: " + captchaImageResponse);
                        userCaptchaInput = (String)DialogCaptcha.invoke((Object)DialogCaptcha, captchaImageResponse, "institutlogo-crediteuropebank.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der Captcha-Antwort durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:CreditEuropeBank] " + getLogMethod + "DialogCaptcha fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("DialogCaptcha fehlerhaft: " + error.getMessage());
                    }
                    catch (Exception error) {
                        throw new Exception("Fehler bei der Captcha-Abfrage oder Abbruch durch Benutzer (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    WebElement captchaInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "tanInput: " + captchaInput);
                    captchaInput.sendKeys(new CharSequence[]{userCaptchaInput});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitCaptcha", submiCaptchaPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterTanResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)checkWrongCaptchaPath));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der Credit Europe Bank N.V.:\n\n\nDer eingegebene " + tanArt + " ist falsch.", "institutlogo-crediteuropebank.png");
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "confirmWrongCaptcha", confirmWrongCaptchaPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterTanResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (TimeoutException noTANauth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt oder wurde umgebaut? mache weiter ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return true;
    }

    static boolean checkForBankingApp(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        String getLogMethod = "[waitBankingApp] ";
        String tanArt = "BankingApp";
        String detectAppAuthPath = "//div[contains(.,'den Login in der Banking App')]";
        String detectVerifiPath = "//div[contains(.,'Der Vorgang wird nun validiert')]";
        String detectAbortPath = "//p[contains(.,'Der Vorgang wurde abgebrochen')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectAppAuthPath)));
                LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Warte auf Banking-App Freigabe ...");
                MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                int rounds = 0;
                Thread.sleep(3000L);
                boolean showWaiting = true;
                boolean validating = false;
                while (true) {
                    WebElement waiterCheckElement = null;
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAppAuthPath));
                        showWaiting = true;
                    }
                    catch (NoSuchElementException noMoreWaiting) {
                        showWaiting = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectVerifiPath));
                        validating = true;
                    }
                    catch (NoSuchElementException noMoreWaiting) {
                        validating = false;
                    }
                    try {
                        waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAbortPath));
                        isSelfException = true;
                        throw new Exception("Banking-App Authentifizierung: Der Vorgang wurde abgebrochen");
                    }
                    catch (NoSuchElementException noMoreWaiting) {
                        if (showWaiting) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                            Thread.sleep(3000L);
                        } else if (validating) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Validierung des Vorgang im gange ...");
                            MonitorLog.invoke((Object)MonitorLog, "Validierung des Vorgang im gange ...");
                            SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        } else {
                            showWaiting = false;
                            validating = false;
                        }
                        if (++rounds >= 39) {
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung auch nach 120 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            continue;
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                        if (showWaiting || validating) continue;
                    }
                    break;
                }
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            isSelfException = true;
            throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return true;
    }

    static boolean checkForSecCode(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskSecCode = externalDialogInterface.getMethod("askSecCode", String.class, String.class, Integer.class, Integer.class, String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkForMTAN] ";
        String authArt = "secureCode";
        String detectSecCodeFormPath = "//*[@id='code']";
        String secTextPath = "//label[contains(@class,'proto') and contains(@class,'genericBody')]";
        String codeInputPath = "//*[@id='code']";
        String submitCodePath = "//*[@id='panel-action-button-next']";
        String checkWrongCodePath = "//*[contains(.,'Der Sicherheitscode ist ung')]";
        String confirmWrongCodePath = "//*[@id='modal-forward-button']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Pr\u00fcfen auf " + authArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectSecCodeFormPath)));
                WebElement tanForm = seleniumWebDriver.findElement(By.xpath((String)detectSecCodeFormPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "tanForm: " + tanForm);
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + authArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "secCodeForm", detectSecCodeFormPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")"))).getText().trim().replace(" Bitte geben Sie den Code innerhalb des angezeigten Zeitlimits ein.", "");
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "secText: " + secText);
                boolean retryInput = false;
                do {
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskSecCode.invoke((Object)DialogAskSecCode, authArt, secText, 5, 5, "institutlogo-crediteuropebank.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + authArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:CreditEuropeBank] " + getLogMethod + "SecCodeAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("SecCodeAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)codeInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitCode", submitCodePath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterTanResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebElement checkWrongCode = seleniumWebDriver.findElement(By.xpath((String)checkWrongCodePath));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "checkWrongTAN: " + checkWrongCode);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der Credit Europe Bank N.V.:\n\n\nDie eingegebene " + authArt + " ist falsch.", "institutlogo-crediteuropebank.png");
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "confirmWrongCaptcha", confirmWrongCodePath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfterTanResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (TimeoutException noTANauth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Sicherheitsverfahren '" + authArt + "' wird NICHT (direkt) abgefragt oder wurde umgebaut? mache weiter ...");
                return false;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(authArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return true;
    }
}

