/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.crediteuropebank;

import de.derrichter.finance.websync.institute.crediteuropebank.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            String transData;
            double availableAmount;
            double amount;
            block67: {
                try {
                    String detectPath = "//div[contains(@class,'proto-modal')]";
                    String messagePath = detectPath + "//*[@id='message-label']";
                    String closePath = detectPath + "//*[contains(@class,'proto-svg-clickable')]";
                    boolean hasAbortButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String formWarnText = "";
                        List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)messagePath));
                        for (WebElement headline : allHeadlines) {
                            String headlinetext = headline.getText();
                            formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:CreditEuropeBank] ", headlinetext, externalLogger) + " ";
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "warnText: " + formWarnText);
                        DialogWarn.invoke((Object)DialogWarn, "Meldung der Credit Europe Bank N.V.:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://banking.crediteurope.de/web/#" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-crediteuropebank.png");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closePath)));
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasAbortButton = false;
                            isSelfException = true;
                            throw new Exception("Im Onlinebanking muss auf folgende Meldung reagiert werden: " + formWarnText.trim());
                        }
                        hasAbortButton = true;
                        LogWarn.invoke((Object)LogWarn, "[WebSync:CreditEuropeBank] Meldung(en) der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", closePath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    } while (hasAbortButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
                LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "Kontonummer (formated): " + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer));
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//*[contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer) + "')]"))));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
                }
                catch (NoSuchElementException | TimeoutException noCreditCard) {
                    isSelfException = true;
                    throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Umsatz\u00fcbersicht aufrufen ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountIDLabel", "//label[contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer) + "')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                amount = Double.NaN;
                availableAmount = Double.NaN;
                try {
                    String amountText = seleniumWebDriver.findElement(By.xpath((String)"//*[contains(@id,'amount')]")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "amountText: " + amountText);
                    amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
                }
                try {
                    availableAmount = amount;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage());
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Amount: " + amount);
                LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "availableAmount: " + availableAmount);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountLink", "//label[contains(.,'Ihr Konto')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "showTransaktions", "//*[@id='show-transactions-button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "searchBar", "//*[@id='search-date-label']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    String fromInputPath = "//*[@id='start-date-datepicker']";
                    String toInputPath = "//*[@id='end-date-datepicker']";
                    String filterButtonPath = "//*[@id='modal-forward-button']";
                    seleniumWebDriver = SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, getLogMethod, "Credit Europe Bank N.V.", "institutlogo-crediteuropebank.png", fromDateSimple, toDateSimple, fromInputPath, toInputPath, filterButtonPath, true, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception searchError) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)searchError));
                }
                String searchPageSource = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(searchPageSource, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String moreButtonPath = "//span[contains(.,'Weitere Ums\u00e4tze laden')]/parent::button";
                String lastDate = "(//h3[contains(@class,'c-table-list__headline')])[last()]/span/span[2]";
                boolean more = true;
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                Date maxDate = sdf.parse(fromDateSimple);
                do {
                    try {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Gefundener Weitere-Button: " + wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)moreButtonPath))));
                        String lastDateText = seleniumWebDriver.findElement(By.xpath((String)lastDate)).getText();
                        Date strDate = sdf.parse(lastDateText);
                        if (strDate.before(maxDate)) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Abrufzeitraum \u00fcberschritten, stoppe Aufruf weitere Ums\u00e4tze");
                            more = false;
                            break;
                        }
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "moreButton", moreButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        Thread.sleep(1000L);
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Weitere-Button-Button wurde nicht (mehr) gefunden.  xPathExpression " + moreButtonPath + " ergab kein Ergebnis");
                        more = false;
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                } while (more);
                transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Credit Europe Bank N.V.\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
                boolean haveNewTrans = false;
                try {
                    if (seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'diesen Zeitraum liegen keine Transaktionen')]")) != null) {
                        transData = transData + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                    }
                }
                catch (Exception waiterror) {
                    haveNewTrans = true;
                    LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] xpath //section[contains(.,'Zeitraum sind keine Ums\u00e4tze vorhanden')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
                }
                String transDetailsPath = "//ul[contains(@class,'proto-list')]//*[contains(@id,'show-details-label-item')]";
                String scheduledTansPath = "//label[contains(@id,'scheduled-date-label')]";
                try {
                    if (!haveNewTrans) break block67;
                    String betragPath = "//label[@id='sign-label-itemIDX']";
                    String purpPath = "//label[@id='effective-desc-label-itemIDX']";
                    String bookingDatePath = "//label[@id='transaction-date-label-itemIDX']";
                    String valutaDatePath = "//label[@id='date-value-label-itemIDX']";
                    String showDetailsPath = "//label[@id='show-details-label-itemIDX']";
                    LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] " + getLogMethod + "Gefundene Ums\u00e4tze: " + wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transDetailsPath))));
                    List transactions = seleniumWebDriver.findElements(By.xpath((String)transDetailsPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Anzahl aller gefundenen Transaktionen auf der Seite (inkl. Termin): " + String.valueOf(transactions.size()));
                    int futureTransactions = 0;
                    String futureTransactionID = "0";
                    int addEndID = 0;
                    try {
                        futureTransactions = seleniumWebDriver.findElements(By.xpath((String)scheduledTansPath)).size();
                        WebElement futureTransaction = seleniumWebDriver.findElement(By.xpath((String)("(" + scheduledTansPath + ")[last()]")));
                        if (!StringCharUtils.isNullOrEmptyOrNothing(futureTransaction.getAttribute("id"))) {
                            futureTransactionID = futureTransaction.getAttribute("id");
                            futureTransactionID = futureTransactionID.substring(futureTransactionID.length() - 1);
                            addEndID = 1;
                        }
                    }
                    catch (Exception waiterror) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:CreditEuropeBank] Termin-Buchungen vorhanden: " + String.valueOf(futureTransactions) + "; ID letzer Transaktion in der Zukuft ist: " + futureTransactionID);
                    }
                    LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Anzahl der gebuchten Transaktionen auf der Seite: " + String.valueOf(transactions.size() - futureTransactions));
                    for (int i = futureTransactions + addEndID; i < transactions.size() + addEndID; ++i) {
                        double MonitorPercent = 30.0 + (29.0 / (double)transactions.size() - (double)futureTransactions) * (double)(i + 1);
                        MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                        String purpPathText = "";
                        String betragPathText = "";
                        String bookingDatePathText = "";
                        String valutaDatePathText = "";
                        String namePathText = "";
                        String ibanPathText = "";
                        String bicPathText = "";
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "openDetailDialog", showDetailsPath.replace("IDX", String.valueOf(i)), WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        bookingDatePathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)bookingDatePath.replace("IDX", String.valueOf(i)))).getText());
                        LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "bookingDatePathText: " + bookingDatePathText);
                        if (bookingDatePathText.trim().equals("Heute")) {
                            bookingDatePathText = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                            LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "bookingDatePathText converted: " + bookingDatePathText);
                        } else if (bookingDatePathText.trim().equals("Gestern")) {
                            Calendar cal = Calendar.getInstance();
                            cal.add(5, -1);
                            bookingDatePathText = new SimpleDateFormat("dd.MM.yyyy").format(new Date(cal.getTimeInMillis()));
                            LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "bookingDatePathText converted: " + bookingDatePathText);
                        }
                        valutaDatePathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)valutaDatePath.replace("IDX", String.valueOf(i)))).getText());
                        LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "valutaDatePathText: " + valutaDatePathText);
                        purpPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)purpPath.replace("IDX", String.valueOf(i)))).getText());
                        LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "purpPathText: " + purpPathText);
                        betragPathText = StringCharUtils.shrinkString(seleniumWebDriver.findElement(By.xpath((String)betragPath.replace("IDX", String.valueOf(i)))).getText());
                        LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "betragPathText: " + betragPathText);
                        transData = transData + bookingDatePathText + ";" + valutaDatePathText + ";" + purpPathText + ";" + betragPathText + ";" + namePathText + ";" + ibanPathText + ";" + bicPathText + "\n";
                    }
                }
                catch (TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:CreditEuropeBank] " + getLogMethod + "Keine Ums\u00e4tze gefunden. xPathExpression " + transDetailsPath + " ergab kein Ergebnis");
                }
            }
            try {
                String closeButtonPath = "//*[@id='icon-close']";
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeButton", closeButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeButton", closeButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transData (Statement): \n\n====================== BEGIN STATEMENT DATA ======================\n" + transData + "\n======================= END STATEMENT DATA =======================\n");
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][3], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (String.valueOf(betrag).startsWith("-")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Auszahlung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Einzahlung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    String purp = matrixArrayData[i][2];
                    if (!StringCharUtils.isNullOrEmptyOrNothing(purp)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String gegenkontoName = "";
                    String gegenkontoNummer = "";
                    String gegenkontoBLZ = "";
                    String iban = "";
                    String bic = "";
                    String kommentar = "";
                    String[] checkString = purp.split(" ");
                    if (StringCharUtils.isIbanCountryStructure(checkString[0])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(checkString[0]);
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(iban);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(bic);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentar);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:CreditEuropeBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("CreditEuropeBank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

