/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.consorsfinanzbnpparibas;

import de.derrichter.finance.websync.institute.consorsfinanzbnpparibas.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlPage;

public class WebPull {
    public static ArrayList getTransData(WebClient syncWebClient, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, HtmlPage postLoginPage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        try {
            HtmlPage dataPage;
            LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] Check ob in der Konto\u00fcbersicht der Willkommen-Seite die Kontonummer enthalten ist ...");
            try {
                String responsePageXML = postLoginPage.asXml();
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] Kontonummer-Check: ResponsePageXML (Seite): \n" + responsePageXML);
                if (!responsePageXML.contains(kontonummer)) {
                    throw new Exception("Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Abbruch: " + error.getMessage());
            }
            String amountPageXML = postLoginPage.asXml();
            if (!amountPageXML.contains("Aktueller Saldo")) {
                throw new Exception("Auf der Seite konnte kein 'Aktueller Saldo' gefunden werden. Falsche oder andere Seite");
            }
            DomText amountText = (DomText)postLoginPage.getFirstByXPath("//span[contains(.,'Kontostand')]//following-sibling::span/text()");
            LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "AmountText: " + amountText);
            DomText realAmountText = (DomText)postLoginPage.getFirstByXPath("//span[contains(.,'Verf\u00fcgungsrahmen')]//following-sibling::span/text()");
            LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "RealAmountText: " + realAmountText);
            double amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText.getTextContent(), externalLogger));
            double realAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(realAmountText.getTextContent(), externalLogger));
            LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "realAmount: " + realAmount);
            syncWebClient.getOptions().setJavaScriptEnabled(true);
            String transactions = "https://olb.consorsfinanz.de/web/homebanking/umsatze";
            LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "GET " + transactions);
            try {
                dataPage = (HtmlPage)syncWebClient.getPage(transactions);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "dataPage (Seite): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (dataPage == null) {
                throw new Exception("Die Umsatz\u00fcbersicht konnte nicht aufgerufen werden!");
            }
            String dataPageXML = dataPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(dataPageXML, (Page)dataPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            int dataCount = 0;
            String cutResponse = "Kaufdatum;Wertstellung;Betrag;Beschreibung\n";
            List dataCountObjects = dataPage.getByXPath("//div[contains(@class,'transaction-description')]/text()");
            if (dataCountObjects != null) {
                dataCountObjects.size();
            } else {
                cutResponse = "\nIm Abrufzeitraums sind keine Transaktionen vorhanden";
            }
            String kaufDatum = "";
            String valutaDatum = "";
            String betragCut = "";
            String verwendungszweck = "";
            for (int transNbr = 0; transNbr < dataCount; ++transNbr) {
                kaufDatum = (String)dataPage.getByXPath("//div[contains(@class,'transaction-date-left')]/text()").get(transNbr);
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "kaufDatum #" + transNbr + ": " + kaufDatum);
                valutaDatum = (String)dataPage.getByXPath("//div[contains(@class,'transaction-date-center')]/text()").get(transNbr);
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "valutaDatum #" + transNbr + ": " + valutaDatum);
                betragCut = (String)dataPage.getByXPath("//div[contains(@class,'transaction-amount')]/text()").get(transNbr);
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "betrag #" + transNbr + ": " + betragCut);
                verwendungszweck = (String)dataPage.getByXPath("//div[contains(@class,'transaction-description')]/text()").get(transNbr);
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "verwendungszweck #" + transNbr + ": " + verwendungszweck);
                cutResponse = cutResponse + kaufDatum + ";" + valutaDatum + ";" + betragCut + ";" + verwendungszweck + "\n";
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Consors Finanz BNP Paribas S.A.\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + realAmount + "\nAnzahl der Transaktionen:;" + dataCount + "\n";
            LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            if (transData.contains("<html") || transData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    String betragString = matrixArrayData[i][2];
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(betragString, externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayData[i][3].contains("zinsen")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zinsen vor Steuern");
                    } else if (!String.valueOf(betragString).contains("-")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][3].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("ConsorsFinanz", kontonummer, amount, realAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

