/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.consorsfinanzbnpparibas;

import de.derrichter.finance.websync.institute.consorsfinanzbnpparibas.WebUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlPage;
import org.w3c.dom.Node;

public class WebAuth {
    public static HtmlPage loginWithHTMLUnit(String responseLogin, String responsePassword, WebClient syncWebClient, String Unterkonto, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        HtmlPage pageLogin = null;
        DomElement submitLogin = null;
        HtmlPage postLoginPage = null;
        String pageLoginXML = null;
        String postLoginXML = null;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:ConsorsFinanz] " + getLogMethod + "[WebLogin] DAB-Bank-Login aufrufen ... (GET " + "https://olb.consorsfinanz.de/web/homebanking/home" + ")");
            try {
                pageLogin = (HtmlPage)syncWebClient.getPage("https://olb.consorsfinanz.de/web/homebanking/home");
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "[WebLogin] pageLogin: " + pageLogin);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (pageLogin == null) {
                throw new Exception("Die Login-Seite konnte nicht aufgerufen werden!");
            }
            pageLoginXML = pageLogin.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(pageLoginXML, (Page)pageLogin, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                HtmlInput usernameField = (HtmlInput)pageLogin.getFirstByXPath("//input[contains(@id,'loginForm:handle')]");
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "[WebLogin] usernameField: " + usernameField);
                usernameField.setValue(responseLogin);
                HtmlInput passwordField = (HtmlInput)pageLogin.getFirstByXPath("//input[contains(@id,'loginForm:handle')]");
                passwordField.setValue(responsePassword);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "[WebLogin] passwordField: " + passwordField);
                submitLogin = (DomElement)pageLogin.getFirstByXPath("//button[contains(.,'Anmelden')]");
            }
            catch (Exception error) {
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:ConsorsFinanz] " + getLogMethod + "[WebLogin] Login-Form wird abgesendet ...");
            try {
                DomElement fakeSubmitCC = pageLogin.createElement("button");
                fakeSubmitCC.setAttribute("type", "submit");
                HtmlForm formLogin = (HtmlForm)pageLogin.getFirstByXPath("//form[contains(@id,'loginForm')]");
                formLogin.appendChild((Node)fakeSubmitCC);
                postLoginPage = (HtmlPage)fakeSubmitCC.click();
                syncWebClient.waitForBackgroundJavaScript(50000L);
                Thread.sleep(3000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "[WebLogin] postLoginPage: " + postLoginPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (postLoginPage == null) {
                throw new Exception("Die Login-Folgeseite konnte nicht aufgerufen werden!");
            }
            postLoginXML = postLoginPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(postLoginXML, (Page)postLoginPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (postLoginXML.contains("loginForm:handle") && postLoginXML.contains("loginForm:password")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return postLoginPage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logout(WebClient syncWebClient, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            String logoutURL = null;
            logoutURL = "https://olb.consorsfinanz.de/c/portal/logout";
            HtmlPage postLogoutPage = null;
            String postLogoutPageXML = null;
            LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "GET: " + logoutURL);
            try {
                postLogoutPage = (HtmlPage)syncWebClient.getPage(logoutURL);
                LogDebug.invoke((Object)LogDebug, "[WebSync:ConsorsFinanz] " + getLogMethod + "PostLogoutPage: " + postLogoutPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            postLogoutPageXML = postLogoutPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(postLogoutPageXML, (Page)postLogoutPage, externalLogger, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!(postLogoutPageXML.contains("Sie haben sich erfolgreich abgemeldet") || postLogoutPageXML.contains("Abmeldung erfolgreich") || postLogoutPageXML.contains("Herzlich willkommen!"))) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:ConsorsFinanz] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:ConsorsFinanz] " + getLogMethod + "Logout bei der '" + "Consors Finanz BNP Paribas S.A." + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:ConsorsFinanz] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

