/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.bwbank;

import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[@class='msgerror']//li";
        WebUtils.xpathSearchString[1] = "//label[contains(@class,'error-message') and text()!='' and not(contains(@style,'display: none;'))]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, String blz, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, WebUtils.getLogIdent(blz), WebUtils.getLongName(blz), WebUtils.getLogoPath(blz), xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static String getLoginURL(String thisKontonummer) throws Exception {
        String loginURL;
        block4: {
            loginURL = null;
            try {
                if (thisKontonummer.equals("0002785419")) {
                    loginURL = "https://kso.bw-bank.de/";
                    break block4;
                }
                if (thisKontonummer.equals("0002785550")) {
                    loginURL = "https://kso.bw-bank.de/payback";
                    break block4;
                }
                throw new Exception("Unbekannte Kontonummer angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'loginURL' fehlerhaft: " + logerror.getMessage());
            }
        }
        return loginURL;
    }

    public static String getShortName(String thisKontonummer) throws Exception {
        String shortName;
        block4: {
            shortName = null;
            try {
                if (thisKontonummer.equals("0002785419")) {
                    shortName = "MercedesCard";
                    break block4;
                }
                if (thisKontonummer.equals("0002785550")) {
                    shortName = "PAYBACKVisa";
                    break block4;
                }
                throw new Exception("Unbekannte Kontonummer angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'shortName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return shortName;
    }

    public static String getLongName(String thisKontonummer) throws Exception {
        String longName;
        block4: {
            longName = null;
            try {
                if (thisKontonummer.equals("0002785419")) {
                    longName = "MercedesCard Visa Kartenservice";
                    break block4;
                }
                if (thisKontonummer.equals("0002785550")) {
                    longName = "PAYBACK Visa Kartenservice";
                    break block4;
                }
                throw new Exception("Unbekannte Kontonummer angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'longName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return longName;
    }

    public static String getLogIdent(String thisKontonummer) throws Exception {
        String logIdent;
        block4: {
            logIdent = null;
            try {
                if (thisKontonummer.equals("0002785419")) {
                    logIdent = "[WebSync:MercedesCard] ";
                    break block4;
                }
                if (thisKontonummer.equals("0002785550")) {
                    logIdent = "[WebSync:PAYBACKVisa] ";
                    break block4;
                }
                throw new Exception("Unbekannte Kontonummer angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logIdent' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logIdent;
    }

    public static String getLogoPath(String thisKontonummer) throws Exception {
        String logoPath;
        block4: {
            logoPath = null;
            try {
                if (thisKontonummer.equals("0002785419")) {
                    logoPath = "institutlogo-mercedescard.png";
                    break block4;
                }
                if (thisKontonummer.equals("0002785550")) {
                    logoPath = "institutlogo-paybackvisa.png";
                    break block4;
                }
                throw new Exception("Unbekannte Kontonummer angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logoPath' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logoPath;
    }
}

