/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.bwbank;

import de.derrichter.finance.websync.institute.bwbank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String kundennummer, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        boolean isSelfException = false;
        String loaderCatchString = "DummyLoaderCatchString";
        String loaderExclusion = "DummyLoaderExclusion";
        String loaderPath = "DummyLoaderPath";
        String loaderText = "DummyLoaderText";
        boolean localTest = false;
        boolean localPDFTest = false;
        try {
            String[] arrayvaluta;
            String[] arraydatum;
            String[] checkColumn;
            int i;
            WebElement toDateField;
            WebElement fromDateField;
            String pageDownlodsResponse;
            Actions actions;
            WebElement logo;
            Double amount = 0.0;
            String transData = "";
            boolean haveNewTrans = true;
            String fromDateFieldPath = "(//input[contains(@class,'dp-picker-input')])[1]";
            String toDateFieldPath = "(//input[contains(@class,'dp-picker-input')])[2]";
            if (!localTest && !localPDFTest) {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "Check ob in der Konto\u00fcbersicht der Willkommen-Seite die Kreditkartennummer enthalten ist ...");
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "Kreditkartennummer-Check: " + kundennummer.substring(0, 4) + " **** **** " + kundennummer.substring(12, 16));
                try {
                    seleniumWebDriver.findElement(By.xpath((String)("//*[contains(.,'" + kundennummer.substring(0, 4) + "') and contains(.,'" + kundennummer.substring(12, 16) + "')]")));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "OK - Kreditkartennummer auf der Startseite vorhanden");
                }
                catch (Exception waiterror) {
                    isSelfException = true;
                    throw new Exception("Ihre angegebene Kreditkartennummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"(//td[@data-header='Saldo'])[1]")));
                }
                catch (Exception waiterror) {
                    isSelfException = true;
                    throw new Exception("Auf der Seite konnte kein 'Saldo' zum angegebenen Konto gefunden werden. Falsche oder andere Seite");
                }
                WebElement amountCollum = seleniumWebDriver.findElement(By.xpath((String)"(//td[@data-header='Saldo'])[1]"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "getAmount: amountCollum: " + amountCollum);
                String amountText = amountCollum.getText();
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "AmountText: " + amountText);
                if (StringCharUtils.shrinkString(amountText).equals("-")) {
                    amountText = "0,00";
                }
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "Amount: " + String.valueOf(amount));
                String openMenuCardPath = "//a[contains(@href,'/kreditkarten')]";
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "openMenuCard", openMenuCardPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                logo = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'logo')]"));
                actions = new Actions(seleniumWebDriver);
                actions.moveToElement(logo).perform();
                pageDownlodsResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageDownlodsResponse, seleniumWebDriver, kontonummer, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String dateNowSimple = null;
                if (!StringCharUtils.isNullOrEmptyOrNothing(toDateSimple)) {
                    dateNowSimple = toDateSimple;
                } else {
                    toDateSimple = dateNowSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                }
                fromDateField = seleniumWebDriver.findElement(By.xpath((String)fromDateFieldPath));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "fromDateField: " + fromDateField);
                toDateField = seleniumWebDriver.findElement(By.xpath((String)toDateFieldPath));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "toDateField: " + toDateField);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "fromDateField", fromDateFieldPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    fromDateField.sendKeys(new CharSequence[]{fromDateSimple});
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "toDateField", toDateFieldPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    toDateField.sendKeys(new CharSequence[]{toDateSimple});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "searchButton", "//input[@name='aktualisieren']", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    Thread.sleep(1500L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der " + WebUtils.getLongName(kontonummer) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nKartennummer:;" + kundennummer.substring(0, 4) + " **** **** " + kundennummer.substring(12) + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + amount + "\n\n";
                haveNewTrans = false;
                try {
                    if (seleniumWebDriver.findElement(By.xpath((String)"//li[contains(.,'Es liegen keine Ums\u00e4tze vor')]")) != null) {
                        transData = transData + "Datum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                    }
                }
                catch (Exception waiterror) {
                    haveNewTrans = true;
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + "xpath //li[contains(.,'Es liegen keine Ums\u00e4tze vor')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
                }
            }
            File downloadedFile = null;
            String doctext = null;
            String doctype = "";
            if (localTest) {
                haveNewTrans = true;
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                downloadedFile = new File(docFixTempFilePath);
            }
            if (haveNewTrans) {
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest && !localPDFTest) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", "//input[@name='Export']", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "Warte auf die Fertigstellung des Downloads der Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    if (downloadedFile != null) {
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                        doctype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                        if (doctype.toLowerCase().equals("txt") || doctype.toLowerCase().equals("htm") || doctype.toLowerCase().equals("html") || doctype.toLowerCase().equals("asp") || doctype.toLowerCase().equals("js")) {
                            LogWarn.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                            ++downloadCount;
                            downloadedFileIsFalse = true;
                        } else {
                            downloadedFileIsFalse = false;
                        }
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    if (downloadedFile == null || !downloadedFile.exists()) {
                        throw new Exception("Fehler beim Download des Kontoauszugs, Datei wurde nicht geladen (NULL)");
                    }
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                String fileResponse = "";
                String fileencoding = "windows-1252";
                if (!localPDFTest) {
                    fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "raw-fileResponse witout file-encoding convert: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                    if (!fileencoding.equals("UTF-8")) {
                        LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(kontonummer) + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                        byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                        doctext = new String(filebytes, System.getProperty("file.encoding"));
                    } else {
                        doctext = fileResponse;
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + doctype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                }
                if (!localTest && !localPDFTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
                transData = transData + doctext;
            }
            String transDataPDFs = "";
            boolean haveNewPDFs = true;
            String billLinksPath = null;
            List billLinks = null;
            int billRound = 0;
            if (!localTest && !localPDFTest) {
                MonitorLog.invoke((Object)MonitorLog, "Es werden alle notwendigen PDF-Abrechnungen abgerufen ... bitte warten ...");
                String openMenuInboxPath = "//a[contains(@href,'/postfach')]";
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "openMenuInbox", openMenuInboxPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                logo = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(@class,'logo')]"));
                actions = new Actions(seleniumWebDriver);
                actions.moveToElement(logo).perform();
                pageDownlodsResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageDownlodsResponse, seleniumWebDriver, kontonummer, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String maxSearchDate = toDateSimple;
                if (haveNewTrans) {
                    String[][] matrixArrayDataTempCSV = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
                    maxSearchDate = matrixArrayDataTempCSV[9][0].trim();
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "maxSearchDate (oldest Transaction in CSV): " + maxSearchDate);
                }
                fromDateField = seleniumWebDriver.findElement(By.xpath((String)fromDateFieldPath));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "fromDateField: " + fromDateField);
                toDateField = seleniumWebDriver.findElement(By.xpath((String)toDateFieldPath));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "toDateField: " + toDateField);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "fromDateField", fromDateFieldPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    fromDateField.sendKeys(new CharSequence[]{fromDateSimple});
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "toDateField", toDateFieldPath, loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                    toDateField.sendKeys(new CharSequence[]{maxSearchDate});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                Select accountSelect = new Select(seleniumWebDriver.findElement(By.name((String)"dokumententyp")));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "accountSelect: " + accountSelect);
                accountSelect.selectByValue("ABRECHNUNGEN");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "searchButton", "//input[@name='aktualisieren']", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                Thread.sleep(1000L);
                transDataPDFs = "Gesammelte Rechnung(en) f\u00fcr ein Konto der " + WebUtils.getLongName(kontonummer) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nKartennummer:;" + kundennummer.substring(0, 4) + " **** **** " + kundennummer.substring(12) + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + amount + "\n\n";
                haveNewPDFs = false;
                billLinksPath = "//input[@value='Details anzeigen']";
                billLinks = null;
                billRound = 0;
                try {
                    if (seleniumWebDriver.findElement(By.xpath((String)"//li[contains(.,' keine Abrechnungen') or contains(.,' keine Nachrichten')]")) != null) {
                        transDataPDFs = transDataPDFs + "Datum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                    }
                }
                catch (Exception waiterror) {
                    haveNewPDFs = true;
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + "xpath //li[contains(.,' keine Abrechnungen') or contains(' keine Nachrichten')] NICHT gefunden; Es sollten neue Abrechnungen vorhanden sein ...");
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + "Lese alle Rechnungs-Links um Anzahl zu erhalten ...");
                    billLinks = seleniumWebDriver.findElements(By.xpath((String)billLinksPath));
                    SeleniumUtils.showFormatedListOfAllWebElementsInLog(seleniumWebDriver, billLinksPath, externalLogger);
                }
            }
            File downloadedBill = null;
            String billtext = null;
            String fileType = "";
            if (localPDFTest) {
                haveNewPDFs = true;
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.pdf";
                downloadedBill = new File(docFixTempFilePath);
            }
            while (haveNewPDFs) {
                ++billRound;
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest && !localPDFTest) {
                        double MonitorPercent = 30.0 + 29.0 / (double)billLinks.size() * (double)(billRound + 1);
                        MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "detailsButton", "(" + billLinksPath + ")[" + billRound + "]", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "Warte auf die Fertigstellung des Downloads einer PDF-Rechnung ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedBill = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedBill == null && waiter < 30);
                            if (downloadedBill != null && downloadedBill.exists()) continue;
                            if (downloadCount < 4) {
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "detailsButton", "(" + billLinksPath + ")[" + billRound + "]", loaderCatchString, loaderExclusion, loaderPath, loaderText, true, externalLogger);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                }
                                ++downloadCount;
                                Thread.sleep(500L);
                                waiter = 0;
                                downloadedBill = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"));
                                continue;
                            }
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedBill.getAbsolutePath().endsWith(".crdownload"));
                    }
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "downloaded file: " + downloadedBill.getAbsolutePath());
                    fileType = downloadedBill.getName().substring(downloadedBill.getAbsolutePath().lastIndexOf("\\.") + 1).toUpperCase();
                    if (fileType.toLowerCase().equals("txt") || fileType.toLowerCase().equals("htm") || fileType.toLowerCase().equals("html") || fileType.toLowerCase().equals("asp") || fileType.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "wrong downloaded file: " + downloadedBill.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                MemoryUsageSetting memUsageSetting = MemoryUsageSetting.setupTempFileOnly();
                PDDocument pdf = Loader.loadPDF((File)downloadedBill);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "[PDDocument.load FILE]: " + pdf);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "Erzeuge einen Kontoauszug aus PDF ...");
                try {
                    PDFTextStripper stripper = new PDFTextStripper();
                    stripper.setWordSeparator(";");
                    stripper.setSortByPosition(true);
                    billtext = stripper.getText(pdf);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der PDF hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "getDataExport: soeben abgeholte und umgewandelte PDF-Rechnung (pdftext): \n" + billtext);
                pdf.close();
                int idxStart = billtext.indexOf("Buchungstext/Ort;Betrag;Kurs");
                int idxEnd = billtext.indexOf("Neuer Kontostand zum ", idxStart);
                idxEnd = billtext.indexOf("\n", idxEnd);
                billtext = billtext.substring(idxStart, idxEnd);
                if (!localPDFTest) {
                    FileUtils.copyFileToDirectory((File)downloadedBill, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(kontonummer) + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedBill);
                }
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + billtext + "\n======================= END DATA =======================\n");
                transDataPDFs = transDataPDFs + "\n\n" + billtext;
                if (localPDFTest) {
                    haveNewPDFs = false;
                    continue;
                }
                if (billRound < billLinks.size()) continue;
                haveNewPDFs = false;
            }
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transdata + transDataPDFs: \n\n====================== BEGIN DATA ======================\n" + transData + "\n\n\n" + transDataPDFs + "\n======================= END DATA =======================\n");
            String[] dataResponse = new String[2];
            String csvResponse = transData;
            String pdfResponse = transDataPDFs;
            dataResponse[0] = csvResponse + "\n\n\n\n\n\n" + pdfResponse;
            dataResponse[1] = Double.toString(amount);
            String[][] matrixArrayDataCSV = StringCharUtils.data2matrixArray(csvResponse.replace("\"", "\\\""), '\"', ';', externalLogger);
            String[][] matrixArrayDataPDFs = StringCharUtils.data2matrixArray(pdfResponse.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (i = 0; i < matrixArrayDataCSV.length; ++i) {
                if (matrixArrayDataCSV[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "matrixArrayDataCSV: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    checkColumn = matrixArrayDataCSV[i][0].trim().split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    String[] checkColumn2 = matrixArrayDataCSV[i][1].trim().split("\\.");
                    float testnumber2 = Float.parseFloat(checkColumn2[0]);
                    testnumber2 = Float.parseFloat(checkColumn2[1]);
                    testnumber2 = Float.parseFloat(checkColumn2[2]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + "matrixArrayDataCSV: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    arraydatum = matrixArrayDataCSV[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    arrayvaluta = matrixArrayDataCSV[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCSV[i][5], externalLogger));
                    if (matrixArrayDataCSV[i][6].equals("S")) {
                        Betrag *= -1.0;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataCSV[i][4]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (matrixArrayDataCSV[i][6].equals("H")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCSV[i][3])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayDataCSV[i][3].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!matrixArrayDataCSV[i][4].equals("EUR")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Urspr\u00fcngliche W\u00e4hrung: " + matrixArrayDataCSV[i][4]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Karte: " + matrixArrayDataCSV[i][2]);
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            for (i = 0; i < matrixArrayDataPDFs.length; ++i) {
                if (matrixArrayDataPDFs[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataPDFs[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "matrixArrayDataPDFs: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    checkColumn = matrixArrayDataPDFs[i][0].trim().split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    String[] CheckColumn2 = matrixArrayDataPDFs[i][1].trim().split("\\.");
                    float testnumber2 = Float.parseFloat(CheckColumn2[0]);
                    testnumber2 = Float.parseFloat(CheckColumn2[1]);
                    testnumber2 = Float.parseFloat(CheckColumn2[2]);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + "matrixArrayDataPDFs: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    arraydatum = matrixArrayDataPDFs[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    arrayvaluta = matrixArrayDataPDFs[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    int transIDX = i;
                    int betragIDX = 3;
                    if (matrixArrayDataPDFs[i].length == 3) {
                        if (i < matrixArrayDataPDFs.length - 1 && matrixArrayDataPDFs[i + 1].length == 2 && !matrixArrayDataPDFs[i + 1][0].contains("Alter Kontostand vom ") && !matrixArrayDataPDFs[i + 1][0].contains("Neuer Kontostand zum ")) {
                            transIDX = i + 1;
                            betragIDX = 1;
                        }
                    } else if (matrixArrayDataPDFs[i].length > 4) {
                        betragIDX = 6;
                    }
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataPDFs[transIDX][betragIDX], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    if (matrixArrayDataPDFs[i].length > 4) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayDataPDFs[i][3]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (!matrixArrayDataPDFs[i][betragIDX].contains("-")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataPDFs[i][2])) {
                        String purp = matrixArrayDataPDFs[i][2];
                        if (i < matrixArrayDataPDFs.length - 1 && matrixArrayDataPDFs[i + 1].length == 2 && !matrixArrayDataPDFs[i + 1][0].contains("Alter Kontostand vom ") && !matrixArrayDataPDFs[i + 1][0].contains("Neuer Kontostand zum ")) {
                            purp = purp + " " + matrixArrayDataPDFs[i + 1][0];
                        }
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (matrixArrayDataPDFs[i].length > 4 && !matrixArrayDataPDFs[i][3].equals("EUR")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Urspr\u00fcnglicher Betrag: " + matrixArrayDataPDFs[i][4] + " " + matrixArrayDataPDFs[i][3] + "\nzum Kurs: " + matrixArrayDataPDFs[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(kontonummer) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader(WebUtils.getShortName(kontonummer), kundennummer.substring(0, 4) + " **** **** " + kundennummer.substring(12, 16), amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

