/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.barclays;

import de.derrichter.finance.websync.utils.StringCharUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.html.HtmlPage;

public class WebUtils_Tg {
    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        boolean isSelfException = false;
        try {
            String errorResponse = null;
            String errorMessage = null;
            if (responseContentAsString.contains("all_errors_explained")) {
                errorResponse = ((HtmlPage)responsePage).asXml();
                errorMessage = WebUtils_Tg.formErrorMessage(errorResponse, externalLogger, externalProgressMonitor);
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Barclays Bank Ireland PLC Hamburg:\n\n\n" + errorMessage, "institutlogo-barclays.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("Zu Ihrer Sicherheit wurden Sie automatisch abgemeldet")) {
                isSelfException = true;
                throw new Exception("Die Sitzung wurde von der Bank beendet. Bitte melden Sie sich erneut an");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int errorTextIDXStart = 0;
            int errorTextIDXend = 0;
            errorTextIDXStart = contentStringToParse.indexOf("all_errors_explained");
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            errorTextIDXStart = contentStringToParse.indexOf("<li>", errorTextIDXStart) + 4;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "ErrorTextIDXStart: " + errorTextIDXStart);
            errorTextIDXend = contentStringToParse.indexOf("</li>", errorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "ErrorTextIDXend: " + errorTextIDXend);
            String ErrorText = contentStringToParse.substring(errorTextIDXStart, errorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            String formErrorText = ErrorText.replaceAll("<br/> ", "\n");
            formErrorText = ErrorText.replaceAll("<br/ > ", "\n");
            formErrorText = ErrorText.replaceAll("<br> ", "\n");
            formErrorText = ErrorText.replaceAll("\t", "");
            formErrorText = ErrorText.replaceAll("<BR>", "\n");
            formErrorText = ErrorText.replaceAll("  ", "\n");
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

