/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.barclays;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.openqa.selenium.WebDriver;

public class WebUtils_Kk {
    static String COOKIE_DETECT_PATH = "//div[@id='bcConsentOverlay' and not(contains(@style,'display: none;'))]";
    static String COOKIE_ACCEPT_PATH = "//button[@id='bcConsentAnnehmen']";
    static String LOADER_CATCHSTRING = "spinner-loading-overlay show";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[@class='spinner-loading-overlay show']";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils_Kk.xpathSearchString[0] = "(//div[contains(@class,'alert') and not(contains(@class,'alert-info')) and not(contains(@style,'display: none;'))])[1]";
        WebUtils_Kk.xpathSearchString[1] = "//*[contains(@id,'DynamicErrorMessage') and not(contains(@style,'display: none')) and not(contains(@style,'display:none'))]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils_Kk.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        String logIdent = "[WebSync:Barclays] ";
        String longName = "Barclays Bank Ireland PLC Hamburg";
        String errorMessage = null;
        if (responsePageAsString.contains("PIN \u00e4ndern")) {
            errorMessage = "Es ist notwendig, dass Sie Ihre Zugangs-PIN \u00e4ndern. \n\nBitte melden Sie sich im Online-Banking an und folgen dort den Anweisungen.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Barclays Bank Ireland PLC Hamburg:\n\n\n" + errorMessage, "institutlogo-barclaysvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (seleniumWebDriver.getCurrentUrl().contains("RequestPin.xhtml")) {
            errorMessage = "Sie haben Ihr/e PIN/Passwort vergessen und k\u00f6nnen sich nicht mehr im Banking anmelden? Geben Sie hier Ihren Anmeldenamen an und beantworten die Verifizierungsfragen.\n\nUnter der Website\nhttps://www.dkb.de/Welcome/content/RequestPin.xhtml\nk\u00f6nnen Sie ein neues Passwort anfordern.\n\nDurch das Absenden des Auftrags wird Ihr Zugang zum Banking sofort gesperrt und ein Start-Passwort zur einmaligen Anmeldung generiert.";
            DialogError.invoke((Object)DialogError, "Hinweis-Frage der Barclays Bank Ireland PLC Hamburg:\n\n\nPasswort vergessen\n\n" + errorMessage, "institutlogo-barclaysvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("Online-Sperre aufheben") || responsePageAsString.contains("PIN-Sperre aufheben")) {
            errorMessage = "Ihr Zugang zum Online-Banking ist gesperrt. \n\nF\u00fcr die Freischaltung melden Sie sich im Online-Banking an und folgen dort den Anweisungen.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Barclays Bank Ireland PLC Hamburg:\n\n\n" + errorMessage, "institutlogo-barclaysvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        if (responsePageAsString.contains("id=\"wartungsSeite\"") && responsePageAsString.contains("Geplante Wartungsarbeiten")) {
            errorMessage = "Geplante Wartungsarbeiten\n\nManchmal muss man auch in der digitalen Welt manuell Hand anlegen.\n\nDie Webseite steht aufgrund von Wartungsarbeiten aktuell nicht zur Verf\u00fcgung. Wir bitten um Ihr Verst\u00e4ndnis.";
            DialogError.invoke((Object)DialogError, "Fehlermeldung der Barclays Bank Ireland PLC Hamburg:\n\n\n" + errorMessage, "institutlogo-barclaysvisa.png");
            errorMessage = StringCharUtils.shrinkString(errorMessage);
            throw new Exception(errorMessage);
        }
        try {
            WebUtils_Kk.setSerchStrings();
            WebUtils_Kk.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-barclaysvisa.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }
}

