/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.barclays;

import de.derrichter.finance.websync.institute.barclays.WebUtils_Tg;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSpan;
import org.htmlunit.html.HtmlTable;
import org.htmlunit.html.HtmlTableRow;

public class WebPull_Tg {
    public static ArrayList getTransData(WebClient syncWebClient, String unterkontoArt, String fromDateSimple, String toDateSimple, HtmlPage postLoginPage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        try {
            String transData;
            HtmlButton searchSubmit;
            HtmlPage dataPage;
            String kontoart;
            String token;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Auslesen des aktuellen Token der Sitzung ...");
            try {
                if (!postLoginPage.asXml().contains("_toktok_=")) {
                    throw new Exception("Die aktuelle Seite enth\u00e4lt keinen Token der aktuellen Sitzung. Bitte nochmals versuchen oder den Entwickler im Forum informieren");
                }
                String postLoginResponse = postLoginPage.asXml();
                int tokenStart = postLoginResponse.indexOf("_toktok_=") + 9;
                int tokenEnde = postLoginResponse.indexOf(34, tokenStart);
                token = postLoginResponse.substring(tokenStart, tokenEnde);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "aktueller Token der Sitzung ist: " + token);
                unterkontoArt = unterkontoArt.toLowerCase();
                if (!unterkontoArt.equals("tagesgeld") && !unterkontoArt.equals("festgeld")) {
                    throw new Exception("Ihre Einstellungen im Feld Unterkonto sind nicht korrekt. Stellen Sie bitte 'Tagesgeld' oder 'Festgeld' ein");
                }
                kontoart = unterkontoArt;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Die abzurufende Kontoart ist: " + kontoart);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Abbruch: " + error.getMessage());
            }
            String getDataPageURL = "https://service.barclays.de/<kontoart>/index?_toktok_=".replace("<kontoart>", kontoart) + token;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "GET " + getDataPageURL);
            try {
                dataPage = (HtmlPage)syncWebClient.getPage(getDataPageURL);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "dataPage (Seite): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (dataPage == null) {
                throw new Exception("Die Umsatz\u00fcbersicht konnte nicht aufgerufen werden!");
            }
            String dataPageXML = dataPage.asXml();
            try {
                WebUtils_Tg.checkResponse(dataPageXML, (Page)dataPage, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!dataPageXML.contains("class=\"betrag\"")) {
                throw new Exception("Auf der Seite konnte kein 'Guthaben' gefunden werden. Falsche oder andere Seite");
            }
            String amountText = ((HtmlSpan)postLoginPage.getFirstByXPath("//span[@class='betrag']")).asNormalizedText();
            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "amountText: " + amountText);
            double amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Amount: " + amount);
            String formaction = "/" + kontoart + "/umsatz/";
            try {
                HtmlForm form = (HtmlForm)dataPage.getFirstByXPath("//form[@action='" + formaction + "']");
                String[] fromDateArray = fromDateSimple.split("\\.");
                String[] toDateArray = toDateSimple.split("\\.");
                form.getInputByName("uf[start_date]").setValue(fromDateArray[0] + "." + fromDateArray[1] + "." + fromDateArray[2]);
                form.getInputByName("uf[end_date]").setValue(toDateArray[0] + "." + toDateArray[1] + "." + toDateArray[2]);
                searchSubmit = (HtmlButton)dataPage.getFirstByXPath("//button[@class='btn btn-finder']");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Suchen-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                dataPage = (HtmlPage)searchSubmit.click();
                syncWebClient.waitForBackgroundJavaScript(10000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "DataPage (Suche): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (dataPage == null) {
                throw new Exception("Die Suche-Folgeseite konnte nicht aufgerufen werden!");
            }
            dataPageXML = dataPage.asXml();
            try {
                WebUtils_Tg.checkResponse(dataPageXML, (Page)dataPage, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            double notSaldo = 0.0;
            if (dataPageXML.contains("keine Ums\u00e4tze im gew\u00e4hlten Zeitraum")) {
                transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Barclays Bank Ireland PLC Hamburg\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nAnzahl der Transaktionen:;0\nKontostand:;" + amount + "\ndavon nicht abgerechnet:;0\n\nGebucht am;Wertstellung am;Verwendungszweck;Betrag (EUR)\nIm gew\u00e4hltem Abrufzeitraum sind keine Transaktionen vorhanden";
            } else {
                HtmlAnchor nextPage;
                int rowCount = 0;
                int transCount = 0;
                HtmlPage countDataPage = dataPage.cloneNode(true);
                boolean moreRadio = false;
                int loopCheck = 0;
                int pageCount = 1;
                int checkUmsatzZeilenHash = -1;
                do {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "############### ES WIRD DIE '" + pageCount + "' SEITE GEZ\u00c4HLT ###############");
                    ++loopCheck;
                    nextPage = null;
                    countDataPage.getEnclosingWindow().setEnclosedPage((Page)countDataPage);
                    int umsatzZeilenHash = ((HtmlTable)countDataPage.getFirstByXPath("//table[@id='umsaetze']")).getRows().hashCode();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "UmsatzZeilen-Liste und dessen Hash-Code von dieser Seite (UmsatzZeilenHash): " + umsatzZeilenHash);
                    int ZeilenCount = ((HtmlTable)countDataPage.getFirstByXPath("//table[@id='umsaetze']")).getRowCount() - 2;
                    rowCount += ZeilenCount;
                    if (checkUmsatzZeilenHash != umsatzZeilenHash) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] UmsatzZeilen und CheckUmsatzZeilen sind hier KOMMISCHERWEISE GLEICH ...");
                    } else {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] UmsatzZeilen und CheckUmsatzZeilen sind nun RICHTIG UNTERSCHIEDLICH ...");
                    }
                    if (ZeilenCount >= 10) {
                        moreRadio = false;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] Es sind zehn Umsatz-Zeilen auf dieser Seite vorhanden; Check ob es danach noch weiter geht ...");
                        nextPage = (HtmlAnchor)countDataPage.getFirstByXPath("//div[contains(.,'Weiter')]/child::a");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "getTransData; nextPage: " + nextPage);
                        if (nextPage != null) {
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] Es ist ein 'Seite vor'-Button vorhanden; Check ob dieser einen Verweis als Attribut hat");
                            String nextButtonValue = nextPage.getHrefAttribute();
                            if (!StringCharUtils.isNullOrEmptyOrNothing(nextButtonValue) && checkUmsatzZeilenHash != umsatzZeilenHash) {
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "getTransData; nextButtonValue: " + nextButtonValue);
                                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] aktueller 'Weiter'-Button hat einen Verweis als Attribute und neue UmsatzZeilen sind auf der Seite vorhanden; demnach pr\u00fcfen ob noch mehr Transaktionen vorhanden ...");
                                moreRadio = true;
                                checkUmsatzZeilenHash = umsatzZeilenHash;
                                if (checkUmsatzZeilenHash == umsatzZeilenHash) {
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] UmsatzZeilen und CheckUmsatzZeilen sind nach Angleich RICHTIG GLEICH ...");
                                } else {
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] UmsatzZeilen und CheckUmsatzZeilen sind nach Angleich KOMISCHERWEISE UNTERSCHIEDLICH ...");
                                }
                            } else {
                                moreRadio = false;
                            }
                        } else {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] Weiter-Button hat keinen HREF also keine weitere Seite vorhanden");
                        }
                    } else {
                        moreRadio = false;
                    }
                    countDataPage = null;
                    if (!moreRadio) continue;
                    countDataPage = (HtmlPage)nextPage.click();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "getTransData; Next countDataPage: " + countDataPage);
                    countDataPage.getEnclosingWindow().setEnclosedPage((Page)countDataPage);
                    int PreCheckUmsatzZeilenHash = ((HtmlTable)countDataPage.getFirstByXPath("//table[@id='umsaetze']")).getRows().hashCode();
                    if (checkUmsatzZeilenHash == PreCheckUmsatzZeilenHash) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] UmsatzZeilen auf der n\u00e4chsten Seite sind GLEICH also keine Transaktionen mehr vorhanden...");
                    } else {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] UmsatzZeilen auf der n\u00e4chsten Seite sind UNTERSCHIEDLICH also weitere Transaktionen...");
                        ++pageCount;
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Es gibt somit nun soviele Seiten: " + pageCount);
                } while (loopCheck != 200 && moreRadio);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "getTransData; Anzahl aller Umsatz-Zeilen: " + rowCount + "  (Sollte Anzahl Transaktionen entsprechen)");
                transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Barclays Bank Ireland PLC Hamburg\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nAnzahl der Transaktionen:;<insertTransCount>\nKontostand:;" + amount + "\ndavon nicht abgerechnet:;<insertNotSaldo>\n\nGebucht am;Wertstellung am;Verwendungszweck;Betrag (EUR)\n";
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Transaktionsdaten aus der Homepage exportieren ...");
                try {
                    loopCheck = 0;
                    int rowCountLoop = 0;
                    int runCount = 0;
                    HtmlPage getDataPage = dataPage.cloneNode(true);
                    getDataPage.getEnclosingWindow().setEnclosedPage((Page)getDataPage);
                    do {
                        String dataXML = getDataPage.asXml();
                        ++loopCheck;
                        ++runCount;
                        HtmlTable umsatzTabelle = (HtmlTable)getDataPage.getFirstByXPath("//table[@id='umsaetze']");
                        List umsatzZeilen = ((HtmlTable)getDataPage.getFirstByXPath("//table[@id='umsaetze']")).getRows();
                        int valutaStart = dataXML.lastIndexOf("Betrag");
                        int dataCount = umsatzZeilen.size();
                        LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "alle '" + (dataCount - 2) + "' UmsatzZeilen dieser Seite:\n" + umsatzTabelle.asNormalizedText());
                        transCount += dataCount - 2;
                        for (int i = 1; i < dataCount - 1; ++i) {
                            String stateData;
                            double monitorPercent = 30.0 + 29.0 / (double)rowCount * (double)(rowCountLoop + 1);
                            MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)monitorPercent);
                            ++rowCountLoop;
                            String buchungsDataText = ((HtmlTableRow)umsatzZeilen.get(i)).getCell(0).asNormalizedText();
                            String buchungsData = StringCharUtils.shrinkString(buchungsDataText).replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\\s+", "");
                            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "BuchungsData: " + buchungsData);
                            String valutaDataText = ((HtmlTableRow)umsatzZeilen.get(i)).getCell(1).asNormalizedText();
                            String valutaData = StringCharUtils.shrinkString(valutaDataText).replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\\s+", "");
                            String purpDataText = ((HtmlTableRow)umsatzZeilen.get(i)).getCell(2).asNormalizedText().replaceAll("\\u00dcberweisung", "");
                            String purpData = StringCharUtils.shrinkString(purpDataText);
                            String saldoDataText = ((HtmlTableRow)umsatzZeilen.get(i)).getCell(3).asNormalizedText();
                            String saldoData = StringCharUtils.shrinkString(saldoDataText).replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\\s+", "");
                            if (StringCharUtils.isNullOrEmptyOrNothing(buchungsData)) {
                                stateData = "ungebucht";
                                notSaldo += Double.parseDouble(StringCharUtils.shrinkString(saldoData).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim()) * -1.0;
                            } else {
                                stateData = "abgerechnet";
                            }
                            transData = transData + buchungsData + ";" + valutaData + ";" + purpData + ";" + saldoData + ";" + stateData + "\n";
                        }
                        if (pageCount <= runCount) continue;
                        getDataPage.getEnclosingWindow().setEnclosedPage((Page)getDataPage);
                        nextPage = getDataPage.getAnchorByText(String.valueOf(runCount + 1));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "getTransData; nextPage: " + nextPage);
                        getDataPage = (HtmlPage)nextPage.click();
                    } while (loopCheck != 200 && runCount < pageCount);
                    transData = transData.replace("<insertNotSaldo>", String.valueOf(notSaldo));
                    transData = transData.replace("<insertTransCount>", String.valueOf(transCount));
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Die Transaktionsdaten konnten nicht ohne Fehler ausgelesen werden (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            if (transData == null) {
                throw new Exception("Der Kontoauszug konnte nicht erstellt werden! (TransData=NULL)");
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            if (transData.contains("<html") || transData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][3], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (String.valueOf(betrag).indexOf("-") == -1) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Einzahlung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("\u00dcberweisung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][2])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][2]));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    if (String.valueOf(betrag).indexOf("-") != -1) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Referenzkonto");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(new String())) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][1].replaceAll("Reference: ", ""));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Barclays", unterkontoArt, amount, amount, notSaldo, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

