/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.barclays;

import de.derrichter.finance.websync.institute.barclays.WebUtils_Kk;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull_Kk {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(20L));
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        WebDriverWait wait5 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(5L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        String formatedKontonummer = StringCharUtils.banknumAddSpacesLikeIBAN(kontonummer);
        try {
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils_Kk.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "checkAccountNr (formated): " + formatedKontonummer);
            try {
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//*[contains(.,'" + formatedKontonummer + "')]"))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Barclays] ", "Barclays Bank Ireland PLC Hamburg", "institutlogo-barclaysvisa.png", WebUtils_Kk.COOKIE_DETECT_PATH, WebUtils_Kk.COOKIE_ACCEPT_PATH, WebUtils_Kk.LOADER_CATCHSTRING, WebUtils_Kk.LOADER_EXCLUSIONS, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Check ob der Karten-Tab gewechselt werden muss...");
            String cardBoxPath = "//*[@id='IBANTitleLabel']//label[contains(.,'" + formatedKontonummer + "')]//ancestor::*[contains(@class,'single-product-container') or contains(@id,'tabModel')]";
            String tabID = "";
            boolean tabIsActive = true;
            try {
                tabID = seleniumWebDriver.findElement(By.xpath((String)cardBoxPath)).getAttribute("tab-id");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "current tabID: " + tabID);
                String tabClass = seleniumWebDriver.findElement(By.xpath((String)cardBoxPath)).getAttribute("class");
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "current tabClass: " + tabClass);
                if (!tabClass.contains("active")) {
                    tabIsActive = false;
                }
            }
            catch (NoSuchElementException | TimeoutException noTab) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "keine Tab-ID gefunden, ist wohl Single-Container: " + noTab.getMessage());
            }
            try {
                if (!StringCharUtils.isNullOrEmptyOrNothing(tabID) && !tabIsActive) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Angefragter Tab nicht aktiv, es wird gewechselt...");
                    String tabXpath = "//button[@aria-controls='" + tabID + "']";
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)tabXpath)));
                    seleniumWebDriver.findElement(By.xpath((String)tabXpath)).click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
            }
            catch (Exception tabChange) {
                isSelfException = true;
                throw new Exception("Tab-Wechsel fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)tabChange));
            }
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            try {
                String amountText = seleniumWebDriver.findElement(By.xpath((String)("(" + cardBoxPath + "//vc-amount-label//label)[1]"))).getText();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Kartensaldo' fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                String availableAmountText = seleniumWebDriver.findElement(By.xpath((String)("(" + cardBoxPath + "//vc-amount-label//label)[2]"))).getText();
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "availableAmountText: " + availableAmountText);
                availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String transPagePath = cardBoxPath + "//a[@id='TransactionOverviewMenuLabel-btn-box']";
            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transPagePath: " + transPagePath);
            try {
                boolean linkPresent = true;
                int round = 1;
                do {
                    WebElement transPageLink = seleniumWebDriver.findElement(By.xpath((String)transPagePath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "transPageLink: " + transPageLink);
                    try {
                        try {
                            JavascriptExecutor jsExecutor = (JavascriptExecutor)seleniumWebDriver;
                            jsExecutor.executeScript("window.scrollTo(document.body.scrollHeight,1920)", new Object[0]);
                            jsExecutor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{transPageLink});
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transPagePath)));
                        SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, transPagePath);
                        transPageLink.click();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        Thread.sleep(2000L);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        seleniumWebDriver.findElement(By.xpath((String)transPagePath));
                        ++round;
                    }
                    catch (Exception error) {
                        linkPresent = false;
                    }
                    if (round <= 15) continue;
                    isSelfException = true;
                    throw new Exception("Die Umsatzseite konnte auch nach 15 Versuchen nicht aufgerufen werden. Informieren Sie bitte den Entwickler im Forum");
                } while (linkPresent);
                pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils_Kk.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            catch (NoSuchElementException | TimeoutException openTransPage) {
                isSelfException = true;
                throw new Exception("Link von Umsatz\u00fcbersicht kann nicht gefunden werden. Vermutlich unbekannte Meldung auf der Homepage. Bitte im Online-Banking pr\u00fcfen, ansonsten im Forum melden.\n" + ExceptionUtils.getStackTrace((Throwable)openTransPage));
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Barclays] ", "Barclays Bank Ireland PLC Hamburg", "institutlogo-barclaysvisa.png", WebUtils_Kk.COOKIE_DETECT_PATH, WebUtils_Kk.COOKIE_ACCEPT_PATH, WebUtils_Kk.LOADER_CATCHSTRING, WebUtils_Kk.LOADER_EXCLUSIONS, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, externalLogger);
            String tanArt = "mobileTAN";
            String detectTANformPath = "//vc-otp-box[@id='TransactionViewOTP']";
            String secTextPath = "//vc-label[@vb-id='CheckOTPInstruction' or @vb-id='SmsSentLabel'or @vb-id='MobileNumberLabel' or @id='CheckOTPInstruction' or @id='SmsSentLabel'or @id='MobileNumberLabel']";
            String tanInputPath = "//input[@id='OTPPassword-Full-field']";
            String submitTanPath = "//vc-button-group[@id='OtpModalButtonGroup']//button[@id='btn-NextButton']";
            boolean retryInput = false;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait5.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
                LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                MonitorLog.invoke((Object)MonitorLog, tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                do {
                    String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")[1]"))).getText().trim();
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-barclaysvisa.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:Barclays] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    try {
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)submitTanPath)));
                        seleniumWebDriver.findElement(By.xpath((String)submitTanPath)).click();
                        SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    Thread.sleep(1000L);
                    String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils_Kk.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    try {
                        wait5.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        retryInput = true;
                    }
                    catch (TimeoutException noSecondSec) {
                        retryInput = false;
                    }
                } while (retryInput);
            }
            catch (TimeoutException noSecondSec) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
            }
            String selectPath = "//select[contains(@id,'DateRangeSelector')]";
            String selectOptionPath = "(//select[contains(@id,'DateRangeSelector')]//option[contains(.,'Zeitraum') or contains(.,'Select Date Range')])[last()]";
            wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)selectPath)));
            Select periodSelect = new Select(seleniumWebDriver.findElement(By.xpath((String)selectPath)));
            JavascriptExecutor jsExecutor = (JavascriptExecutor)seleniumWebDriver;
            WebElement selectOption = seleniumWebDriver.findElement(By.xpath((String)selectOptionPath));
            String selectOptionText = selectOption.getText().trim();
            jsExecutor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{selectOption});
            periodSelect.selectByVisibleText(selectOptionText);
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, true, externalLogger);
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Barclays] ", "Barclays Bank Ireland PLC Hamburg", "institutlogo-barclaysvisa.png", WebUtils_Kk.COOKIE_DETECT_PATH, WebUtils_Kk.COOKIE_ACCEPT_PATH, WebUtils_Kk.LOADER_CATCHSTRING, WebUtils_Kk.LOADER_EXCLUSIONS, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, externalLogger);
            String dateNowSimple = null;
            if (!StringCharUtils.isNullOrEmptyOrNothing(toDateSimple)) {
                dateNowSimple = toDateSimple;
            } else {
                toDateSimple = dateNowSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
            }
            try {
                String fromInputPath = "//input[contains(@id,'StartDate')]";
                String toInputPath = "//input[contains(@id,'EndDate')]";
                String filterButtonPath = "//button[@id='btn-NextButton']";
                seleniumWebDriver = SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, getLogMethod, "Barclays Bank Ireland PLC Hamburg", "institutlogo-barclaysvisa.png", fromDateSimple, toDateSimple, fromInputPath, toInputPath, filterButtonPath, false, WebUtils_Kk.LOADER_CATCHSTRING, WebUtils_Kk.LOADER_EXCLUSIONS, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception searchError) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)searchError));
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils_Kk.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait5.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
                LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                MonitorLog.invoke((Object)MonitorLog, tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                try {
                    String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")[1]"))).getText().trim();
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-barclaysvisa.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:Barclays] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                }
                catch (Exception tanInputError) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler (Tan-Eingabe): " + ExceptionUtils.getStackTrace((Throwable)tanInputError));
                }
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)submitTanPath)));
                    seleniumWebDriver.findElement(By.xpath((String)submitTanPath)).click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils_Kk.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            catch (NoSuchElementException | TimeoutException noSecondSec) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der Barclays Bank Ireland PLC Hamburg\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\nVerf\u00fcgbarer Betrag:;" + availableAmount + "\n";
            boolean haveNewTrans = false;
            try {
                String notFoundStringPath = "//label[contains(.,'Leider keine Treffer') or contains(.,'No results found')]";
                wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)notFoundStringPath)));
                if (seleniumWebDriver.findElement(By.xpath((String)notFoundStringPath)) == null) {
                    throw new Exception("wait error");
                }
                transData = transData + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] xpath //label[contains(.,'Leider keine Treffer') or contains(.,'No results found')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
            }
            File downloadedFile = null;
            String doctext = null;
            String doctype = "";
            boolean localTest = false;
            if (localTest) {
                haveNewTrans = true;
                String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.xlsx";
                downloadedFile = new File(docFixTempFilePath);
            }
            if (haveNewTrans || localTest) {
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest) {
                        String downloadDocumentPath = "//button[@aria-label='Export document']";
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadDocumentPath)));
                        WebElement downloadDocument = seleniumWebDriver.findElement(By.xpath((String)downloadDocumentPath));
                        JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                        jse.executeScript("scroll(0, 0);", new Object[0]);
                        try {
                            downloadDocument.click();
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        Thread.sleep(2000L);
                        String downloadButtonPath = "//button[@id='btn-btnExcel']";
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadButtonPath)));
                        Thread.sleep(2000L);
                        WebElement downloadButton = seleniumWebDriver.findElement(By.xpath((String)downloadButtonPath));
                        jse = (JavascriptExecutor)seleniumWebDriver;
                        jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{downloadButton});
                        try {
                            downloadButton.click();
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download eines Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    doctype = downloadedFile.getAbsolutePath().substring(downloadedFile.getAbsolutePath().lastIndexOf(".") + 1).toUpperCase();
                    if (doctype.toLowerCase().equals("txt") || doctype.toLowerCase().equals("htm") || doctype.toLowerCase().equals("html") || doctype.toLowerCase().equals("asp") || doctype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                } while (downloadedFileIsFalse);
                FileInputStream fis = new FileInputStream(downloadedFile);
                XSSFWorkbook workbook = new XSSFWorkbook((InputStream)fis);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "[workbook " + doctype + "-FILE]: " + workbook);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Erzeuge einen Kontoauszug aus dem " + doctype + "-Dokument ...");
                try {
                    XSSFSheet sheet = workbook.getSheetAt(0);
                    for (Row row : sheet) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell = (Cell)cellIterator.next();
                            doctext = doctext + cell.toString() + ";";
                        }
                        doctext = doctext + "\n";
                    }
                    workbook.close();
                    fis.close();
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + doctype + "-Rechnung (text): \n" + doctext);
                if (!localTest) {
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                transData = doctext;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transData: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            String[] dataResponse = new String[]{doctext, Double.toString(amount)};
            String[][] matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Auslesen des " + doctype + "-Kontoauszugs im Zeitraum ...");
            int unbookedTransCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                try {
                    if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) continue;
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                    String[] checkColumn = matrixArrayData[i][1].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + e.toString());
                    continue;
                }
                if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][6]) && matrixArrayData[i][6].toLowerCase().contains("vorgemerkt")) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] Umsatzzeile beinhaltet einen 'vorgemerkten' Umsatz und wird ausgelassen!");
                    ++unbookedTransCount;
                    continue;
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                try {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "Zeile der " + doctype + "-Konto\u00fcbersicht die nun verarbeitet wird: " + Arrays.toString(matrixArrayData[i]));
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][1].split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = !StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][2]) ? matrixArrayData[i][2].split("\\.") : matrixArrayData[i][1].split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    Double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][3].replaceAll("-", ""), externalLogger));
                    if (!StringCharUtils.shrinkString(matrixArrayData[i][3]).contains("+")) {
                        betrag = betrag * -1.0;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][4]));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    String kommentarText = "";
                    String originalAmount = StringCharUtils.shrinkString(matrixArrayData[i][8]);
                    String land = StringCharUtils.shrinkString(matrixArrayData[i][10]);
                    String cardOwner = StringCharUtils.shrinkString(matrixArrayData[i][11]);
                    String cardNumber = StringCharUtils.shrinkString(matrixArrayData[i][7]);
                    String cardType = StringCharUtils.shrinkString(matrixArrayData[i][12]);
                    String payType = StringCharUtils.shrinkString(matrixArrayData[i][13]);
                    if (!StringCharUtils.isNullOrEmptyOrNothing(originalAmount) && !originalAmount.contains("\u20ac")) {
                        kommentarText = "Originalbetrag: " + originalAmount;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(land)) {
                            kommentarText = kommentarText + " (Land: " + land + ")";
                        }
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(cardOwner)) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + "Karteninhaber(in): " + cardOwner;
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(cardNumber)) {
                        kommentarText = !StringCharUtils.isNullOrEmptyOrNothing(originalAmount) && StringCharUtils.isNullOrEmptyOrNothing(cardOwner) ? kommentarText + "\n\n" : kommentarText + "\n";
                        kommentarText = kommentarText + "Kartennummer: " + cardNumber;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(cardType)) {
                            kommentarText = kommentarText + " (" + cardType + ")";
                        }
                    }
                    if (!StringCharUtils.isNullOrEmptyOrNothing(payType) && String.valueOf(betrag).contains("-")) {
                        if (!StringCharUtils.isNullOrEmptyOrNothing(kommentarText)) {
                            kommentarText = kommentarText + "\n\n";
                        }
                        kommentarText = kommentarText + "Kontaktlose Bezahlung: " + payType;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentarText);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][0]));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Anzahl an ungebuchten Transaktionen die nicht \u00fcbernommen wurden: " + unbookedTransCount);
            if (unbookedTransCount == 1) {
                MonitorLog.invoke((Object)MonitorLog, "Info: Es wurde 'eine' vorgemerkte Transaktion (noch) nicht in den Kontoauszug \u00fcbernommen");
            } else if (unbookedTransCount > 1) {
                MonitorLog.invoke((Object)MonitorLog, "Info: Es wurden '" + unbookedTransCount + "' vorgemerkte Transaktionen (noch) nicht in den Kontoauszug \u00fcbernommen");
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "needTransPurpFusion", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("Barclays", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(formatedKontonummer, "**** **** **"));
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error).replace(formatedKontonummer, "**** **** **"));
        }
    }
}

