/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.barclays;

import de.derrichter.finance.websync.institute.barclays.WebUtils_Tg;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;

public class WebAuth_Tg {
    public static HtmlPage loginWithHTMLUnit(String responseLogin, String responsePassword, WebClient syncWebClient, String optionalOptions, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogWarn = ExternalLogger.getMethod("warn", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        Method MonitorLog = ExternalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = ExternalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        HtmlPage pageLogin = null;
        HtmlButton submitLogin = null;
        HtmlPage postLoginPage = null;
        String pageLoginXML = null;
        String postLoginXML = null;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "BarclaysBank-Login aufrufen ... (GET " + "https://service.barclays.de/" + ")");
            try {
                pageLogin = (HtmlPage)syncWebClient.getPage("https://service.barclays.de/");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "pageLogin: " + pageLogin);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (pageLogin == null) {
                throw new Exception("Die Login-Seite konnte nicht aufgerufen werden!");
            }
            pageLoginXML = pageLogin.asXml();
            try {
                WebUtils_Tg.checkResponse(pageLoginXML, (Page)pageLogin, ExternalLogger, ExternalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                HtmlForm formLogin = (HtmlForm)pageLogin.getFirstByXPath("//form[@action='/']");
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "formLogin: " + formLogin);
                formLogin.getInputByName("login[b_usr]").setValue(responseLogin);
                formLogin.getInputByName("login[b_pwd]").setValue(responsePassword);
                submitLogin = (HtmlButton)pageLogin.getFirstByXPath("//button[@type='Submit']");
            }
            catch (Exception error) {
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Login-Form wird abgesendet ...");
            try {
                postLoginPage = (HtmlPage)submitLogin.click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "postLoginPage: " + postLoginPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (postLoginPage == null) {
                throw new Exception("Die Login-Folgeseite konnte nicht aufgerufen werden!");
            }
            postLoginXML = postLoginPage.asXml();
            try {
                WebUtils_Tg.checkResponse(postLoginXML, (Page)postLoginPage, ExternalLogger, ExternalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                if (error.getMessage().equals("BarclaysBankAccountUnlocked")) {
                    return null;
                }
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (postLoginXML.contains("name=\"login[b_usr]\"") && postLoginXML.contains("name=\"login[b_pwd]\"")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return postLoginPage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logout(WebClient syncWebClient, String optionalOptions, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogWarn = ExternalLogger.getMethod("warn", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        boolean isHtmlPage = false;
        try {
            List webWindowArray = syncWebClient.getWebWindows();
            for (int a = 0; a < webWindowArray.size(); ++a) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "offenes Web-Fenster #" + a + ": " + webWindowArray.get(a));
            }
            Page currentPage = ((WebWindow)syncWebClient.getWebWindows().get(0)).getTopWindow().getEnclosedPage();
            if (currentPage.isHtmlPage()) {
                isHtmlPage = true;
            } else {
                int Versuche = 0;
                do {
                    if (Versuche == 0) {
                        LogWarn.invoke((Object)LogWarn, "[WebSync:Barclays] " + getLogMethod + "Aktuell geladene Seite ist keine HtmlPage sondern '" + currentPage.toString() + "'; Versuche Back-Sprung ...");
                    }
                    ((WebWindow)syncWebClient.getWebWindows().get(0)).getHistory().back();
                    syncWebClient.waitForBackgroundJavaScript(5000L);
                    currentPage = syncWebClient.getCurrentWindow().getTopWindow().getEnclosedPage();
                    if (currentPage.isHtmlPage()) {
                        isHtmlPage = true;
                        continue;
                    }
                    LogWarn.invoke((Object)LogWarn, "[WebSync:Barclays] " + getLogMethod + "... hat wohl nicht funktioniert/gereicht; probiere es nochmals ...");
                } while (++Versuche < 2 && !isHtmlPage);
            }
            if (!isHtmlPage) {
                throw new Exception("Seite ist keine HtmlPage sondern (immer noch?) eine '" + currentPage.toString() + "; kann daher nicht verarbeitet werden");
            }
            HtmlPage logoutPage = (HtmlPage)currentPage;
            HtmlElement logoutButton = null;
            HtmlPage postLogoutPage = null;
            String postLogoutPageXML = null;
            logoutButton = (HtmlElement)logoutPage.getFirstByXPath("//input[@value='abmelden']");
            if (logoutButton == null) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "logoutPageXML: \n" + logoutPage.asXml());
                throw new Exception("Button 'Abmelden' in der linken Navigation nicht gefunden! Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.!");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Click Button: " + logoutButton);
            try {
                postLogoutPage = (HtmlPage)logoutButton.click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "PostLogoutPage: " + postLogoutPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            postLogoutPageXML = postLogoutPage.asXml();
            try {
                WebUtils_Tg.checkResponse(postLogoutPageXML, (Page)postLogoutPage, ExternalLogger, ExternalProgressMonitor, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!postLogoutPageXML.contains("Sie haben sich aus dem Online-Banking-Bereich ausgeloggt")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Logout bei der '" + "Barclays Bank Ireland PLC Hamburg" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Barclays] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

