/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.barclays;

import de.derrichter.finance.websync.institute.barclays.WebUtils_Kk;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth_Kk {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Barclays" + "-Login aufrufen ... (GET " + "https://banking.barclaycard.de" + ")");
            try {
                seleniumWebDriver.get("https://banking.barclaycard.de");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            int waiter = 0;
            do {
                try {
                    wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)WebUtils_Kk.LOADER_PATH)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Warte das Laden der Loginseite ab ...");
                    waiter = 0;
                }
                catch (NoSuchElementException | TimeoutException notLoading) {
                    ++waiter;
                    Thread.sleep(1000L);
                }
            } while (waiter >= 2);
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils_Kk.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"UserName-field")));
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:Barclays] ", "Barclays Bank Ireland PLC Hamburg", "institutlogo-barclaysvisa.png", WebUtils_Kk.COOKIE_DETECT_PATH, WebUtils_Kk.COOKIE_ACCEPT_PATH, WebUtils_Kk.LOADER_CATCHSTRING, WebUtils_Kk.LOADER_EXCLUSIONS, WebUtils_Kk.LOADER_PATH, WebUtils_Kk.LOADER_TEXT, externalLogger);
            JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
            jse.executeScript("location.reload(true);", new Object[0]);
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"UserName-field")));
            try {
                WebElement inputUsername = seleniumWebDriver.findElement(By.id((String)"UserName-field"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "inputUsername: " + inputUsername);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.id((String)"Password-field"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "inputPassword: " + inputPasswd);
                inputUsername.sendKeys(new CharSequence[]{responseLogin});
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                seleniumWebDriver.findElement(By.id((String)"btn-NextButton")).click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(2000L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils_Kk.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String tanArt = "mobileTAN";
            String detectTANformPath = "//vc-main-container[@id='OTPContentContainer']";
            String secTextPath = "//vc-label[@vb-id='CheckOTPInstruction' or @vb-id='SmsSentLabel'or @vb-id='MobileNumberLabel' or @id='CheckOTPInstruction' or @id='SmsSentLabel'or @id='MobileNumberLabel']";
            String tanInputPath = "//input[@id='OTPPassword-Full-field']";
            String submitTanPath = "//button[@id='btn-NextButton']";
            boolean retryInput = false;
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                do {
                    String secText = seleniumWebDriver.findElement(By.xpath((String)("(" + secTextPath + ")[1]"))).getText().trim();
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-barclaysvisa.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:Barclays] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    WebElement submitTan = seleniumWebDriver.findElement(By.xpath((String)submitTanPath));
                    jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{submitTan});
                    try {
                        submitTan.click();
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    Thread.sleep(1000L);
                    String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils_Kk.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    try {
                        wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        retryInput = true;
                    }
                    catch (TimeoutException noSecondSec) {
                        retryInput = false;
                    }
                } while (retryInput);
            }
            catch (TimeoutException noSecondSec) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//input[@id='UserName-field' or @id='Password-field']"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:Barclays] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(7L));
        try {
            try {
                seleniumWebDriver.findElement(By.xpath((String)"(//button[@id='btn-LogoutButtonText'])[1]")).click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Abmelden best\u00e4tigen durch JA klicken ... ");
            try {
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(2000L);
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"button[id=btn-NextButton][aria-label=Ja]")));
                    seleniumWebDriver.findElement(By.cssSelector((String)"button[id=btn-NextButton][aria-label=Ja]")).click();
                }
                catch (NoSuchElementException isEng) {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"button[id=btn-NextButton][aria-label=Yes]")));
                    seleniumWebDriver.findElement(By.cssSelector((String)"button[id=btn-NextButton][aria-label=Yes]")).click();
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils_Kk.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//*[contains(.,'Sie haben sich ausgeloggt') or contains(.,'Sie haben sich erfolgreich ausgeloggt') or contains(.,'You have successfully logged out')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Barclays] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:Barclays] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:Barclays] " + getLogMethod + "Logout bei der '" + "Barclays Bank Ireland PLC Hamburg" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:Barclays] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

