/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.bankofscotland;

import de.derrichter.finance.websync.institute.bankofscotland.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:BankOfScotland] " + getLogMethod + "BankOfScotland" + "-Login aufrufen ... (GET " + "https://banking.bankofscotland.de/eBankingClient/pages/login/login.jsf#login" + ")");
            try {
                seleniumWebDriver.get("https://banking.bankofscotland.de/eBankingClient/pages/login/login.jsf#login");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"contentForm:Benutzerkennung")));
                WebElement inputUser = seleniumWebDriver.findElement(By.id((String)"contentForm:Benutzerkennung"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "inputUser: " + inputUser);
                inputUser.sendKeys(new CharSequence[]{responseLogin});
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Feld inputUser (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//a[contains(@class,'btn-submit')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            Thread.sleep(2000L);
            String pageLogin2Response = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLogin2Response, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(.,'dass nur Sie Ihren neuen Benutzernamen erhalten')]"));
                isSelfException = true;
                throw new Exception("Bitte identifizieren Sie sich manuell im Online-Banking per mTAN und erstellen zuerst Ihren neuen Benutzernamen. So stellen wir sicher, dass nur Sie Ihren neuen Benutzernamen erhalten.");
            }
            catch (NoSuchElementException | TimeoutException checkLoginField) {
                try {
                    WebElement checkLoginField2 = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(.,'Der von Ihnen eingegebene Benutzername ist leider nicht mehr g')]"));
                    String formErrorText = "Der von Ihnen eingegebene Benutzername ist leider nicht mehr g\u00fcltig. Sie haben Ihren neuen Benutzernamen beim 1. Login per SMS erhalten.";
                    DialogWarn.invoke((Object)DialogWarn, "Meldung der Bank of Scotland:\n\n\n" + formErrorText, "institutlogo-bankofscotland.png");
                    isSelfException = true;
                    throw new Exception(formErrorText);
                }
                catch (NoSuchElementException | TimeoutException checkLoginField2) {
                    try {
                        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"contentForm:password")));
                        WebElement inputPasswort = seleniumWebDriver.findElement(By.id((String)"contentForm:password"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "inputPasswort: " + inputPasswort);
                        inputPasswort.sendKeys(new CharSequence[]{responsePassword});
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("Fehler beim Setzen des Login-Feld inputPasswort (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//a[contains(@class,'btn-submit')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    Thread.sleep(2000L);
                    pageLogin2Response = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageLogin2Response, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                    try {
                        WebElement checkLoginField3 = seleniumWebDriver.findElement(By.xpath((String)"//div[contains(.,'Ihr Zugang ist gesperrt')]"));
                        isSelfException = true;
                        throw new Exception("Wir haben Ihren Zugang aufgrund von drei Passwort bzw. mTAN Eingaben gesperrt. Entsperren Sie Ihren Zugang jetzt online.");
                    }
                    catch (NoSuchElementException | TimeoutException checkLoginField3) {
                        seleniumWebDriver = WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalDialogInterface, externalProgressMonitor);
                        try {
                            WebElement checkLoginField4 = seleniumWebDriver.findElement(By.xpath((String)"//form[@action='/eBankingClient/pages/login/login.jsf']"));
                            isSelfException = true;
                            throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
                        }
                        catch (NoSuchElementException | TimeoutException throwable) {
                            return seleniumWebDriver;
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:BankOfScotland] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static String loginQuestionGetWithSelenium(WebDriver seleniumWebDriver, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLoginQuestionGet] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "Login-Pagetitle Phase #2: " + seleniumWebDriver.getTitle());
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)"frmmain")));
            if (seleniumWebDriver.getTitle().equals("Security Question") || seleniumWebDriver.getPageSource().contains("Bitte beantworten Sie die folgende Sicherheitsfrage")) {
                WebElement htmlTableDataInput;
                LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "Seite 'Sicherheitsfrage' (Titel 'Security Question' oder Frage-Text) scheinbar erhalten");
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)"fldquestion1")));
                    htmlTableDataInput = seleniumWebDriver.findElement(By.name((String)"fldquestion1"));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "htmlTableDataInput: " + htmlTableDataInput);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen des Inputs der Sicherheitsfrage (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (htmlTableDataInput != null) {
                    String formtextQuestion;
                    try {
                        formtextQuestion = htmlTableDataInput.getAttribute("value");
                        LogTrace.invoke((Object)LogTrace, "[WebSync:BankOfScotland] " + getLogMethod + "formtextQuestion: " + formtextQuestion);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("Fehler beim Lesen der Sicherheitsfrage (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    return formtextQuestion;
                }
                isSelfException = true;
                throw new Exception("Kein Auslesen der Sicherheitsfrage m\u00f6glich");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:BankOfScotland] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static WebDriver loginQuestionSetWithSelenium(String ResponseAnswer, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLoginQuestionSet] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            WebElement submitSecAnswer;
            try {
                WebElement inputSecAnswer = seleniumWebDriver.findElement(By.id((String)"answer"));
                inputSecAnswer.sendKeys(new CharSequence[]{ResponseAnswer});
                Thread.sleep(1000L);
            }
            catch (Exception error) {
                throw new Exception("Fehler beim setzen der Sicherheitsfrage im Feld (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                submitSecAnswer = seleniumWebDriver.findElement(By.name((String)"fldGO"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "submitSecAnswer: " + submitSecAnswer);
            }
            catch (Exception error) {
                throw new Exception("Fehler beim Setzen des Formulars f\u00fcr Sicherheitsabfrage oder des Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "click the submit-answer button ...");
                submitSecAnswer.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(3000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "page after secquestion: current webdriver hash: " + seleniumWebDriver.hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                seleniumWebDriver.switchTo().defaultContent();
                wait.until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)"frame_txn"));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogTrace.invoke((Object)LogTrace, "[WebSync:BankOfScotland] " + getLogMethod + "frameToBeAvailableAndSwitchToIt(\"frame_txn\") war erfolgreich und somit wurde zum Frame gewechselt");
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:BankOfScotland] " + getLogMethod + "frameToBeAvailableAndSwitchToIt(\"frame_txn\") hatte kein Ergebnis!");
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)"frmmain")));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:BankOfScotland] " + getLogMethod + "findElement(By.name(\"frmmain\") hatte kein Ergebnis!");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "after login phase#2: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            String pageContentResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageContentResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            if (pageContentResponse.contains("name=\"frame_txn\" id=\"frame_txn\" src=\"ENVLogin.jsp\"") || pageContentResponse.contains("Bitte beantworten Sie die folgende Sicherheitsfrage")) {
                isSelfException = true;
                throw new Exception("Die Security-Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:BankOfScotland] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage());
        }
    }

    public static String loginSessionID(WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLoginSessionID] ";
        LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "getSessionID: SessionMessage: " + seleniumWebDriver);
        String sessionXML = seleniumWebDriver.getPageSource();
        int sessionIndexStart = sessionXML.indexOf("idsession");
        int sessionIndexEnd = sessionXML.indexOf("\n", sessionIndexStart);
        LogDebug.invoke((Object)LogDebug, "[WebSync:BankOfScotland] " + getLogMethod + "getSessionID: SessionIndex: " + sessionIndexStart);
        if (sessionIndexStart != -1) {
            if (StringCharUtils.isNullOrEmptyOrNothing(sessionXML)) {
                throw new Exception("Der SessionXML-String ist leer oder null");
            }
            String sessionID = StringCharUtils.shrinkString(sessionXML.substring(sessionIndexStart, sessionIndexEnd));
            sessionID = sessionID.replace("var", "");
            sessionID = sessionID.replace("idsession", "");
            sessionID = sessionID.replace("=", "");
            sessionID = sessionID.replaceAll("'", "");
            sessionID = sessionID.replaceAll(";", "");
            sessionID = sessionID.replaceAll(" ", "");
            LogTrace.invoke((Object)LogTrace, "[WebSync:BankOfScotland] " + getLogMethod + "Ausgelesene SessionID zum weiterem Funktionsaufruf: " + sessionID);
            return sessionID;
        }
        WebUtils.checkSeleniumResponseHasError(sessionXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
        return null;
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            String logoutButtonPath = "//a[contains(@data-wt,'logout')]";
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutButton", logoutButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            Thread.sleep(2000L);
            String postLogoutPageXML = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPageXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            if (!postLogoutPageXML.contains("Erfolgreich abgemeldet") && !postLogoutPageXML.contains("abgemeldet</h1>")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:BankOfScotland] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:BankOfScotland] " + getLogMethod + "Logout bei der '" + "Bank of Scotland" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:BankOfScotland] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

