/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.americanexpress;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.HTMLUnitUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static String LOADER_CATCHSTRING = "progress-circle";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static String LOADER_PATH = "//div[contains(@class,'progress-circle')]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[9];
    protected static String[] xpathSearchStringExclusion = new String[10];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[@id='alertMsg' and text()!='']";
        WebUtils.xpathSearchString[1] = "//span[@id='alertMsg' and text()!='']";
        WebUtils.xpathSearchString[2] = "//div[@id='errormsg' and text()!='']";
        WebUtils.xpathSearchString[3] = "//div[@id='alertMsg']/child::div[text()!='']";
        WebUtils.xpathSearchString[4] = "(//p[@aria-live='polite' and contains(.,'Es tut uns Leid') and contains(.,'nicht verf\u00fcgbar')])[1]";
        WebUtils.xpathSearchString[5] = "//div[contains(@class,'alert') and not(contains(@class,'alert-neutral')) and not(contains(@class,'marketing')) and not(contains(@class,'css-'))]";
        WebUtils.xpathSearchString[6] = "(//form[@name='sorry_form']//ancestor::table)[2]";
        WebUtils.xpathSearchString[7] = "//div[@role='alert' and not(contains(@aria-live,'assertive'))]";
        WebUtils.xpathSearchString[8] = "(//div[contains(@data-module-name,'login') or @id='LoginComponent']//div[@role='alert']//span)[2]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "erhalten sie Ihre Abrechnung in Papierformat";
        WebUtils.xpathSearchStringExclusion[1] = "Offer";
        WebUtils.xpathSearchStringExclusion[2] = "ExtraPunkte";
        WebUtils.xpathSearchStringExclusion[3] = "Gold empfehlen";
        WebUtils.xpathSearchStringExclusion[4] = "keine Angebote";
        WebUtils.xpathSearchStringExclusion[5] = "in Raten";
        WebUtils.xpathSearchStringExclusion[6] = "kostenlos anmelden";
        WebUtils.xpathSearchStringExclusion[7] = "Zinsen";
        WebUtils.xpathSearchStringExclusion[8] = "tzlichen Links momentan nicht verf";
        WebUtils.xpathSearchStringExclusion[9] = "Entdecken Sie";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:AMEX] ";
        String longName = "American Express";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-americanexpress.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            String errMsg = error.getMessage();
            if (errMsg.contains("title") && errMsg.contains("message")) {
                errMsg = errMsg + "\n\nDieser Fehler bedeuted vermutlich, dass eine Seite nicht geladen werden konnte.\nBitte versuchen Sie es sp\u00e4ter noch einmal.";
            }
            throw new Exception(errMsg);
        }
    }

    public static void checkHTMLUnitResponseHasError(String pageResponse, Page currentPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:AMEX] ";
        String longName = "American Express";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            HTMLUnitUtils.checkHTMLUnitWebClientResponse(pageResponse, currentPage, logIdent, longName, "institutlogo-americanexpress.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    static boolean checkForBankingApp(WebDriver seleniumWebDriver, String isAlternateAuthOption, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        block26: {
            Method LogInfo = externalLogger.getMethod("info", String.class);
            Method LogDebug = externalLogger.getMethod("debug", String.class);
            Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
            WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
            String getLogMethod = "[waitBankingApp] ";
            String tanArt = "BankingApp";
            String detectAppAuthPath = "//*[contains(.,' haben eine Push-Mitteilung an Ihr ')]";
            String detectVerifiPath = "//div[contains(.,'Der Vorgang wird nun validiert')]";
            String detectAbortPath = "//p[contains(.,'Der Vorgang wurde abgebrochen')]";
            String otpChannelSelectMailPath = "//button//h3[contains(.,'E-Mail')]//ancestor::button | (//input[contains(@value,'EMAIL')])[1]";
            String deviceNameInputPath = "//input[@id='device-name-input']";
            String submitDevicePath = "//button[contains(.,'Weiter')]";
            boolean isSelfException = false;
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
                try {
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectAppAuthPath)));
                    if (isAlternateAuthOption.equals("true")) {
                        MonitorLog.invoke((Object)MonitorLog, "2FA - Laut Einstellung: Alternatives Verfahren wird gew\u00e4hlt ...");
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "2FA - Laut Einstellung: Alternatives Verfahren wird gew\u00e4hlt ...");
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "changeMethod", "//button[@id='changeMethod']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "2FA - Option E-Mail wird gew\u00e4hlt ...");
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "otpChannelSelectMail", otpChannelSelectMailPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                        MonitorLog.invoke((Object)MonitorLog, tanArt + " per E-Mail ist als Verfahren gesetzt ... Beginne Abfrage ...");
                        break block26;
                    }
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Warte auf Banking-App Freigabe ...");
                    MonitorLog.invoke((Object)MonitorLog, "Warte auf Banking-App Freigabe ...");
                    int rounds = 0;
                    Thread.sleep(3000L);
                    boolean showWaiting = true;
                    boolean validating = false;
                    while (true) {
                        WebElement waiterCheckElement = null;
                        try {
                            waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAppAuthPath));
                            showWaiting = true;
                        }
                        catch (NoSuchElementException noMoreWaiting) {
                            showWaiting = false;
                        }
                        try {
                            waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectVerifiPath));
                            validating = true;
                        }
                        catch (NoSuchElementException noMoreWaiting) {
                            validating = false;
                        }
                        try {
                            waiterCheckElement = seleniumWebDriver.findElement(By.xpath((String)detectAbortPath));
                            isSelfException = true;
                            throw new Exception("Banking-App Authentifizierung: Der Vorgang wurde abgebrochen");
                        }
                        catch (NoSuchElementException noMoreWaiting) {
                            if (showWaiting) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Warte weiter auf Banking-App Freigabe (weitere 3 Sekunden) ...");
                                Thread.sleep(3000L);
                            } else if (validating) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Validierung des Vorgang im gange ...");
                                MonitorLog.invoke((Object)MonitorLog, "Validierung des Vorgang im gange ...");
                                SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                            } else {
                                showWaiting = false;
                                validating = false;
                            }
                            if (++rounds >= 79) {
                                isSelfException = true;
                                throw new Exception("Banking-App Authentifizierung auch nach 240 Sekunden nicht abgeschlossen. Warten auf Banking-App Freigabe abgebrochen");
                            }
                            try {
                                WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                                continue;
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception(error.getMessage());
                            }
                            if (showWaiting || validating) continue;
                            boolean saveTrustedDevice = true;
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "saveDeviceAsTrusted", "//input[@id='trustDevice']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Option zum Merken des Ger\u00e4ts wird wohl nicht angeboten?! Ist wohl schon bekannt...");
                                MonitorLog.invoke((Object)MonitorLog, "Option zum Merken des Ger\u00e4ts wird wohl nicht angeboten?! Ist wohl schon bekannt...");
                                saveTrustedDevice = false;
                            }
                            if (!saveTrustedDevice) break;
                            WebElement deviceNameInput = seleniumWebDriver.findElement(By.xpath((String)deviceNameInputPath));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "deviceNameInput: " + deviceNameInput);
                            Thread.sleep(1000L);
                            WebElement selectElement = seleniumWebDriver.findElement(By.xpath((String)submitDevicePath));
                            JavascriptExecutor jsExecutor = (JavascriptExecutor)seleniumWebDriver;
                            jsExecutor.executeScript("window.scrollTo(document.body.scrollHeight,1920)", new Object[0]);
                            jsExecutor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{selectElement});
                            try {
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitDeviceName", submitDevicePath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                            String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                            try {
                                WebUtils.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                            }
                            catch (Exception error) {
                                isSelfException = true;
                                throw new Exception(error.getMessage());
                            }
                        }
                        break;
                    }
                }
                catch (TimeoutException noAuth) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
                    return false;
                }
            }
            catch (Exception error) {
                if (isSelfException) {
                    throw new Exception(error.getMessage());
                }
                isSelfException = true;
                throw new Exception("Warten auf Banking-App Freigabe fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
        }
        return true;
    }

    public static WebDriver checkForAuthCode(WebDriver seleniumWebDriver, String isAlternateAuthOption, Class<?> externalLogger, Class<?> externalDialogInterface, Class<?> externalProgressMonitor) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        WebDriverWait wait7 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(7L));
        boolean isSelfException = false;
        String tanArt = "authCode";
        String detectTANformPath = "//*[contains(.,'Einmaliger Verifizierungscode')] | //*[contains(.,'Einmaliger Best\u00e4tigungscode')]";
        String secTextPath = "//p[contains(.,'Verifizierungscode') or contains(.,'Best\u00e4tigungscode')]";
        String tanInputPath = "//input[@id='question-value'] | //input[@id='question-input']";
        String submitTanPath = "//button[contains(.,'Verifizieren')] | //button[contains(.,'Weiter')]";
        String otpChannelSelectMailPath = "//button//h3[contains(.,'E-Mail')]//ancestor::button | (//input[contains(@value,'EMAIL')])[1]";
        String otpChannelInputMailPath = "//form//p[contains(.,'@')]//following::input";
        String otpChannelSelectSMSPath = "//button//h3[contains(.,'SMS')]//ancestor::button | (//input[contains(@value,'SMS')])[1]";
        String otpChannelInputSmsPath = "//form//p[not(contains(.,'@'))]//following::input";
        String saveDeviceAsTrustedPath = "//input[@id='trustDevice']";
        String deviceNameInputPath = "//input[@id='device-name-input']";
        String submitDevicePath = "//button[contains(.,'Weiter')]";
        boolean retryInput = false;
        int retryCount = 0;
        LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Gefundene Abfrage mit xPathExpression des " + tanArt + "-Verfahren: " + wait7.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath))));
            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
            try {
                boolean mailAuthSelectVisible = false;
                try {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Pr\u00fcffe ob die Auswahl f\u00fcr 2FA per Mail zur Auswahl steht...");
                    seleniumWebDriver.findElement(By.xpath((String)otpChannelSelectMailPath));
                    mailAuthSelectVisible = true;
                }
                catch (NoSuchElementException | TimeoutException throwable) {
                    // empty catch block
                }
                boolean mailAuthInputVisible = false;
                try {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Pr\u00fcffe ob der Input f\u00fcr 2FA per Mail angezeigt wird...");
                    seleniumWebDriver.findElement(By.xpath((String)otpChannelInputMailPath));
                    mailAuthInputVisible = true;
                }
                catch (NoSuchElementException | TimeoutException throwable) {
                    // empty catch block
                }
                boolean smsAuthSelectVisible = false;
                try {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Pr\u00fcffe ob die Auswahl f\u00fcr 2FA per SMS zur Auswahl steht...");
                    seleniumWebDriver.findElement(By.xpath((String)otpChannelSelectSMSPath));
                    smsAuthSelectVisible = true;
                }
                catch (NoSuchElementException | TimeoutException throwable) {
                    // empty catch block
                }
                boolean smsAuthInputVisible = false;
                try {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Pr\u00fcffe ob der Input f\u00fcr 2FA per Mail angezeigt wird...");
                    seleniumWebDriver.findElement(By.xpath((String)otpChannelInputSmsPath));
                    smsAuthInputVisible = true;
                }
                catch (NoSuchElementException | TimeoutException throwable) {
                    // empty catch block
                }
                if (isAlternateAuthOption.equals("true") && mailAuthSelectVisible && !mailAuthInputVisible) {
                    MonitorLog.invoke((Object)MonitorLog, "2FA - Laut Einstellung: Alternatives Verfahren wird gew\u00e4hlt ...");
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "2FA - Laut Einstellung: Alternatives Verfahren wird gew\u00e4hlt ...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "changeMethod", "//button[@id='changeMethod']", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "2FA - Option E-Mail wird gew\u00e4hlt ...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "otpChannelSelectMail", otpChannelSelectMailPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    MonitorLog.invoke((Object)MonitorLog, tanArt + " per E-Mail ist als Verfahren gesetzt ... Beginne Abfrage ...");
                } else if (!mailAuthSelectVisible && mailAuthInputVisible) {
                    MonitorLog.invoke((Object)MonitorLog, tanArt + " per E-Mail ist als Verfahren gesetzt ... Beginne Abfrage ...");
                } else if (smsAuthSelectVisible && !smsAuthInputVisible) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "2FA - Option SMS-Text wird gew\u00e4hlt ...");
                    MonitorLog.invoke((Object)MonitorLog, tanArt + " per SMS ist als Verfahren gesetzt ... Beginne Abfrage ...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "otpChannelSelectSMS", otpChannelSelectSMSPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                } else if (!smsAuthSelectVisible && smsAuthInputVisible) {
                    MonitorLog.invoke((Object)MonitorLog, tanArt + " per SMS ist als Verfahren gesetzt ... Beginne Abfrage ...");
                }
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                seleniumWebDriver.findElement(By.xpath((String)"(//input[contains(@value,'EMAIL')])[1]"));
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "continueButton", "//button[contains(.,'Weiter')]", LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            catch (NoSuchElementException noOldSite) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Alte 2FA-Seite nicht erkannt, mache daher ohne Klick auf Button weiter ...");
            }
            try {
                do {
                    String secText = seleniumWebDriver.findElement(By.xpath((String)secTextPath)).getText().trim().replace("Verifizierungsmethode \u00e4ndern", "");
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-americanexpress.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:AMEX] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.clear();
                    tanInput.click();
                    tanInput.clear();
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    Thread.sleep(1000L);
                    WebElement selectElement = seleniumWebDriver.findElement(By.xpath((String)submitTanPath));
                    JavascriptExecutor jsExecutor = (JavascriptExecutor)seleniumWebDriver;
                    jsExecutor.executeScript("window.scrollTo(document.body.scrollHeight,1920)", new Object[0]);
                    jsExecutor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{selectElement});
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTAN", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    Thread.sleep(1000L);
                    try {
                        wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                        userTanInput = null;
                        retryInput = true;
                        if (++retryCount == 2) {
                            retryInput = false;
                            isSelfException = true;
                            throw new Exception("mTAN zweimal falsch eingegeben (Eingabe erscheint wieder), daher Abbruch bevor Konto gesperrt wird");
                        }
                    }
                    catch (TimeoutException noSecondSec) {
                        userTanInput = null;
                        retryInput = false;
                    }
                    if (retryInput) continue;
                    boolean saveTrustedDevice = true;
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "saveDeviceAsTrusted", saveDeviceAsTrustedPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Option zum Merken des Ger\u00e4ts wird wohl nicht angeboten?! Ist wohl schon bekannt...");
                        MonitorLog.invoke((Object)MonitorLog, "Option zum Merken des Ger\u00e4ts wird wohl nicht angeboten?! Ist wohl schon bekannt...");
                        saveTrustedDevice = false;
                    }
                    if (!saveTrustedDevice) continue;
                    WebElement deviceNameInput = seleniumWebDriver.findElement(By.xpath((String)deviceNameInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "deviceNameInput: " + deviceNameInput);
                    Thread.sleep(1000L);
                    selectElement = seleniumWebDriver.findElement(By.xpath((String)submitDevicePath));
                    jsExecutor = (JavascriptExecutor)seleniumWebDriver;
                    jsExecutor.executeScript("window.scrollTo(document.body.scrollHeight,1920)", new Object[0]);
                    jsExecutor.executeScript("arguments[0].scrollIntoView(true);", new Object[]{selectElement});
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitDeviceName", submitDevicePath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfter2FLoginResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebUtils.checkSeleniumResponseHasError(pageAfter2FLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (retryInput);
            }
            catch (Exception secError) {
                if (isSelfException) {
                    throw new Exception(secError.getMessage());
                }
                throw new Exception("Sicherheitsverfahren '" + tanArt + "' fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)secError));
            }
        }
        catch (TimeoutException noSecondSec) {
            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt ... mache weiter ..." + noSecondSec.getMessage());
        }
        return seleniumWebDriver;
    }
}

