/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.americanexpress;

import de.derrichter.finance.websync.institute.americanexpress.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String creditCardNr, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait30 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        boolean isSelfException = false;
        try {
            WebElement acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'sprite-ContinueButton')]"));
            acceptCookies.click();
        }
        catch (Exception acceptCookies) {
            // empty catch block
        }
        Double amount = Double.NaN;
        String amexType = "default";
        String typedCardSearchPath = "";
        String noFeedbackButtonPath = "//button[contains(.,'No, Thanks') or contains(.,'Nein, danke')]";
        String closeAxpOfferPath = "//div[@data-module-name='axp-dynamic-offer']//a[contains(@class,'close')]";
        String accountInfo = "";
        try {
            WebElement noFeedback2;
            String cookieDetectPath = "//div[@id='consentContainer' and not(contains(@style,'display: none;'))]";
            String cookieAcceptPath = "//input[@id='sprite-AcceptButton_DE']";
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:AMEX] ", "American Express", "institutlogo-americanexpress.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            try {
                String messagePath = "//*[contains(@data-module-name,'axp-marketing-offer') or contains(@data-module-name,'axp-dynamic-offer')]";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Zwischenseite oder PopUp mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeButton", messagePath + "//*[contains(@class,'close')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            String cardsOverview = "//button[contains(@class,'accountSwitcher')]";
            LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "cardsOverview: " + cardsOverview);
            try {
                wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cardsOverview)));
                WebElement cardsOverviewLink = seleniumWebDriver.findElement(By.xpath((String)cardsOverview));
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "cardsOverviewLink: " + cardsOverviewLink);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardsOverviewLink", cardsOverview, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            catch (NoSuchElementException | TimeoutException openTransPage) {
                isSelfException = true;
                String cardOverviewXML = seleniumWebDriver.getPageSource();
                LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "cardOverviewXML (Seite): \n" + cardOverviewXML);
                throw new Exception("Link von Karten\u00fcbersicht kann nicht gefunden werden. Vermutlich unbekannte Meldung auf der Homepage. Bitte im Online-Banking pr\u00fcfen, ansonsten im Forum melden.\n" + ExceptionUtils.getStackTrace((Throwable)openTransPage));
            }
            try {
                noFeedback2 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                noFeedback2.click();
            }
            catch (Exception noFeedback2) {
                // empty catch block
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] Karten-Endnummer aus den Einstellungen: " + creditCardNr.substring(10));
            LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] Zu suchende Karten-End-Nr. ist: " + creditCardNr.substring(10, 15));
            try {
                WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Gefundene xPathExpression zur gesuchten Karte: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//*[contains(@class,'heading-2') and contains(text(),'" + creditCardNr.substring(10, 15) + "')]")))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogError.invoke((Object)LogError, "[WebSync:AMEX] " + getLogMethod + "Saldoabruf: Kartenkonto-Regex fehlerhaft: Error:\n" + ExceptionUtils.getStackTrace((Throwable)notFounderr));
                throw new Exception("Letzte f\u00fcnf Stellen der Kreditkartennummer auf Seite nicht gefunden! \u00dcberpr\u00fcfen Sie Ihre Angaben.");
            }
            try {
                noFeedback2 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                noFeedback2.click();
            }
            catch (Exception noFeedback3) {
                // empty catch block
            }
            try {
                WebElement acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'sprite-ContinueButton')]"));
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Cookie-Law Meldung... ");
                acceptCookies.click();
            }
            catch (Exception acceptCookies) {
                // empty catch block
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Kartenart finden: Karten aufrufen ...");
            String cardLinkPathMain = "(//*[contains(@class,'heading-2') and contains(text(),'" + creditCardNr.substring(10, 15) + "')])";
            String cardLinkPath = cardLinkPathMain + "[1]";
            if (creditCardNr.endsWith("-2")) {
                cardLinkPath = cardLinkPathMain + "[3]";
            } else if (creditCardNr.endsWith("-3")) {
                cardLinkPath = cardLinkPathMain + "[5]";
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "cardLinkPath: ...[+0]: " + cardLinkPath);
            try {
                WebElement noFeedback42;
                WebElement closeApxOffer2;
                WebElement cardLink = seleniumWebDriver.findElement(By.xpath((String)cardLinkPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "cardLink: " + cardLink);
                String amexTypeText = cardLink.getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "amexTypeText: " + amexTypeText);
                if (amexTypeText.contains("Blue")) {
                    amexType = "Blue";
                    typedCardSearchPath = "contains(.,'Blue')";
                } else if (!(amexTypeText.contains("Blue") || amexTypeText.contains("Gold") || amexTypeText.contains("Platinum") || amexTypeText.contains("Business") || amexTypeText.contains("Corporate") || amexTypeText.contains("PAYBACK"))) {
                    amexType = "Private";
                    typedCardSearchPath = "not(contains(.,'Blue')) and not(contains(.,'Gold')) and not(contains(.,'Platinum')) and not(contains(.,'Business')) and not(contains(.,'Corporate'))";
                } else if (amexTypeText.contains("Gold") && !amexTypeText.contains("Business") && !amexTypeText.contains("Corporate")) {
                    amexType = "PrivateGold";
                    typedCardSearchPath = "contains(.,'Gold') and not(contains(.,'Business')) and not(contains(.,'Corporate'))";
                } else if (amexTypeText.contains("Platinum") && !amexTypeText.contains("Business") && !amexTypeText.contains("Corporate")) {
                    amexType = "PrivatePlatinum";
                    typedCardSearchPath = "contains(.,'Platinum') and not(contains(.,'Business')) and not(contains(.,'Corporate'))";
                } else if (amexTypeText.contains("PAYBACK")) {
                    amexType = "PAYBACK";
                    typedCardSearchPath = "contains(.,'PAYBACK')";
                } else if (!amexTypeText.contains("Gold") && !amexTypeText.contains("Platinum") && amexTypeText.contains("Business")) {
                    amexType = "Business";
                    typedCardSearchPath = "not(contains(.,'Blue')) and not(contains(.,'Gold')) and not(contains(.,'Platinum')) and contains(.,'Business')";
                } else if (amexTypeText.contains("Gold") && amexTypeText.contains("Business")) {
                    amexType = "BusinessGold";
                    typedCardSearchPath = "contains(.,'Gold') and contains(.,'Business')";
                } else if (amexTypeText.contains("Platinum") && amexTypeText.contains("Business")) {
                    amexType = "BusinessPlatinum";
                    typedCardSearchPath = "contains(.,'Platinum') and contains(.,'Business')";
                } else if (!amexTypeText.contains("Gold") && !amexTypeText.contains("Platinum") && amexTypeText.contains("Corporate")) {
                    amexType = "Corporate";
                    typedCardSearchPath = "not(contains(.,'Gold')) and not(contains(.,'Platinum')) and contains(.,'Corporate')";
                } else if (amexTypeText.contains("Gold") && amexTypeText.contains("Corporate")) {
                    amexType = "CorporateGold";
                    typedCardSearchPath = "contains(.,'Gold') and contains(.,'Corporate')";
                } else if (amexTypeText.contains("Platinum") && amexTypeText.contains("Corporate")) {
                    amexType = "CorporatePlatinum";
                    typedCardSearchPath = "contains(.,'Platinum') and contains(.,'Corporate')";
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "amexType nach Analyse: " + amexType);
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "typeSearchPath nach Analyse: " + typedCardSearchPath);
                try {
                    WebElement noFeedback5 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback5.click();
                }
                catch (Exception noFeedback5) {
                    // empty catch block
                }
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cardLinkPath)));
                boolean needRetry = false;
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardLink", cardLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (ElementNotInteractableException notClickable) {
                    cardLinkPath = cardLinkPathMain + "[2]";
                    if (creditCardNr.endsWith("-2")) {
                        cardLinkPath = cardLinkPathMain + "[4]";
                    } else if (creditCardNr.endsWith("-3")) {
                        cardLinkPath = cardLinkPathMain + "[6]";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "current cardLinkPath return ElementNotInteractableException: new cardLinkPath: ...[+1]: " + cardLinkPath);
                    needRetry = true;
                }
                catch (Exception error) {
                    if (error.getMessage().contains("QSIWebResponsive")) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            closeApxOffer2 = seleniumWebDriver.findElement(By.xpath((String)closeAxpOfferPath));
                            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Amex Offer Meldung... ");
                            closeApxOffer2.click();
                        }
                        catch (Exception closeApxOffer2) {
                            // empty catch block
                        }
                        needRetry = true;
                    }
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (needRetry) {
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardLink", cardLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Punktestand auslesen...");
                try {
                    accountInfo = seleniumWebDriver.findElement(By.xpath((String)"(//div[contains(@class,'loyalty-tile-title')])[1]")).getText();
                    accountInfo = accountInfo + ": " + seleniumWebDriver.findElement(By.xpath((String)"(//div[contains(@class,'loyalty-tile-title')]//following::div)[1]")).getText();
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] accountInfo: " + accountInfo);
                }
                catch (Exception error) {
                    accountInfo = "Auslesen des Punktestands fehlerhaft!";
                }
                try {
                    WebElement acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'sprite-ContinueButton')]"));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Cookie-Law Meldung... ");
                    acceptCookies.click();
                }
                catch (Exception acceptCookies) {
                    // empty catch block
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Rechnungsseite aufrufen ... (GET " + "https://global.americanexpress.com/activity?inav=de_myca_pc_statement_transactions" + ")");
                try {
                    seleniumWebDriver.get("https://global.americanexpress.com/activity?inav=de_myca_pc_statement_transactions");
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Page title befor Login is: " + seleniumWebDriver.getTitle());
                String pageBillXML = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageBillXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                try {
                    noFeedback42 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback42.click();
                }
                catch (Exception noFeedback42) {
                    // empty catch block
                }
                try {
                    closeApxOffer2 = seleniumWebDriver.findElement(By.xpath((String)closeAxpOfferPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Amex Offer Meldung... ");
                    closeApxOffer2.click();
                }
                catch (Exception closeApxOffer3) {
                    // empty catch block
                }
                try {
                    WebElement acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'sprite-ContinueButton')]"));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Cookie-Law Meldung... ");
                    acceptCookies.click();
                }
                catch (Exception acceptCookies) {
                    // empty catch block
                }
                cardsOverview = "//button[contains(@class,'accountSwitcher')]";
                LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "cardsOverview: " + cardsOverview);
                try {
                    wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cardsOverview)));
                    WebElement cardsOverviewLink = seleniumWebDriver.findElement(By.xpath((String)cardsOverview));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "cardsOverviewLink: " + cardsOverviewLink);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardsOverviewLink", cardsOverview, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
                catch (NoSuchElementException | TimeoutException openTransPage) {
                    isSelfException = true;
                    String cardOverviewXML = seleniumWebDriver.getPageSource();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "cardOverviewXML (Seite): \n" + cardOverviewXML);
                    throw new Exception("Link von Karten\u00fcbersicht kann nicht gefunden werden. Vermutlich unbekannte Meldung auf der Homepage. Bitte im Online-Banking pr\u00fcfen, ansonsten im Forum melden.\n" + ExceptionUtils.getStackTrace((Throwable)openTransPage));
                }
                cardLink = seleniumWebDriver.findElement(By.xpath((String)cardLinkPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "cardLink: " + cardLink);
                amexTypeText = cardLink.getText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "amexTypeText: " + amexTypeText);
                if (amexTypeText.contains("Blue")) {
                    amexType = "Blue";
                    typedCardSearchPath = "contains(.,'Blue')";
                } else if (!(amexTypeText.contains("Blue") || amexTypeText.contains("Gold") || amexTypeText.contains("Platinum") || amexTypeText.contains("Business") || amexTypeText.contains("Corporate") || amexTypeText.contains("PAYBACK"))) {
                    amexType = "Private";
                    typedCardSearchPath = "not(contains(.,'Blue')) and not(contains(.,'Gold')) and not(contains(.,'Platinum')) and not(contains(.,'Business')) and not(contains(.,'Corporate'))";
                } else if (amexTypeText.contains("Gold") && !amexTypeText.contains("Business") && !amexTypeText.contains("Corporate")) {
                    amexType = "PrivateGold";
                    typedCardSearchPath = "contains(.,'Gold') and not(contains(.,'Business')) and not(contains(.,'Corporate'))";
                } else if (amexTypeText.contains("Platinum") && !amexTypeText.contains("Business") && !amexTypeText.contains("Corporate")) {
                    amexType = "PrivatePlatinum";
                    typedCardSearchPath = "contains(.,'Platinum') and not(contains(.,'Business')) and not(contains(.,'Corporate'))";
                } else if (amexTypeText.contains("PAYBACK")) {
                    amexType = "PAYBACK";
                    typedCardSearchPath = "contains(.,'PAYBACK')";
                } else if (!amexTypeText.contains("Gold") && !amexTypeText.contains("Platinum") && amexTypeText.contains("Business")) {
                    amexType = "Business";
                    typedCardSearchPath = "not(contains(.,'Blue')) and not(contains(.,'Gold')) and not(contains(.,'Platinum')) and contains(.,'Business')";
                } else if (amexTypeText.contains("Gold") && amexTypeText.contains("Business")) {
                    amexType = "BusinessGold";
                    typedCardSearchPath = "contains(.,'Gold') and contains(.,'Business')";
                } else if (amexTypeText.contains("Platinum") && amexTypeText.contains("Business")) {
                    amexType = "BusinessPlatinum";
                    typedCardSearchPath = "contains(.,'Platinum') and contains(.,'Business')";
                } else if (!amexTypeText.contains("Gold") && !amexTypeText.contains("Platinum") && amexTypeText.contains("Corporate")) {
                    amexType = "Corporate";
                    typedCardSearchPath = "not(contains(.,'Gold')) and not(contains(.,'Platinum')) and contains(.,'Corporate')";
                } else if (amexTypeText.contains("Gold") && amexTypeText.contains("Corporate")) {
                    amexType = "CorporateGold";
                    typedCardSearchPath = "contains(.,'Gold') and contains(.,'Corporate')";
                } else if (amexTypeText.contains("Platinum") && amexTypeText.contains("Corporate")) {
                    amexType = "CorporatePlatinum";
                    typedCardSearchPath = "contains(.,'Platinum') and contains(.,'Corporate')";
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "amexType nach Analyse: " + amexType);
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "typeSearchPath nach Analyse: " + typedCardSearchPath);
                try {
                    noFeedback42 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback42.click();
                }
                catch (Exception noFeedback6) {
                    // empty catch block
                }
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)cardLinkPath)));
                needRetry = false;
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardLink", cardLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (ElementNotInteractableException notClickable) {
                    cardLinkPath = cardLinkPathMain + "[2]";
                    if (creditCardNr.endsWith("-2")) {
                        cardLinkPath = cardLinkPathMain + "[4]";
                    } else if (creditCardNr.endsWith("-3")) {
                        cardLinkPath = cardLinkPathMain + "[6]";
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "current cardLinkPath return ElementNotInteractableException: new cardLinkPath: ...[+1]: " + cardLinkPath);
                    needRetry = true;
                }
                catch (Exception error) {
                    if (error.getMessage().contains("QSIWebResponsive")) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception cardOverviewXML) {
                            // empty catch block
                        }
                        try {
                            WebElement closeApxOffer4 = seleniumWebDriver.findElement(By.xpath((String)closeAxpOfferPath));
                            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Amex Offer Meldung... ");
                            closeApxOffer4.click();
                        }
                        catch (Exception closeApxOffer4) {
                            // empty catch block
                        }
                        needRetry = true;
                    }
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                if (needRetry) {
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "cardLink", cardLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                }
                String cardHomePageXML = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(cardHomePageXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            catch (NoSuchElementException | TimeoutException openTransPage) {
                isSelfException = true;
                String cardHomePageXML = seleniumWebDriver.getPageSource();
                LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "cardHomePageXML (Seite): \n" + cardHomePageXML);
                throw new Exception("Link von Hauptseite der Karte kann nicht gefunden werden. Vermutlich unbekannte Meldung auf der Homepage. Bitte im Online-Banking pr\u00fcfen, ansonsten im Forum melden.\n" + ExceptionUtils.getStackTrace((Throwable)openTransPage));
            }
            String amountPath = "//*[@data-module-name='axp-activity-vitals-total-lg']//div[contains(@class,'heading-5')]";
            wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountPath)));
            String amountText = seleniumWebDriver.findElement(By.xpath((String)amountPath)).getText();
            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] Card Amount Data: " + amountText);
            if (StringCharUtils.shrinkString(amountText).equals("Nicht verf\u00fcgbar")) {
                throw new Exception("Saldo im Moment nicht verf\u00fcgbar");
            }
            amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            amount = amount * -1.0;
            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Amount: " + amount);
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            isSelfException = true;
            throw new Exception("Saldo konnte nicht ermittelt werden: " + error.getMessage());
        }
        try {
            WebElement noFeedback = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
            noFeedback.click();
        }
        catch (Exception noFeedback) {
            // empty catch block
        }
        try {
            WebElement acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'sprite-ContinueButton')]"));
            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Cookie-Law Meldung... ");
            acceptCookies.click();
        }
        catch (Exception acceptCookies) {
            // empty catch block
        }
        File downloadedFile = null;
        String doctext = null;
        String filetype = "";
        try {
            boolean localTest = false;
            if (!localTest) {
                WebElement noFeedback10;
                WebElement noFeedback72;
                WebElement noFeedback82;
                boolean Versuche = false;
                Object kkBillDlXML = null;
                try {
                    WebElement acceptCookies = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'sprite-ContinueButton')]"));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Cookie-Law Meldung... ");
                    acceptCookies.click();
                }
                catch (Exception acceptCookies) {
                    // empty catch block
                }
                try {
                    noFeedback82 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback82.click();
                }
                catch (Exception noFeedback82) {
                    // empty catch block
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "searchLink", "//a[@href='/activity/search']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    if (error.getMessage().contains("QSIWebResponsive")) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception needRetry) {
                            // empty catch block
                        }
                    }
                    if (error.getMessage().contains("QSIWebResponsive") || error.getMessage().contains("receive the click: <div class=\"pad-0-l-md-down\">")) {
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "searchLink", "//a[@href='/activity/search']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error2) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error2));
                        }
                    }
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    noFeedback82 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback82.click();
                }
                catch (Exception noFeedback9) {
                    // empty catch block
                }
                String dateNowSimple = null;
                if (!StringCharUtils.isNullOrEmptyOrNothing(toDateSimple)) {
                    dateNowSimple = toDateSimple;
                } else {
                    toDateSimple = dateNowSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                }
                SimpleDateFormat germanDate = new SimpleDateFormat("dd.MM.yyyy");
                SimpleDateFormat englishDate = new SimpleDateFormat("dd/MM/yyyy");
                Date fromDateConvert = germanDate.parse(fromDateSimple);
                fromDateSimple = englishDate.format(fromDateConvert);
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "fromDateSimple: " + fromDateSimple);
                Date toDateConvert = germanDate.parse(toDateSimple);
                toDateSimple = englishDate.format(toDateConvert);
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "toDateSimple: " + toDateSimple);
                String patternFieldPath = "(//input[@name='searchInput'])[1]";
                try {
                    wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)patternFieldPath)));
                }
                catch (NoSuchElementException | TimeoutException noSearch) {
                    isSelfException = true;
                    throw new Exception("Suchfeld '" + patternFieldPath + "'konnte nicht gefunden werden. Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.\n" + ExceptionUtils.getStackTrace((Throwable)noSearch));
                }
                WebElement patternField = seleniumWebDriver.findElement(By.xpath((String)patternFieldPath));
                patternField.click();
                patternField.sendKeys(new CharSequence[]{fromDateSimple});
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                    patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "c"})});
                    patternField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                } else {
                    patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                    patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "c"})});
                    patternField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                }
                try {
                    WebElement toDateField;
                    block249: {
                        WebElement fromDateField;
                        String endDatePath;
                        block248: {
                            try {
                                noFeedback72 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                                noFeedback72.click();
                            }
                            catch (Exception noFeedback72) {
                                // empty catch block
                            }
                            String startDatePath = "(//input[@id='startDate'])[1]";
                            endDatePath = "(//input[@id='endDate'])[1]";
                            fromDateField = seleniumWebDriver.findElement(By.xpath((String)startDatePath));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "fromDateField: " + fromDateField);
                            toDateField = seleniumWebDriver.findElement(By.xpath((String)endDatePath));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "toDateField: " + toDateField);
                            try {
                                fromDateField.click();
                            }
                            catch (Exception error) {
                                if (error.getMessage().contains("QSIWebResponsive")) {
                                    try {
                                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    try {
                                        fromDateField = seleniumWebDriver.findElement(By.xpath((String)startDatePath));
                                        LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "startDate: " + fromDateField);
                                        fromDateField.click();
                                    }
                                    catch (Exception error2) {
                                        if (error2.getMessage().contains("QSIWebResponsive")) {
                                            try {
                                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            try {
                                                fromDateField = seleniumWebDriver.findElement(By.xpath((String)startDatePath));
                                                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "startDate: " + fromDateField);
                                                fromDateField.click();
                                                break block248;
                                            }
                                            catch (Exception error3) {
                                                isSelfException = true;
                                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error3));
                                            }
                                        }
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error2));
                                    }
                                }
                                isSelfException = true;
                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                            }
                        }
                        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                            fromDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                            fromDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "v"})});
                        } else {
                            fromDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                            fromDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "v"})});
                        }
                        try {
                            noFeedback10 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                            noFeedback10.click();
                        }
                        catch (Exception noFeedback10) {
                            // empty catch block
                        }
                        patternField.click();
                        patternField.clear();
                        patternField.sendKeys(new CharSequence[]{toDateSimple});
                        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                            patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                            patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "c"})});
                            patternField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        } else {
                            patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                            patternField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "c"})});
                            patternField.sendKeys(new CharSequence[]{Keys.BACK_SPACE});
                        }
                        try {
                            toDateField = seleniumWebDriver.findElement(By.xpath((String)endDatePath));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "endDate: " + toDateField);
                            toDateField.click();
                        }
                        catch (Exception error) {
                            if (error.getMessage().contains("QSIWebResponsive")) {
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception error2) {
                                    // empty catch block
                                }
                                try {
                                    toDateField = seleniumWebDriver.findElement(By.xpath((String)endDatePath));
                                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "endDate: " + toDateField);
                                    toDateField.click();
                                }
                                catch (Exception error2) {
                                    if (error2.getMessage().contains("QSIWebResponsive")) {
                                        try {
                                            WebElement noFeedback11 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                                            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                                            noFeedback11.click();
                                        }
                                        catch (Exception noFeedback11) {
                                            // empty catch block
                                        }
                                        try {
                                            toDateField = seleniumWebDriver.findElement(By.xpath((String)endDatePath));
                                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "endDate: " + toDateField);
                                            toDateField.click();
                                            break block249;
                                        }
                                        catch (Exception error3) {
                                            isSelfException = true;
                                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error3));
                                        }
                                    }
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error2));
                                }
                            }
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                    }
                    if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                        toDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "a"})});
                        toDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.COMMAND, "v"})});
                        Thread.sleep(3000L);
                    } else {
                        toDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"})});
                        toDateField.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "v"})});
                    }
                    try {
                        noFeedback10 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                        noFeedback10.click();
                    }
                    catch (Exception noFeedback12) {
                        // empty catch block
                    }
                    Thread.sleep(1000L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nAuf dieser Seite befindliche Inputs zur Analyse:" + SeleniumUtils.getFormatedListOfAllWebElements(seleniumWebDriver, "//input", externalLogger));
                }
                try {
                    noFeedback72 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback72.click();
                }
                catch (Exception noFeedback13) {
                    // empty catch block
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitButton", "(//button[contains(.,'Suchen')])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                Thread.sleep(1000L);
                try {
                    WebElement noFeedback14 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                    LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                    noFeedback14.click();
                }
                catch (Exception noFeedback14) {
                    // empty catch block
                }
                try {
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//span[contains(.,'Ihre Kontoinformationen sind derzeit nicht')]")));
                    throw new Exception("Es tut uns leid. Ihre Kontoinformationen sind derzeit nicht verf\u00fcgbar. Bitte versuchen Sie es sp\u00e4ter noch einmal.");
                }
                catch (NoSuchElementException | TimeoutException noFeedback14) {
                    doctext = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der American Express\n\n\nDatum des Auszugs:;" + new Date() + "\nKartennummer:;**** ****** " + creditCardNr.substring(10) + "\nKontostand:;" + amount + "\n";
                    boolean haveNewTrans = false;
                    try {
                        if (seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'Keine Ergebnisse ')]")) != null) {
                            doctext = doctext + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                        }
                    }
                    catch (Exception waiterror) {
                        haveNewTrans = true;
                        LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] xpath //span[contains(.,'Keine Ergebnisse ')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
                    }
                    if (localTest) {
                        String docFixTempFilePath = "/Users/derRichter/Desktop/Kontoauszug.csv";
                        downloadedFile = new File(docFixTempFilePath);
                    }
                    boolean downloadedFileIsFalse = false;
                    int downloadCount = 1;
                    try {
                        noFeedback10 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Schlie\u00dfe Feedback Meldung... ");
                        noFeedback10.click();
                    }
                    catch (Exception noFeedback15) {
                        // empty catch block
                    }
                    if (haveNewTrans || localTest) {
                        do {
                            if (!localTest) {
                                block250: {
                                    try {
                                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadsLink", "//*[contains(@class,'icon-download')]//following::p[contains(.,'Herunterladen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception error) {
                                        if (error.getMessage().contains("QSIWebResponsive")) {
                                            try {
                                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "noFeedbackButton", noFeedbackButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                            }
                                            catch (Exception error2) {
                                                // empty catch block
                                            }
                                            try {
                                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadsLink", "//*[contains(@class,'icon-download')]//following::p[contains(.,'Herunterladen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                                break block250;
                                            }
                                            catch (Exception error2) {
                                                isSelfException = true;
                                                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                            }
                                        }
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                                    }
                                }
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "csvFileType", "//input[contains(@id,'csv')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nAuf dieser Seite befindliche Inputs zur Analyse:" + SeleniumUtils.getFormatedListOfAllWebElements(seleniumWebDriver, "//input", externalLogger));
                                }
                                WebElement allDataButton = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'includeAll')]"));
                                if (allDataButton.isSelected()) {
                                    try {
                                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "allData", "//input[contains(@id,'includeAll')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                    }
                                    catch (Exception error) {
                                        isSelfException = true;
                                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nAuf dieser Seite befindliche Inputs zur Analyse:" + SeleniumUtils.getFormatedListOfAllWebElements(seleniumWebDriver, "//input", externalLogger));
                                    }
                                }
                                try {
                                    WebElement noFeedback16 = seleniumWebDriver.findElement(By.xpath((String)noFeedbackButtonPath));
                                    noFeedback16.click();
                                }
                                catch (Exception noFeedback16) {
                                    // empty catch block
                                }
                                try {
                                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", "//a[contains(.,'Herunterladen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                                }
                                catch (Exception error) {
                                    isSelfException = true;
                                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error) + "\nAuf dieser Seite befindliche Links zur Analyse:" + SeleniumUtils.getFormatedListOfAllWebElements(seleniumWebDriver, "//a", externalLogger));
                                }
                                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                                do {
                                    Thread.sleep(500L);
                                    int waiter = 0;
                                    do {
                                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                        Thread.sleep(1000L);
                                        ++waiter;
                                    } while (downloadedFile == null && waiter < 30);
                                    if (downloadedFile != null && downloadedFile.exists()) continue;
                                    isSelfException = true;
                                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                            }
                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                            filetype = FilenameUtils.getExtension((String)downloadedFile.getAbsolutePath()).toUpperCase();
                            if (filetype.toLowerCase().equals("txt") || filetype.toLowerCase().equals("htm") || filetype.toLowerCase().equals("html") || filetype.toLowerCase().equals("asp") || filetype.toLowerCase().equals("js")) {
                                LogWarn.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / falscher Dateityp, versuche es nochmals ...");
                                ++downloadCount;
                                downloadedFileIsFalse = true;
                            } else {
                                downloadedFileIsFalse = false;
                            }
                            if (downloadCount < 4) continue;
                            isSelfException = true;
                            throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert");
                        } while (downloadedFileIsFalse);
                        String fileResponse = "";
                        String fileencoding = "UTF-8";
                        fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                        LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "raw-fileResponse witout file-encoding convert:\n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                        if (!fileencoding.equals("UTF-8")) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                            byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                            doctext = new String(filebytes, System.getProperty("file.encoding"));
                        } else {
                            doctext = fileResponse;
                        }
                        LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + filetype + "-Rechnung (text):\n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                        if (!localTest) {
                            FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                            LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "deleting downloaded transactions-file ...");
                            FileSysUtils.forceDeleteTarget(downloadedFile);
                        }
                    }
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//span[contains(.,'Leider konnten wir Ihre Registrierung bei Online Services nicht')]")));
                        throw new Exception("Anfrage-Verarbeitungsfehler (AMEX) ... Leider konnten wir Ihre Registrierung bei Online Services nicht vollst\\u00e4ndig bearbeiten. Bitte versuchen Sie es sp\\u00e4ter erneut");
                    }
                    catch (NoSuchElementException | TimeoutException throwable) {
                        // empty catch block
                    }
                }
            }
            String[] dataResponse = new String[]{doctext, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(doctext, '\"', ',', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            int betragSpalte = 2;
            if (matrixArrayData.length >= 1 && matrixArrayData[0].length == 5) {
                betragSpalte = 4;
            }
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("/");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].split("/");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][0].split("/");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][betragSpalte], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag *= -1.0);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (String.valueOf(betrag).indexOf("-") == -1) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Zahlung / \u00dcberweisung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][1]));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("AMEX", creditCardNr, amount, Double.NaN, 0.0, fromDateSimple, toDateSimple, accountInfo);
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            LogTrace.invoke((Object)LogTrace, "[WebSync:AMEX] " + getLogMethod + "\n" + StringCharUtils.formatedArrayListForLog(sortetBankArrayListAndData));
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

