/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.americanexpress;

import de.derrichter.finance.websync.institute.americanexpress.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        String pageLoginXML = null;
        String postLoginXML = null;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        boolean login = false;
        int round = 1;
        try {
            do {
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "AmericanExpress-Login aufrufen ... (GET " + "https://www.americanexpress.com/de-de/account/login/" + ")");
                try {
                    seleniumWebDriver.get("https://www.americanexpress.com/de-de/account/login/");
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    Thread.sleep(5000L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Page title befor Login is: " + seleniumWebDriver.getTitle());
                pageLoginXML = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLoginXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                String cookieDetectPath = "//div[contains(@id,'consent-management') and not(contains(@style,'display: none;'))]";
                String cookieAcceptPath = "//button[contains(.,'kzeptieren')]";
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:AMEX] ", "American Express", "institutlogo-americanexpress.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//input[contains(@id,'Username') or contains(@id,'eliloUserID')]")));
                    WebElement username = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'Username') or contains(@id,'eliloUserID')]"));
                    username.clear();
                    username.sendKeys(new CharSequence[]{responseLogin});
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "username: " + username);
                    Thread.sleep(2000L);
                    WebElement password = seleniumWebDriver.findElement(By.xpath((String)"//input[contains(@id,'Passwrd') or contains(@id,'eliloPassword')]"));
                    password.clear();
                    password.sendKeys(new CharSequence[]{responsePassword});
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "password: " + password);
                    Thread.sleep(2000L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Login-Form wird abgesendet ...");
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//*[contains(@id,'LoginButton') or contains(@id,'loginSubmit')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                SeleniumUtils.checkSecBorderBuster(seleniumWebDriver, "[WebSync:AMEX] ", "American Express", "institutlogo-americanexpress.png", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    postLoginXML = seleniumWebDriver.getPageSource();
                    WebUtils.checkSeleniumResponseHasError(postLoginXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    String errMsg = error.getMessage();
                    if (errMsg.contains("Es tut uns leid. Unser System ist") && errMsg.contains("nicht verf\u00fcgbar")) {
                        errMsg = "Es tut uns leid. Unser System ist vor\u00fcbergehend nicht verf\u00fcgbar.\n\nDiese Meldung bedeuted bei American Express aber wahrscheinlich:\nIhr Konto wurde aus Sicherheitsgr\u00fcnden gesperrt.\nRufen Sie die Nummer auf der R\u00fcckseite Ihrer Karte an.";
                    }
                    throw new Exception(errMsg);
                }
                MonitorLog.invoke((Object)MonitorLog, "Erste Login-Phase abgeschlossen, pr\u00fcfe auf Verfahren der Zwei-Faktor-Authentifizierung ...");
                try {
                    WebUtils.checkForBankingApp(seleniumWebDriver, optionalOptions, externalLogger, externalProgressMonitor, externalDialogInterface);
                    seleniumWebDriver = WebUtils.checkForAuthCode(seleniumWebDriver, optionalOptions, externalLogger, externalDialogInterface, externalProgressMonitor);
                }
                catch (Exception tanerror) {
                    isSelfException = true;
                    throw new Exception(tanerror.getMessage());
                }
                try {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Warte auf Kartenauswahl-Button um sicher zu gehen, dass der Login erfolgreich war...");
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//button[contains(@class,'accountSwitcher')]")));
                    login = true;
                }
                catch (NoSuchElementException | TimeoutException noSecondSec) {
                    try {
                        WebElement checkLoginField = seleniumWebDriver.findElement(By.id((String)"loginSubmit"));
                        if (round != 1) {
                            isSelfException = true;
                            throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Bitte pr\u00fcfen Sie dies manuell Online oder aktivieren Sie den Camouflage-Modus. Ansonsten bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
                        }
                        LogWarn.invoke((Object)LogWarn, "[WebSync:AMEX] " + getLogMethod + "Der Login wurde zur\u00fcckgesetzt, vermutlich nach Speichern des Ger\u00e4ts, versuche es daher nochmals...");
                        MonitorLog.invoke((Object)MonitorLog, "Der Login wurde zur\u00fcckgesetzt, vermutlich nach Speichern des Ger\u00e4ts, versuche es daher nochmals...");
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        isSelfException = true;
                        throw new Exception("Der Login hat wohl nicht funktioniert wird aber auch nicht mehr gefunden?!. Bitte pr\u00fcfen Sie dies manuell Online. Ansonsten bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
                    }
                }
                ++round;
            } while (!login);
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Abmelden aufrufen ... (" + "https://global.americanexpress.com/myca/logon/emea/action?request_type=LogLogoffConfirmHandler&Face=de_DE&BUnit=null&inav=de_utility_logout" + ")");
            try {
                seleniumWebDriver.get("https://global.americanexpress.com/myca/logon/emea/action?request_type=LogLogoffConfirmHandler&Face=de_DE&BUnit=null&inav=de_utility_logout");
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//input[@id='eliloUserID']";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:AMEX] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:AMEX] " + getLogMethod + "Logout bei der '" + "[WebSync:AMEX] " + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                LogError.invoke((Object)LogError, "[WebSync:AMEX] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:AMEX] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

