/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.akbank;

import de.derrichter.finance.websync.institute.akbank.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String unterkonto, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "Konten\u00fcbersicht aufrufen ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "mainmenu1", "//a[contains(@href,'#collapse1')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountsLink", "//a[contains(.,'Meine Konten')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "Check ob in der Konto\u00fcbersicht die Kontonummer enthalten ist ...");
            LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "Kontonummer (formated): " + kontonummer);
            try {
                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)("//a[contains(.,'" + kontonummer + "')]"))));
                LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (NoSuchElementException | TimeoutException noCreditCard) {
                isSelfException = true;
                throw new Exception("Abbruch: Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "Umsatz\u00fcbersicht aufrufen ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountDetails", "//a[contains(.,'" + kontonummer + "')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageTransResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageTransResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            double amount = Double.NaN;
            double availableAmount = Double.NaN;
            try {
                String amountText = seleniumWebDriver.findElement(By.id((String)"vcSavingBalance")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Kontostand' fehlgeschlagen: " + error.getMessage());
            }
            try {
                String blockedAmountText = seleniumWebDriver.findElement(By.id((String)"vcSavingBlockedAmount")).getText().trim();
                LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "blockedAmountText: " + blockedAmountText);
                double blockedAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(blockedAmountText, externalLogger));
                availableAmount = amount - blockedAmount;
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Verf\u00fcgbarer Betrag' fehlgeschlagen: " + error.getMessage());
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "availableAmount: " + availableAmount);
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "comboboxPeriod", "//*[@id='comboboxPeriod']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "dateInterval", "//li[contains(.,'Datumsintervall')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                String fromInputPath = "//*[@id='datePickerStartDate']";
                String toInputPath = "//*[@id='datePickerEndDate']";
                String filterButtonPath = "//a[contains(.,'Suchen')]";
                seleniumWebDriver = SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, getLogMethod, "AKBANK AG", "institutlogo-akbank.png", fromDateSimple, toDateSimple, fromInputPath, toInputPath, filterButtonPath, false, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception searchError) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)searchError));
            }
            String searchPageSource = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(searchPageSource, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der AKBANK AG\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
            boolean haveNewTrans = false;
            try {
                if (seleniumWebDriver.findElement(By.xpath((String)"//span[contains(.,'keine Transaktionen')]")) != null) {
                    transData = transData + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                }
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] xpath //section[contains(.,'Zeitraum sind keine Ums\u00e4tze vorhanden')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
            }
            if (haveNewTrans) {
                String downloadButtonPath = "//*[@id='ExcelButton']";
                try {
                    transData = transData + "\n\n" + SeleniumUtils.downloadStatementAndConvert(seleniumWebDriver, "[WebSync:AKBank] ", downloadButtonPath, "", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transData (Statement): \n\n====================== BEGIN STATEMENT DATA ======================\n" + transData + "\n======================= END STATEMENT DATA =======================\n");
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] checkColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double betrag = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][5], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    double saldo = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayData[i][6], externalLogger));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(saldo);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (String.valueOf(betrag).startsWith("-")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Auszahlung");
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("Einzahlung");
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    String purp = matrixArrayData[i][2];
                    if (!StringCharUtils.isNullOrEmptyOrNothing(purp)) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(purp.replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String gegenkontoName = "";
                    String gegenkontoNummer = "";
                    String gegenkontoBLZ = "";
                    String iban = "";
                    String bic = "";
                    String kommentar = "";
                    String[] checkString = purp.split(" ");
                    if (StringCharUtils.isIbanCountryStructure(checkString[0])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(checkString[0]);
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(iban);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(bic);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(kommentar);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "inclInterBalace", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("AKBank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

