/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.akbank;

import de.derrichter.finance.websync.institute.akbank.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(20L));
        try {
            String pageAfterLoginResponse;
            block23: {
                LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "AKBank" + "-Login aufrufen ... (GET " + "https://myonline.akbank.de/" + ")");
                try {
                    seleniumWebDriver.get("https://myonline.akbank.de/");
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
                Thread.sleep(2000L);
                SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:AKBank] ", "AKBANK AG", "institutlogo-akbank.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
                try {
                    String userNameXpath = "//input[@autocomplete='username' or @placeholder='Kundennummer']";
                    String passXpath = "//input[@type='password' or contains(@autocomplete,'password')]";
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)userNameXpath)));
                    WebElement inputUsername = seleniumWebDriver.findElement(By.xpath((String)userNameXpath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "inputUsername: " + inputUsername);
                    WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)passXpath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "inputPassword: " + inputPasswd);
                    inputUsername.click();
                    inputUsername.sendKeys(new CharSequence[]{responseLogin});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    inputPasswd.click();
                    inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "//a[contains(@class,'login-button')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                MonitorLog.invoke((Object)MonitorLog, "Erste Login-Phase abgeschlossen, pr\u00fcfe auf Verfahren der Zwei-Faktor-Authentifizierung ...");
                try {
                    if (WebUtils.checkForBankingApp(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "AKBank" + "-2FA-Login mit Banking durchlaufen");
                        break block23;
                    }
                    if (WebUtils.checkForMTAN(seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface)) {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "AKBank" + "-2FA-Login mit mTAN durchlaufen");
                        break block23;
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "Login-Dialog noch vorhanden ... bei der Seite mit dem vermeintlich angebotenen Sicherheitsverfahren handelt es sich um diese im XML-Format: \n" + seleniumWebDriver.getPageSource());
                    isSelfException = true;
                    throw new Exception("Angebotenes Sicherheitsverfahren nicht erkannt oder bekannt. Bitte informieren Sie im Forum den Entwickler");
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
            }
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:AKBank] ", "AKBANK AG", "institutlogo-akbank.png", WebUtils.COOKIE_DETECT_PATH, WebUtils.COOKIE_ACCEPT_PATH, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger);
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//form[@id='new_session' or @name='login']"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, "[WebSync:AKBank] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "Abmelden aufrufen...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutLink", "//*[@id='LogoutButton']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutConfirm", "//a[contains(.,'Best\u00e4tigen')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//span[contains(.,'erfolgreich') and contains(.,'abgemeldet')]";
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:AKBank] " + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:AKBank] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPage);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:AKBank] " + getLogMethod + "Logout bei der '" + "AKBANK AG" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:AKBank] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

