/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.advanziabank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebUtils {
    static final boolean LOCAL_TRANSACTIONS_READ_TEST = false;
    static final String LOCAL_TEST_DOWNLOAD_CURRENT_PATH = "/Users/derRichter/Desktop/Kontoauszug_current.pdf";
    static final String LOACAL_TEST_DOWNLOAD_ARCHIV_PATH = "/Users/derRichter/Desktop/Kontoauszug_archiv.pdf";
    static final String COOKIE_DETECT_PATH = "#usercentrics-root,#focus-lock-id";
    static final String COOKIE_ACCEPT_PATH = "button[data-testid='uc-accept-all-button']";
    static final String LOADER_CATCHSTRING = "DummyCatchString";
    static final String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static final String LOADER_PATH = "//div[@id='loader' and not(contains(@style,'display: none;'))]";
    static final String LOADER_TEXT = "Anfrage wird bearbeitet";
    protected static final String[] xpathSearchString = new String[1];
    protected static final String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = ".//div[contains(@class,'alert-content') and not(ancestor::div[contains(@style,'display:none')]) and not(ancestor::div[@hidden]) and not(ancestor::div[contains(@style,'display: none')])]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Sie sind bereits registriert";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    static WebDriver checkTANRequest(WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkTANRequest] ";
        String tanArt = "Auswahl";
        String selectFormPath = "//form[contains(@id,'device-list-form')]";
        String selectMenuPath = "//div[contains(@id,'device-dropdown-button')]";
        String optionPath = "//a[contains(.,'SMS')]";
        String confirmPath = "//button[@id='nextButton']";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)selectFormPath)));
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "selectMenu", selectMenuPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "selectOption", optionPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "sendConfirm", confirmPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "Auswahl gestartet ... untersuche Verfahrens-Abfrage ...");
            }
            catch (TimeoutException noAuth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + tanArt + "' wird NICHT (direkt) abgefragt oder hat sich ge\u00e4ndert? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    static WebDriver checkForMTAN(WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogAskTan = externalDialogInterface.getMethod("askTAN", String.class, String.class, String.class);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        String getLogMethod = "[checkForMTAN] ";
        String tanArt = "mobileTAN";
        String detectTANformPath = "//form[contains(@id,'otp-login')]";
        String secTextPath = "//label[contains(@class,'otp-info')]";
        String tanInputPath = "//input[contains(@id,'otp-input-1')]";
        String submitTanPath = "//button[contains(@id,'login')]";
        boolean isSelfException = false;
        try {
            LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "Pr\u00fcfen auf " + tanArt + "-Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)detectTANformPath)));
                WebElement tanForm = seleniumWebDriver.findElement(By.xpath((String)detectTANformPath));
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "tanForm: " + tanForm);
                LogInfo.invoke((Object)LogInfo, "[WebSync:Advanzia] " + getLogMethod + tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                MonitorLog.invoke((Object)MonitorLog, tanArt + " ist als Verfahren gesetzt ... Beginne Abfrage ...");
                String secText = seleniumWebDriver.findElement(By.xpath((String)secTextPath)).getText().trim();
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "secText: " + secText);
                boolean retryInput = false;
                do {
                    String userTanInput = null;
                    try {
                        userTanInput = (String)DialogAskTan.invoke((Object)DialogAskTan, tanArt, secText, "institutlogo-advanziabank.png");
                    }
                    catch (InvocationTargetException error) {
                        isSelfException = true;
                        if (!StringCharUtils.isNullOrEmptyOrNothing(error.getCause().toString()) && error.getCause().toString().contains("OperationCanceledException")) {
                            throw new Exception("Abbruch der " + tanArt + "-Eingabe durch Benutzer (OperationCanceledException)");
                        }
                        LogError.invoke((Object)LogError, "[WebSync:Advanzia] " + getLogMethod + "TANAuthDialog fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                        throw new Exception("TANAuthDialog fehlerhaft: " + error.getMessage());
                    }
                    WebElement tanInput = seleniumWebDriver.findElement(By.xpath((String)tanInputPath));
                    LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "tanInput: " + tanInput);
                    tanInput.click();
                    tanInput.sendKeys(new CharSequence[]{userTanInput});
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitTan", submitTanPath, LOADER_CATCHSTRING, LOADER_EXCLUSIONS, LOADER_PATH, LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String pageAfterTanResponse = seleniumWebDriver.getPageSource();
                    try {
                        WebElement checkWrongTAN = seleniumWebDriver.findElement(By.xpath((String)"//*[contains(.,'Bitte versuchen Sie es erneut')]"));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "checkWrongTAN: " + checkWrongTAN);
                        DialogWarn.invoke((Object)DialogWarn, "Fehlermeldung der Advanzia Bank S.A.:\n\n\nDie eingegebene " + tanArt + " ist falsch.\nBitte versuchen Sie es erneut.", "institutlogo-advanziabank.png");
                        retryInput = true;
                    }
                    catch (NoSuchElementException | TimeoutException wrongTAN) {
                        retryInput = false;
                        try {
                            WebUtils.checkSeleniumResponseHasError(pageAfterTanResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    }
                } while (retryInput);
            }
            catch (TimeoutException noTANauth) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "Sicherheitsverfahren '" + tanArt + "' wird NICHT (direkt) abgefragt oder wurde umgebaut? mache weiter ...");
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception(tanArt + "-Verarbeitung fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
        return seleniumWebDriver;
    }

    public static String getShortName(String bankArt) throws Exception {
        String shortName;
        block6: {
            shortName = null;
            try {
                if (bankArt.equals("Kreditkarte")) {
                    shortName = "Advanzia";
                    break block6;
                }
                if (bankArt.equals("Tagesgeld")) {
                    shortName = "Advanzia";
                    break block6;
                }
                if (bankArt.equals("free.at")) {
                    shortName = "free.at";
                    break block6;
                }
                if (bankArt.equals("geb\u00fchrenfrei.de")) {
                    shortName = "geb\u00fchrenfrei.de";
                    break block6;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'shortName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return shortName;
    }

    public static String getLongName(String bankArt) throws Exception {
        String longName;
        block6: {
            longName = null;
            try {
                if (bankArt.equals("Kreditkarte")) {
                    longName = "Advanzia Bank S.A.";
                    break block6;
                }
                if (bankArt.equals("Tagesgeld")) {
                    longName = "Advanzia Bank S.A.";
                    break block6;
                }
                if (bankArt.equals("free.at")) {
                    longName = "free.at (Advanzia Bank)";
                    break block6;
                }
                if (bankArt.equals("geb\u00fchrenfrei.de")) {
                    longName = "geb\u00fchrenfrei.de (Advanzia Bank)";
                    break block6;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'longName' fehlerhaft: " + logerror.getMessage());
            }
        }
        return longName;
    }

    public static String getLogIdent(String bankArt) throws Exception {
        String logIdent;
        block6: {
            logIdent = null;
            try {
                if (bankArt.equals("Kreditkarte")) {
                    logIdent = "[WebSync:Advanzia] ";
                    break block6;
                }
                if (bankArt.equals("Tagesgeld")) {
                    logIdent = "[WebSync:Advanzia] ";
                    break block6;
                }
                if (bankArt.equals("free.at")) {
                    logIdent = "[WebSync:free.at] ";
                    break block6;
                }
                if (bankArt.equals("geb\u00fchrenfrei.de")) {
                    logIdent = "[WebSync:geb\u00fchrenfrei.de] ";
                    break block6;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logIdent' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logIdent;
    }

    public static String getLogoPath(String bankArt) throws Exception {
        String logoPath;
        block6: {
            logoPath = null;
            try {
                if (bankArt.equals("Kreditkarte")) {
                    logoPath = "institutlogo-advanziabank.png";
                    break block6;
                }
                if (bankArt.equals("Tagesgeld")) {
                    logoPath = "institutlogo-advanziabank.png";
                    break block6;
                }
                if (bankArt.equals("free.at")) {
                    logoPath = "institutlogo-free.png";
                    break block6;
                }
                if (bankArt.equals("geb\u00fchrenfrei.de")) {
                    logoPath = "institutlogo-gebuehrenfrei.png";
                    break block6;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'logoPath' fehlerhaft: " + logerror.getMessage());
            }
        }
        return logoPath;
    }

    public static String getLoginURL(String bankArt) throws Exception {
        String loginURL;
        block6: {
            loginURL = null;
            try {
                if (bankArt.equals("Kreditkarte")) {
                    loginURL = "https://mein.advanzia.com/b2b/de/";
                    break block6;
                }
                if (bankArt.equals("Tagesgeld")) {
                    loginURL = "https://mein.advanziakonto.com";
                    break block6;
                }
                if (bankArt.equals("free.at")) {
                    loginURL = "https://mein.free.at/b2c/de-AT/";
                    break block6;
                }
                if (bankArt.equals("geb\u00fchrenfrei.de")) {
                    loginURL = "https://mein.gebuhrenfrei.com/b2c/de/";
                    break block6;
                }
                throw new Exception("Unbekannten Kontoanbieter angegeben");
            }
            catch (Exception logerror) {
                throw new Exception("Setzen der Ident-Variable 'loginURL' fehlerhaft: " + logerror.getMessage());
            }
        }
        return loginURL;
    }
}

