/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.advanziabank;

import de.derrichter.finance.websync.institute.advanziabank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String bankArt, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait3 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(3L));
        boolean isSelfException = false;
        try {
            double amount;
            double availableAmount = 0.0;
            double unbookedAmount = 0.0;
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), "#usercentrics-root,#focus-lock-id", "button[data-testid='uc-accept-all-button']", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", externalLogger);
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "accountDetailsButton", "//div[contains(@class,'product-item-content')]//span", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (!bankArt.equals("Tagesgeld")) {
                try {
                    seleniumWebDriver.findElement(By.xpath((String)"//div[contains(.,'Saldo')]"));
                }
                catch (Exception waiterror) {
                    isSelfException = true;
                    throw new Exception("Auf der Seite konnte kein 'Aktuell gebuchter Saldo' gefunden werden. Falsche oder andere Seite");
                }
            }
            String amountText = "";
            String availableAmountText = "";
            try {
                String amountPath;
                if (!bankArt.equals("Tagesgeld")) {
                    amountPath = "(//div[@data-role='credit-limit-owed-value']/bb-amount-ui)[1]";
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountPath)));
                    amountText = seleniumWebDriver.findElement(By.xpath((String)amountPath)).getText().trim();
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "amountText: " + amountText);
                    availableAmountText = seleniumWebDriver.findElement(By.xpath((String)"//bb-amount-ui[@data-role='credit-limit-attribute-value']")).getText().trim();
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "availableAmountText: " + availableAmountText);
                } else {
                    amountPath = "(//bb-amount-ui)[1]";
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)amountPath)));
                    amountText = seleniumWebDriver.findElement(By.xpath((String)amountPath)).getText().trim();
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "amountText: " + amountText);
                }
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "amount: " + String.valueOf(amount));
                if (!bankArt.equals("Tagesgeld")) {
                    availableAmount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(availableAmountText, externalLogger));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "availableAmount: " + String.valueOf(availableAmount));
                } else {
                    availableAmount = amount;
                }
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Amount: " + String.valueOf(amount));
            }
            catch (Exception noAmount) {
                isSelfException = true;
                throw new Exception("Auslesen des Kontostands fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)noAmount));
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), "#usercentrics-root,#focus-lock-id", "button[data-testid='uc-accept-all-button']", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", externalLogger);
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterButton", "//button[contains(.,'Filter')]", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String fromDateInputPath = "//input[@id='bb_input_1']";
            String endDateInputPath = "//input[@id='bb_input_2']";
            String searchButtunPath = "//button[contains(@title,'Best\u00e4tigen')]";
            SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), "institutlogo-advanziabank.png", fromDateSimple, toDateSimple, fromDateInputPath, endDateInputPath, searchButtunPath, false, "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", externalLogger, externalProgressMonitor, externalDialogInterface);
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der " + WebUtils.getLongName(bankArt) + "\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
            String transDataObject = "";
            String transDataTextCurrent = "";
            String transDataTextArchiv = "";
            boolean haveNewTrans = false;
            File downloadedFile = null;
            String pdftext = null;
            try {
                wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(text(),'Keine Ergebnisse')]")));
                transData = transData + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + "xpath //div[contains(text(),'Keine Ergebnisse')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
            }
            if (haveNewTrans) {
                String exportMenuPath = "//button[contains(@aria-label,'export')]";
                SeleniumUtils.scrollElementInMiddleOfScreen(seleniumWebDriver, exportMenuPath);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "exportMenu", exportMenuPath, "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "pdfDownload", "//a[contains(.,'PDF')]", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                MemoryUsageSetting memUsageSetting = MemoryUsageSetting.setupTempFileOnly();
                PDDocument pdf = Loader.loadPDF((File)downloadedFile);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[PDDocument.load FILE]: " + pdf);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Erzeuge einen Kontoauszug aus PDF ...");
                try {
                    PDFTextStripper stripper = new PDFTextStripper();
                    stripper.setWordSeparator(";");
                    stripper.setSortByPosition(true);
                    pdftext = stripper.getText(pdf);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der PDF hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "getDataExport: soeben abgeholte und gestrippte PDF (aktuelleTransaktionen): \n" + pdftext);
                pdf.close();
                FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
                transDataTextCurrent = StringEscapeUtils.unescapeHtml4((String)(transDataTextCurrent + "\n" + pdftext));
                int idxPageFooter = transDataTextCurrent.indexOf("Page ");
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "idxPageFooter: " + idxPageFooter);
                int idxPageFooterEnd = transDataTextCurrent.indexOf(";Amount", idxPageFooter);
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "idxPageFooterEnd: " + idxPageFooterEnd);
                do {
                    if (idxPageFooter > 0 && idxPageFooterEnd > idxPageFooter) {
                        transDataTextCurrent = transDataTextCurrent.substring(0, idxPageFooter) + transDataTextCurrent.substring(idxPageFooterEnd + 8);
                    } else if (idxPageFooter > 0) {
                        transDataTextCurrent = transDataTextCurrent.substring(0, idxPageFooter);
                    }
                    idxPageFooter = transDataTextCurrent.indexOf("Page ");
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "idxPageFooter: " + idxPageFooter);
                    idxPageFooterEnd = transDataTextCurrent.indexOf(";Amount", idxPageFooter);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "idxPageFooterEnd: " + idxPageFooterEnd);
                } while (idxPageFooter > 0);
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "TransDataText (aktuelle Transaktionen, Page-Footer entfernt): \n" + transDataTextCurrent);
                transData = transData + transDataTextCurrent;
                transDataObject = "";
            }
            String billsLinkPath = "//a[contains(@href,'statements')]";
            MonitorLog.invoke((Object)MonitorLog, "Es werden alle notwendigen PDF-Abrechnungen abgerufen ... bitte warten ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "billsLink", billsLinkPath, "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Rechnungs-Seite: " + error.getMessage());
            }
            String billRowPath = "//tr[@bb-account-statement-table-row]";
            List invoiceLinks = null;
            int invoiceCount = 0;
            try {
                wait3.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)billRowPath)));
            }
            catch (NoSuchElementException | TimeoutException noBills) {
                invoiceCount = 0;
            }
            invoiceLinks = seleniumWebDriver.findElements(By.xpath((String)billRowPath));
            invoiceCount = invoiceLinks.size();
            if (invoiceLinks == null || invoiceCount == 0) {
                transData = transData + "\n\n\nverf\u00fcgbare Rechnung f\u00fcr Abrufzeitraum:\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine Rechnungen vorhanden";
            } else {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "(InvoiceCount) Es sind '" + invoiceCount + "' Rechnungen vorhanden");
                List billTexts = seleniumWebDriver.findElements(By.xpath((String)(billRowPath + "//td[contains(@class,'cell')][1]")));
                List downloadButtons = seleniumWebDriver.findElements(By.xpath((String)(billRowPath + "//td[contains(@class,'cell')]//button[contains(@data-role,'download')]")));
                for (int readRound = 0; readRound < invoiceCount; ++readRound) {
                    double MonitorPercent = 30.0 + 29.0 / (double)invoiceCount * (double)(readRound + 1);
                    MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Es ist die '" + String.valueOf(readRound + 1) + "' Runde beim Rechnung auslesen");
                    boolean getNextBill = true;
                    PDDocument pdf = null;
                    String billText = null;
                    try {
                        billText = ((WebElement)billTexts.get(readRound)).getText();
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("Fehler beim Auslesen des Datum-Text zu den Rechnungsdetails (siehe Log):\nLog-Eintrag:" + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    String billDateText = billText.replace("Januar ", "3.2.");
                    billDateText = billDateText.replace("J&auml;nner ", "3.2.");
                    billDateText = billDateText.replace("J\u00e4nner ", "3.2.");
                    billDateText = billDateText.replace("Februar ", "3.3.");
                    billDateText = billDateText.replace("M&auml;rz ", "3.4.");
                    billDateText = billDateText.replace("M\u00e4rz ", "3.4.");
                    billDateText = billDateText.replace("April ", "3.5.");
                    billDateText = billDateText.replace("Mai ", "3.6.");
                    billDateText = billDateText.replace("Juni ", "3.7.");
                    billDateText = billDateText.replace("Juli ", "3.8.");
                    billDateText = billDateText.replace("August ", "3.9.");
                    billDateText = billDateText.replace("September ", "3.10.");
                    billDateText = billDateText.replace("Oktober ", "3.11.");
                    billDateText = billDateText.replace("November ", "3.12.");
                    if (billDateText.contains("Dezember")) {
                        billDateText = billDateText.replace("Dezember ", "");
                        int nextYear = Integer.parseInt(billDateText) + 1;
                        billDateText = "3.1." + String.valueOf(nextYear);
                    }
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Datum der Rechnung (Konto\u00fcbersicht) aus Listeneintrag: " + billDateText + " und beinhaltet die Monatsrechnung " + billText);
                    Date billDate = new SimpleDateFormat("dd.MM.yyyy").parse(billDateText);
                    Date fromDate = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple);
                    if (billDate.getTime() < fromDate.getTime()) {
                        LogDebug.invoke((Object)LogDebug, "BillDateText=" + billDateText + ";fromDateSimple=" + fromDateSimple + " - Billdate '" + String.valueOf(billDate.getTime()) + "' soll nun kleiner sein als fromDate: '" + String.valueOf(fromDate.getTime()));
                        LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + "Rechnung (Konto\u00fcbersicht) liegt au\u00dferhalb des Abrufdatum ... daher kein weiterer Abruf mehr");
                        getNextBill = false;
                        break;
                    }
                    pdf = null;
                    WebElement downloadButton = (WebElement)downloadButtons.get(readRound);
                    LogDebug.invoke((Object)LogDebug, "Link zur Rechnung: '" + downloadButton + " zur Rechnung: " + billText);
                    try {
                        downloadButton.click();
                        SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:Advanzia] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                        LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    }
                    catch (Exception pdferror) {
                        LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "PDF-Export fehlerhaft:\n" + ExceptionUtils.getStackTrace((Throwable)pdferror));
                        throw new Exception("PDF-Export fehlerhaft: " + pdferror.getMessage());
                    }
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Erzeuge einen Kontoauszug aus Rechnung vom " + billText + " ...");
                    pdf = Loader.loadPDF((File)downloadedFile);
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "[PDDocument.load FILE]: " + pdf);
                    pdftext = null;
                    try {
                        PDFTextStripper Stripper = new PDFTextStripper();
                        Stripper.setWordSeparator(";");
                        pdftext = Stripper.getText(pdf);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("Beim Lesen der PDF hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "getDataExport: soeben abgeholte und umgewandelte PDF-Rechnung (pdftext): \n" + pdftext);
                    pdf.close();
                    FileUtils.copyFileToDirectory((File)downloadedFile, (File)new File(SysUtils.SUPPORT_TEMP_PATH));
                    LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                    int transDataObjectStart = pdftext.indexOf("Datum;Beschreibung;");
                    int transDataObjectEnd = pdftext.lastIndexOf("MINDESTBETRAG f\u00f6llig am");
                    transDataObjectEnd = pdftext.indexOf("Kreditlimit", transDataObjectEnd);
                    try {
                        transDataObject = pdftext.substring(transDataObjectStart, transDataObjectEnd);
                    }
                    catch (Exception error) {
                        LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + "transDataObject auslesen fehlerhaft: ! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    if (!getNextBill) break;
                    if (transDataObject == null) continue;
                    transDataObject = StringEscapeUtils.unescapeHtml4((String)transDataObject);
                    transDataObject = StringCharUtils.shrinkWhitespaces(transDataObject);
                    transDataObject = transDataObject.replace("AMP;", "&");
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transDataText (Rechnungsdaten): \n" + transDataObject);
                    transData = transData + "\n\n\nverf\u00fcgbare Rechnung f\u00fcr " + billText + ":\n";
                    transData = transData + transDataObject;
                    transDataTextArchiv = transDataTextArchiv + transDataObject;
                    transDataObject = null;
                }
            }
            LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "TransData: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            if (transData.contains("<html") || transData.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayDataCurrent = StringCharUtils.data2matrixArray(transDataTextCurrent.replace("\"", "\\\""), '\"', ';', externalLogger);
            String[][] matrixArrayDataArchiv = StringCharUtils.data2matrixArray(transDataTextArchiv.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList<ArrayList> transactionDataList = new ArrayList<ArrayList>();
            int arrayRowCount = 0;
            for (int currentArchiv = 0; currentArchiv < matrixArrayDataArchiv.length; ++currentArchiv) {
                if (matrixArrayDataArchiv[currentArchiv] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataArchiv[currentArchiv][0])) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "matrixArrayDataArchiv: Zeile Nr. " + currentArchiv + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                String[] checkColumn = matrixArrayDataArchiv[currentArchiv][0].split("\\.");
                try {
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + e.toString());
                    continue;
                }
                if (matrixArrayDataArchiv[currentArchiv][1].equals("ALTER SALDO") || matrixArrayDataArchiv[currentArchiv][1].equals("NEUER SALDO") || matrixArrayDataArchiv[currentArchiv][1].equals("Letzter Rechnungssaldo")) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataArchiv: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                try {
                    transactionDataList.add(new ArrayList());
                    transactionDataList.get(arrayRowCount).add(new SimpleDateFormat("dd.MM.yyyy").parse(matrixArrayDataArchiv[currentArchiv][0]));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + transactionDataList.get(arrayRowCount).get(0));
                    transactionDataList.get(arrayRowCount).add(transactionDataList.get(arrayRowCount).get(0));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + transactionDataList.get(arrayRowCount).get(1));
                    double betrag = 0.0;
                    betrag = matrixArrayDataArchiv[currentArchiv].length == 4 ? Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataArchiv[currentArchiv][3], externalLogger)) : Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataArchiv[currentArchiv][2], externalLogger));
                    transactionDataList.get(arrayRowCount).add(betrag *= -1.0);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + transactionDataList.get(arrayRowCount).get(2));
                    transactionDataList.get(arrayRowCount).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + transactionDataList.get(arrayRowCount).get(3));
                    transactionDataList.get(arrayRowCount).add("EUR");
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + transactionDataList.get(arrayRowCount).get(4));
                    if (String.valueOf(betrag).indexOf("-") == -1) {
                        transactionDataList.get(arrayRowCount).add("Zahlung / \u00dcberweisung");
                    } else {
                        transactionDataList.get(arrayRowCount).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + transactionDataList.get(arrayRowCount).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataArchiv[currentArchiv][1])) {
                        String purpString = matrixArrayDataArchiv[currentArchiv][1];
                        if (matrixArrayDataArchiv[currentArchiv].length == 4 && !StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataArchiv[currentArchiv][2])) {
                            purpString = purpString + " " + matrixArrayDataArchiv[currentArchiv][2];
                        }
                        transactionDataList.get(arrayRowCount).add(purpString);
                    } else {
                        transactionDataList.get(arrayRowCount).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + transactionDataList.get(arrayRowCount).get(6));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + transactionDataList.get(arrayRowCount).get(7));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + transactionDataList.get(arrayRowCount).get(8));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + transactionDataList.get(arrayRowCount).get(9));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + transactionDataList.get(arrayRowCount).get(10));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + transactionDataList.get(arrayRowCount).get(11));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + transactionDataList.get(arrayRowCount).get(12));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + transactionDataList.get(arrayRowCount).get(13));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + transactionDataList.get(arrayRowCount).get(14));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + transactionDataList.get(arrayRowCount).get(15));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + transactionDataList.get(arrayRowCount).get(16));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + transactionDataList.get(arrayRowCount).get(17));
                    transactionDataList.get(arrayRowCount).add(currentArchiv + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + transactionDataList.get(arrayRowCount).get(18));
                    transactionDataList.get(arrayRowCount).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + transactionDataList.get(arrayRowCount).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList<ArrayList> copyUnsortedDataList = StringCharUtils.deepCopyMatrixArrayList(transactionDataList);
            ArrayList allDataDates = new ArrayList();
            Date newestBillDate = null;
            Date oldestBillDate = null;
            if (copyUnsortedDataList.size() > 0) {
                for (int i = 0; i < copyUnsortedDataList.size(); ++i) {
                    if (i == 0) {
                        allDataDates.add(copyUnsortedDataList.get(i).get(0));
                        continue;
                    }
                    if (((Date)copyUnsortedDataList.get(i).get(0)).getTime() == ((Date)copyUnsortedDataList.get(i - 1).get(0)).getTime()) continue;
                    allDataDates.add(copyUnsortedDataList.get(i).get(0));
                }
                Collections.sort(allDataDates);
                Collections.reverse(allDataDates);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "bill allDataDates.size: " + String.valueOf(allDataDates.size()));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "bill allDataDates.first: " + new SimpleDateFormat("dd.MM.yyyy").format((Date)allDataDates.get(0)));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "bill allDataDates.last: " + new SimpleDateFormat("dd.MM.yyyy").format((Date)allDataDates.get(allDataDates.size() - 1)));
            } else {
                allDataDates.add(new SimpleDateFormat("dd.MM.yyyy").parse("01.01.1977"));
            }
            if (((Date)allDataDates.get(0)).getTime() < ((Date)allDataDates.get(allDataDates.size() - 1)).getTime()) {
                newestBillDate = (Date)allDataDates.get(allDataDates.size() - 1);
                oldestBillDate = (Date)allDataDates.get(0);
            } else if (((Date)allDataDates.get(0)).getTime() > ((Date)allDataDates.get(allDataDates.size() - 1)).getTime()) {
                newestBillDate = (Date)allDataDates.get(0);
                oldestBillDate = (Date)allDataDates.get(allDataDates.size() - 1);
            } else {
                newestBillDate = (Date)allDataDates.get(0);
                oldestBillDate = (Date)allDataDates.get(0);
            }
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "newestBillDate: " + newestBillDate + " | " + newestBillDate.getTime());
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "oldestBillDate: " + oldestBillDate + " | " + oldestBillDate.getTime());
            for (int currentnext = 0; currentnext < matrixArrayDataCurrent.length; ++currentnext) {
                if (matrixArrayDataCurrent[currentnext] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCurrent[currentnext][0])) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "matrixArrayDataCurrent: Zeile Nr. " + currentnext + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                if (matrixArrayDataCurrent[currentnext][0].equals("Pending")) {
                    double thisamount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCurrent[currentnext][4], externalLogger));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "unbookedAmount at this time: " + (unbookedAmount += thisamount * -1.0));
                    continue;
                }
                String[] checkColumn = matrixArrayDataCurrent[currentnext][0].split("/");
                try {
                    float testnumber = Float.parseFloat(checkColumn[0]);
                    testnumber = Float.parseFloat(checkColumn[1]);
                    testnumber = Float.parseFloat(checkColumn[2]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + e.toString());
                    continue;
                }
                Date currentCSVdate = new SimpleDateFormat("MM/dd/yy").parse(matrixArrayDataCurrent[currentnext][0]);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "currentCSVdate: " + currentCSVdate + " | " + currentCSVdate.getTime());
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "newestBillDate: " + newestBillDate + " | " + newestBillDate.getTime());
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "oldestBillDate: " + oldestBillDate + " | " + oldestBillDate.getTime());
                if (currentCSVdate.getTime() <= newestBillDate.getTime() && currentCSVdate.getTime() >= oldestBillDate.getTime()) {
                    LogDebug.invoke((Object)LogDebug, "NewestBillDate=" + new SimpleDateFormat("dd.MM.yyyy").format(newestBillDate) + ";currentCSVdate=" + matrixArrayDataCurrent[currentnext][0] + " --- CurrentCSVdate '" + String.valueOf(currentCSVdate.getTime()) + "' soll nun kleiner oder gleich sein als NewestBillDate: '" + String.valueOf(newestBillDate.getTime()) + "' und gr\u00f6\u00dfer oder gleich sein als OldestBillDate: '" + String.valueOf(oldestBillDate.getTime()));
                    LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + "CSV-Zeile (" + matrixArrayDataCurrent[currentnext] + ") ist in PDF-Rechnung enthalten ... daher kein Auslesen... mache aber mal weiter...");
                    continue;
                }
                if (matrixArrayDataCurrent[currentnext][1].equals("HIER EINTRAGEN WAS AUSGELASSEN WERDEN SOLLTE")) continue;
                LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + "matrixArrayDataCurrent: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                try {
                    transactionDataList.add(new ArrayList());
                    transactionDataList.get(arrayRowCount).add(new SimpleDateFormat("MM/dd/yy").parse(matrixArrayDataCurrent[currentnext][0]));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + transactionDataList.get(arrayRowCount).get(0));
                    transactionDataList.get(arrayRowCount).add(transactionDataList.get(arrayRowCount).get(0));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + transactionDataList.get(arrayRowCount).get(1));
                    double betrag = matrixArrayDataCurrent[currentnext].length == 4 ? Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCurrent[currentnext][3], externalLogger)) : Double.parseDouble(StringCharUtils.parseAndFormatAmount(matrixArrayDataCurrent[currentnext][4], externalLogger));
                    transactionDataList.get(arrayRowCount).add(betrag *= -1.0);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + transactionDataList.get(arrayRowCount).get(2));
                    transactionDataList.get(arrayRowCount).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + transactionDataList.get(arrayRowCount).get(3));
                    transactionDataList.get(arrayRowCount).add("EUR");
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + transactionDataList.get(arrayRowCount).get(4));
                    if (String.valueOf(betrag).indexOf("-") == -1) {
                        transactionDataList.get(arrayRowCount).add("Zahlung / \u00dcberweisung");
                    } else {
                        transactionDataList.get(arrayRowCount).add("Abrechnung");
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + transactionDataList.get(arrayRowCount).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayDataCurrent[currentnext][1])) {
                        String purpString = "";
                        if (matrixArrayDataCurrent[currentnext].length > 4) {
                            purpString = matrixArrayDataCurrent[currentnext][1];
                        }
                        try {
                            if (matrixArrayDataCurrent[currentnext + 1].length == 1 && !matrixArrayDataCurrent[currentnext + 1][0].contains("Page ")) {
                                if (matrixArrayDataCurrent[currentnext].length > 4 && !matrixArrayDataCurrent[currentnext][1].endsWith(" ") && !matrixArrayDataCurrent[currentnext][1].endsWith("-")) {
                                    purpString = purpString + " ";
                                }
                                purpString = purpString + matrixArrayDataCurrent[currentnext + 1][0];
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        try {
                            if (matrixArrayDataCurrent[currentnext + 2].length == 1 && matrixArrayDataCurrent[currentnext + 1].length <= 1 && !matrixArrayDataCurrent[currentnext + 2][0].contains("Page ")) {
                                if (matrixArrayDataCurrent[currentnext].length > 4 && !matrixArrayDataCurrent[currentnext + 1][0].endsWith(" ") && !matrixArrayDataCurrent[currentnext + 1][0].endsWith("-")) {
                                    purpString = purpString + " ";
                                }
                                purpString = purpString + matrixArrayDataCurrent[currentnext + 2][0];
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        if (purpString.equals("PAYMENT")) {
                            purpString = "EINZAHLUNG";
                        }
                        transactionDataList.get(arrayRowCount).add(purpString);
                    } else {
                        transactionDataList.get(arrayRowCount).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + transactionDataList.get(arrayRowCount).get(6));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + transactionDataList.get(arrayRowCount).get(7));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + transactionDataList.get(arrayRowCount).get(8));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + transactionDataList.get(arrayRowCount).get(9));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + transactionDataList.get(arrayRowCount).get(10));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + transactionDataList.get(arrayRowCount).get(11));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + transactionDataList.get(arrayRowCount).get(12));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + transactionDataList.get(arrayRowCount).get(13));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + transactionDataList.get(arrayRowCount).get(14));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + transactionDataList.get(arrayRowCount).get(15));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + transactionDataList.get(arrayRowCount).get(16));
                    transactionDataList.get(arrayRowCount).add(new String());
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + transactionDataList.get(arrayRowCount).get(17));
                    transactionDataList.get(arrayRowCount).add(currentnext + 1);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + transactionDataList.get(arrayRowCount).get(18));
                    transactionDataList.get(arrayRowCount).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, WebUtils.getLogIdent(bankArt) + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + transactionDataList.get(arrayRowCount).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "needTransPurpFusion", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader(WebUtils.getShortName(bankArt), bankArt, amount, availableAmount, unbookedAmount, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

