/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute.advanziabank;

import de.derrichter.finance.websync.institute.advanziabank.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(60L));
        try {
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + WebUtils.getShortName(bankArt) + "-Login aufrufen ... (GET " + WebUtils.getLoginURL(bankArt) + ")");
            try {
                seleniumWebDriver.get(WebUtils.getLoginURL(bankArt));
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.cssSelector((String)"#usercentrics-root,#focus-lock-id".split(",")[0])));
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), "#usercentrics-root,#focus-lock-id", "button[data-testid='uc-accept-all-button']", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", externalLogger);
            if (!bankArt.equals("Tagesgeld")) {
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "callLogin", "//button[contains(@class,'login')]", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLoginResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
                }
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), "#usercentrics-root,#focus-lock-id", "button[data-testid='uc-accept-all-button']", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", externalLogger);
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"username")));
                WebElement inputUser = seleniumWebDriver.findElement(By.id((String)"username"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "inputUser: " + inputUser);
                WebElement inputPasswd = seleniumWebDriver.findElement(By.id((String)"password"));
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "inputPasswd: " + inputPasswd);
                inputUser.click();
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                inputPasswd.click();
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = null;
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitLogin", "//button[contains(@id,'login')]", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, WebUtils.getLogIdent(bankArt), WebUtils.getLongName(bankArt), WebUtils.getLogoPath(bankArt), "#usercentrics-root,#focus-lock-id", "button[data-testid='uc-accept-all-button']", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", externalLogger);
            MonitorLog.invoke((Object)MonitorLog, "Erste Login-Phase abgeschlossen, pr\u00fcfe auf Verfahren der Zwei-Faktor-Authentifizierung ...");
            try {
                WebUtils.checkTANRequest(seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
                WebUtils.checkForMTAN(seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            Thread.sleep(1000L);
            SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "after login: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            try {
                seleniumWebDriver.findElement(By.xpath((String)"//form[contains(@id,'form-login')]"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (Exception waiterror) {
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(@class,'account')]")));
                }
                catch (Exception afterloginerror) {
                    throw new Exception("Kein Kontodaten-Block gefunden (scheinbar keine Konten vorhanden): " + afterloginerror.getMessage());
                }
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage().replace(responseLogin, "*******").replace(responsePassword, "*******"));
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error).replace(responseLogin, "*******").replace(responsePassword, "*******"));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage());
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String bankArt, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(15L));
        try {
            JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
            jse.executeScript("window.scrollTo(document.body.scrollHeight,0)", new Object[0]);
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "Abmelden aufrufen durch klicken ... ");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "userMenu", "//div[contains(@class,'user-context-menu')]", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutXpath", "//button[contains(.,'Ausloggen')]", "DummyCatchString", "DummyExclutionCatchString", "//div[@id='loader' and not(contains(@style,'display: none;'))]", "Anfrage wird bearbeitet", true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            String postLogoutPage = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPage, seleniumWebDriver, bankArt, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String successLogoutXpath = "//form[contains(@id,'form-login')]";
            try {
                LogDebug.invoke((Object)LogDebug, WebUtils.getLogIdent(bankArt) + getLogMethod + "Gefundene Logout-Best\u00e4tigung: " + wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)successLogoutXpath))));
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, WebUtils.getLogIdent(bankArt) + getLogMethod + "Logout bei der '" + WebUtils.getLongName(bankArt) + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, WebUtils.getLogIdent(bankArt) + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

