/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.rabodirect;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    static String LOADER_CATCHSTRING = "DummyCatchString";
    static String LOADER_EXCLUSIONS = "DummyExclutionCatchString";
    static final String LOADER_PATH = "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]";
    static String LOADER_TEXT = "DummyLoaderText";
    protected static String[] xpathSearchString = new String[2];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[contains(@class,'mx-validation-message')]";
        WebUtils.xpathSearchString[1] = "//div[contains(@class,'modal-dialog mx-dialog')]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "den gew\u00e4hlten Zeitraum wurden keine Ums\u00e4tze gefunden";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:RaboDirect] ";
        String longName = "RaboDirect Deutschland";
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        if (responsePageAsString.contains("Wir lassen nichts anbrennen") || responsePageAsString.contains("Kurze Wartungspause")) {
            String formErrorText = StringCharUtils.formMessageText(logIdent, seleniumWebDriver.findElement(By.xpath((String)"//div[@class='compText']")).getText(), externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "errorText: " + formErrorText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der RaboDirect Deutschland:\n\n\n" + formErrorText, "institutlogo-rabodirect.png");
            throw new Exception("Webseite ist im Moment nicht verf\u00fcgbar, vermutlich aufgrund von Wartungsarbeiten. Meldung der Bank wurde angezeigt");
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-rabodirect.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }
}

