/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.rabodirect;

import de.derrichter.finance.websync.institute._archiv.rabodirect.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String accountNr, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait10 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(10L));
        boolean isSelfException = false;
        try {
            double amount;
            block66: {
                String amountText;
                LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] " + getLogMethod + "Konto\u00fcbersicht aufrufen ... (GET " + "https://www.rabodirect.de/mein-konto/AccountOverview" + ")");
                try {
                    seleniumWebDriver.get("https://www.rabodirect.de/mein-konto/AccountOverview");
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "accountspage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String pageLoginAccounts = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(pageLoginAccounts, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler auf der Konto\u00fcbersicht-Seite: " + error.getMessage());
                }
                try {
                    String dialogPath = "//div[contains(@id,'mxui_widget_Underlay')]";
                    String messagePath = "//div[contains(@id,'mxui_widget_Window')]";
                    String closeButtonPath = "//span[contains(@class,'btn-icon-close')]";
                    String readConfirmPath = "//span[text()='Ich habe die Informationen gelesen.' or text()='Als gelesen markieren']//ancestor::div//label";
                    boolean hasContinueButton = false;
                    do {
                        LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)dialogPath)));
                        LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "Dialog mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                        String warnHeader = seleniumWebDriver.findElement(By.xpath((String)(messagePath + "//h3"))).getText();
                        String formWarnText = StringCharUtils.formMessageText("[WebSync:RaboDirect] ", seleniumWebDriver.findElement(By.xpath((String)(messagePath + "//p"))).getText(), externalLogger);
                        LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "warnText: " + formWarnText);
                        DialogWarn.invoke((Object)DialogWarn, "Wichtige Meldung der RaboDirect Deutschland:\n\n\n" + warnHeader + "\n\n" + formWarnText + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://www.rabodirect.de/mein-konto" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-rabodirect.png");
                        LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                        try {
                            wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closeButtonPath)));
                        }
                        catch (NoSuchElementException | TimeoutException notAborterr) {
                            hasContinueButton = false;
                            isSelfException = true;
                            throw new Exception(warnHeader + " " + formWarnText);
                        }
                        hasContinueButton = true;
                        LogWarn.invoke((Object)LogWarn, "[WebSync:RaboDirect] Wichtige Meldung der Bank: " + formWarnText);
                        MonitorLog.invoke((Object)MonitorLog, "Wichtige Meldung der Bank: " + formWarnText);
                        try {
                            try {
                                wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)readConfirmPath)));
                                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "readCheckbox", readConfirmPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                            }
                            catch (NoSuchElementException | TimeoutException haveReadError) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] Keine Checkbox zum Best\u00e4tigen des Lesens der Information vorhanden. OK");
                            }
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "closeButton", closeButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception clickerror) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)clickerror));
                        }
                        try {
                            WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception(error.getMessage());
                        }
                    } while (hasContinueButton);
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
                }
                try {
                    wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(@id,'mxui_widget_ListView_')]")));
                }
                catch (Exception waiterror) {
                    isSelfException = true;
                    throw new Exception("Kein Konto-Block gefunden (scheinbar keine Konten vorhanden): " + waiterror.getMessage());
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "Abzurufende Kontonummer: " + StringCharUtils.banknumAddSpacesLikeIBAN(accountNr));
                try {
                    wait10.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)("//li[contains(@id,'ListViewItem_') and contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(accountNr) + "')]"))));
                }
                catch (Exception error2) {
                    isSelfException = true;
                    throw new Exception("Angegebene IBAN oder Kontodetails-Link nicht gefunden, pr\u00fcfen Sie Ihre Angaben oder melden Sie den Fehler im Forum");
                }
                String amountLinkPath = "(//li[contains(@id,'ListViewItem_') and contains(.,'" + StringCharUtils.banknumAddSpacesLikeIBAN(accountNr) + "')]//div[contains(@class,'balance')])[1]";
                amount = Double.NaN;
                try {
                    wait.until((Function)ExpectedConditions.presenceOfAllElementsLocatedBy((By)By.xpath((String)amountLinkPath)));
                    SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                    amountText = seleniumWebDriver.findElement(By.xpath((String)amountLinkPath)).getText();
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "Ausgelesener nicht formatierter RAW-Saldo aus der Seite:\n" + amountText);
                }
                catch (Exception error2) {
                    isSelfException = true;
                    throw new Exception("Auslesen des Saldo fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)error2));
                }
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "Ausgelesener und formatierter Saldo aus der Seite: " + amount);
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 25);
                try {
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "kontoDetailsLink", amountLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String accdetailResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(accdetailResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
                }
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 40);
                String downloadsectionLinkPath = "//a[contains(.,' herunterladen')]";
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadsectionLink", downloadsectionLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                try {
                    wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//a[contains(.,'CSV')]")));
                }
                catch (NoSuchElementException | TimeoutException notFounderr) {
                    if (!((WebElement)seleniumWebDriver.findElements(By.xpath((String)downloadsectionLinkPath)).get(0)).getAttribute("outerHTML").contains("btn-default")) break block66;
                    LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "Aufruf des Filter-Tab wohl fehlgeschlagen, versuche es nochmals...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadsectionLink", downloadsectionLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                }
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "setTypeCSV", "//a[contains(.,'CSV')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
            Calendar dateNow = Calendar.getInstance();
            LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "LocalDateTime.now().getHour(): " + String.valueOf(LocalDateTime.now().getHour()));
            if (LocalDateTime.now().getHour() < 3) {
                dateNow.add(5, -1);
                toDateSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date(dateNow.getTimeInMillis()));
            }
            String dateNowSimple = null;
            if (!StringCharUtils.isNullOrEmptyOrNothing(toDateSimple)) {
                dateNowSimple = toDateSimple;
            } else {
                toDateSimple = dateNowSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date(dateNow.getTimeInMillis()));
            }
            SeleniumUtils.showFormatedListOfAllWebElementsInLog(seleniumWebDriver, "//input", externalLogger);
            try {
                wait10.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(@class,'input-group date')]")));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "Aufruf des Filter-Tab wohl fehlgeschlagen, versuche es nochmals...");
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "filterLink", "//a[contains(.,'bersicht filtern')]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
            }
            WebElement fromDateField = null;
            WebElement toDateField = null;
            try {
                fromDateField = (WebElement)seleniumWebDriver.findElements(By.xpath((String)"//div[contains(@id,'BootstrapDatepicker')]//input[@placeholder='TT.MM.JJJJ']")).get(0);
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "fromDateField: " + fromDateField);
                toDateField = (WebElement)seleniumWebDriver.findElements(By.xpath((String)"//div[contains(@id,'BootstrapDatepicker')]//input[@placeholder='TT.MM.JJJJ']")).get(1);
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "toDateField: " + toDateField);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Datum-Felder nicht gefunden (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                fromDateField.sendKeys(new CharSequence[]{fromDateSimple});
                toDateField.sendKeys(new CharSequence[]{toDateSimple});
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String downloadButtonPath = "//button[contains(.,'Herunterladen')]";
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)downloadButtonPath)));
            WebElement downloadButton = seleniumWebDriver.findElement(By.xpath((String)downloadButtonPath));
            boolean downloadButtonIsEnabled = true;
            String downloadButtonHTML = downloadButton.getAttribute("outerHTML");
            LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "downloadButtonHTML: " + downloadButtonHTML);
            if (downloadButtonHTML.contains(" disabled ")) {
                downloadButtonIsEnabled = false;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "downloadButton (after Search) is enabled: " + String.valueOf(downloadButtonIsEnabled));
            if (downloadButtonIsEnabled) {
                try {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] " + getLogMethod + "click the download button and start the transactions-csv-download ...");
                    SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", downloadButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                    Thread.sleep(2000L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String downloadResponse = seleniumWebDriver.getPageSource();
                try {
                    WebUtils.checkSeleniumResponseHasError(downloadResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception(error.getMessage());
                }
                try {
                    String noTransText = "den gew\u00e4hlten Zeitraum wurden keine Ums\u00e4tze gefunden";
                    if (seleniumWebDriver.findElement(By.xpath((String)("//div[contains(.,'" + noTransText + "')]"))) != null) {
                        downloadButtonIsEnabled = false;
                    }
                }
                catch (NoSuchElementException | TimeoutException noTransText) {
                    // empty catch block
                }
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 55);
            String csvResponse = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der RaboDirect Deutschland\n\n\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nAnzahl der Transaktionen:;0\nKontostand:;" + amount + "\n\nBuchungsdatum;Valutadatum;Transaktion;Absender / Empf\u00e4nger;Verwendungszweck;Betrag\nIm gew\u00e4hltem Abrufzeitraum sind keine Transaktionen vorhanden";
            if (downloadButtonIsEnabled) {
                File downloadedFile = null;
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                do {
                    Thread.sleep(500L);
                    int waiter = 0;
                    do {
                        if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                        Thread.sleep(1000L);
                        ++waiter;
                    } while (downloadedFile == null && waiter < 30);
                    if (downloadedFile != null && downloadedFile.exists()) continue;
                    isSelfException = true;
                    throw new Exception("Download des Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                String fileResponse = "";
                String fileencoding = "UTF-8";
                fileResponse = new String(FileUtils.readFileToString((File)downloadedFile, (Charset)Charset.forName(fileencoding)));
                LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + fileResponse + "\n======================= END DATA =======================\n");
                if (!fileencoding.equals("UTF-8")) {
                    LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] " + getLogMethod + "CSV-Datei mit Zeichen-Codierung '" + fileencoding + "' auslesen und zu System-Codierung '" + System.getProperty("file.encoding") + "' konvertieren...");
                    byte[] filebytes = fileResponse.getBytes(Charset.forName(fileencoding));
                    csvResponse = new String(filebytes, System.getProperty("file.encoding"));
                } else {
                    csvResponse = fileResponse;
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "deleting downloaded transactions-file ...");
                FileSysUtils.forceDeleteTarget(downloadedFile);
            }
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 65);
            String[] dataResponse = new String[]{csvResponse, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(csvResponse, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] Erste Spalte dieser Zeile: " + matrixArrayData[i][0]);
                    String[] CheckColumn = matrixArrayData[i][0].split("-");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].substring(0, 10).split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[0], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[2], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].substring(0, 10).split("-");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[0], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[2], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][3]).replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim());
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][7])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][7].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String csvKonto = "";
                    String csvBLZ = "";
                    String csvIBAN = "";
                    String csvBic = "";
                    String csvName = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        csvIBAN = matrixArrayData[i][5].replaceAll("\\s+", "");
                        csvBLZ = csvIBAN.substring(4, 12);
                        csvKonto = csvIBAN.substring(12);
                        csvName = !csvKonto.equals(accountNr.replaceAll("\\s+", "")) ? StringCharUtils.shrinkString(matrixArrayData[i][6]) : "RaboDirect";
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(csvIBAN);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(csvBic);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(csvName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(csvKonto);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(csvBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    if (!matrixArrayData[i][4].equals("EUR")) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add("W\u00e4hrung: " + matrixArrayData[i][4]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][8])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][8].replaceAll("Reference: ", ""));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("RaboDirect", accountNr, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

