/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.rabodirect;

import de.derrichter.finance.websync.institute._archiv.rabodirect.WebUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] " + getLogMethod + "RaboDirect" + "-Login aufrufen ... (GET " + "https://www.rabodirect.de/mein-konto" + ")");
            try {
                seleniumWebDriver.get("https://www.rabodirect.de/mein-konto");
                SeleniumUtils.waitForPageLoading(seleniumWebDriver, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            String cookieDetectPath = "//button[@id='ppms_cm_save-choices']";
            String cookieAcceptPath = "//button[@id='ppms_cm_save-choices']";
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:RaboDirect] ", "RaboDirect Deutschland", "institutlogo-rabodirect.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, externalLogger);
            cookieDetectPath = "//div[contains(@class,'announcementBanner')]//button";
            cookieAcceptPath = "//button[contains(@class,'announcementBanner')]";
            SeleniumUtils.closeCookieLaw(seleniumWebDriver, "[WebSync:RaboDirect] ", "RaboDirect Deutschland", "institutlogo-rabodirect.png", cookieDetectPath, cookieAcceptPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, externalLogger);
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//input[@placeholder='Hier Benutzernummer eingeben']")));
                WebElement inputUser = seleniumWebDriver.findElement(By.xpath((String)"//input[@placeholder='Hier Benutzernummer eingeben']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "inputUser: " + inputUser);
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                Thread.sleep(500L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Benutzer-Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "(//button[contains(.,'Weiter')])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLogin2Response = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLogin2Response, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//input[@placeholder='Hier Zufallscode eingeben']")));
                WebElement inputPasswd = seleniumWebDriver.findElement(By.xpath((String)"//input[@placeholder='Hier Zufallscode eingeben']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "inputPasswd: " + inputPasswd);
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                Thread.sleep(500L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Passwort-Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "submitContinue", "(//button[contains(.,'Anmelden')])[1]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageAfterLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageAfterLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//li[contains(@id,'ListViewItem_')]")));
                pageLogin2Response = seleniumWebDriver.getPageSource();
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogError.invoke((Object)LogError, "[WebSync:RaboDirect] Konto\u00fcbersicht nicht gefunden. Eventuell unbekannte Zwischenseite. Bitte im Online-Banking pr\u00fcfen. Ansonsten im Forum melden.");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:RaboDirect] " + getLogMethod + "after login: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            try {
                WebElement checkLoginField = seleniumWebDriver.findElement(By.xpath((String)"//input[@placeholder='Hier 8-stelligen Zufallscode eingeben.']"));
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            catch (NoSuchElementException | TimeoutException throwable) {
                return seleniumWebDriver;
            }
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:RaboDirect] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage());
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] " + getLogMethod + "Abmelden von der Onlinebanking-Website ...");
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "logoutButton", "(//a[contains(@class,'mxLogout')])[2]", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, "//div[(contains(@class,'loading') or @id='ppms_spinner' or @id='mx-progress') and not(contains(@style,'none')) and not(contains(@class,'removeLoading'))]", WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                String logoutPageXML = seleniumWebDriver.getPageSource();
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPageXML = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPageXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            if (!postLogoutPageXML.contains("Ihre Abmeldung war erfolgreich") && !postLogoutPageXML.contains("Vielen Dank f\u00fcr Ihr Online-Banking mit RaboDirect")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:RaboDirect] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:RaboDirect] " + getLogMethod + "Logout bei der '" + "RaboDirect Deutschland" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:RaboDirect] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

