/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.psadirektbank;

import de.derrichter.finance.websync.institute._archiv.psadirektbank.WebUtils;
import de.derrichter.finance.websync.utils.FileSysUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String kontonummer, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        WebDriverWait wait1 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(1L));
        WebDriverWait wait30 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        boolean isSelfException = false;
        try {
            try {
                String messagePath = "//*[@id='datenabgleich' or contains(@class,'modal-dialog')]";
                String closeButtonPath = "//*[contains(@id,'btnClose')]";
                boolean hasAbortButton = false;
                do {
                    LogInfo.invoke((Object)LogInfo, "Pr\u00fcfen ob etwas best\u00e4tigt werden muss...");
                    wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)messagePath)));
                    LogDebug.invoke((Object)LogDebug, getLogMethod + "Zwischenseite mit Bank-Meldung erkannt die best\u00e4tigt werden muss...");
                    String formWarnText = "";
                    List allHeadlines = seleniumWebDriver.findElements(By.xpath((String)(messagePath + "//span//span")));
                    for (WebElement headline : allHeadlines) {
                        String headlinetext = headline.getText();
                        formWarnText = formWarnText + StringCharUtils.formMessageText("[WebSync:PSADirektbank] ", headlinetext, externalLogger) + " ";
                    }
                    LogDebug.invoke((Object)LogDebug, getLogMethod + "warnText: " + formWarnText);
                    DialogWarn.invoke((Object)DialogWarn, "Meldung der PSA Direktbank:\n\n\n" + formWarnText.trim() + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://www.psa-direktbank.de/services_cloud/portal/" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-psadirektbank.png");
                    LogDebug.invoke((Object)LogDebug, getLogMethod + "Pr\u00fcfen ob diese Meldung aber direkt automatisch \u00fcbersprungen werden kann...");
                    try {
                        wait1.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)closeButtonPath)));
                    }
                    catch (NoSuchElementException | TimeoutException notAborterr) {
                        hasAbortButton = false;
                        isSelfException = true;
                        throw new Exception("Meldung(en) der Bank: " + formWarnText.trim());
                    }
                    hasAbortButton = true;
                    LogWarn.invoke((Object)LogWarn, "Meldung(en) der Bank: " + formWarnText);
                    MonitorLog.invoke((Object)MonitorLog, "Meldung(en) der Bank: " + formWarnText);
                    try {
                        SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "abortButton", "//button[@id='abort_button']", WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                    }
                    try {
                        WebUtils.checkSeleniumResponseHasError(seleniumWebDriver.getPageSource(), seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
                    }
                    catch (Exception error) {
                        isSelfException = true;
                        throw new Exception(error.getMessage());
                    }
                } while (hasAbortButton);
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:PSADirektbank] Keine Meldung erkannt und kein Button zum akzeptieren vorhanden. OK");
            }
            String transLinkPath = "(//a[contains(.,'Ums\u00e4tze')])[2]";
            try {
                wait30.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)transLinkPath)));
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                isSelfException = true;
                LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "xPathExpression " + transLinkPath + " ergab kein Ergebnis");
                throw new Exception("Button zur Umsatzanzeige nicht gefunden.  (Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)");
            }
            try {
                SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "translistButton", transLinkPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            Thread.sleep(2000L);
            String transPageSource = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(transPageSource, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            double amount = Double.NaN;
            try {
                String amountText = seleniumWebDriver.findElement(By.xpath((String)"//span[contains(@class,'right-sum')]")).getText();
                LogTrace.invoke((Object)LogTrace, getLogMethod + "amountText: " + amountText);
                amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
                LogDebug.invoke((Object)LogDebug, getLogMethod + "Amount: " + String.valueOf(amount));
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Auslesen des 'Konto-Saldo' fehlgeschlagen: " + error.getMessage());
            }
            double availableAmount = amount;
            try {
                String fromInputPath = "//input[@id='contentForm:inbox-datetimepicker-start']";
                String toInputPath = "//input[@id='contentForm:inbox-datetimepicker-end']";
                String filterButtonPath = "//a[contains(.,'Anzeigen')]";
                seleniumWebDriver = SeleniumUtils.fillDateRangeSearchFields(seleniumWebDriver, getLogMethod, "PSA Direktbank", "institutlogo-psadirektbank.png", fromDateSimple, toDateSimple, fromInputPath, toInputPath, filterButtonPath, false, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception searchError) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)searchError));
            }
            String searchPageSource = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(searchPageSource, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der PSA Direktbank\n\n\nDatum des Auszugs:;" + new Date() + "\nKontonummer:;" + kontonummer + "\nKontostand:;" + amount + "\n";
            boolean haveNewTrans = false;
            try {
                if (seleniumWebDriver.findElement(By.xpath((String)"//section[contains(.,'Zeitraum sind keine Ums\u00e4tze vorhanden')]")) != null) {
                    transData = transData + "\nDatum;Beschreibung;Betrag EUR\nIm Abrufzeitraum sind keine aktuellen Transaktionen vorhanden";
                }
            }
            catch (Exception waiterror) {
                haveNewTrans = true;
                LogDebug.invoke((Object)LogDebug, "[WebSync:PSADirektbank] xpath //section[contains(.,'Zeitraum sind keine Ums\u00e4tze vorhanden')] NICHT gefunden; Es sollten neue Transaktionen vorhanden sein ...");
            }
            File downloadedFile = null;
            String doctext = null;
            String doctype = "???";
            boolean localTest = false;
            if (localTest) {
                haveNewTrans = true;
                String docFixTempFilePath = "C:\\Users\\richs\\Desktop\\Kontoauszug.xlsx";
                downloadedFile = new File(docFixTempFilePath);
            }
            if (haveNewTrans) {
                boolean downloadedFileIsFalse = false;
                int downloadCount = 1;
                do {
                    if (!localTest) {
                        String downloadButtonPath = "//a[contains(@data-wt,'excel-download')]";
                        WebElement downloadButton = seleniumWebDriver.findElement(By.xpath((String)downloadButtonPath));
                        JavascriptExecutor jse = (JavascriptExecutor)seleniumWebDriver;
                        jse.executeScript("arguments[0].scrollIntoView(true);", new Object[]{downloadButton});
                        try {
                            SeleniumUtils.clickElementHandleErrors(seleniumWebDriver, "downloadButton", downloadButtonPath, WebUtils.LOADER_CATCHSTRING, WebUtils.LOADER_EXCLUSIONS, WebUtils.LOADER_PATH, WebUtils.LOADER_TEXT, true, externalLogger);
                        }
                        catch (Exception error) {
                            isSelfException = true;
                            throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                        }
                        LogDebug.invoke((Object)LogDebug, "[WebSync:PSADirektbank] " + getLogMethod + "Warte auf die Fertigstellung des Downloads des Kontoauszugs ...");
                        do {
                            Thread.sleep(500L);
                            int waiter = 0;
                            do {
                                if ((downloadedFile = FileSysUtils.lastFileModified(System.getProperty("selenium.downloads.path"))) != null) continue;
                                Thread.sleep(1000L);
                                ++waiter;
                            } while (downloadedFile == null && waiter < 30);
                            if (downloadedFile != null && downloadedFile.exists()) continue;
                            isSelfException = true;
                            throw new Exception("Download eines Kontoauszuges nicht erfolgreich! (=NULL); Blockiert ein Sicherheitsprogramm? Ausnahmen f\u00fcr die Pfade: '" + System.getProperty("chromium.root.path") + "' und '" + System.getProperty("selenium.downloads.path") + "' eintragen");
                        } while (downloadedFile.getAbsolutePath().endsWith(".crdownload") || downloadedFile.getAbsolutePath().endsWith(".tmp"));
                    }
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PSADirektbank] " + getLogMethod + "downloaded file: " + downloadedFile.getAbsolutePath());
                    doctype = downloadedFile.getAbsolutePath().substring(downloadedFile.getAbsolutePath().lastIndexOf(".") + 1).toUpperCase();
                    if (doctype.toLowerCase().equals("txt") || doctype.toLowerCase().equals("htm") || doctype.toLowerCase().equals("html") || doctype.toLowerCase().equals("asp") || doctype.toLowerCase().equals("js")) {
                        LogWarn.invoke((Object)LogDebug, "[WebSync:PSADirektbank] " + getLogMethod + "wrong downloaded file: " + downloadedFile.getAbsolutePath() + " / Falscher Dateityp, versuche es nochmals ...");
                        ++downloadCount;
                        downloadedFileIsFalse = true;
                    } else {
                        downloadedFileIsFalse = false;
                    }
                    if (downloadCount < 4) continue;
                    isSelfException = true;
                    throw new Exception("Fehler beim Download des Kontoauszugs, es wird immer ein falsches Dokument geliefert: Typ: " + doctype);
                } while (downloadedFileIsFalse);
                FileInputStream fis = new FileInputStream(downloadedFile);
                HSSFWorkbook workbook = new HSSFWorkbook((InputStream)fis);
                LogDebug.invoke((Object)LogDebug, "[WebSync:PSADirektbank] " + getLogMethod + "[workbook " + doctype + "-FILE]: " + workbook);
                LogDebug.invoke((Object)LogDebug, "[WebSync:PSADirektbank] " + getLogMethod + "Erzeuge einen Kontoauszug aus dem " + doctype + "-Dokument ...");
                try {
                    HSSFSheet sheet = workbook.getSheetAt(0);
                    for (Row row : sheet) {
                        Iterator cellIterator = row.cellIterator();
                        while (cellIterator.hasNext()) {
                            Cell cell = (Cell)cellIterator.next();
                            doctext = doctext + StringCharUtils.shrinkString(cell.toString()) + ";";
                        }
                        doctext = doctext + "\n";
                    }
                    workbook.close();
                    fis.close();
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Beim Lesen der hat es Fehler gegeben (siehe Log)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "getDataExport: soeben abgeholte und ausgelesene " + doctype + "-Rechnung (text): \n" + doctext);
                if (!localTest) {
                    LogDebug.invoke((Object)LogDebug, "[WebSync:PSADirektbank] " + getLogMethod + "deleting downloaded transactions-file ...");
                    FileSysUtils.forceDeleteTarget(downloadedFile);
                }
                LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "fileResponse: \n\n====================== BEGIN DATA ======================\n" + doctext + "\n======================= END DATA =======================\n");
                transData = doctext;
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transData: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            String[] dataResponse = new String[]{transData, String.valueOf(amount)};
            String[][] transDataArray = StringCharUtils.data2matrixArray(transData.replace("\"", ""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < transDataArray.length; ++i) {
                if (transDataArray[i] == null || StringCharUtils.isNullOrEmptyOrNothing(transDataArray[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transDataArray: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = transDataArray[i][0].split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] transDataArray: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = transDataArray[i][0].split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = transDataArray[i][1].split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble(StringCharUtils.parseAndFormatAmount(transDataArray[i][4], externalLogger)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(transDataArray[i][2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(transDataArray[i][3]));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + StringCharUtils.shrinkString(((ArrayList)transactionDataList.get(arrayRowCount)).get(12).toString()));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:PSADirektbank] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("PSADirektbank", kontonummer, amount, availableAmount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

