/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.moneyou;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.HTMLUnitUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.htmlunit.Page;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    protected static String[] xpathSearchString = new String[1];
    protected static String[] xpathSearchStringExclusion = new String[2];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "//div[contains(@class,'validation-summary-errors') or contains(@class,'alert')]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Hier k\u00f6nnen Sie sich Ihre Kontoums\u00e4tze anzeigen lassen";
        WebUtils.xpathSearchStringExclusion[1] = "Es wurden keine Daten gefunden";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method DialogWarn = externalDialogInterface.getMethod("warn", String.class, String.class);
        String logIdent = "[WebSync:MoneYou] ";
        String longName = "MoneYou (ABN AMRO Bank)";
        String getLogMethod = "[checkSeleniumResponseHasError] ";
        if (responsePageAsString.contains("aus gesetzlichen Gr\u00fcnden") || responsePageAsString.contains("pers\u00f6nlichen Daten auf Aktualit\u00e4t zu \u00fcberpr\u00fcfen")) {
            String formText = StringCharUtils.formMessageText(logIdent, seleniumWebDriver.findElement(By.xpath((String)"//div[@class='myPageheader']//p")).getText(), externalLogger);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "errorText: " + formText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der MoneYou (ABN AMRO Bank):\n\n\n" + formText + "\n\nBitte melden Sie sich am Online-Banking unter\n" + "https://www.moneyou.de/personalpage/login" + "\nan und best\u00e4tigen Sie diese Meldung(en).", "institutlogo-moneyou.png");
            throw new Exception(formText.trim());
        }
        if (responsePageAsString.contains("SEHR GEEHRTE KUNDEN")) {
            int MsgIDXstartMain = responsePageAsString.indexOf("SEHR GEEHRTE KUNDEN");
            int MsgIDXstart = responsePageAsString.indexOf("\">", MsgIDXstartMain) + 2;
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "MsgIDXstart: " + MsgIDXstart);
            int MsgIDXend = responsePageAsString.indexOf("</b>", MsgIDXstart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "MsgErrorIDXend: " + MsgIDXend);
            String formErrorText = "SEHR GEEHRTE KUNDEN,</b><br><br>" + responsePageAsString.substring(MsgIDXstart, MsgIDXend);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "errorText: " + formErrorText);
            DialogWarn.invoke((Object)DialogWarn, "Meldung der MoneYou (ABN AMRO Bank):\n\n\n" + formErrorText, "institutlogo-moneyou.png");
            throw new Exception("Webseite ist im Moment nicht verf\u00fcgbar, vermutlich aufgrund von Wartungsarbeiten. Meldung der Bank wurde angezeigt");
        }
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-moneyou.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static void checkHTMLUnitResponseHasError(String pageResponse, Page currentPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:MoneYou] ";
        String longName = "MoneYou (ABN AMRO Bank)";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            HTMLUnitUtils.checkHTMLUnitWebClientResponse(pageResponse, currentPage, logIdent, longName, "institutlogo-moneyou.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }
}

