/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.moneyou;

import de.derrichter.finance.websync.institute._archiv.moneyou.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import de.jost_net.OBanToo.SEPA.IBAN;
import de.jost_net.OBanToo.SEPA.Land.SEPALand;
import de.jost_net.OBanToo.SEPA.SEPAException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPull {
    public static ArrayList getTransData(WebDriver seleniumWebDriver, String accountNr, String fromDateSimple, String toDateSimple, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(30L));
        WebDriverWait wait2 = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(2L));
        try {
            String amountText;
            WebElement kontoDetailsLink;
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//a[@href='/persoenlicheseite/tagesgeld']")));
            WebElement accountsListURL = seleniumWebDriver.findElement(By.xpath((String)"//a[@href='/persoenlicheseite/tagesgeld']"));
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "Click " + accountsListURL);
            try {
                accountsListURL.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "accountsList: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//div[contains(@id,'savingsAccountBlock')]")));
            }
            catch (Exception waiterror) {
                isSelfException = true;
                throw new Exception("Kein Tagesgeldkonto-Block gefunden (scheinbar keine Konten vorhanden): " + waiterror.getMessage());
            }
            try {
                kontoDetailsLink = seleniumWebDriver.findElement(By.xpath((String)("//a[contains(@id,'lnkSADetail_') and contains(@id,'" + accountNr + "')]")));
            }
            catch (Exception error2) {
                isSelfException = true;
                throw new Exception("Angegebene Kontonummer oder Kontodetails-Link nicht gefunden, pr\u00fcfen Sie Ihre Angaben oder melden Sie den Fehler im Forum");
            }
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "Click " + kontoDetailsLink);
                kontoDetailsLink.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "account-details: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String accdetailResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(accdetailResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            double amount = Double.NaN;
            try {
                amountText = seleniumWebDriver.findElement(By.xpath((String)"//div[@class='myEm mynofloat']")).getText();
                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "Ausgelesener nicht formatierter RAW-Saldo aus der Seite:\n" + amountText);
            }
            catch (Exception error2) {
                isSelfException = true;
                throw new Exception("Auslesen des Saldo fehlgeschlagen: " + ExceptionUtils.getStackTrace((Throwable)error2));
            }
            amount = Double.parseDouble(StringCharUtils.parseAndFormatAmount(amountText, externalLogger));
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "Ausgelesener und formatierter Saldo aus der Seite: " + amount);
            String accountTitle = null;
            String accountIBAN = null;
            try {
                accountTitle = seleniumWebDriver.findElement(By.xpath((String)"(//div[@class='myPageheader']/h1)")).getText();
                accountIBAN = seleniumWebDriver.findElement(By.xpath((String)"(//div[@class='myPageheader']/div)")).getText();
            }
            catch (Exception error1) {
                isSelfException = true;
                throw new Exception("Auslesen des Titel und IBAN fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error1));
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "Kontotitel: " + accountTitle + "   IBAN: " + accountIBAN);
            MonitorSetPercent.invoke((Object)MonitorSetPercent, 30);
            int transactionsCount = 0;
            String transDataRows = "";
            boolean haveTransSection = false;
            List dataBlock = null;
            try {
                dataBlock = seleniumWebDriver.findElement(By.id((String)"transferResults")).findElements(By.xpath((String)".//div[@data-panelid='pnlTransactionDetail']"));
                haveTransSection = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (haveTransSection) {
                LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] zuk\u00fcnftige Transaktionen auslesen die bereits angezeigt werden und wohl schon im Kontosaldo sind...");
                for (WebElement rawTransaction : dataBlock) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "raw text from future-transaction to check:\n" + rawTransaction.getText());
                    String Buchungsdatum = rawTransaction.getAttribute("data-transactiondate").trim();
                    String Valuta = rawTransaction.getAttribute("data-interestdate").trim();
                    String Umsatzart = rawTransaction.getAttribute("data-transactiontext").trim();
                    String Empfaengername = rawTransaction.getAttribute("data-totitle").trim();
                    String EmpfaengerIBAN = rawTransaction.getAttribute("data-toiban").trim();
                    String Sendername = rawTransaction.getAttribute("data-fromtitle").trim();
                    String SenderIBAN = rawTransaction.getAttribute("data-fromiban").trim();
                    String Verwendungszweck = rawTransaction.getAttribute("data-comment").replace(";", ",").trim();
                    Object Betrag = rawTransaction.getAttribute("data-amount").trim();
                    if (rawTransaction.getAttribute("class").contains("myNegative")) {
                        Betrag = "-" + (String)Betrag;
                    }
                    long currentDate = new Date().getTime();
                    long transDate = new SimpleDateFormat("dd.MM.yyyy").parse(Buchungsdatum).getTime();
                    if (transDate > currentDate) {
                        transDataRows = transDataRows + Buchungsdatum + ";" + Valuta + ";" + Umsatzart + ";" + Empfaengername + ";" + EmpfaengerIBAN + ";" + Sendername + ";" + SenderIBAN + ";" + Verwendungszweck + ";" + (String)Betrag + "\n";
                        transactionsCount = transactionsCount++;
                        continue;
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "this transaction is not in the future, abort ..." + rawTransaction);
                    break;
                }
                WebElement filterFormField = seleniumWebDriver.findElement(By.id((String)"lnkSavingsAccountFilter"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "filterFormField: " + filterFormField);
                filterFormField.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1000L);
                String dateNowSimple = null;
                if (!StringCharUtils.isNullOrEmptyOrNothing(toDateSimple)) {
                    dateNowSimple = toDateSimple;
                } else {
                    toDateSimple = dateNowSimple = new SimpleDateFormat("dd.MM.yyyy").format(new Date());
                }
                WebElement fromDateField = seleniumWebDriver.findElement(By.id((String)"FilterPeriodMin"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "fromDateField: " + fromDateField);
                WebElement toDateField = seleniumWebDriver.findElement(By.id((String)"FilterPeriodMax"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "toDateField: " + toDateField);
                try {
                    fromDateField.click();
                    fromDateField.sendKeys(new CharSequence[]{fromDateSimple});
                    toDateField.click();
                    toDateField.sendKeys(new CharSequence[]{toDateSimple});
                    Thread.sleep(1000L);
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Fehler beim setzen der Abrufzeitraum-Werte oder des Anfordern-Button (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                WebElement searchButton = seleniumWebDriver.findElement(By.xpath((String)"//button[contains(text(),'Suchen')]"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "searchButton: " + searchButton);
                if (searchButton == null) {
                    isSelfException = true;
                    throw new Exception("Der Suchen-Button bzw. Filtern-Button konnte nicht gefunden werden! (Null)");
                }
                try {
                    searchButton.click();
                    SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "searchButton.click: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
                String dataPageResponse = seleniumWebDriver.getPageSource();
                MonitorSetPercent.invoke((Object)MonitorSetPercent, 45);
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"transferResults")));
                WebElement transferResults = seleniumWebDriver.findElement(By.id((String)"transferResults"));
                WebElement noTransferResults = seleniumWebDriver.findElement(By.id((String)"noTransferResults"));
                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "style of transferResults (after Search): " + transferResults.getAttribute("style"));
                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "style of noTransferResults (after Search): " + noTransferResults.getAttribute("style"));
                if (noTransferResults.getAttribute("style").equals("display: block;") || transferResults.getAttribute("style").equals("display: none;")) {
                    transDataRows = transDataRows + "Im gew\u00e4hltem Abrufzeitraum sind keine Transaktionen vorhanden";
                } else {
                    try {
                        wait2.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.id((String)"LoadMoreButton")));
                        WebElement loadMoreArea = seleniumWebDriver.findElement(By.id((String)"LoadMoreButton"));
                        while (!loadMoreArea.getAttribute("style").equals("display: none;")) {
                            WebElement loadMoreButton = seleniumWebDriver.findElement(By.id((String)"btnShowMore"));
                            loadMoreButton.click();
                            SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                        }
                    }
                    catch (NoSuchElementException | TimeoutException notFounderr) {
                        LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] Kein Button  zum Anzeigen weiterer Transaktionen vorhanden");
                    }
                    dataBlock = seleniumWebDriver.findElement(By.id((String)"transferResults")).findElements(By.xpath((String)".//div[@data-panelid='pnlTransactionDetail']"));
                    int datacount = ((ArrayList)dataBlock).size();
                    int dataround = 0;
                    for (WebElement rawTransaction : dataBlock) {
                        double MonitorPercent = 45.0 + 30.0 / (double)datacount * (double)(dataround + 1);
                        MonitorSetPercent.invoke((Object)MonitorSetPercent, (int)MonitorPercent);
                        ++dataround;
                        LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "raw text from transaction to read:\n" + rawTransaction.getText());
                        String buchungsdatum = rawTransaction.getAttribute("data-transactiondate").trim();
                        String valuta = rawTransaction.getAttribute("data-interestdate").trim();
                        String umsatzart = rawTransaction.getAttribute("data-transactiontext").trim();
                        String empfaengername = rawTransaction.getAttribute("data-totitle").trim();
                        String empfaengerIBAN = rawTransaction.getAttribute("data-toiban").trim();
                        String sendername = rawTransaction.getAttribute("data-fromtitle").trim();
                        String senderIBAN = rawTransaction.getAttribute("data-fromiban").trim();
                        String verwendungszweck = rawTransaction.getAttribute("data-comment").replace(";", ",").trim();
                        String betrag = rawTransaction.getAttribute("data-amount").trim();
                        if (rawTransaction.getAttribute("class").contains("myNegative")) {
                            betrag = "-" + betrag;
                        }
                        long getDateTime = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple).getTime();
                        long buchungsDateTime = new SimpleDateFormat("dd.MM.yyyy").parse(buchungsdatum).getTime();
                        if (buchungsDateTime < getDateTime) {
                            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "Buchungsdatum '" + buchungsdatum + "' au\u00dferhalb des Abrufzeitraums, daher keine weitere Verarbeitung");
                            break;
                        }
                        transDataRows = transDataRows + buchungsdatum + ";" + valuta + ";" + umsatzart + ";" + empfaengername + ";" + empfaengerIBAN + ";" + sendername + ";" + senderIBAN + ";" + verwendungszweck + ";" + betrag + "\n";
                        transactionsCount = transactionsCount++;
                    }
                }
            }
            String transData = "Automatisch generierter Kontoauszug f\u00fcr ein Konto der MoneYou (ABN AMRO Bank)\n\n\nKontotitel:;" + accountTitle + "\nIBAN:;" + accountIBAN + "\nDatum des Auszugs:;" + new Date() + "\nZeitraum:;" + fromDateSimple + " bis " + toDateSimple + "\nAnzahl der Transaktionen:;" + String.valueOf(transactionsCount) + "\nKontostand:;" + String.valueOf(amount) + "\n\nBuchungsdatum;Valutadatum;Umsatzart;Empf\u00e4nger Name;Empf\u00e4nger IBAN;Absender Name;Absender IBAN;Verwendungszweck;Betrag\n" + transDataRows;
            LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "TransData: \n\n====================== BEGIN DATA ======================\n" + transData + "\n======================= END DATA =======================\n");
            String[] dataResponse = new String[]{transData, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(transData, '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].trim().split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    String[] CheckColumn2 = matrixArrayData[i][1].trim().split("\\.");
                    float testnumber2 = Float.parseFloat(CheckColumn2[0]);
                    testnumber2 = Float.parseFloat(CheckColumn2[1]);
                    testnumber2 = Float.parseFloat(CheckColumn2[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    SEPALand land;
                    IBAN iban;
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][0].trim().split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][1].trim().split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(matrixArrayData[i][8].replaceAll("\\.", "").replace(",", "."));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][2])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][2].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][7])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][7].replaceAll("\\<.*?\\>", "")));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(StringCharUtils.shrinkString(matrixArrayData[i][2].replaceAll("\\<.*?\\>", "")));
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String toTitle = matrixArrayData[i][3].trim();
                    String toIBAN = matrixArrayData[i][4].replaceAll("\\s+", "").trim();
                    String fromTitle = matrixArrayData[i][5].trim();
                    String fromIBAN = matrixArrayData[i][6].replaceAll("\\s+", "").trim();
                    String gegenkontoName = "";
                    String gegenkontoIBAN = "";
                    String gegenkontoNR = "";
                    String gegenkontoBLZ = "";
                    if (!fromTitle.equals(accountTitle.trim()) && !fromIBAN.equals(accountIBAN.replaceAll("\\s+", "").trim())) {
                        iban = null;
                        try {
                            iban = new IBAN(fromIBAN);
                        }
                        catch (SEPAException error) {
                            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "new IBAN error (set iban as useraccount-nr): " + error.getMessage());
                            gegenkontoNR = fromIBAN;
                        }
                        if (iban != null) {
                            land = iban.getLand();
                            if (land.getBankIdentifierLength() == null) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] length of bank identifier unknown for this country, set iban as useraccount-nr");
                                gegenkontoNR = fromIBAN;
                            } else {
                                gegenkontoNR = iban.getKonto();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "Kontonummer aus IBAN: " + gegenkontoNR);
                                gegenkontoBLZ = iban.getBLZ();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "BLZ aus IBAN: " + gegenkontoBLZ);
                            }
                        }
                        gegenkontoName = fromTitle;
                        gegenkontoIBAN = fromIBAN;
                    } else if (!toTitle.equals(accountTitle.trim()) && !toIBAN.equals(accountIBAN.replaceAll("\\s+", "").trim())) {
                        iban = null;
                        try {
                            iban = new IBAN(toIBAN);
                        }
                        catch (SEPAException error) {
                            gegenkontoNR = toIBAN;
                            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "new IBAN error (set iban as useraccount-nr): " + error.getMessage());
                        }
                        if (iban != null) {
                            land = iban.getLand();
                            if (land.getBankIdentifierLength() == null) {
                                LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] length of bank identifier unknown for this country, set iban as useraccount-nr");
                                gegenkontoNR = toIBAN;
                            } else {
                                gegenkontoNR = iban.getKonto();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "Kontonummer aus IBAN: " + gegenkontoNR);
                                gegenkontoBLZ = iban.getBLZ();
                                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "BLZ aus IBAN: " + gegenkontoBLZ);
                            }
                        }
                        gegenkontoName = toTitle;
                        gegenkontoIBAN = toIBAN;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoIBAN);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNR);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, true, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("MoneYou", accountNr, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

