/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.moneyou;

import de.derrichter.finance.websync.institute._archiv.moneyou.WebUtils;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlPage;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebAuth {
    public static WebDriver loginWithSelenium(String responseLogin, String responsePassword, WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        WebDriverWait wait = new WebDriverWait(seleniumWebDriver, Duration.ofSeconds(60L));
        try {
            WebElement submitContinue;
            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "MoneYou-Login aufrufen ... (GET " + "https://www.moneyou.de/personalpage/login" + ")");
            try {
                seleniumWebDriver.get("https://www.moneyou.de/personalpage/login");
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "loginpage: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLoginResponse = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLoginResponse, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler auf der Login-Seite: " + error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//form[@class='possiblewaiterform']")));
                WebElement formLogin = seleniumWebDriver.findElement(By.xpath((String)"//form[@class='possiblewaiterform']"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "formLogin: " + formLogin);
                WebElement inputUser = formLogin.findElement(By.name((String)"UserId"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "inputUser: " + inputUser);
                WebElement inputPasswd = formLogin.findElement(By.name((String)"Password"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "inputPasswd: " + inputPasswd);
                submitContinue = formLogin.findElement(By.xpath((String)"//button[contains(text(),'Anmelden')]"));
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "submitContinue: " + submitContinue);
                inputUser.sendKeys(new CharSequence[]{responseLogin});
                inputPasswd.sendKeys(new CharSequence[]{responsePassword});
                Thread.sleep(1000L);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            try {
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "click on the login-button ....");
                submitContinue.click();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "loginpage2 after login-click: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String pageLogin2Response = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(pageLogin2Response, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            try {
                wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)"//a[@id='lnk_Tagesgeld']")));
                pageLogin2Response = seleniumWebDriver.getPageSource();
            }
            catch (NoSuchElementException | TimeoutException notFounderr) {
                LogError.invoke((Object)LogError, "[WebSync:MoneYou] Tagesgeld-Link nicht gefunden.");
            }
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "after login: current webdriver hash: " + seleniumWebDriver.getWindowHandle().hashCode());
            if (pageLogin2Response.contains("<button id=\"btnLoginConfirm\"")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            return seleniumWebDriver;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:MoneYou] " + getLogMethod + "Fehlermeldung/Exception des Systems:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("Fehlermeldung des Systems: " + error.getMessage());
        }
    }

    public static HtmlPage loginWithHTMLUnit(String responseLogin, String responsePassword, WebClient syncWebClient, String optionalOptions, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method DialogWarn = ExternalDialogInterface.getMethod("warn", String.class, String.class);
        Method DialogError = ExternalDialogInterface.getMethod("error", String.class, String.class);
        if (responsePassword.length() > 12) {
            DialogWarn.invoke((Object)DialogWarn, "Das MoneYou-Passwort darf nicht mehr als 12-stellig sein", "institutlogo-moneyou.png");
            return null;
        }
        String getLogMethod = "[WebLogin] ";
        boolean isSelfException = false;
        HtmlPage pageLogin = null;
        DomElement submitLogin = null;
        HtmlPage postLoginPage = null;
        String pageLoginXML = null;
        try {
            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "MoneYou-Login aufrufen ... (GET " + "https://www.moneyou.de/personalpage/login" + ")");
            try {
                pageLogin = (HtmlPage)syncWebClient.getPage("https://www.moneyou.de/personalpage/login");
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "pageLogin: " + pageLogin);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (pageLogin == null) {
                throw new Exception("Die Login-Seite konnte nicht aufgerufen werden!");
            }
            pageLoginXML = pageLogin.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(pageLoginXML, (Page)pageLogin, ExternalLogger, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            try {
                HtmlForm formLogin = (HtmlForm)pageLogin.getFirstByXPath("//form[@class='possiblewaiterform']");
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "formLogin: " + formLogin);
                formLogin.getInputByName("UserId").setValue(responseLogin);
                formLogin.getInputByName("Password").setValue(responsePassword);
                submitLogin = (DomElement)pageLogin.getFirstByXPath("//button[contains(text(),'Anmelden')]");
            }
            catch (Exception error) {
                throw new Exception("Fehler beim Setzen des Login-Formulars oder der Felder (siehe Log - Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.)\nLog-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "Login-Form wird abgesendet ...");
            try {
                postLoginPage = (HtmlPage)((HtmlElement)submitLogin).click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "postLoginPage: " + postLoginPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (postLoginPage == null) {
                throw new Exception("Die Login-Folgeseite konnte nicht aufgerufen werden!");
            }
            String postLoginXML = postLoginPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(pageLoginXML, (Page)pageLogin, ExternalLogger, ExternalDialogInterface);
            }
            catch (Exception error) {
                if (error.equals("MoneYouAccountUnlocked")) {
                    return null;
                }
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (postLoginXML.contains("MoneYou findet den Schutz Ihrer Daten wichtig") && postLoginXML.contains("Ihr Kennwort muss aus")) {
                isSelfException = true;
                DialogWarn.invoke((Object)DialogWarn, "Meldung der MoneYou (ABN AMRO Bank):\n\n\nVergabe einer neuen PIN notwendig. Loggen Sie sich im Online-Banking ein um dies zu erledigen", "institutlogo-moneyou.png");
                throw new Exception("Vergabe einer neuen PIN notwendig. Loggen Sie sich im Online-Banking ein um dies zu erledigen");
            }
            if (postLoginXML.contains("possiblewaiterform")) {
                isSelfException = true;
                throw new Exception("Die Loginseite wird trotz keinem bekannten Fehler noch immer angezeigt. Informieren Sie bitte den Entwickler im Forum");
            }
            postLoginXML = postLoginPage.asXml();
            if (postLoginXML.contains("Ihren Antrag") && postLoginXML.contains("ist erfolgreich abgeschlossen, wenn alle Punkte abgehakt sind")) {
                int NrIDXend;
                int NrIDXstart;
                int i;
                int openPointsCount = postLoginXML.split("untickbox").length - 1;
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "HibiscusScripting_MoneYou_AfterLogin: openPointsCount: " + openPointsCount);
                int donePointsCount = postLoginXML.split("alt=\"tickbox\"").length - 1;
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "HibiscusScripting_MoneYou_AfterLogin: donePointsCount: " + donePointsCount);
                String openPoints = "";
                String donePoints = "";
                int SearchPos = 0;
                for (i = 0; i < openPointsCount; ++i) {
                    NrIDXstart = postLoginXML.indexOf("untickbox", SearchPos);
                    NrIDXstart = postLoginXML.indexOf(">", NrIDXstart) + 1;
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "NrIDXstart: " + NrIDXstart);
                    NrIDXend = postLoginXML.indexOf("</tr>", NrIDXstart);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "NrIDXend: " + NrIDXend);
                    String RAWopenPoint = postLoginXML.substring(NrIDXstart, NrIDXend);
                    String openPoint = StringEscapeUtils.unescapeHtml4((String)RAWopenPoint);
                    openPoint = openPoint.replaceAll("\\<.*?\\>", "");
                    openPoint = StringCharUtils.shrinkString(openPoint);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "AfterLogin openPoint gefunden: " + openPoint);
                    openPoints = openPoints + " - " + openPoint + "\n";
                    SearchPos = NrIDXend;
                }
                SearchPos = 0;
                for (i = 0; i < donePointsCount; ++i) {
                    NrIDXstart = postLoginXML.indexOf("alt=\"tickbox\"", SearchPos);
                    NrIDXstart = postLoginXML.indexOf(">", NrIDXstart) + 1;
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "NrIDXstart: " + NrIDXstart);
                    NrIDXend = postLoginXML.indexOf("</tr>", NrIDXstart);
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "NrIDXend: " + NrIDXend);
                    String RAWdonePoint = postLoginXML.substring(NrIDXstart, NrIDXend);
                    String donePoint = StringEscapeUtils.unescapeHtml4((String)RAWdonePoint);
                    donePoint = donePoint.replaceAll("\\<.*?\\>", "");
                    donePoint = StringCharUtils.shrinkString(donePoint);
                    donePoint = donePoint.replace("Ihre Kontonummer ist oben angegeben.", "");
                    LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "AfterLogin donePoint gefunden: " + donePoint);
                    donePoints = donePoints + " - " + donePoint + "\n";
                    SearchPos = NrIDXend;
                }
                DialogError.invoke((Object)DialogError, "\nMeldung der MoneYou:\n\n\nUm die Kontoer\u00f6ffnung abzuschlie\u00dfen, sehen Sie hier, was noch zu tun ist:\n\n\nWas m\u00fcssen Sie oder Wir noch tun?\n\n" + openPoints + "\n\nWie aktiviert MoneYou Ihr Konto? Was ist erledigt?\n\n" + donePoints, "institutlogo-moneyou.png");
                throw new Exception("Die Kontoer\u00f6ffnung ist noch nicht abgeschlossen. Es m\u00fcssen alle angegebenen Punkte erledigt sein ...");
            }
            return postLoginPage;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Fehlermeldung des Systems: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static void logoutWithSelenium(WebDriver seleniumWebDriver, String optionalOptions, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            WebElement logoutButton = (WebElement)seleniumWebDriver.findElements(By.xpath((String)"//button[contains(@onclick,'logout')]")).get(1);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "logoutButton: " + logoutButton);
            String logoutPageXML = seleniumWebDriver.getPageSource();
            if (logoutButton == null) {
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "logoutPageXML: \n" + logoutPageXML);
                throw new Exception("Button 'Abmelden' im oberen Frame nicht gefunden! Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.!");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "Abmelden anklicken ... (Click " + logoutButton + ")");
            try {
                logoutButton.click();
                seleniumWebDriver.switchTo().defaultContent();
                SeleniumUtils.waitForJSandJQueryToLoad(seleniumWebDriver);
                Thread.sleep(1000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "postLogoutPage: " + seleniumWebDriver);
            }
            catch (Exception error) {
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            String postLogoutPageXML = seleniumWebDriver.getPageSource();
            try {
                WebUtils.checkSeleniumResponseHasError(postLogoutPageXML, seleniumWebDriver, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception(error.getMessage());
            }
            if (!postLogoutPageXML.contains("Sie sind jetzt ausgeloggt") && !postLogoutPageXML.contains("Abgemeldet")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "Logout bei der '" + "MoneYou (ABN AMRO Bank)" + "' war erfolgreich");
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:MoneYou] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }

    public static void logoutWithHTMLUnit(WebClient syncWebClient, String optionalOptions, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor, Class<?> ExternalDialogInterface) throws Exception {
        Method LogInfo = ExternalLogger.getMethod("info", String.class);
        Method LogError = ExternalLogger.getMethod("error", String.class);
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[WebLogout] ";
        boolean isSelfException = false;
        try {
            String logoutURL = "https://www.moneyou.de/personalpage/api/security/logout";
            HtmlPage postLogoutPage = null;
            String postLogoutPageXML = null;
            LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "GET: " + logoutURL);
            try {
                postLogoutPage = (HtmlPage)syncWebClient.getPage(logoutURL);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MoneYou] " + getLogMethod + "PostLogoutPage: " + postLogoutPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            postLogoutPageXML = postLogoutPage.asXml();
            try {
                WebUtils.checkHTMLUnitResponseHasError(postLogoutPageXML, (Page)postLogoutPage, ExternalLogger, ExternalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!postLogoutPageXML.contains("click.indexlogout.topmenu.home")) {
                LogTrace.invoke((Object)LogTrace, "[WebSync:MoneYou] " + getLogMethod + "Seite nach Logout-Aufruf unbekannt; Code zur Analyse:\n" + postLogoutPageXML);
                isSelfException = true;
                throw new Exception("Seite nach Logout-Aufruf unbekannt; Bitte den Entwickler im Forum informieren. Danke f\u00fcr Ihre Mithilfe.");
            }
            LogInfo.invoke((Object)LogInfo, "[WebSync:MoneYou] " + getLogMethod + "Logout bei der '" + "MoneYou (ABN AMRO Bank)" + "' war erfolgreich");
            syncWebClient.close();
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            LogError.invoke((Object)LogError, "[WebSync:MoneYou] " + getLogMethod + "WebLogout fehlerhaft! Stacktrace:\n" + ExceptionUtils.getStackTrace((Throwable)error));
            throw new Exception("WebLogout fehlerhaft! Fehlermeldung:" + error.getMessage());
        }
    }
}

