/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.mercedesbenzbank;

import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.webdrivertools.HTMLUnitUtils;
import de.derrichter.finance.websync.utils.webdrivertools.SeleniumUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.htmlunit.Page;
import org.htmlunit.html.DomNode;
import org.openqa.selenium.WebDriver;

public class WebUtils {
    protected static String[] xpathSearchString = new String[1];
    protected static String[] xpathSearchStringExclusion = new String[1];

    protected static void setSerchStrings() {
        WebUtils.xpathSearchString[0] = "(//div[contains(@class,'error')]//span)[1]";
    }

    protected static void setSerchExclusionStrings() {
        WebUtils.xpathSearchStringExclusion[0] = "Dummy";
    }

    public static void checkSeleniumResponseHasError(String responsePageAsString, WebDriver seleniumWebDriver, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:MercedesBenz] ";
        String longName = "Mercedes-Benz Bank AG";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            SeleniumUtils.checkWebDriverResponse(responsePageAsString, seleniumWebDriver, logIdent, longName, "institutlogo-mercedesbenzbank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalProgressMonitor, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static void checkHTMLUnitResponseHasError(String pageResponse, Page currentPage, Class<?> externalLogger, Class<?> externalDialogInterface) throws Exception {
        String logIdent = "[WebSync:MercedesBenz] ";
        String longName = "Mercedes-Benz Bank AG";
        try {
            WebUtils.setSerchStrings();
            WebUtils.setSerchExclusionStrings();
            HTMLUnitUtils.checkHTMLUnitWebClientResponse(pageResponse, currentPage, logIdent, longName, "institutlogo-mercedesbenzbank.png", xpathSearchString, xpathSearchStringExclusion, externalLogger, externalDialogInterface);
        }
        catch (Exception error) {
            throw new Exception(error.getMessage());
        }
    }

    public static String checkResponse(String responseContentAsString, Page responsePage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method DialogError = externalDialogInterface.getMethod("error", String.class, String.class);
        boolean isSelfException = false;
        try {
            String errorResponse = null;
            String errorMessage = null;
            if (responseContentAsString.contains("Online-Sperre aufheben")) {
                errorMessage = "Sie haben Ihre PIN drei mal falsch eingegeben oder Ihren Zugang aktiv gesperrt.\nZum Freischalten Ihres Login melden Sie sich bitte im Online-Banking an und entsperren Ihren Account mit der Super-PIN\n";
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Mercedes-Benz Bank AG:\n\n\n" + errorMessage, "institutlogo-mercedesbenzbank.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("class=\"fmError\"")) {
                errorResponse = ((DomNode)responsePage).asXml();
                errorMessage = WebUtils.formErrorMessage(errorResponse, externalLogger, externalProgressMonitor);
                DialogError.invoke((Object)DialogError, "Fehlermeldung der Mercedes-Benz Bank AG:\n\n\n" + errorMessage, "institutlogo-mercedesbenzbank.png");
                errorMessage = StringCharUtils.shrinkString(errorMessage);
                isSelfException = true;
                throw new Exception(errorMessage);
            }
            if (responseContentAsString.contains("Anwendersitzung abgelaufen") && responseContentAsString.contains("Bitte loggen Sie sich ein")) {
                isSelfException = true;
                throw new Exception("Die Online Banking Sitzung ist abgelaufen. Bitte melden Sie sich erneut an.");
            }
            if (responseContentAsString.contains("Wartungsarbeiten Online-Banking") || responseContentAsString.contains("wartungsarbeiten.jpg")) {
                isSelfException = true;
                throw new Exception("Wegen Wartungsarbeiten ist unser Online-Banking gerade leider nicht erreichbar");
            }
            return null;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("checkResponse fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }

    public static String formErrorMessage(String contentStringToParse, Class<?> ExternalLogger, Class<?> ExternalProgressMonitor) throws Exception {
        Method LogDebug = ExternalLogger.getMethod("debug", String.class);
        Method LogTrace = ExternalLogger.getMethod("trace", String.class);
        String getLogMethod = "[formErrorMessage] ";
        try {
            int ErrorTextIDXStart = 0;
            int ErrorTextIDXend = 0;
            ErrorTextIDXStart = contentStringToParse.indexOf("class=\"fmError\"");
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "ErrorTextIDXStart: " + ErrorTextIDXStart);
            ErrorTextIDXStart = contentStringToParse.indexOf("\">", ErrorTextIDXStart) + 2;
            ErrorTextIDXend = contentStringToParse.indexOf("</ul>", ErrorTextIDXStart);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "ErrorTextIDXend: " + ErrorTextIDXend);
            String ErrorText = contentStringToParse.substring(ErrorTextIDXStart, ErrorTextIDXend);
            LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "ErrorText (unformatiert): " + ErrorText);
            String formErrorText = ErrorText.replaceAll("Angaben.<br>Leider", "Angaben. Leider");
            formErrorText = ErrorText.replaceAll("Angaben.</li><li>Leider", "Angaben. Leider");
            formErrorText = ErrorText.replaceAll("<br/> ", "\n");
            formErrorText = ErrorText.replaceAll("<br/ > ", "\n");
            formErrorText = ErrorText.replaceAll("<br> ", "\n");
            formErrorText = ErrorText.replaceAll("\t", "");
            formErrorText = ErrorText.replaceAll("<BR>", "\n");
            formErrorText = StringEscapeUtils.unescapeHtml4((String)formErrorText);
            formErrorText = formErrorText.replaceAll("\\<.*?\\>", "");
            formErrorText = StringCharUtils.shrinkWhitespaces(formErrorText);
            formErrorText = formErrorText.trim();
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "ErrorText (formatiert): " + formErrorText);
            return formErrorText;
        }
        catch (Exception error) {
            throw new Exception("formErrorMessage fehlerhaft: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

