/*
 * Decompiled with CFR 0.152.
 */
package de.derrichter.finance.websync.institute._archiv.mercedesbenzbank;

import de.derrichter.finance.websync.institute._archiv.mercedesbenzbank.WebUtils;
import de.derrichter.finance.websync.utils.StatementWorker;
import de.derrichter.finance.websync.utils.StringCharUtils;
import de.derrichter.finance.websync.utils.SysUtils;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.htmlunit.Page;
import org.htmlunit.WebClient;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSelect;

public class WebPull {
    public static ArrayList getTransData(WebClient syncWebClient, String kontonummer, String Unterkonto, String fromDateSimple, String toDateSimple, HtmlPage postLoginPage, Class<?> externalLogger, Class<?> externalProgressMonitor, Class<?> externalDialogInterface) throws Exception {
        Method LogInfo = externalLogger.getMethod("info", String.class);
        Method LogWarn = externalLogger.getMethod("warn", String.class);
        Method LogError = externalLogger.getMethod("error", String.class);
        Method LogDebug = externalLogger.getMethod("debug", String.class);
        Method LogTrace = externalLogger.getMethod("trace", String.class);
        Method MonitorLog = externalProgressMonitor.getMethod("log", String.class);
        Method MonitorSetPercent = externalProgressMonitor.getMethod("setPercentComplete", Integer.TYPE);
        String getLogMethod = "[getTransData] ";
        boolean isSelfException = false;
        try {
            Page csv;
            HtmlPage dataPage;
            String responsePageXML = postLoginPage.asXml();
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "Check ob in der Konto\u00fcbersicht der Willkommen-Seite die Kontonummer enthalten ist ...");
            String checkKontonummer = new DecimalFormat("0000000000").format(Long.parseLong(kontonummer));
            LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "checkKontonummer (formated): " + checkKontonummer);
            String ibanSub = "60030000".substring(0, 4) + " " + "60030000".substring(4, 8) + " " + checkKontonummer.substring(0, 4) + " " + checkKontonummer.substring(4, 8) + " " + checkKontonummer.substring(8, 10);
            LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "Kontonummer-Check: IBAN: DExx " + ibanSub);
            try {
                if (!responsePageXML.contains(ibanSub)) {
                    isSelfException = true;
                    throw new Exception("Ihre angegebene Kontonummer ist in der Konto\u00fcbersicht nicht vorhanden oder unbekannte Zwischenseite. Bitte pr\u00fcfen");
                }
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "OK - Kontonummer auf der Startseite vorhanden");
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Abbruch: " + error.getMessage());
            }
            HtmlAnchor selectKonto = (HtmlAnchor)postLoginPage.getFirstByXPath("//div[contains(.,'" + ibanSub + "')]/parent::a");
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "Click " + selectKonto);
            try {
                dataPage = (HtmlPage)selectKonto.click();
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "getTransactionData: DataPage (Seite): " + dataPage);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + error + " [SelectKonto = '" + selectKonto + "']");
            }
            if (dataPage == null) {
                throw new Exception("Die Umsatz\u00fcbersicht konnte nicht aufgerufen werden!");
            }
            String dataPageXML = dataPage.asXml();
            try {
                WebUtils.checkResponse(dataPageXML, (Page)dataPage, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            if (!dataPageXML.contains("Aktueller Kontostand")) {
                throw new Exception("Auf der Konto-Seite konnte kein Kontostand gefunden werden. Falsche oder andere Seite");
            }
            HtmlElement amountSpan = (HtmlElement)dataPage.getFirstByXPath("//span[contains(.,'Aktueller Kontostand')]/following::span");
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "amountSpan: " + amountSpan);
            String amountText = amountSpan.getTextContent().trim();
            double amount = Double.parseDouble(StringCharUtils.shrinkString(amountText.replaceAll("[A-Za-z]+", "").replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll("\u20ac", "").replaceAll("&euro;", "").replaceAll("\\+", "").replaceAll("\\s", "").trim()));
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "Amount: " + amount);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "Select f\u00fcr den Abrufzeitraum setzen ...");
            HtmlForm formData = dataPage.getFormByName("form");
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "getTransactionData: formData: " + formData);
            HtmlSelect zeitwahl = formData.getSelectByName("form:selectPeriodId");
            List list = zeitwahl.getOptions();
            String zeitraum = null;
            long fromDate = new SimpleDateFormat("dd.MM.yyyy").parse(fromDateSimple).getTime();
            long dateNow = new Date().getTime();
            for (int Auswahl = 0; Auswahl < list.size(); ++Auswahl) {
                HtmlOption selectOption = (HtmlOption)list.get(Auswahl);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "Listeneintrag der Zeitraumauswahl gefunden: " + selectOption);
                zeitraum = selectOption.asNormalizedText();
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "dieser Eintrag als reiner Text: " + zeitraum);
                if (selectOption.getValueAttribute().equals("THIRTY_DAYS") && fromDate <= dateNow - 2592000000L) {
                    selectOption.setSelected(true);
                }
                if (selectOption.getValueAttribute().equals("SIXTY_DAYS") && fromDate <= dateNow - 5184000000L) {
                    selectOption.setSelected(true);
                }
                if (selectOption.getValueAttribute().equals("NINETY_DAYS") && fromDate <= dateNow - 7776000000L) {
                    selectOption.setSelected(true);
                }
                if (selectOption.getValueAttribute().equals("SIX_MONTHS") && fromDate <= dateNow - 15768000000L) {
                    selectOption.setSelected(true);
                }
                if (selectOption.getValueAttribute().equals("ONE_YEAR") && fromDate <= dateNow - 31536000000L) {
                    selectOption.setSelected(true);
                }
                if (selectOption.getValueAttribute().equals("TWO_YEARS") && fromDate <= dateNow - 63072000000L) {
                    selectOption.setSelected(true);
                }
                if (selectOption.getValueAttribute().equals("THREE_YEARS") && fromDate <= dateNow - 94608000000L) {
                    selectOption.setSelected(true);
                }
                if (!selectOption.getValueAttribute().equals("FOUR_YEARS") || fromDate > dateNow - 126144000000L) continue;
                selectOption.setSelected(true);
            }
            syncWebClient.waitForBackgroundJavaScript(5000L);
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "selektierte Listeneintr\u00e4ge sind nun: " + zeitwahl.getSelectedOptions());
            zeitraum = ((HtmlOption)zeitwahl.getSelectedOptions().get(0)).asNormalizedText();
            HtmlAnchor csvDownloadLink = (HtmlAnchor)dataPage.getFirstByXPath("//span[contains(.,'CSV Export')]/parent::a");
            LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "Click CSV-Download: " + csvDownloadLink);
            try {
                csv = csvDownloadLink.click();
                syncWebClient.waitForBackgroundJavaScript(5000L);
                LogDebug.invoke((Object)LogDebug, "[WebSync:MercedesBenz] " + getLogMethod + "getCSVExport: csv: " + csv);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("WebDriver-Fehler: " + ExceptionUtils.getStackTrace((Throwable)error));
            }
            if (csv == null) {
                throw new Exception("Der Kontoauszug (CSV) konnte nicht aufgerufen werden!");
            }
            String csvResponse = csv.getWebResponse().getContentAsString();
            try {
                WebUtils.checkResponse(csvResponse, csv, externalLogger, externalProgressMonitor, externalDialogInterface);
            }
            catch (Exception error) {
                isSelfException = true;
                throw new Exception("Fehlermeldung des Servers: " + error.getMessage());
            }
            LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "csvResponse: \n\n====================== BEGIN DATA ======================\n" + csvResponse + "\n======================= END DATA =======================\n");
            if (csvResponse.contains("<html") || csvResponse.contains("<head")) {
                throw new Exception("Kontoauszug abholen fehlgeschlagen! Beinhaltet falsche Daten. Bitte neu versuchen oder \u00fcberpr\u00fcfen Sie dies mit einem manuellen Download auf der Bank-Homepage");
            }
            String[] dataResponse = new String[]{csvResponse, Double.toString(amount)};
            String[][] matrixArrayData = null;
            matrixArrayData = StringCharUtils.data2matrixArray(csvResponse.replace("\"", "\\\""), '\"', ';', externalLogger);
            ArrayList transactionDataList = new ArrayList();
            int arrayRowCount = 0;
            for (int i = 0; i < matrixArrayData.length; ++i) {
                if (matrixArrayData[i] == null || StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][0])) continue;
                LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "matrixArrayData: Zeile Nr. " + i + " wurde beachtet da diese nicht leer ist ... und wird nun auf eine Umsatzzeile gepr\u00fcft ...");
                try {
                    String[] CheckColumn = matrixArrayData[i][0].split("\\.");
                    float testnumber = Float.parseFloat(CheckColumn[0]);
                    testnumber = Float.parseFloat(CheckColumn[1]);
                    testnumber = Float.parseFloat(CheckColumn[2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] matrixArrayData: OK - diese hat die Kriterien f\u00fcr eine Umsatzzeile und wird nun ausgelesen ...");
                }
                catch (NumberFormatException e) {
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + e.toString());
                    continue;
                }
                try {
                    transactionDataList.add(new ArrayList());
                    String[] arraydatum = matrixArrayData[i][1].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arraydatum[2], 10), Integer.parseInt(arraydatum[1], 10) - 1, Integer.parseInt(arraydatum[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][0]  hat nun folgenden Inhalt: (Datum)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(0));
                    String[] arrayvaluta = matrixArrayData[i][0].substring(0, 10).split("\\.");
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(SysUtils.getDate(Integer.parseInt(arrayvaluta[2], 10), Integer.parseInt(arrayvaluta[1], 10) - 1, Integer.parseInt(arrayvaluta[0], 10)));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][1]  hat nun folgenden Inhalt: (Valuta)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(1));
                    double Betrag = Double.parseDouble(StringCharUtils.shrinkString(matrixArrayData[i][6]).replaceAll("[A-Za-z]+", "").replaceAll("\\.", "").replaceAll(",", ".").replaceAll("&nbsp;", "").replaceAll("\u00a0", "").replaceAll(" \u20ac", "").replaceAll(" &euro;", "").replaceAll("\\+", "").replaceAll("-", "").replaceAll("\\s", "").trim());
                    if (matrixArrayData[i][6].contains("-")) {
                        Betrag *= -1.0;
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Betrag);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][2]  hat nun folgenden Inhalt: (Betrag)              : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(2));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Double.parseDouble("0"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][3]  hat nun folgenden Inhalt: (Saldo)               : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(3));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String("EUR"));
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][4]  hat nun folgenden Inhalt: (W\u00e4hrung)             : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(4));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][2]);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][5]  hat nun folgenden Inhalt: (Umsatzart)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(5));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][5])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][5]);
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][4]);
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][6]  hat nun folgenden Inhalt: (Verwendungszweck)    : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(6));
                    String gegenkontoName = "";
                    String gegenkontoNummer = "";
                    String gegenkontoBLZ = "";
                    String gegenkontoIBAN = matrixArrayData[i][3];
                    String gegenkontoBIC = "";
                    if (!StringCharUtils.isNullOrEmptyOrNothing(gegenkontoIBAN) && StringCharUtils.isIbanCountryStructure(gegenkontoIBAN) && gegenkontoIBAN.startsWith("DE")) {
                        gegenkontoNummer = gegenkontoIBAN.substring(12, 22);
                        gegenkontoBLZ = gegenkontoIBAN.substring(4, 12);
                    } else if (!StringCharUtils.isNullOrEmptyOrNothing(gegenkontoIBAN)) {
                        gegenkontoNummer = gegenkontoIBAN;
                        if (!StringCharUtils.isIbanCountryStructure(gegenkontoIBAN)) {
                            gegenkontoIBAN = "";
                        }
                    }
                    if (!gegenkontoNummer.equals(kontonummer) && !StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][4])) {
                        gegenkontoName = matrixArrayData[i][4];
                    }
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoIBAN);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][7]  hat nun folgenden Inhalt: (IBAN)                : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(7));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBIC);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][8]  hat nun folgenden Inhalt: (BIC)                 : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(8));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoName);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][9]  hat nun folgenden Inhalt: (Gegenkonto-Name)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(9));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoNummer);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][10] hat nun folgenden Inhalt: (Gegenkonto-Nummer)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(10));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(gegenkontoBLZ);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][11] hat nun folgenden Inhalt: (Gegenkonto-BLZ)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(11));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][12] hat nun folgenden Inhalt: (Kommentar)           : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(12));
                    if (!StringCharUtils.isNullOrEmptyOrNothing(matrixArrayData[i][1])) {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(matrixArrayData[i][1].replaceAll("Reference: ", ""));
                    } else {
                        ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    }
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][13] hat nun folgenden Inhalt: (Primanotakennzeichen): " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(13));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][14] hat nun folgenden Inhalt: (Kundenreferenz)      : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(14));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][15] hat nun folgenden Inhalt: (EndToEnd-Referenz)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(15));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][16] hat nun folgenden Inhalt: (Mandatsreferenz)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(16));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(new String());
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][17] hat nun folgenden Inhalt: (Transaktions-ID)     : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(17));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(i + 1);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][18] hat nun folgenden Inhalt: (Zeilennummer-Auszug) : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(18));
                    ((ArrayList)transactionDataList.get(arrayRowCount)).add(Boolean.FALSE);
                    LogTrace.invoke((Object)LogTrace, "[WebSync:MercedesBenz] " + getLogMethod + "transactionDataList[" + arrayRowCount + "][19] hat nun folgenden Inhalt: (vorhanden? Marker)   : " + ((ArrayList)transactionDataList.get(arrayRowCount)).get(19));
                    ++arrayRowCount;
                    continue;
                }
                catch (Exception error) {
                    isSelfException = true;
                    throw new Exception("Exception beim Verarbeiten/Auslesen des RAW-Kontoauszugs-Array - Log-Eintrag: " + ExceptionUtils.getStackTrace((Throwable)error));
                }
            }
            ArrayList sortetTransactionDataList = StatementWorker.sortBankArrayList(transactionDataList, false, "", externalLogger, externalProgressMonitor);
            ArrayList sortetBankArrayListAndData = StatementWorker.createBankArrayListHeader("MercedesBenz", kontonummer, amount, amount, 0.0, fromDateSimple, toDateSimple, "");
            sortetBankArrayListAndData.addAll(sortetTransactionDataList);
            return sortetBankArrayListAndData;
        }
        catch (Exception error) {
            if (isSelfException) {
                throw new Exception(error.getMessage());
            }
            throw new Exception("Exception beim Abrufen der Kontoums\u00e4tze: " + ExceptionUtils.getStackTrace((Throwable)error));
        }
    }
}

